/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.FlowEngineHelper;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import com.trs.webframework.xmlserver.IXMLConvertor;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FlowContentsToXML
implements IXMLConvertor {
    private static Logger logger = Logger.getLogger(FlowContentsToXML.class);

    public String[] registerTargetClassName() {
        IFlowContent[] iFlowContentArray = new IFlowContent[]{};
        return new String[]{iFlowContentArray.getClass().getName()};
    }

    public String toXmlString(MethodContext methodContext, Object object) throws ConvertException {
        try {
            Element element = null;
            if (object instanceof IFlowContent[]) {
                IFlowContent[] iFlowContentArray = (IFlowContent[])object;
                int n = -1;
                int n2 = 1;
                if (methodContext != null) {
                    n = methodContext.getValue("PAGESIZE", -1);
                    n2 = methodContext.getPageIndex();
                }
                element = DocumentHelper.createElement((String)"FlowContents");
                CPager cPager = new CPager(n);
                cPager.setCurrentPageIndex(n2);
                cPager.setItemCount(iFlowContentArray.length);
                this.setPageAttributes(cPager, element);
                for (int i = cPager.getFirstItemIndex(); i <= cPager.getLastItemIndex(); ++i) {
                    IFlowContent iFlowContent = iFlowContentArray[i - 1];
                    if (iFlowContent == null) continue;
                    element.add(this.toXMLElement(methodContext, iFlowContent));
                }
            } else if (object instanceof IFlowContent) {
                element = this.toXMLElement(methodContext, (IFlowContent)object);
            } else {
                throw new ConvertException(I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label1", "\u4e0d\u652f\u6301\u7684\u7c7b\u578b[") + object.getClass().getName() + "]!");
            }
            return element.asXML();
        }
        catch (WCMException wCMException) {
            throw new ConvertException(I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label2", "\u5c06FlowContent\u8f6c\u6362\u4e3aXML\u5931\u8d25"), wCMException);
        }
    }

    private void setPageAttributes(CPager cPager, Element element) {
        element.addAttribute("Num", String.valueOf(cPager.getItemCount()));
        if (cPager.getPageSize() <= 0) {
            return;
        }
        element.addAttribute("PageSize", String.valueOf(cPager.getPageSize()));
        element.addAttribute("PageCount", String.valueOf(cPager.getPageCount()));
        element.addAttribute("CurrPageIndex", String.valueOf(cPager.getCurrentPageIndex()));
    }

    private Element toXMLElement(MethodContext methodContext, IFlowContent iFlowContent) throws WCMException {
        Element element = DocumentHelper.createElement((String)"FlowContent");
        element.addElement("Title").addCDATA(CMyString.transDisplay(iFlowContent.getDesc()));
        element.addElement("ContentType").addText(String.valueOf(iFlowContent.getContentType()));
        element.addElement("ContentId").addText(String.valueOf(iFlowContent.getId()));
        element.addElement("DeletePage").addCDATA(iFlowContent.getDeletePage());
        element.addElement("EditPage").addCDATA(iFlowContent.getContentAddEditPage());
        element.addElement("ShowPage").addCDATA(iFlowContent.getContentShowPage());
        element.addElement("Status").addCDATA(iFlowContent.getStatusDesc());
        element.addElement("CrUser").addCDATA(iFlowContent.getSubinstance().getCrUserName());
        element.addElement("CrTime").addCDATA(this.convertDateTimeValueToString(methodContext, iFlowContent.getSubinstance().getCrTime()));
        if (iFlowContent.getStartTime() != null) {
            element.addElement("StartTime").addCDATA(this.convertDateTimeValueToString(methodContext, iFlowContent.getStartTime()));
        }
        element.addElement("ProcessInfo").addCDATA(this.makeProcessInfo(iFlowContent.getFlowDoc()));
        element.addElement("IsEnd").addText(iFlowContent.getFlowDoc() == null ? "1" : "0");
        if (iFlowContent.getFlowDoc() != null) {
            FlowDoc flowDoc = iFlowContent.getFlowDoc();
            element.addElement("FlowDocId").addText(String.valueOf(flowDoc.getId()));
            element.addElement("PostUser").addCDATA(flowDoc.getRealPostUserNames());
            User user = flowDoc.getPostUser();
            String string = null;
            string = user == null ? "0" : String.valueOf(user.getId());
            element.addElement("PostUserId").addCDATA(string);
            element.addElement("PostTime").addCDATA(this.convertDateTimeValueToString(methodContext, flowDoc.getPostTime()));
            element.addElement("ToUsers").addCDATA(flowDoc.getToUserNames());
            element.addElement("FlagId").addText(String.valueOf(flowDoc.getFlag()));
            element.addElement("FlagDesc").addText(flowDoc.getFlagDesc());
            element.addElement("Reworked").addText(flowDoc.getFlag() == 2 ? "1" : "0");
            element.addElement("Received").addText(flowDoc.isReceived() ? "1" : "0");
            element.addElement("Accepted").addText(flowDoc.isAccepted() ? "1" : "0");
            element.addElement("Worked").addText(flowDoc.isWorked() ? "1" : "0");
            element.addElement("WorkModal").addText(String.valueOf(flowDoc.getWorkModal()));
            FlowNode flowNode = flowDoc.getNode();
            if (flowNode != null) {
                element.addElement("NodeId").addText(String.valueOf(flowNode.getId()));
                element.addElement("NodeName").addText(String.valueOf(flowNode.getName()));
            }
            User user2 = ContextHelper.getLoginUser();
            int n = 0;
            if (flowNode != null && !flowDoc.isWorked() && user2.getId() == flowDoc.getToUserId()) {
                n = flowNode.getDocActionsAsInt();
            }
            element.addElement("Right").addText(String.valueOf(n));
            Element element2 = element.addElement("Comments");
            String[] stringArray = FlowEngineHelper.parseComments(flowDoc);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Element element3 = element2.addElement("Comment");
                    element3.addElement("User").addCDATA(stringArray[i]);
                    element3.addElement("Content").addCDATA(stringArray[++i]);
                }
            }
        }
        return element;
    }

    private String makeProcessInfo(FlowDoc flowDoc) throws WCMException {
        if (flowDoc == null) {
            return I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label3", "\u6d41\u8f6c\u7ed3\u675f");
        }
        String string = I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label4", "yy\u5e74MM\u6708dd\u65e5 HH:mm");
        if (flowDoc.getToUserId() > 0) {
            if (flowDoc.isWorked()) {
                return flowDoc.getPostUserName() + "[" + flowDoc.getPostTime().toString(string) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label5", "]\u4ea4\u7ed9") + flowDoc.getToUserNames() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label6", "\u7684\u4e8b\u60c5\u5df2\u4e8e[") + flowDoc.getPropertyAsDateTime("WorkTime").toString(string) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label7", "]\u5904\u7406\u5b8c\u6210\uff01");
            }
            if (flowDoc.isReceived()) {
                if (flowDoc.isAccepted()) {
                    return flowDoc.getPostUserName() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label8", "\u5df2\u4e8e[") + flowDoc.getPostTime().toString(string) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label5", "]\u4ea4\u7ed9") + flowDoc.getToUserNames() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label9", "\u5904\u7406\uff0c") + flowDoc.getToUserNames() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label8", "\u5df2\u4e8e[") + flowDoc.getAcceptTime().toString(string) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label10", "]\u51b3\u5b9a\u5f00\u59cb\u5904\u7406");
                }
                return flowDoc.getPostUserName() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label8", "\u5df2\u4e8e[") + flowDoc.getPostTime().toString(string) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label5", "]\u4ea4\u7ed9") + flowDoc.getToUserNames() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label9", "\u5904\u7406\uff0c") + flowDoc.getToUserNames() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label8", "\u5df2\u4e8e[") + flowDoc.getReceiveTime().toString(string) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label11", "]\u6536\u5230\uff0c\u4f46\u5c1a\u672a\u51b3\u5b9a\u662f\u5426\u5904\u7406");
            }
            return flowDoc.getPostUserName() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label8", "\u5df2\u4e8e[") + flowDoc.getPostTime().toString(string) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label5", "]\u4ea4\u7ed9") + flowDoc.getToUserNames() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label12", "\u5904\u7406\uff0c\u4f46") + flowDoc.getToUserNames() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label13", "\u5c1a\u672a\u6536\u5230");
        }
        if (CMyString.isEmpty(flowDoc.getToUserIds())) {
            return "";
        }
        FlowDocs flowDocs = flowDoc.getChildren(null, null);
        StringBuffer stringBuffer = new StringBuffer(flowDocs.size() * 200);
        stringBuffer.append(flowDoc.getPostUserName() + "[" + flowDoc.getPostTime().toString(string) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label5", "]\u4ea4\u7ed9") + flowDoc.getToUserNames() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label15", "\u7684\u4e8b\u60c5 "));
        boolean bl = true;
        int n = flowDocs.size();
        for (int i = 0; i < n; ++i) {
            User user;
            FlowDoc flowDoc2 = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc2 == null || (user = flowDoc2.getToUser()) == null) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("\uff1b");
            }
            if (flowDoc2.isWorked()) {
                stringBuffer.append(user.getName() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label8", "\u5df2\u4e8e[") + flowDoc2.getPropertyAsDateTime("WorkTime").toString(string) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label16", "]\u5904\u7406\u5b8c\u6210"));
                continue;
            }
            if (flowDoc2.isReceived()) {
                if (flowDoc2.isAccepted()) {
                    stringBuffer.append(user.getName() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label8", "\u5df2\u4e8e[") + flowDoc2.getAcceptTime().toString(string) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label10", "]\u51b3\u5b9a\u5f00\u59cb\u5904\u7406"));
                    continue;
                }
                stringBuffer.append(user.getName() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label8", "\u5df2\u4e8e[") + flowDoc2.getReceiveTime().toString(string) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label11", "]\u6536\u5230\uff0c\u4f46\u5c1a\u672a\u51b3\u5b9a\u662f\u5426\u5904\u7406"));
                continue;
            }
            stringBuffer.append(user.getName() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label13", "\u5c1a\u672a\u6536\u5230"));
        }
        return stringBuffer.toString();
    }

    private String convertDateTimeValueToString(MethodContext methodContext, CMyDateTime cMyDateTime) {
        String string = "yyyy-MM-dd HH:mm:ss";
        if (methodContext != null && (string = methodContext.getValue("DateTimeFormat")) == null) {
            string = "yyyy-MM-dd HH:mm:ss";
        }
        String string2 = cMyDateTime.toString(string);
        return string2;
    }

    public static void main(String[] stringArray) {
        IFlowContent[] iFlowContentArray = new IFlowContent[3];
        System.out.println(iFlowContentArray.getClass().getName());
    }
}

