/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.ajaxservice.WCMDocumentHelper;
import com.trs.ajaxservice.xmlconvertors.BaseWCMObjectToXML;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import org.apache.log4j.Logger;

public class ChnlDocToXML
extends BaseWCMObjectToXML {
    private static Logger logger = Logger.getLogger(ChnlDocToXML.class);
    private static final int CHNLID = 1;
    private static final int DOCSTATUS = 2;
    private static final int DOCID = 3;

    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("CHNLID", 1, "CHANNEL");
        this.registerHostSpecialProperty("DOCSTATUS", 2);
        this.registerHostSpecialProperty("DOCID", 3, "DOCUMENT");
    }

    protected String[][] getSpecialProperty(MethodContext methodContext, BaseObj baseObj, int n, Object object) throws ConvertException {
        try {
            switch (n) {
                case 1: {
                    return this.makeChannelValue(object);
                }
                case 2: {
                    return this.makeStatus(object);
                }
                case 3: {
                    int n2 = ((Number)object).intValue();
                    return this.makeDocumentValue(n2, methodContext);
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)CMyString.format(I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label1", "\u8f6c\u6362\u5bf9\u8c61[{0}]\u6570\u636e[{1}\u5931\u8d25\uff01]"), new String[]{baseObj.toString(), n + ""}), (Throwable)exception);
            throw new ConvertException(I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label4", "\u8f6c\u6362\u6570\u636e[") + n + I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label3", "]\u5931\u8d25\uff01"), exception);
        }
        return null;
    }

    private String[][] makeStatus(Object object) throws WCMException {
        Status status = Status.findById(((Long)object).intValue());
        if (status == null) {
            return new String[][]{{"ID", "0"}, {"NAME", I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label5", "\u672a\u77e5")}};
        }
        return new String[][]{{"ID", status.getKey().toString()}, {"NAME", status.getDisp()}};
    }

    private String[][] makeDocumentValue(int n, MethodContext methodContext) throws WCMException {
        Document document = Document.findById(n, methodContext.getValue("DocumentSelectFields"));
        if (document == null) {
            return new String[][]{{"ID", String.valueOf(n)}, {"Title", I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label6", "======\u6587\u6863[ID=") + n + I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label7", "]\u6ca1\u6709\u627e\u5230\uff01======")}};
        }
        return new String[][]{{"ID", String.valueOf(n)}, {"DocType", String.valueOf(document.getType())}, {"DocTypeName", document.getTypeString()}, {"DocChannelId", String.valueOf(document.getChannelId())}, {"DocChannelName", document.getChannel().getDispDesc()}, {"Title", document.getTitle()}};
    }

    private String[][] makeChannelValue(Object object) throws WCMException {
        Channel channel = Channel.findById(((Long)object).intValue());
        if (channel == null) {
            return new String[][]{{"ID", "0"}, {"NAME", I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label5", "\u672a\u77e5")}};
        }
        return new String[][]{{"ID", channel.getKey().toString()}, {"NAME", channel.getDispDesc()}};
    }

    public String[] registerTargetClassName() {
        return new String[]{ChnlDocs.class.getName(), ChnlDoc.class.getName()};
    }

    protected String[][] getSpecialRootAttributes(MethodContext methodContext, BaseObjs baseObjs) {
        return null;
    }

    protected String[][] getSpecialRootAttributes(MethodContext methodContext, BaseObj baseObj) throws ConvertException {
        try {
            return new String[][]{{"CanEdit", String.valueOf(AuthServer.hasRight(ContextHelper.getLoginUser(), (CMSObj)((Document)baseObj), 32))}};
        }
        catch (WCMException wCMException) {
            throw new ConvertException(I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label8", "\u6784\u9020\u6587\u6863\u6839\u8282\u70b9\u5c5e\u6027\u5931\u8d25\uff01"), wCMException);
        }
    }

    protected String[][] getSpecialElementAttributes(MethodContext methodContext, BaseObj baseObj) throws ConvertException {
        String[] stringArray;
        ChnlDoc chnlDoc = (ChnlDoc)baseObj;
        String[] stringArray2 = null;
        if (methodContext.getValue("ContainsRight", false)) {
            try {
                stringArray = chnlDoc.getDocument();
                User user = ContextHelper.getLoginUser();
                Channel channel = chnlDoc.getChannel();
                String string = WCMDocumentHelper.makeRightValue(methodContext, user, channel, (Document)stringArray);
                stringArray2 = new String[]{"Right", string};
            }
            catch (Exception exception) {
                throw new ConvertException(I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label9", "\u6784\u9020[DocId=") + chnlDoc.getDocId() + ",ChnlId=" + chnlDoc.getChannelId() + I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label10", "]\u6743\u9650\u4fe1\u606f\u5931\u8d25!"), exception);
            }
        }
        stringArray = new String[]{"Topped", String.valueOf(chnlDoc.isTopped())};
        return new String[][]{stringArray, stringArray2};
    }
}

