/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.cms.auth.config.RightConfigServer;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import org.apache.log4j.Logger;

public class WCMDocumentHelper {
    private static Logger logger = Logger.getLogger(WCMDocumentHelper.class);

    public static String makeRightValue(MethodContext methodContext, User user, Channel channel, Document document) throws WCMException {
        Object object;
        String string = document.getPropertyAsString("FLOWOPERATIONMARK");
        boolean bl = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("FLOW_RIGHT_PRI", "false"));
        boolean bl2 = bl && !CMyString.isEmpty(string) && !string.equalsIgnoreCase("RESERVED_FORCED_END") && !string.equals(I18NMessage.get(WCMDocumentHelper.class, "WCMDocumentHelper.label1", "\u7ed3\u675f\u6d41\u8f6c"));
        int[] nArray = WCMRightTypes.getRemoveRightIndexs();
        if (DocumentAuthServer.isDefineRightOnDocument(document)) {
            try {
                RightValue rightValue = new RightValue();
                rightValue.load(user, 605, document.getId(), true);
                if (user.getName().equalsIgnoreCase(document.getCrUserName())) {
                    int[] nArray2 = DocumentAuthServer.INDEXES_OWNER_HAS;
                    for (int i = 0; i < nArray2.length; ++i) {
                        int n = nArray2[i];
                        rightValue.setBit(n, true);
                    }
                }
                if (bl2) {
                    for (int i = 0; i < nArray.length; ++i) {
                        rightValue.setBit(nArray[i], false);
                    }
                }
                return rightValue.toString();
            }
            catch (WCMException wCMException) {
                throw new WCMException(1100, I18NMessage.get(WCMDocumentHelper.class, "WCMDocumentHelper.label2", "\u83b7\u53d6\u6307\u5b9a\u5bf9\u8c61\u7684\u6743\u9650\u503c\u65f6\u5931\u8d25"), wCMException);
            }
        }
        if (user.isAdministrator()) {
            if (!bl2) {
                return RightValue.getAdministratorValues();
            }
            RightValue rightValue = new RightValue(RightValue.getAdministratorRightValue().getValue());
            for (int i = 0; i < nArray.length; ++i) {
                rightValue.setBit(nArray[i], false);
            }
            return rightValue.toString();
        }
        Channel channel2 = channel;
        if (channel != null && channel.isOnlySearch() && (channel2 = document.getChannel()) == null) {
            logger.error((Object)(document + I18NMessage.get(WCMDocumentHelper.class, "WCMDocumentHelper.label3", "\u6240\u5c5e\u680f\u76ee[ID=") + document.getChannelId() + I18NMessage.get(WCMDocumentHelper.class, "WCMDocumentHelper.label4", "]\u4e0d\u5b58\u5728")));
            return "0";
        }
        int n = document.getChannelId();
        String string2 = n + "." + n;
        RightValue rightValue = new RightValue();
        if (channel2 == null || channel2.getId() == n) {
            if (channel2 != null && user.getName().equals(channel2.getCrUserName())) {
                return RightValue.getAdministratorValues();
            }
            object = WCMDocumentHelper.getChannelRightValueFromCache(methodContext, user, string2, n);
            rightValue.copy((RightValue)object);
        } else {
            object = n + "." + channel2.getId();
            RightValue rightValue2 = null;
            rightValue2 = user.getName().equalsIgnoreCase(channel2.getCrUserName()) ? RightValue.getAdministratorRightValue() : WCMDocumentHelper.getChannelRightValueFromCache(methodContext, user, (String)object, channel2.getId());
            RightValue rightValue3 = WCMDocumentHelper.getChannelRightValueFromCache(methodContext, user, string2, document.getChannelId());
            rightValue.copy(rightValue3);
            int[] nArray3 = RightConfigServer.getInstance().getRightIndexDefineOnCurrChannel(channel2.getSiteId());
            for (int i = 0; i < nArray3.length; ++i) {
                int n2 = nArray3[i];
                rightValue.setBit(n2, rightValue2.getBit(n2));
            }
        }
        if (user.getName().equalsIgnoreCase(document.getCrUserName())) {
            object = DocumentAuthServer.INDEXES_OWNER_HAS;
            for (int i = 0; i < ((Object)object).length; ++i) {
                Object object2 = object[i];
                rightValue.setBit((int)object2, true);
            }
        }
        if (bl2) {
            for (int i = 0; i < nArray.length; ++i) {
                rightValue.setBit(nArray[i], false);
            }
        }
        return rightValue.toString();
    }

    private static RightValue getChannelRightValueFromCache(MethodContext methodContext, User user, String string, int n) throws WCMException {
        RightValue rightValue = (RightValue)methodContext.getContextCacheData(string);
        if (rightValue == null) {
            rightValue = new RightValue();
            rightValue.load(user, 101, n, true);
            methodContext.putContextCacheData(string, rightValue);
        }
        return rightValue;
    }

    public static ViewDocuments findViewDocumentsByIds(User user, String string) throws WCMException {
        String string2 = "RecId,ChnlId,DocId,DocChannel";
        WCMFilter wCMFilter = new WCMFilter("WCMChnlDoc", "", "", string2);
        int[] nArray = CMyString.splitToInt(string, ",");
        StringBuffer stringBuffer = new StringBuffer(string.length() + nArray.length * 1 + 20);
        stringBuffer.append("RecId in(?");
        wCMFilter.addSearchValues(nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            stringBuffer.append(",?");
            wCMFilter.addSearchValues(nArray[i]);
        }
        stringBuffer.append(")");
        wCMFilter.setWhere(stringBuffer.toString());
        ViewDocuments viewDocuments = new ViewDocuments(user);
        viewDocuments.setSelectFields("RecId,ChnlId,DocId,DocChannel", "CrUser");
        viewDocuments.setPageSize(nArray.length);
        viewDocuments.openViewDocuments(wCMFilter);
        return viewDocuments;
    }
}

