/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.TemplateEmployMgrHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateEmploy;
import com.trs.components.common.publish.persistent.template.TemplateEmploys;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.ArrayList;

public class TemplateServiceHelperProvider
implements IGlueServiceProvider {
    private TemplateEmployMgr m_oEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");

    public void setChannelEmployersOfTemplate(MethodContext methodContext) throws Throwable {
        Object object;
        User user = this.getLoginUser();
        int n = methodContext.getValue("TemplateId", 0);
        Template template = Template.findById(n);
        if (template == null) {
            throw new WCMException(I18NMessage.get(TemplateServiceHelperProvider.class, "TemplateServiceHelperProvider.label9", "\u6a21\u677f[ID=") + n + I18NMessage.get(TemplateServiceHelperProvider.class, "TemplateServiceHelperProvider.label1", "]\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01"));
        }
        this.validateRight(user, template, 24, I18NMessage.get(TemplateServiceHelperProvider.class, "TemplateServiceHelperProvider.label2", "\u8bbe\u7f6e"));
        boolean bl = methodContext.getValue("SetDefaultTemplate", true);
        String string = methodContext.getValue("EmployOnSite");
        if (string != null && template.getFolderType() == 103) {
            object = template.getFolder();
            if (!object.isCanDoSave(user) && !AuthServer.hasRight(user, object.getSubstance(), 9)) {
                throw new WCMException(I18NMessage.get(TemplateServiceHelperProvider.class, "TemplateServiceHelperProvider.label3", "\u60a8[") + user.getName() + I18NMessage.get(TemplateServiceHelperProvider.class, "TemplateServiceHelperProvider.label4", "]\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u6a21\u677f\u6240\u5c5e\u7ad9\u70b9\u8bbe\u7f6e\u6a21\u677f\uff01"));
            }
            boolean bl2 = methodContext.getValue("EmployOnSite", false);
            if (!bl2) {
                this.clearEmploymentOfEmployer((IPublishElement)object, template);
            } else if (bl) {
                this.setDefaultTemplate((IPublishElement)object, template);
            } else {
                TemplateEmployMgrHelper.setOtherOutlinesOfSite((IPublishElement)object, template);
            }
        }
        if (bl) {
            int n2;
            object = methodContext.getValue("ChannelIds");
            if (CMyString.isEmpty((String)object)) {
                this.clearEmploymentOfEmployee(template, 101);
                return;
            }
            Channels channels = Channels.findByIds(user, (String)object);
            if (channels == null || channels.size() == 0) {
                return;
            }
            String[] stringArray = null;
            String string2 = this.getAllEmployMentOfEmployee(template, 101);
            if (!string2.equals("")) {
                stringArray = string2.split(",");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (stringArray != null) {
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    arrayList.add(stringArray[n2]);
                }
            }
            for (n2 = 0; n2 < channels.size(); ++n2) {
                Channel channel = (Channel)channels.getAt(n2);
                int n3 = channel.getId();
                arrayList2.add(String.valueOf(n3));
                if (arrayList != null && arrayList.contains(String.valueOf(n3))) continue;
                IPublishElement iPublishElement = PublishElementFactory.lookupElement(101, channel.getId());
                this.setDefaultTemplate(iPublishElement, template);
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                if (arrayList2.contains(arrayList.get(n2))) continue;
                int n4 = Integer.parseInt(String.valueOf(arrayList.get(n2)));
                this.clearEmploymentOfChnlEmployer(n4, template);
            }
        } else {
            TemplateEmployMgrHelper.setOtherOutlinesOfChannels(methodContext, template);
        }
    }

    private String getAllEmployMentOfEmployee(Template template, int n) throws WCMException {
        if (template == null) {
            return null;
        }
        String string = "TEMPLATETYPE=? AND EMPLOYERTYPE=? AND TEMPLATEID=? AND ISDEFAULT=?";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.addSearchValues(0, template.getType());
        wCMFilter.addSearchValues(1, n);
        wCMFilter.addSearchValues(2, template.getId());
        wCMFilter.addSearchValues(3, 1);
        TemplateEmploys templateEmploys = TemplateEmploys.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        String string2 = "";
        for (int i = 0; i < templateEmploys.size(); ++i) {
            TemplateEmploy templateEmploy = (TemplateEmploy)templateEmploys.getAt(i);
            int n2 = templateEmploy.getEmployerId();
            string2 = i == templateEmploys.size() - 1 ? string2 + n2 : string2 + n2 + ",";
        }
        return string2;
    }

    private void clearEmploymentOfChnlEmployer(int n, Template template) throws WCMException {
        if (template == null || n == 0) {
            return;
        }
        String string = "TEMPLATETYPE=? AND EMPLOYERTYPE=? AND TEMPLATEID=? AND ISDEFAULT=? AND EMPLOYERID=?";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.addSearchValues(0, template.getType());
        wCMFilter.addSearchValues(1, 101);
        wCMFilter.addSearchValues(2, template.getId());
        wCMFilter.addSearchValues(3, 1);
        wCMFilter.addSearchValues(4, n);
        TemplateEmploys templateEmploys = TemplateEmploys.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        templateEmploys.removeAll(true);
    }

    private int clearEmploymentOfEmployer(IPublishElement iPublishElement, Template template) throws WCMException {
        if (iPublishElement == null || template == null) {
            return 0;
        }
        String string = "EMPLOYERID=? AND EMPLOYERTYPE=? AND TEMPLATEID=? AND ISDEFAULT=?";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.addSearchValues(0, iPublishElement.getId());
        wCMFilter.addSearchValues(1, iPublishElement.getType());
        wCMFilter.addSearchValues(2, template.getId());
        wCMFilter.addSearchValues(3, 1);
        TemplateEmploys templateEmploys = TemplateEmploys.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        int n = templateEmploys.size();
        templateEmploys.removeAll(true);
        return n;
    }

    private int clearEmploymentOfEmployee(Template template, int n) throws WCMException {
        if (template == null) {
            return 0;
        }
        String string = "TEMPLATETYPE=? AND EMPLOYERTYPE=? AND TEMPLATEID=? AND ISDEFAULT=?";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.addSearchValues(0, template.getType());
        wCMFilter.addSearchValues(1, n);
        wCMFilter.addSearchValues(2, template.getId());
        wCMFilter.addSearchValues(3, 1);
        TemplateEmploys templateEmploys = TemplateEmploys.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        int n2 = templateEmploys.size();
        templateEmploys.removeAll(true);
        return n2;
    }

    private void setDefaultTemplate(IPublishElement iPublishElement, Template template) throws Throwable {
        if (iPublishElement == null || template == null) {
            return;
        }
        User user = this.getLoginUser();
        if (!iPublishElement.isCanDoSave(user) && !AuthServer.hasRight(user, iPublishElement.getSubstance(), 9)) {
            throw new WCMException(I18NMessage.get(TemplateServiceHelperProvider.class, "TemplateServiceHelperProvider.label5", "\u60a8\u6ca1\u6709\u6743\u9650\u8bbe\u7f6e\uff1a") + iPublishElement.getInfo() + I18NMessage.get(TemplateServiceHelperProvider.class, "TemplateServiceHelperProvider.label6", "\u7684\u6a21\u677f\uff01"));
        }
        int n = template.getType();
        int n2 = template.getId();
        if (iPublishElement.isFolder()) {
            switch (n) {
                case 2: {
                    this.m_oEmployMgr.setDetailTemplate(iPublishElement, n2, false);
                    break;
                }
                case 3: {
                    this.m_oEmployMgr.setDetailTemplate((IPublishFolder)iPublishElement, n2, false, 3);
                    break;
                }
                case 1: {
                    this.m_oEmployMgr.setDefaultOutline((IPublishFolder)iPublishElement, n2);
                    break;
                }
            }
        } else {
            this.m_oEmployMgr.setDetailTemplate(iPublishElement, n2, false);
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void validateRight(User user, IPublishFolder iPublishFolder, int n, String string) throws WCMException {
        if (AuthServer.hasRight(user, iPublishFolder.getSubstance(), n)) {
            return;
        }
        IPublishFolder iPublishFolder2 = iPublishFolder.getParent();
        if (iPublishFolder2 == null || iPublishFolder2 == iPublishFolder) {
            throw new WCMException(I18NMessage.get(TemplateServiceHelperProvider.class, "TemplateServiceHelperProvider.label7", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(TemplateServiceHelperProvider.class, "TemplateServiceHelperProvider.label8", "]\u6ca1\u6709\u6743\u9650\u6267\u884c") + string + "\uff01");
        }
        this.validateRight(user, iPublishFolder2, n, string);
    }

    private void validateRight(User user, Template template, int n, String string) throws WCMException {
        if (user.getName().equalsIgnoreCase(template.getCrUserName())) {
            return;
        }
        this.validateRight(user, template.getFolder(), n, string);
    }

    public void delete(MethodContext methodContext) throws Throwable {
    }

    public Object query(MethodContext methodContext) throws Throwable {
        return null;
    }

    public int save(MethodContext methodContext) throws Throwable {
        return 0;
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        return null;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return null;
    }
}

