/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.ajaxservice.ChannelHelper;
import com.trs.ajaxservice.JSONHelper;
import com.trs.ajaxservice.WebSiteHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.util.HashMap;

public class SystemServiceProvider
implements ISelfDefinedServiceProvider {
    public static String[][] SITE_TYPES = new String[][]{{"sitetype", I18NMessage.get(SystemServiceProvider.class, "SystemServiceProvider.label1", "\u6587\u5b57\u5e93"), String.valueOf(0)}, {"sitetype", I18NMessage.get(SystemServiceProvider.class, "SystemServiceProvider.label2", "\u56fe\u7247\u5e93"), String.valueOf(1)}, {"sitetype", I18NMessage.get(SystemServiceProvider.class, "SystemServiceProvider.label3", "\u89c6\u9891\u5e93"), String.valueOf(2)}, {"sitetype", I18NMessage.get(SystemServiceProvider.class, "SystemServiceProvider.label4", "\u8d44\u6e90\u5e93"), String.valueOf(4)}};

    public String findNodesByPath(MethodContext methodContext) throws Throwable {
        Object[] objectArray;
        block19: {
            int n;
            CMSBaseObjs cMSBaseObjs;
            HashMap<String, Object> hashMap;
            String string;
            block21: {
                String[] stringArray;
                String string2;
                User user;
                block20: {
                    int n2;
                    boolean bl;
                    block18: {
                        user = this.getLoginUser();
                        objectArray = null;
                        string2 = methodContext.getValue("Path");
                        if (string2 != null) {
                            string2 = string2.trim();
                        }
                        string = null;
                        hashMap = new HashMap<String, Object>(2);
                        hashMap.put("ParentType", "");
                        hashMap.put("ParentId", "-1");
                        if (string2 != null && string2.length() != 0 && !string2.equals("\\")) break block18;
                        string = "\\";
                        objectArray = new HashMap[SITE_TYPES.length + 1];
                        objectArray[0] = hashMap;
                        for (int i = 0; i < SITE_TYPES.length; ++i) {
                            objectArray[i + 1] = this.makeNodeInfo(SITE_TYPES[i][0], SITE_TYPES[i][1], SITE_TYPES[i][2], string);
                        }
                        break block19;
                    }
                    cMSBaseObjs = null;
                    if (string2.charAt(0) != '\\') break block20;
                    stringArray = string2.split("\\\\");
                    n = stringArray.length - 1;
                    boolean bl2 = bl = string2.charAt(string2.length() - 1) == '\\';
                    if (bl) {
                        string = string2;
                        hashMap = new HashMap(2);
                    } else {
                        n2 = string2.lastIndexOf(92);
                        string = string2.substring(0, n2 + 1);
                    }
                    switch (n) {
                        case 1: {
                            if (bl) {
                                n2 = this.findSiteTypeId(stringArray[1]);
                                hashMap.put("ParentType", "SiteType");
                                hashMap.put("ParentId", String.valueOf(n2));
                                if (n2 != -1) {
                                    cMSBaseObjs = WebSiteHelper.getWebSitesByType(user, n2, new WCMFilter("", "", "SiteOrder Desc"));
                                    break;
                                }
                            } else {
                                objectArray = new HashMap[SITE_TYPES.length];
                                for (n2 = 0; n2 < SITE_TYPES.length; ++n2) {
                                    String string3 = SITE_TYPES[n2][1];
                                    if (string3.indexOf(stringArray[1]) < 0) continue;
                                    objectArray[n2] = this.makeNodeInfo(SITE_TYPES[n2][0], string3, SITE_TYPES[n2][2], string);
                                }
                            }
                            break block21;
                        }
                        case 2: {
                            String string4 = stringArray[2];
                            if (bl) {
                                WebSite webSite = this.findSiteByName(user, this.findSiteTypeId(stringArray[1]), stringArray[2]);
                                hashMap.put("ParentType", "Site");
                                hashMap.put("ParentId", webSite.getKey());
                                cMSBaseObjs = ChannelHelper.getChildren(user, webSite, new WCMFilter("", "", "ChnlOrder Desc"));
                                break;
                            }
                            int n3 = this.findSiteTypeId(stringArray[1]);
                            if (n3 != -1) {
                                cMSBaseObjs = WebSiteHelper.getWebSitesByType(user, n3, null);
                                for (int i = cMSBaseObjs.size() - 1; i >= 0; --i) {
                                    WebSite webSite = (WebSite)cMSBaseObjs.getAt(i);
                                    if (!this.notSimilar(string4, webSite)) continue;
                                    cMSBaseObjs.removeAt(i, false);
                                }
                            }
                            break block21;
                        }
                        default: {
                            cMSBaseObjs = this.findChannelsByPath(user, stringArray, bl, 2, null, hashMap);
                        }
                    }
                    break block21;
                }
                stringArray = "Status>=0 and ChnlDesc like ?";
                WCMFilter wCMFilter = new WCMFilter("", (String)stringArray, "");
                wCMFilter.addSearchValues(0, '%' + string2 + '%');
                cMSBaseObjs = Channels.openWCMObjs(user, wCMFilter);
                ChannelHelper.removeNoRightChannel(user, (Channels)cMSBaseObjs, 64);
            }
            if (string != null) {
                string = CMyString.filterForHTMLValue(string);
            }
            int n4 = cMSBaseObjs == null ? 0 : cMSBaseObjs.size();
            objectArray = new HashMap[n4 + 1];
            objectArray[0] = hashMap;
            if (n4 == 1 && hashMap.get("ParentId").toString().equals("-1")) {
                BaseChannel baseChannel = (BaseChannel)cMSBaseObjs.getAt(0);
                hashMap.put("ParentType", baseChannel.isSite() ? "Site" : "Channel");
                hashMap.put("ParentId", baseChannel.getKey());
            }
            for (n = 0; n < n4; ++n) {
                BaseChannel baseChannel = (BaseChannel)cMSBaseObjs.getAt(n);
                if (baseChannel == null) continue;
                objectArray[n + 1] = this.makeNodeInfo(baseChannel.isSite() ? "site" : "channel", baseChannel.getDispDesc(), baseChannel.getId(), string == null ? this.getPathPre(baseChannel.getHost(), "") : string);
            }
        }
        methodContext.setReturnJSON(true);
        return JSONHelper.toJSON(objectArray, 0);
    }

    public boolean isValidChannelId(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        Channel channel = Channel.findById(methodContext.getObjectId());
        return channel != null && AuthServer.hasRight(user, (CMSObj)channel, 64) && channel.getStatus() >= 0;
    }

    public boolean isValidSiteId(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        WebSite webSite = WebSite.findById(methodContext.getObjectId());
        return webSite != null && AuthServer.hasRight(user, (CMSObj)webSite, 64) && webSite.getStatus() >= 0;
    }

    private Channels findChannelsByPath(User user, String[] stringArray, boolean bl, int n, BaseChannel baseChannel, HashMap hashMap) throws WCMException {
        BaseChannel baseChannel2 = baseChannel;
        if (baseChannel2 == null) {
            int n2 = this.findSiteTypeId(stringArray[1]);
            if (n2 == -1) {
                return null;
            }
            WebSite webSite = this.findSiteByName(user, n2, stringArray[2]);
            if (webSite == null) {
                return null;
            }
            baseChannel2 = webSite;
            return this.findChannelsByPath(user, stringArray, bl, n + 1, baseChannel2, hashMap);
        }
        if (n < stringArray.length - 1 || bl) {
            Channel channel = this.findChannelByName(user, baseChannel2, stringArray[n]);
            if (channel == null) {
                return null;
            }
            if (n == stringArray.length - 1) {
                hashMap.put("ParentType", "Channel");
                hashMap.put("ParentId", channel.getKey());
                return ChannelHelper.getChildren(user, channel, null);
            }
            return this.findChannelsByPath(user, stringArray, bl, n + 1, channel, hashMap);
        }
        return this.findChannelsBySimilarName(user, baseChannel2, stringArray[n]);
    }

    private Channel findChannelByName(User user, BaseChannel baseChannel, String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "ChnlDesc=? and Status>=0", "");
        wCMFilter.addSearchValues(0, string);
        Channels channels = ChannelHelper.getChildren(user, baseChannel, wCMFilter);
        if (!channels.isEmpty()) {
            return (Channel)channels.getAt(0);
        }
        return null;
    }

    private Channels findChannelsBySimilarName(User user, BaseChannel baseChannel, String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "ChnlDesc like ? and Status>=0", "");
        wCMFilter.addSearchValues(0, '%' + string + '%');
        return ChannelHelper.getChildren(user, baseChannel, wCMFilter);
    }

    private WebSite findSiteByName(User user, int n, String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "SiteType=? and SiteDesc=? and Status>=0", "");
        wCMFilter.addSearchValues(0, n);
        wCMFilter.addSearchValues(1, string);
        wCMFilter.setMaxRowNumber(1);
        WebSites webSites = WebSites.openWCMObjs(user, wCMFilter);
        if (!webSites.isEmpty()) {
            return (WebSite)webSites.getAt(0);
        }
        return null;
    }

    private boolean notSimilar(String string, WebSite webSite) {
        return webSite == null || webSite.getDispDesc().indexOf(string) < 0;
    }

    private String getPathPre(BaseChannel baseChannel, String string) throws WCMException {
        if (baseChannel == null) {
            return I18NMessage.get(SystemServiceProvider.class, "SystemServiceProvider.label5", "\u7236\u5bf9\u8c61\u6ca1\u6709\u627e\u5230");
        }
        String string2 = baseChannel.getDispDesc();
        if (baseChannel.isSite()) {
            WebSite webSite = (WebSite)baseChannel;
            return '\\' + SystemServiceProvider.getSiteTypeDesc(webSite.getPropertyAsString("SITETYPE")) + "\\" + CMyString.filterForHTMLValue(string2) + "\\" + string;
        }
        return this.getPathPre(baseChannel.getHost(), string + CMyString.filterForHTMLValue(string2) + "\\");
    }

    public static String getSiteTypeDesc(String string) {
        for (int i = 0; i < SITE_TYPES.length; ++i) {
            if (!SITE_TYPES[i][2].equals(string)) continue;
            return SITE_TYPES[i][1];
        }
        return I18NMessage.get(SystemServiceProvider.class, "SystemServiceProvider.label6", "\u672a\u77e5\u7ad9\u70b9\u7c7b\u578b");
    }

    private int findSiteTypeId(String string) {
        for (int i = 0; i < SITE_TYPES.length; ++i) {
            String string2 = SITE_TYPES[i][1];
            if (!string2.equalsIgnoreCase(string)) continue;
            return Integer.parseInt(SITE_TYPES[i][2]);
        }
        return -1;
    }

    private HashMap makeNodeInfo(String string, String string2, int n, String string3) {
        return this.makeNodeInfo(string, string2, String.valueOf(n), string3);
    }

    private HashMap makeNodeInfo(String string, String string2, String string3, String string4) {
        String string5 = CMyString.filterForHTMLValue(string2);
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("type", string);
        hashMap.put("name", string5);
        hashMap.put("id", string3);
        hashMap.put("path", string4 + string5);
        return hashMap;
    }

    private User getLoginUser() {
        User user = ContextHelper.getLoginUser();
        return user;
    }
}

