/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.GroupServiceProvider;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.GroupMgr;
import com.trs.cms.auth.domain.GroupRoleMgr;
import com.trs.cms.auth.domain.RoleMgr;
import com.trs.cms.auth.domain.UserMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.RoleUser;
import com.trs.cms.auth.persistent.RoleUsers;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RoleServiceProvider
implements IGlueServiceProvider {
    public void delete(MethodContext methodContext) throws Throwable {
    }

    public Object query(MethodContext methodContext) throws Throwable {
        return null;
    }

    public void saveRoles(MethodContext methodContext) throws Throwable {
        int n;
        User user = ContextHelper.getLoginUser();
        int n2 = methodContext.getValue("UserId", 0);
        Roles roles = Roles.findByIds(user, methodContext.getValue("CurrRoleIds"));
        User user2 = null;
        if (n2 > 0) {
            user2 = User.findById(n2);
            if (user2 == null) {
                throw new WCMException(I18NMessage.get(GroupServiceProvider.class, "UserServiceProvider.label4", "\u6ca1\u6709\u627e\u5230ID\u4e3a[") + n2 + "]" + I18NMessage.get(GroupServiceProvider.class, "UserServiceProvider.label3", "\u7684\u7528\u6237\uff01"));
            }
        } else {
            throw new WCMException(I18NMessage.get(GroupServiceProvider.class, "UserServiceProvider.label8", "\u83b7\u53d6\u7684\u7528\u6237ID\u4e0d\u6b63\u786e\uff01"));
        }
        Roles roles2 = user2.getRoles();
        RoleMgr roleMgr = new RoleMgr();
        for (n = 0; n < roles.size(); ++n) {
            if (roles2.indexOf(roles.getAt(n)) >= 0) continue;
            roleMgr.addUser(user2, (Role)roles.getAt(n));
        }
        for (n = 0; n < roles2.size(); ++n) {
            if (roles.indexOf(roles2.getAt(n)) >= 0) continue;
            roleMgr.removeUser(user2, (Role)roles2.getAt(n));
        }
    }

    public int save(MethodContext methodContext) throws Throwable {
        Role role;
        int n = methodContext.getObjectId();
        int n2 = methodContext.getValue("RoleType", 0);
        int n3 = methodContext.getValue("Range", 0);
        String string = methodContext.getValue("GroupIds");
        User user = ContextHelper.getLoginUser();
        if (n <= 0) {
            role = Role.createNewInstance();
        } else {
            role = Role.findById(n);
            n2 = role.getRoleType();
            n3 = role.getRoleRange();
        }
        this.validateRight(user, n2, n3);
        this.validateRight(user, string);
        String[] stringArray = new String[]{"ObjectId"};
        role = (Role)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, role, stringArray);
        if (role.isChangeProperty("RoleType")) {
            throw new WCMException("\u4e0d\u80fd\u4fee\u6539\u89d2\u8272\u7684\u7c7b\u578b");
        }
        role.save(user);
        if (n2 == 0 && n3 == 0) {
            this.getGroupRoleMgr().setGroups(role, Groups.findByIds(user, string));
        }
        return role.getId();
    }

    private void validateRight(User user, int n, int n2) throws WCMException {
        if (user.isAdministrator()) {
            return;
        }
        if (n == -1 || n2 == -1 || n2 == 1) {
            throw new WCMException("\u4ec5\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u53ef\u4ee5\u521b\u5efa\u7cfb\u7edf\u7ea7\u89d2\u8272\u6216\u5bf9\u6240\u6709\u7ec4\u7ec7\u53ef\u80fd\u7684\u89d2\u8272");
        }
        RoleMgr roleMgr = this.getRoleMgr();
        if (!roleMgr.isRoleManagers(user)) {
            throw new WCMException("\u4ec5\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u89d2\u8272\u7ba1\u7406\u5458\u53ef\u4ee5\u521b\u5efa\u7279\u5b9a\u89d2\u8272");
        }
    }

    private void validateRight(User user, String string) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return;
        }
        if (user.isAdministrator()) {
            return;
        }
        GroupMgr groupMgr = this.getGroupMgr();
        Groups groups = Groups.findByIds(ContextHelper.getLoginUser(), string);
        int n = groups.size();
        for (int i = 0; i < n; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null || groupMgr.isAdministrator(group, user, true)) continue;
            throw new WCMException("\u4e0d\u80fd\u5728\u975e\u7ec4\u7ba1\u7406\u5458\u7684\u7ec4\u7ec7\u4e0a\u521b\u5efa\u89d2\u8272");
        }
    }

    public Roles getRolesForCurrUser(MethodContext methodContext) throws Throwable {
        User user = ContextHelper.getLoginUser();
        String string = methodContext.getValue("RoleType");
        String string2 = methodContext.getValue("Viewable");
        boolean bl = methodContext.getValue("IncludeEveryone", false);
        String string3 = "";
        if (!CMyString.isEmpty(string)) {
            string3 = string3 + "RoleType=?";
        }
        if (!CMyString.isEmpty(string2)) {
            if (string3 != "") {
                string3 = string3 + " and ";
            }
            string3 = string3 + "Viewable=?";
        }
        WCMFilter wCMFilter = new WCMFilter("", string3, "");
        if (!CMyString.isEmpty(string)) {
            wCMFilter.addSearchValues(Integer.parseInt(string));
        }
        if (!CMyString.isEmpty(string2)) {
            wCMFilter.addSearchValues(Integer.parseInt(string2));
        }
        WCMFilter wCMFilter2 = methodContext.getExtraWCMFilter();
        wCMFilter2.mergeWith(wCMFilter);
        return this.getRoleMgr().getRolesForUser(user, wCMFilter2, bl);
    }

    public Map getSiteRoleUsersInfo(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("UserId", 0);
        User user = User.findById(n);
        if (user == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7528\u6237[UserId" + n + "]\u4e0d\u5b58\u5728");
        }
        RoleUsers roleUsers = this.getRoleMgr().getRoleUsers(user, null);
        HashMap<Integer, ArrayList<RoleUser>> hashMap = new HashMap<Integer, ArrayList<RoleUser>>();
        int n2 = roleUsers.size();
        for (int i = 0; i < n2; ++i) {
            RoleUser roleUser = (RoleUser)roleUsers.getAt(i);
            if (roleUser == null) continue;
            Integer n3 = new Integer(roleUser.getSiteId());
            if (this.isDirtyData(roleUser)) continue;
            ArrayList<RoleUser> arrayList = (ArrayList<RoleUser>)hashMap.get(n3);
            if (arrayList == null) {
                arrayList = new ArrayList<RoleUser>();
                hashMap.put(n3, arrayList);
            }
            arrayList.add(roleUser);
        }
        return hashMap;
    }

    private boolean isDirtyData(RoleUser roleUser) throws WCMException {
        if (roleUser == null) {
            return true;
        }
        Role role = Role.findById(roleUser.getRoleId());
        if (role == null) {
            return true;
        }
        int n = roleUser.getSiteId();
        return role.isSystemRole() && n == -1 || !role.isSystemRole() && n == 0;
    }

    public void saveRoleUsers(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("RoleId", 0);
        Role role = Role.findById(n);
        if (role == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u89d2\u8272[RoleId" + n + "]\u6ca1\u6709\u627e\u5230");
        }
        if (role.getRoleType() == -1) {
            this.saveUsersOfSystemRoleOnSite(methodContext);
        } else {
            this.saveUsersOfSpecialRole(methodContext);
        }
    }

    public void saveUsersOfSystemRoleOnSite(MethodContext methodContext) throws Throwable {
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getValue("SiteId", 0);
        int n2 = methodContext.getValue("RoleId", 0);
        Role role = Role.findById(n2);
        if (role == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u89d2\u8272[RoleId" + n2 + "]\u6ca1\u6709\u627e\u5230");
        }
        if (role.getRoleType() != -1) {
            throw new WCMException("\u975e\u7cfb\u7edf\u7ea7\u89d2\u8272[RoleId" + n2 + "]\u4e0d\u80fd\u4f7f\u7528\u8be5\u63a5\u53e3");
        }
        RoleMgr roleMgr = this.getRoleMgr();
        if (!user.isAdministrator() && !roleMgr.isRoleManagers(user)) {
            throw new WCMException("\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u89d2\u8272\u7ba1\u7406\u5458\u80fd\u7ed9\u7cfb\u7edf\u7ea7\u89d2\u8272\u6dfb\u52a0\u7528\u6237");
        }
        String string = methodContext.getValue("UserIds");
        Users users = Users.findByIds(ContextHelper.getLoginUser(), string);
        roleMgr.setRoleUsers(role, n, users);
    }

    public void saveUsersOfSpecialRole(MethodContext methodContext) throws Throwable {
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getValue("RoleId", 0);
        Role role = Role.findById(n);
        if (role == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u89d2\u8272[RoleId" + n + "]\u6ca1\u6709\u627e\u5230");
        }
        if (role.getRoleType() != 0) {
            throw new WCMException("\u975e\u7279\u5b9a\u89d2\u8272[RoleId" + n + "]\u4e0d\u80fd\u4f7f\u7528\u8be5\u63a5\u53e3");
        }
        String string = methodContext.getValue("UserIds");
        Users users = Users.findByIds(ContextHelper.getLoginUser(), string);
        RoleMgr roleMgr = this.getRoleMgr();
        if (!user.isAdministrator() && !roleMgr.isRoleManagers(user)) {
            throw new WCMException("\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u89d2\u8272\u7ba1\u7406\u5458\u80fd\u7ed9\u7279\u5b9a\u89d2\u8272\u6dfb\u52a0\u7528\u6237");
        }
        roleMgr.setRoleUsers(role, -1, users);
    }

    public void removeUsersFromCurrRole(MethodContext methodContext) throws Throwable {
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getValue("RoleId", 0);
        Role role = Role.findById(n);
        int n2 = methodContext.getValue("SiteId", 0);
        if (role == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u89d2\u8272[RoleId" + n + "]\u6ca1\u6709\u627e\u5230");
        }
        String string = methodContext.getValue("UserIds");
        Users users = Users.findByIds(ContextHelper.getLoginUser(), string);
        if (users == null) {
            throw new WCMException("\u6ca1\u6709\u627e\u5230\u8981\u5220\u9664\u7684\u7528\u6237");
        }
        RoleMgr roleMgr = this.getRoleMgr();
        if (!user.isAdministrator() && !roleMgr.isRoleManagers(user)) {
            throw new WCMException("\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u89d2\u8272\u7ba1\u7406\u5458\u80fd\u5220\u9664\u7528\u6237");
        }
        for (int i = 0; i < users.size(); ++i) {
            roleMgr.removeUser(role, n2, (User)users.getAt(i));
        }
    }

    public Roles getSystemRolesOfUser(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("SiteId", 0);
        int n2 = methodContext.getValue("UserId", 0);
        User user = User.findById(n2);
        if (user == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7528\u6237[UserId=" + n2 + "]\u6ca1\u6709\u627e\u5230");
        }
        WCMFilter wCMFilter = methodContext.getExtraWCMFilter();
        RoleMgr roleMgr = this.getRoleMgr();
        return roleMgr.getSystemRolesOfUser(user, n, wCMFilter);
    }

    public void saveSystemRolesOfUser(MethodContext methodContext) throws Throwable {
        Roles roles;
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getValue("SiteId", 0);
        int n2 = methodContext.getValue("UserId", 0);
        String string = methodContext.getValue("RoleIds");
        User user2 = User.findById(n2);
        if (user2 == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7528\u6237[UserId=" + n2 + "]\u6ca1\u6709\u627e\u5230\uff01");
        }
        RoleMgr roleMgr = this.getRoleMgr();
        if (!user.isAdministrator()) {
            if (!this.getUserMgr().isManagerOfUser(user2)) {
                throw new WCMException("\u60a8\u4e0d\u662f\u5f53\u524d\u7528\u6237\u7684\u7ec4\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u4fee\u6539\u8be5\u7528\u6237\u89d2\u8272\u4fe1\u606f\u7684\u6743\u9650\uff01");
            }
            roles = roleMgr.getRolesForUser(user, null);
            int[] nArray = CMyString.splitToInt(string, ",");
            for (int i = 0; i < nArray.length; ++i) {
                String string2 = "userid=" + user2.getId() + " and roleid=" + nArray[i] + " and siteid=" + n;
                WCMFilter wCMFilter = new WCMFilter("", string2, "");
                RoleUsers roleUsers = RoleUsers.openWCMObjs(null, wCMFilter);
                if (roles.indexOf(nArray[i]) >= 0 || roleUsers == null || roleUsers.size() != 0) continue;
                throw new WCMException("\u60a8\u6ca1\u6709\u5411\u89d2\u8272[RoleId=" + nArray[i] + "]\u4e2d\u6dfb\u52a0\u7528\u6237\u7684\u6743\u9650\uff01");
            }
        }
        roles = Roles.findByIds(null, string);
        roleMgr.setSystemRolesOfUser(user2, n, roles);
    }

    public Roles getSpecialRolesOfUser(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("UserId", 0);
        User user = User.findById(n);
        if (user == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7528\u6237[UserId=" + n + "]\u6ca1\u6709\u627e\u5230");
        }
        WCMFilter wCMFilter = methodContext.getExtraWCMFilter();
        RoleMgr roleMgr = this.getRoleMgr();
        return roleMgr.getSpecialRolesOfUser(user, wCMFilter);
    }

    public void saveSpecialRolesOfUser(MethodContext methodContext) throws Throwable {
        Roles roles;
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getValue("UserId", 0);
        User user2 = User.findById(n);
        if (user2 == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7528\u6237[UserId=" + n + "]\u6ca1\u6709\u627e\u5230");
        }
        String string = methodContext.getValue("SpecialRoleIds");
        RoleMgr roleMgr = this.getRoleMgr();
        if (!user.isAdministrator()) {
            if (!this.getUserMgr().isManagerOfUser(user2)) {
                throw new WCMException("\u60a8\u4e0d\u662f\u5f53\u524d\u7528\u6237\u7684\u7ec4\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u4fee\u6539\u8be5\u7528\u6237\u89d2\u8272\u4fe1\u606f\u7684\u6743\u9650\uff01");
            }
            roles = roleMgr.getRolesForUser(user, null);
            int[] nArray = CMyString.splitToInt(string, ",");
            for (int i = 0; i < nArray.length; ++i) {
                String string2 = "userid=" + user2.getId() + " and roleid=" + nArray[i] + " and siteid=-1";
                WCMFilter wCMFilter = new WCMFilter("", string2, "");
                RoleUsers roleUsers = RoleUsers.openWCMObjs(null, wCMFilter);
                if (roles.indexOf(nArray[i]) >= 0 || roleUsers == null || roleUsers.size() != 0) continue;
                throw new WCMException("\u60a8\u6ca1\u6709\u5411\u89d2\u8272[RoleId=" + nArray[i] + "]\u4e2d\u6dfb\u52a0\u7528\u6237\u7684\u6743\u9650\uff01");
            }
        }
        roles = Roles.findByIds(null, string);
        roleMgr.setSpecailRolesOfUser(user2, roles);
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        return null;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return null;
    }

    private RoleMgr getRoleMgr() {
        return (RoleMgr)DreamFactory.createObjectById("RoleMgr");
    }

    private GroupMgr getGroupMgr() {
        return (GroupMgr)DreamFactory.createObjectById("GroupMgr");
    }

    private GroupRoleMgr getGroupRoleMgr() {
        return (GroupRoleMgr)DreamFactory.createObjectById("GroupRoleMgr");
    }

    private UserMgr getUserMgr() {
        return (UserMgr)DreamFactory.createObjectById("UserMgr");
    }
}

