/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.domain.ReplaceMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Replace;
import com.trs.components.wcm.content.persistent.Replaces;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class ReplaceContentServiceProvider
implements IGlueServiceProvider {
    private ReplaceMgr m_oReplaceMgr = (ReplaceMgr)DreamFactory.createObjectById("ReplaceMgr");

    public void delete(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Replaces replaces = Replaces.findByIds(user, methodContext.getObjectIds());
        this.validateRight(user, replaces, I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label1", "\u5220\u9664"), 13);
        int n = replaces.size();
        for (int i = 0; i < n; ++i) {
            Replace replace = (Replace)replaces.getAt(i);
            if (replace == null) continue;
            this.m_oReplaceMgr.delete(replace);
        }
    }

    public Object query(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("ChannelId", 0);
        Channel channel = this.findChannelById(n);
        this.validateRight(user, channel, I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label2", "\u8fdb\u5165\u66ff\u6362\u5185\u5bb9\u5217\u8868"), 13);
        WCMFilter wCMFilter = methodContext.getExtraWCMFilter();
        return this.m_oReplaceMgr.getReplaces(channel, wCMFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int save(MethodContext methodContext) throws Throwable {
        int n;
        User user = this.getLoginUser();
        Replace replace = null;
        int n2 = methodContext.getObjectId();
        if (n2 > 0) {
            replace = this.findReplaceById(n2);
            n = replace.getChnlId();
        } else {
            replace = new Replace();
            n = methodContext.getValue("ChannelId", 0);
            replace.setChnlId(n);
        }
        Channel channel = this.findChannelById(n);
        this.validateRight(user, channel, I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label3", "\u8bbe\u7f6e\u66ff\u6362\u5185\u5bb9"), 13);
        try {
            if (n2 > 0) {
                replace.validCanEditAndLock(user);
            }
            String[] stringArray = new String[]{"ChannelId", "ObjectId"};
            WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, replace, stringArray);
            this.m_oReplaceMgr.save(replace);
            int n3 = replace.getId();
            return n3;
        }
        finally {
            if (n2 > 0) {
                replace.cancelUpdate(user);
            }
        }
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        int n;
        User user = this.getLoginUser();
        Replace replace = null;
        int n2 = methodContext.getObjectId();
        if (n2 > 0) {
            replace = this.findReplaceById(n2);
            n = replace.getChnlId();
        } else {
            replace = new Replace();
            n = methodContext.getValue("ChannelId", 0);
            replace.setChnlId(n);
        }
        Channel channel = this.findChannelById(n);
        this.validateRight(user, channel, I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label4", "\u83b7\u53d6\u6307\u5b9a\u7684\u66ff\u6362\u5185\u5bb9\u4fe1\u606f"), 13);
        return replace;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Replaces replaces = Replaces.findByIds(user, methodContext.getObjectIds());
        this.validateRight(user, replaces, I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label4", "\u83b7\u53d6\u6307\u5b9a\u7684\u66ff\u6362\u5185\u5bb9\u4fe1\u606f"), 13);
        return replaces;
    }

    public boolean existsSimilarName(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("ChannelId", 0);
        Channel channel = this.findChannelById(n);
        this.validateRight(user, channel, I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label5", "\u67e5\u8be2\u76f8\u4f3c\u66ff\u6362\u5185\u5bb9\u540d\u79f0"), 13);
        WCMFilter wCMFilter = new WCMFilter("WCMREPLACE", "ChnlId=? and ReplaceName=? and ReplaceId<>?", "", "ReplaceId");
        wCMFilter.addSearchValues(0, n);
        wCMFilter.addSearchValues(1, methodContext.getValue("ReplaceName"));
        wCMFilter.addSearchValues(2, methodContext.getObjectId());
        return DBManager.getDBManager().sqlExecuteIntQuery(wCMFilter) > 0;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void validateRight(User user, Replaces replaces, String string, int n) throws WCMException {
        for (int i = replaces.size() - 1; i >= 0; --i) {
            Replace replace = (Replace)replaces.getAt(i);
            if (replace == null) {
                replaces.removeAt(i, false);
                continue;
            }
            this.validateRight(user, replace, string, n);
        }
    }

    private void validateRight(User user, Replace replace, String string, int n) throws WCMException {
        Channel channel = replace.getChannel();
        if (!AuthServer.hasRight(user, (CMSObj)channel, n)) {
            throw new WCMException(I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label6", "\u5bf9\u4e0d\u8d77,\u60a8\u5bf9\u4e8e[") + channel + I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label7", "]\u6ca1\u6709\u4fee\u6539\u6743\u9650,\u6240\u4ee5\u4e0d\u80fd") + string + I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label8", "\u66ff\u6362\u5185\u5bb9![Id=") + replace.getId() + "]");
        }
    }

    private void validateRight(User user, Channel channel, String string, int n) throws WCMException {
        if (!AuthServer.hasRight(user, (CMSObj)channel, n)) {
            throw new WCMException(I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label6", "\u5bf9\u4e0d\u8d77,\u60a8\u5bf9\u4e8e[") + channel + I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label7", "]\u6ca1\u6709\u4fee\u6539\u6743\u9650,\u6240\u4ee5\u4e0d\u80fd") + string + I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label9", "\u66ff\u6362\u5185\u5bb9!"));
        }
    }

    private Replace findReplaceById(int n) throws WCMException {
        Replace replace = Replace.findById(n);
        if (replace == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(105)}));
        }
        return replace;
    }

    private Channel findChannelById(int n) throws WCMException {
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException(1100, I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label12", "\u6307\u5b9a\u7684\u680f\u76ee[ID=") + n + I18NMessage.get(ReplaceContentServiceProvider.class, "ReplaceContentServiceProvider.label11", "]\u4e0d\u5b58\u5728!"));
        }
        return channel;
    }
}

