/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.DocumentPublishHelper;
import com.trs.ajaxservice.JSONHelper;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.ajaxservice.WebSiteHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.job.JobWorkerType;
import com.trs.components.common.job.Schedule;
import com.trs.components.common.job.Schedules;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.WCMContentPublishConfig;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.components.wcm.publish.domain.job.WithDrawJobWorker;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class PublishServiceProvider
implements ISelfDefinedServiceProvider {
    private static Logger logger = Logger.getLogger(PublishServiceProvider.class);
    private PublishServer m_oPublishServer = PublishServer.getInstance();
    private static int m_nUnpubWorkerId = 0;

    public Object getPublishConfig(MethodContext methodContext) throws Throwable {
        Object object;
        if (methodContext.getObjectId() == 0) {
            return "";
        }
        User user = this.getLoginUser();
        IPublishElement iPublishElement = this.findPublishElement(methodContext);
        if (iPublishElement.isFolder() && ((IPublishFolder)iPublishElement).isRoot()) {
            object = (WebSite)iPublishElement.getSubstance();
            if (!WebSiteHelper.isVisible(user, (WebSite)object)) {
                throw new WCMException(I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label1", "\u60a8\u6ca1\u6709\u6743\u9650\u6d4f\u89c8\uff1a") + object + I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label2", "\u7684\u53d1\u5e03\u5c5e\u6027\uff01"));
            }
        } else if (!AuthServer.hasRight(user, iPublishElement.getSubstance(), 64)) {
            throw new WCMException(I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label1", "\u60a8\u6ca1\u6709\u6743\u9650\u6d4f\u89c8\uff1a") + iPublishElement.getInfo() + I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label2", "\u7684\u53d1\u5e03\u5c5e\u6027\uff01"));
        }
        if (iPublishElement.isFolder()) {
            object = new WCMFolderPublishConfig((IPublishFolder)iPublishElement);
            return object;
        }
        object = new WCMContentPublishConfig(user, (IPublishContent)iPublishElement);
        return object;
    }

    public boolean savePublishConfig(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        IPublishElement iPublishElement = this.findPublishElement(methodContext);
        int n = methodContext.getValue("FlowDocId", 0);
        if (!iPublishElement.isFolder() && n > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(user, iPublishElement.getSubstance(), n, 0, I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label3", "\u53d1\u5e03"));
        } else if (!iPublishElement.isCanDoSave(user)) {
            throw new WCMException(I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label1", "\u60a8\u6ca1\u6709\u6743\u9650\u6d4f\u89c8\uff1a") + iPublishElement.getInfo() + I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label2", "\u7684\u53d1\u5e03\u5c5e\u6027\uff01"));
        }
        if (iPublishElement.isFolder()) {
            WCMFolderPublishConfig wCMFolderPublishConfig = new WCMFolderPublishConfig((IPublishFolder)iPublishElement);
            String[] stringArray = new String[]{"ObjectId"};
            wCMFolderPublishConfig = (WCMFolderPublishConfig)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, wCMFolderPublishConfig, stringArray);
            if (methodContext.containsParameter("OutlineTemplates")) {
                wCMFolderPublishConfig.setOutlineTemplateId(methodContext.getValue("OutlineTemplates"));
            }
            if (methodContext.containsParameter("DetailTemplate")) {
                wCMFolderPublishConfig.setDetailTemplateId(methodContext.getValue("DetailTemplate", 0));
            }
            if (methodContext.containsParameter("InfoviewPrintTemplate")) {
                wCMFolderPublishConfig.setInfoviewPrintTemplateId(methodContext.getValue("InfoviewPrintTemplate", 0));
            }
            if (methodContext.containsParameter("STATUSESCANDOPUB") || methodContext.containsParameter("StatusIdAfterModify")) {
                wCMFolderPublishConfig.setDefineStatus(!CMyString.isEmpty(methodContext.getValue("STATUSESCANDOPUB")) || methodContext.containsParameter("StatusIdAfterModify"));
            }
            if (methodContext.containsParameter("ScheduleMode")) {
                wCMFolderPublishConfig.setDefineSchedule(methodContext.getValue("ScheduleMode", 0) != 0);
            }
            wCMFolderPublishConfig.canEdit(user);
            wCMFolderPublishConfig.save(user);
            return true;
        }
        WCMContentPublishConfig wCMContentPublishConfig = new WCMContentPublishConfig(user, (IPublishContent)iPublishElement);
        if (methodContext.containsParameter("DetailTemplate")) {
            wCMContentPublishConfig.setDetialTemplate(methodContext.getValue("DetailTemplate", 0));
        }
        if (methodContext.containsParameter("ScheduleTime")) {
            wCMContentPublishConfig.setSchedulePublish(methodContext.getValue("ScheduleTime", new CMyDateTime()));
        }
        return true;
    }

    public void publish(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("PublishType", 8);
        String string = methodContext.getObjectIds();
        IPublishElements iPublishElements = PublishElementFactory.lookupElements(methodContext.getValue("ObjectType", 0), string);
        int n2 = iPublishElements.size();
        for (int i = 0; i < n2; ++i) {
            IPublishElement iPublishElement = iPublishElements.get(i);
            if (iPublishElement == null) continue;
            this.publishElement(user, iPublishElement, n, methodContext);
        }
    }

    public String preview(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getObjectIds();
        IPublishElements iPublishElements = PublishElementFactory.lookupElements(methodContext.getValue("ObjectType", 0), string);
        Template template = Template.findById(methodContext.getValue("TemplateId", 0));
        IPublishFolder iPublishFolder = null;
        if (methodContext.getValue("FolderId", 0) > 0) {
            iPublishFolder = this.findFolder(methodContext);
        }
        String[] stringArray = new String[1];
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        int n = 0;
        Object[] objectArray = new Object[iPublishElements.size()];
        HashMap<String, Object> hashMap2 = null;
        int n2 = iPublishElements.size();
        for (int i = 0; i < n2; ++i) {
            hashMap2 = new HashMap<String, Object>(2);
            IPublishElement iPublishElement = iPublishElements.get(i);
            if (iPublishElement == null) {
                hashMap2.put("Exception", I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label4", "\u5bf9\u8c61\u6ca1\u6709\u627e\u5230!"));
                hashMap2.put("URLs", new String[0]);
            } else {
                hashMap2.put("Name", iPublishElement.getInfo());
                int n3 = this.getPreviewRightIndexByType(iPublishElement.getType());
                boolean bl = false;
                if (iPublishElement.getType() == 605) {
                    if (!DocumentAuthServer.hasRight(user, null, (Document)iPublishElement.getSubstance(), n3)) {
                        bl = true;
                    }
                } else if (!AuthServer.hasRight(user, iPublishElement.getSubstance(), n3)) {
                    bl = true;
                }
                if (bl) {
                    hashMap2.put("Exception", I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label5", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label6", "]\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u9884\u89c8\u64cd\u4f5c\uff01"));
                    hashMap2.put("URLs", new String[0]);
                } else {
                    String[] stringArray2;
                    try {
                        if (iPublishElement.isFolder()) {
                            stringArray2 = this.m_oPublishServer.previewFolder((IPublishFolder)iPublishElement, stringArray, template);
                        } else {
                            IPublishContent iPublishContent = (IPublishContent)iPublishElement;
                            if (iPublishFolder != null) {
                                iPublishContent.setFolder(iPublishFolder);
                            }
                            stringArray2 = new String[]{this.m_oPublishServer.previewContent((IPublishContent)iPublishElement, stringArray, template)};
                        }
                        if (stringArray[0] != null) {
                            hashMap2.put("Warning", stringArray[0]);
                        }
                    }
                    catch (Exception exception) {
                        stringArray2 = new String[]{};
                        int n4 = exception.getMessage().indexOf(10);
                        String string2 = exception.getMessage();
                        if (n4 > 0) {
                            string2 = string2.substring(0, n4);
                        }
                        hashMap2.put("Exception", string2);
                        hashMap2.put("ExceptionDetail", CMyException.getStackTraceText(exception));
                    }
                    n += stringArray2.length;
                    hashMap2.put("URLs", stringArray2);
                }
            }
            objectArray[i] = hashMap2;
        }
        hashMap.put("URLCount", String.valueOf(n));
        hashMap.put("Data", objectArray);
        methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(hashMap, 0);
    }

    public void publishContents(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("PublishType", 8);
        IPublishFolder iPublishFolder = this.findFolder(methodContext);
        String string = methodContext.getObjectIds();
        int n2 = methodContext.getValue("ObjectType", 0);
        IPublishElements iPublishElements = PublishElementFactory.lookupElements(n2, string);
        if (!AuthServer.hasRight(user, iPublishFolder.getSubstance(), 39)) {
            throw new WCMException(I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label5", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label7", "]\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u53d1\u5e03\u64cd\u4f5c\uff01"));
        }
        if (n2 == 605 && n == 7) {
            DocumentPublishHelper.delete(string, iPublishFolder.getId());
        } else {
            this.m_oPublishServer.publishContents(iPublishElements, iPublishFolder, n);
        }
    }

    private void publishElement(User user, IPublishElement iPublishElement, int n, MethodContext methodContext) throws WCMException, Exception {
        int n2 = methodContext.getValue("FlowDocId", 0);
        if (!iPublishElement.isFolder() && n2 > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(user, iPublishElement.getSubstance(), n2, 2, I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label3", "\u53d1\u5e03"));
        } else {
            int n3 = this.getPubRightIndexByType(iPublishElement.getType(), n);
            if (iPublishElement.getType() == 605 ? !DocumentAuthServer.hasRight(user, null, (Document)iPublishElement.getSubstance(), n3) : !AuthServer.hasRight(user, iPublishElement.getSubstance(), n3)) {
                throw new WCMException(I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label5", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label7", "]\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u53d1\u5e03\u64cd\u4f5c\uff01"));
            }
        }
        if (iPublishElement.isFolder()) {
            if (n == 13) {
                String string = methodContext.getValue("StartDocCrtime");
                String string2 = methodContext.getValue("EndDocCrtime");
                if (CMyString.isEmpty(string) || CMyString.isEmpty(string2)) {
                    throw new WCMException("\u53d1\u5e03\u5df2\u53d1\u7684\u6587\u6863\u53ca\u5176\u6982\u89c8 \u5fc5\u987b\u6307\u5b9a\u4e00\u4e2a\u6587\u6863\u7684\u521b\u5efa\u65f6\u95f4\u8303\u56f4\uff01");
                }
                CMyDateTime cMyDateTime = new CMyDateTime();
                cMyDateTime.setDateTimeWithString(string);
                CMyDateTime cMyDateTime2 = new CMyDateTime();
                cMyDateTime2.setDateTimeWithString(string2);
                this.m_oPublishServer.publishFolderAndPublishedDocs((IPublishFolder)iPublishElement, n, cMyDateTime, cMyDateTime2);
            } else {
                this.m_oPublishServer.publishFolder((IPublishFolder)iPublishElement, n);
            }
            if (n == 7) {
                String string = ConfigServer.getServer().getSysConfigValue("RECALL_CHILDREN_CHANNEL", "false");
                boolean bl = string.equalsIgnoreCase("true");
                this.publishRecallFolder((IPublishFolder)iPublishElement, bl);
            }
        } else if (n == 10) {
            this.publishForcibly((IPublishContent)iPublishElement);
        } else if (n == 7) {
            this.m_oPublishServer.deleteContent((IPublishContent)iPublishElement);
        } else {
            this.m_oPublishServer.publishContent((IPublishContent)iPublishElement, n);
        }
    }

    private void publishRecallFolder(IPublishFolder iPublishFolder, boolean bl) throws WCMException, Exception {
        BaseChannel baseChannel;
        if (iPublishFolder == null) {
            return;
        }
        this.m_oPublishServer.deleteFolder(iPublishFolder);
        if (!bl) {
            return;
        }
        ChannelMgr channelMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
        Channels channels = (Channels)channelMgr.getChildren(baseChannel = (BaseChannel)BaseChannel.findById(iPublishFolder.getType(), iPublishFolder.getId()), -1, true, null);
        if (channels.size() == 0) {
            return;
        }
        IPublishElements iPublishElements = PublishElementFactory.lookupElements(101, channels.getIdListAsString());
        int n = iPublishElements.size();
        for (int i = 0; i < n; ++i) {
            IPublishElement iPublishElement = iPublishElements.get(i);
            if (iPublishElement == null) continue;
            this.publishRecallFolder((IPublishFolder)iPublishElement, bl);
        }
    }

    private void publishForcibly(IPublishContent iPublishContent) throws WCMException {
        this.m_oPublishServer.publishContent(iPublishContent, 10);
    }

    private int getPubRightIndexByType(int n, int n2) {
        switch (n) {
            case 605: {
                return 39;
            }
            case 101: {
                if (n2 == 2 || n2 == 7) {
                    return 16;
                }
                return 17;
            }
            case 103: {
                if (n2 == 2 || n2 == 7) {
                    return 4;
                }
                return 5;
            }
        }
        return 64;
    }

    private int getPreviewRightIndexByType(int n) {
        switch (n) {
            case 605: {
                return 38;
            }
            case 101: {
                return 15;
            }
            case 103: {
                return 3;
            }
        }
        return 64;
    }

    private IPublishElement findPublishElement(MethodContext methodContext) throws WCMException {
        int n;
        int n2 = methodContext.getValue("ObjectType", 0);
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(n2, n = methodContext.getObjectId());
        if (iPublishElement == null) {
            throw new WCMException(I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label8", "\u6307\u5b9a\u7684\u5bf9\u8c61[Type=") + n2 + ", Id=" + n + I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label9", "]\u4e0d\u5b58\u5728\uff01"));
        }
        return iPublishElement;
    }

    private IPublishFolder findFolder(MethodContext methodContext) throws WCMException {
        int n;
        int n2 = methodContext.getValue("FolderType", 0);
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.lookupElement(n2, n = methodContext.getValue("FolderId", 0));
        if (iPublishFolder == null) {
            throw new WCMException(I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label10", "\u6307\u5b9a\u7684\u680f\u76ee[Type=") + n2 + ", Id=" + n + I18NMessage.get(PublishServiceProvider.class, "PublishServiceProvider.label9", "]\u4e0d\u5b58\u5728\uff01"));
        }
        return iPublishFolder;
    }

    private User getLoginUser() {
        User user = ContextHelper.getLoginUser();
        return user;
    }

    public Object getUnpubSchedule(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("SenderId", 0);
        int n2 = methodContext.getValue("SenderType", 605);
        User user = ContextHelper.getLoginUser();
        Schedules schedules = new Schedules(user);
        WCMFilter wCMFilter = new WCMFilter("", "SENDERID=? and SENDERTYPE=? and OPTYPE=?", "");
        wCMFilter.setSelect("SCHID,ETIME");
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(n2);
        if (m_nUnpubWorkerId == 0) {
            JobWorkerType jobWorkerType = JobWorkerType.findByClassName(WithDrawJobWorker.class.getName());
            if (jobWorkerType != null) {
                m_nUnpubWorkerId = jobWorkerType.getId();
            } else {
                logger.fatal((Object)"no worker for unpub job.");
            }
        }
        wCMFilter.addSearchValues(m_nUnpubWorkerId);
        schedules.open(wCMFilter);
        if (!schedules.isEmpty()) {
            return (Schedule)schedules.getAt(0);
        }
        return null;
    }

    public void setUnpubSchedule(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("SchId", 0);
        CMyDateTime cMyDateTime = methodContext.getValue("ETIME", CMyDateTime.now());
        User user = ContextHelper.getLoginUser();
        Schedule schedule = Schedule.findById(n);
        if (schedule == null) {
            schedule = new Schedule();
            int n2 = methodContext.getValue("SenderId", 0);
            int n3 = methodContext.getValue("SenderType", 605);
            schedule.setSender(n3, n2);
            schedule.setName("\u5b9a\u65f6\u64a4\u9500\u53d1\u5e03\u8ba1\u5212[ObjType=" + n3 + ", ObjId=" + n2 + "] ");
            schedule.setMode(3);
            schedule.setExeTime(cMyDateTime);
            if (m_nUnpubWorkerId == 0) {
                JobWorkerType jobWorkerType = JobWorkerType.findByClassName(WithDrawJobWorker.class.getName());
                if (jobWorkerType != null) {
                    m_nUnpubWorkerId = jobWorkerType.getId();
                } else {
                    logger.fatal((Object)"no worker for unpub job.");
                }
            }
            schedule.setWorkerType(m_nUnpubWorkerId);
            schedule.save(user);
        } else {
            boolean bl = methodContext.getValue("Unset", false);
            if (bl) {
                schedule.delete();
            } else {
                CMyDateTime cMyDateTime2 = schedule.getExeTime();
                if (!cMyDateTime.toString("yyyy-MM-dd HH:mm").equals(cMyDateTime2.toString("yyyy-MM-dd HH:mm"))) {
                    schedule.setExeTime(cMyDateTime);
                    schedule.save(user);
                }
            }
        }
    }
}

