/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.JSONHelper;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.ajaxservice.WebSiteServiceProvider;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMSystemObject;
import com.trs.cms.process.FlowContentFactory;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.IFlowServer;
import com.trs.cms.process.QueryFlowDocContext;
import com.trs.cms.process.config.FlowConfigServer;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmployMgr;
import com.trs.cms.process.definition.FlowEmploys;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeField;
import com.trs.cms.process.definition.FlowNodeFields;
import com.trs.cms.process.definition.FlowNodes;
import com.trs.cms.process.definition.Flows;
import com.trs.cms.process.engine.ContentProcessInfo;
import com.trs.cms.process.engine.FlowContext;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.cms.process.engine.FlowNextBranchInfo;
import com.trs.cms.process.engine.IInitValueCreator;
import com.trs.cms.process.xml.FlowImporter;
import com.trs.cms.process.xml.FlowXmlConverter;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.Report;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import com.trs.webframework.xmlserver.IXMLConvertor;
import com.trs.webframework.xmlserver.XMLConvertorFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class ProcessService
implements IGlueServiceProvider {
    private static Logger logger = Logger.getLogger(ProcessService.class);
    private FlowEmployMgr m_oFlowEmployMgr = (FlowEmployMgr)DreamFactory.createObjectById("FlowEmployMgr");
    private IFlowServer m_oFlowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
    private static final int VIEW_TYPE_DOWITH = 1;
    private static final int VIEW_TYPE_DONE = 2;
    private static final int VIEW_TYPE_START = 3;

    public void delete(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Flows flows = Flows.findByIds(user, methodContext.getObjectIds());
        this.validateRight(user, flows, 43, I18NMessage.get(ProcessService.class, "ProcessService.label1", "\u5220\u9664\u5de5\u4f5c\u6d41"));
        flows.removeAll(true);
    }

    public Object query(MethodContext methodContext) throws Throwable {
        Object object;
        User user = this.getLoginUser();
        int n = methodContext.getValue("OwnerType", 0);
        int n2 = methodContext.getValue("OwnerId", 0);
        CMSObj cMSObj = this.findOwner(n, n2);
        methodContext.putContextCacheData("Owner", cMSObj);
        switch (n) {
            case 1: {
                if (user.isAdministrator()) break;
                throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label2", "\u5f53\u524d\u7528\u6237[") + user.getName() + I18NMessage.get(ProcessService.class, "ProcessService.label3", "]\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u65e0\u6743\u7ba1\u7406\u5de5\u4f5c\u6d41\uff01"));
            }
            default: {
                object = WCMRightTypes.RIGHT_INDEXS_WORKFLOW;
                boolean bl = false;
                for (int i = 0; i < ((int[])object).length; ++i) {
                    if (!AuthServer.hasRight(user, cMSObj, (int)object[i])) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
                throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label2", "\u5f53\u524d\u7528\u6237[") + user.getName() + I18NMessage.get(ProcessService.class, "ProcessService.label4", "]\u65e0\u6743\u7ba1\u7406[") + cMSObj + I18NMessage.get(ProcessService.class, "ProcessService.label5", "]\u7684\u5de5\u4f5c\u6d41\uff01"));
            }
        }
        object = this.makeQueryFlowsOfHostFilter(cMSObj, methodContext.getValue("ContainsChildren", false));
        ((WCMFilter)object).mergeWith(methodContext.getExtraWCMFilter());
        return Flows.openWCMObjs(user, (WCMFilter)object);
    }

    public Object queryOptionalFlows(MethodContext methodContext) throws Throwable {
        WCMFilter wCMFilter;
        User user = this.getLoginUser();
        int n = methodContext.getValue("OwnerType", 0);
        int n2 = methodContext.getValue("OwnerId", 0);
        CMSObj cMSObj = this.findOwner(n, n2);
        CMSObj cMSObj2 = null;
        WCMSystemObject wCMSystemObject = null;
        Channel channel = null;
        if (n == 101) {
            if (n2 > 0) {
                channel = Channel.findById(n2);
                cMSObj2 = channel.getSite();
            } else {
                cMSObj2 = WebSite.findById(cMSObj.getPropertyAsInt("SiteId", 0));
            }
        } else if (n == 103) {
            cMSObj2 = cMSObj;
        }
        Flows flows = new Flows(null);
        if (channel != null) {
            wCMFilter = this.makeQueryFlowsOfHostFilter(channel, false);
            wCMFilter.mergeWith(methodContext.getExtraWCMFilter());
            flows = Flows.openWCMObjs(user, wCMFilter);
        }
        wCMFilter = this.makeQueryFlowsOfHostFilter(cMSObj2, false);
        wCMFilter.mergeWith(methodContext.getExtraWCMFilter());
        flows.addWith(Flows.openWCMObjs(user, wCMFilter));
        wCMSystemObject = new WCMSystemObject(cMSObj2.getPropertyAsInt("SiteType", 0));
        WCMFilter wCMFilter2 = this.makeQueryFlowsOfHostFilter(wCMSystemObject, false);
        wCMFilter2.mergeWith(methodContext.getExtraWCMFilter());
        flows.addWith(Flows.openWCMObjs(user, wCMFilter2));
        return flows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int save(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        Flow flow = null;
        if (n > 0) {
            flow = this.findById(n);
        } else {
            flow = Flow.createNewInstance();
            flow.setOwner(methodContext.getValue("OwnerType", 0), methodContext.getValue("OwnerId", 0));
        }
        CMSObj cMSObj = this.findOwner(flow.getOwnerType(), flow.getOwnerId());
        int n2 = n > 0 ? 42 : 41;
        String string = n > 0 ? I18NMessage.get(ProcessService.class, "ProcessService.label6", "\u4fee\u6539\u5de5\u4f5c\u6d41") : I18NMessage.get(ProcessService.class, "ProcessService.label7", "\u65b0\u5efa\u5de5\u4f5c\u6d41");
        this.validateRight(user, cMSObj, flow, n2, string);
        try {
            if (flow != null) {
                flow.validCanEditAndLock(user);
            }
            String[] stringArray = new String[]{"ObjectId", "HostType", "HostId"};
            flow = (Flow)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, flow, stringArray);
            flow.save(user);
            int n3 = flow.getId();
            return n3;
        }
        finally {
            if (flow != null && flow.isLocked() && user.getName().equals(flow.getLockerUserName())) {
                flow.unlock();
            }
        }
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        Flow flow = this.findById(methodContext.getObjectId());
        return flow;
    }

    private Flow findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        Flow flow = Flow.findById(n);
        if (flow == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(401)}));
        }
        return flow;
    }

    private FlowDoc findFlowDocById(int n) throws WCMException {
        FlowDoc flowDoc = FlowDoc.findById(n);
        if (flowDoc == null) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label9", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5de5\u4f5c\u6d41\u8f68\u8ff9\uff01[ID=") + n + "]");
        }
        return flowDoc;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return null;
    }

    public Reports importFlows(MethodContext methodContext) throws WCMException {
        int n;
        User user = this.getLoginUser();
        String string = methodContext.getValue("ImportFile");
        int n2 = methodContext.getValue("OwnerType", 0);
        CMSObj cMSObj = this.findOwner(n2, n = methodContext.getValue("OwnerId", 0));
        if (cMSObj == null) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label10", "\u6ca1\u6709\u627e\u5230\u6307\u5b9aID\u4e3a[") + n + I18NMessage.get(ProcessService.class, "ProcessService.label11", "]\u3001\u7c7b\u578b\u4e3a[") + n2 + I18NMessage.get(ProcessService.class, "ProcessService.label12", "]\u7684\u5bfc\u5165\u76ee\u6807\uff01"));
        }
        int n3 = 45;
        this.validateRight(user, cMSObj, null, n3, I18NMessage.get(ProcessService.class, "ProcessService.label13", "\u5bfc\u5165\u5de5\u4f5c\u6d41"));
        FlowImporter flowImporter = new FlowImporter(user, 1);
        flowImporter.setImportWithInfoviewId(false);
        flowImporter.setOwner(cMSObj);
        Reports reports = null;
        try {
            reports = flowImporter.importFromFile(string, null);
        }
        catch (Throwable throwable) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label14", "\u8981\u5bfc\u5165\u7684XML\u5185\u5bb9\u6216\u8005\u7ed3\u6784\u4e0d\u5408\u6cd5\uff01"), throwable);
        }
        return reports;
    }

    public String exportFlows(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getObjectIds();
        Flows flows = Flows.findByIds(this.getLoginUser(), string);
        int n = 44;
        this.validateRight(user, flows, n, I18NMessage.get(ProcessService.class, "ProcessService.label15", "\u5bfc\u51fa\u5de5\u4f5c\u6d41"));
        FlowXmlConverter flowXmlConverter = new FlowXmlConverter();
        String string2 = FilesMan.getFilesMan().getNextFileName("ST", ".xml", null, true);
        flowXmlConverter.toXMLFile(flows, string2);
        return CMyFile.extractFileName(string2);
    }

    public String getConfigContent() throws Throwable {
        FlowConfigServer flowConfigServer = (FlowConfigServer)DreamFactory.createObjectById("FlowConfigServer");
        if (flowConfigServer == null) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label16", "FlowConfigServer\u5728\u5de5\u5382\u4e2d\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        return flowConfigServer.getConfigFileContent();
    }

    public String toXML(MethodContext methodContext) throws Throwable {
        Flow flow = null;
        if (methodContext.getObjectId() > 0) {
            flow = this.findById(methodContext.getObjectId());
        } else {
            int n;
            int n2 = methodContext.getValue("ContentType", 0);
            IFlowContent iFlowContent = FlowContentFactory.makeFlowContent(n2, n = methodContext.getValue("ContentId", 0));
            if (iFlowContent == null) {
                throw new WCMException(200006, I18NMessage.get(ProcessService.class, "ProcessService.label17", "\u6307\u5b9a\u7684\u5185\u5bb9[Type=") + n2 + ", Id=" + n + I18NMessage.get(ProcessService.class, "ProcessService.label18", "]\u6ca1\u6709\u627e\u5230\uff01"));
            }
            flow = iFlowContent.getOwnerFlow();
            if (flow == null) {
                throw new WCMException(200006, I18NMessage.get(ProcessService.class, "ProcessService.label19", "\u7531\u4e8e\u6307\u5b9a\u7684\u5185\u5bb9[Type=") + n2 + ", Id=" + n + I18NMessage.get(ProcessService.class, "ProcessService.label20", "]\u6ca1\u6709\u914d\u7f6e\u5de5\u4f5c\u6d41\uff0c\u6216\u8005\u5176\u539f\u5148\u4f7f\u7528\u7684\u5de5\u4f5c\u6d41\u5df2\u4e0d\u590d\u5b58\u5728\uff0c\u56e0\u6b64\u65e0\u6cd5\u83b7\u53d6\u5176\u5de5\u4f5c\u6d41\u56fe\u7684\u76f8\u5173\u4fe1\u606f\uff01"));
            }
        }
        FlowXmlConverter flowXmlConverter = new FlowXmlConverter();
        String string = flowXmlConverter.toXMLString(flow);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reports fromXML(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        Flow flow = null;
        if (n > 0) {
            flow = this.findById(n);
        }
        CMSObj cMSObj = null;
        cMSObj = flow != null ? this.findOwner(flow.getOwnerType(), flow.getOwnerId()) : this.findOwner(methodContext.getValue("OwnerType", 0), methodContext.getValue("OwnerId", 0));
        int n2 = n > 0 ? 42 : 41;
        String string = n > 0 ? I18NMessage.get(ProcessService.class, "ProcessService.label6", "\u4fee\u6539\u5de5\u4f5c\u6d41") : I18NMessage.get(ProcessService.class, "ProcessService.label7", "\u65b0\u5efa\u5de5\u4f5c\u6d41");
        this.validateRight(user, cMSObj, flow, n2, string);
        try {
            if (flow != null) {
                flow.validCanEditAndLock(user);
            }
            FlowImporter flowImporter = new FlowImporter(user, 2);
            flowImporter.setImportWithFlowNodeFields(true);
            flowImporter.setImportWithInfoviewId(true);
            flowImporter.setOwner(cMSObj);
            boolean bl = methodContext.getValue("UpdateOptMarkEnum", false);
            flowImporter.setImportWithOptMarkEnum(bl);
            Reports reports = flowImporter.importFromXMLContent(methodContext.getValue("FlowXML"));
            List list = reports.getFailedReporter();
            if (list != null && list.size() != 0) {
                for (int i = 0; i < list.size(); ++i) {
                    Report report = (Report)list.get(i);
                    report.setRportTitle(string + I18NMessage.get(ProcessService.class, "ProcessService.label21", "\u5931\u8d25\uff01"));
                }
                reports.setTitle(string + I18NMessage.get(ProcessService.class, "ProcessService.label22", "\u5931\u8d25"));
            } else {
                List list2 = reports.getSucessedReporter();
                for (int i = 0; i < list2.size(); ++i) {
                    Report report = (Report)list2.get(i);
                    report.setRportTitle(string + I18NMessage.get(ProcessService.class, "ProcessService.label23", "\u6210\u529f\uff01"));
                }
                reports.setTitle(string + I18NMessage.get(ProcessService.class, "ProcessService.label24", "\u6210\u529f"));
            }
            Reports reports2 = reports;
            return reports2;
        }
        finally {
            if (flow != null && flow.isLocked() && user.getName().equals(flow.getLockerUserName())) {
                flow.unlock();
            }
        }
    }

    public Flow getFlowUsedByChannel(MethodContext methodContext) throws WCMException {
        Channel channel = (Channel)this.findOwner(101, methodContext.getObjectId());
        return this.m_oFlowEmployMgr.getFlow(channel);
    }

    public Channels getChannelsUseingFlow(MethodContext methodContext) throws WCMException {
        int n = methodContext.getObjectId();
        WCMFilter wCMFilter = methodContext.getExtraWCMFilter();
        Flow flow = this.findById(n);
        if (flow == null) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label25", "\u627e\u4e0d\u5230[ID=") + n + I18NMessage.get(ProcessService.class, "ProcessService.label5", "]\u7684\u5de5\u4f5c\u6d41\uff01"));
        }
        this.validateSetEmployRight(this.getLoginUser(), flow, I18NMessage.get(ProcessService.class, "ProcessService.label26", "\u67e5\u770b\u5de5\u4f5c\u6d41\u7684\u914d\u7f6e\u60c5\u51b5"));
        return this.getFlowEmployment(flow, wCMFilter);
    }

    private void validateSetEmployRight(User user, Flow flow, String string) throws WCMException {
        if (user.isAdministrator()) {
            return;
        }
        boolean bl = false;
        CMSObj cMSObj = this.findOwner(flow.getOwnerType(), flow.getOwnerId());
        if (cMSObj instanceof BaseChannel) {
            WebSite webSite = ((BaseChannel)cMSObj).getSite();
            for (int i = 0; i < WCMRightTypes.SET_FLOW_EMPLOY_RIGHTS.length; ++i) {
                if (!AuthServer.hasRight(user, (CMSObj)webSite, WCMRightTypes.SET_FLOW_EMPLOY_RIGHTS[i])) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label27", "\u60a8\u6ca1\u6709\u6743\u9650") + string);
        }
    }

    public ContentProcessInfo getProcessInfoOfContent(MethodContext methodContext) throws WCMException {
        int n;
        int n2 = methodContext.getValue("ContentType", 0);
        IFlowContent iFlowContent = FlowContentFactory.makeFlowContent(n2, n = methodContext.getValue("ContentId", 0));
        if (iFlowContent == null) {
            throw new WCMException(200006, I18NMessage.get(ProcessService.class, "ProcessService.label17", "\u6307\u5b9a\u7684\u5185\u5bb9[Type=") + n2 + ", Id=" + n + I18NMessage.get(ProcessService.class, "ProcessService.label18", "]\u6ca1\u6709\u627e\u5230\uff01"));
        }
        return this.m_oFlowServer.getProcessInfoOfContent(iFlowContent);
    }

    private Channels getFlowEmployment(Flow flow, WCMFilter wCMFilter) throws WCMException {
        User user = this.getLoginUser();
        this.validateRight(user, null, flow, WCMRightTypes.RIGHT_INDEXS_WORKFLOW, I18NMessage.get(ProcessService.class, "ProcessService.label28", "\u5de5\u4f5c\u6d41\u67e5\u770b"));
        return (Channels)this.m_oFlowEmployMgr.getChannelsUseingFlow(flow, new Channels(user), 101, "WCMCHANNEL", wCMFilter);
    }

    public void enableFlowToChannel(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        Flow flow = this.findById(methodContext.getValue("FlowId", 0));
        int n = 101;
        int n2 = methodContext.getObjectId();
        Channel channel = (Channel)this.findOwner(n, n2);
        int n3 = 13;
        this.validateRight(user, (CMSObj)channel, flow, n3, I18NMessage.get(ProcessService.class, "ProcessService.label29", "\u7ed9\u680f\u76ee[") + channel.getDispDesc() + "][ID=" + channel.getId() + I18NMessage.get(ProcessService.class, "ProcessService.label30", "]\u8bbe\u7f6e\u5de5\u4f5c\u6d41"));
        this.m_oFlowEmployMgr.setFlow(channel, flow.getId());
    }

    public void disableFlowToChannel(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        Flow flow = Flow.findById(methodContext.getValue("FlowId", 0));
        int n = 101;
        int n2 = methodContext.getValue("ObjectId", 0);
        Channel channel = (Channel)this.findOwner(n, n2);
        if (flow == null) {
            int n3 = 13;
            this.validateRight(user, (CMSObj)channel, null, n3, I18NMessage.get(ProcessService.class, "ProcessService.label29", "\u7ed9\u680f\u76ee[") + channel.getDispDesc() + "][ID=" + channel.getId() + I18NMessage.get(ProcessService.class, "ProcessService.label30", "]\u8bbe\u7f6e\u5de5\u4f5c\u6d41"));
        } else {
            this.validateSetEmployRight(this.getLoginUser(), flow, I18NMessage.get(ProcessService.class, "ProcessService.label26", "\u67e5\u770b\u5de5\u4f5c\u6d41\u7684\u914d\u7f6e\u60c5\u51b5"));
        }
        this.m_oFlowEmployMgr.clearEmploysOfEmployer(channel);
    }

    public void setChannelEmployersOfFlow(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        Flow flow = this.findById(methodContext.getValue("FlowId", 0));
        int n = 101;
        this.validateSetEmployRight(this.getLoginUser(), flow, I18NMessage.get(ProcessService.class, "ProcessService.label31", "\u7ef4\u62a4\u5de5\u4f5c\u6d41\u7684\u914d\u7f6e\u60c5\u51b5"));
        this.m_oFlowEmployMgr.setEmployersOfFlow(user, flow.getId(), n, CMyString.splitToInt(methodContext.getObjectIds(), ","));
    }

    public void removeChannelEmployersOfFlow(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        Flow flow = this.findById(methodContext.getValue("FlowId", 0));
        int n = 101;
        int[] nArray = WCMRightTypes.RIGHT_INDEXS_WORKFLOW;
        this.validateRight(user, null, flow, nArray, I18NMessage.get(ProcessService.class, "ProcessService.label32", "\u7ef4\u62a4\u5de5\u4f5c\u6d41[") + flow.getName() + "][ID=" + flow.getId() + I18NMessage.get(ProcessService.class, "ProcessService.label33", "]\u7684\u914d\u7f6e\u5173\u7cfb!"));
        int[] nArray2 = CMyString.splitToInt(methodContext.getObjectIds(), ",");
        WCMFilter wCMFilter = new WCMFilter("", null, "");
        String string = "FlowId=? and EmployerType=? and EmployerId in(";
        wCMFilter.addSearchValues(flow.getId());
        wCMFilter.addSearchValues(n);
        for (int i = 0; i < nArray2.length; ++i) {
            string = i == 0 ? string + "?" : string + ",?";
            wCMFilter.addSearchValues(nArray2[i]);
        }
        string = string + ")";
        wCMFilter.setWhere(string);
        FlowEmploys.openWCMObjs(user, wCMFilter).removeAll(true);
    }

    public IFlowContent[] getContentsInFlow(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        Flow flow = this.findById(methodContext.getObjectId());
        this.validateRight(user, null, flow, 46, I18NMessage.get(ProcessService.class, "ProcessService.label34", "\u67e5\u770b\u5728\u6307\u5b9a\u5de5\u4f5c\u6d41\u4e2d\u6d41\u8f6c\u7684\u6587\u6863\uff01"));
        return this.m_oFlowServer.getFlowContentsInFlow(flow);
    }

    public IFlowContent[] getContentsOfUser(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        int n = methodContext.getValue("ViewType", 1);
        String string = methodContext.getValue("CurrUser");
        String string2 = methodContext.getValue("SearchValue");
        String string3 = methodContext.getValue("OrderBy");
        CPager cPager = new CPager();
        cPager.setPageSize(methodContext.getPageSize());
        cPager.setCurrentPageIndex(methodContext.getPageIndex());
        QueryFlowDocContext queryFlowDocContext = new QueryFlowDocContext();
        User user2 = User.findByName(string);
        if (user2 == null) {
            user2 = user;
        }
        queryFlowDocContext.setCurrUser(user2);
        queryFlowDocContext.setPager(cPager);
        queryFlowDocContext.setContentType(methodContext.getValue("ObjType", -1));
        methodContext.getServiceContext().getRequest().setAttribute("PAGER", (Object)cPager);
        if (string2 != null) {
            queryFlowDocContext.setParameter("SearchValue", string2);
        }
        if (string3 != null) {
            queryFlowDocContext.setParameter("OrderBy", string3);
        }
        switch (n) {
            case 1: {
                return this.m_oFlowServer.getFlowContentsOfUser(queryFlowDocContext);
            }
            case 2: {
                return this.m_oFlowServer.getFlowContentsDoneByUser(queryFlowDocContext);
            }
            case 3: {
                return this.m_oFlowServer.getFlowContentsStartByUser(queryFlowDocContext);
            }
        }
        throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label35", "\u4e0d\u652f\u6301\u7684\u89c6\u56fe\u7c7b\u578b[") + n + I18NMessage.get(ProcessService.class, "ProcessService.label65", "]\uff01"));
    }

    public FlowDocs getFlowDocsOfContent(MethodContext methodContext) throws Throwable {
        int n;
        int n2 = methodContext.getValue("ContentType", 0);
        IFlowContent iFlowContent = FlowContentFactory.makeFlowContent(n2, n = methodContext.getValue("ContentId", 0));
        if (iFlowContent == null) {
            throw new WCMException(200006, I18NMessage.get(ProcessService.class, "ProcessService.label17", "\u6307\u5b9a\u7684\u5185\u5bb9[Type=") + n2 + ", Id=" + n + I18NMessage.get(ProcessService.class, "ProcessService.label18", "]\u6ca1\u6709\u627e\u5230\uff01"));
        }
        return this.m_oFlowServer.getFlowDocs(iFlowContent, methodContext.getExtraWCMFilter());
    }

    public boolean doReceive(MethodContext methodContext) throws WCMException {
        return this.sendReceipt(methodContext, false);
    }

    public boolean backTo(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        FlowDocs flowDocs = FlowDocs.findByIdsOfDealer(user, methodContext.getObjectIds(), user);
        FlowContext flowContext = new FlowContext();
        flowContext.setCurrUser(user);
        flowContext.setPostUser(user);
        flowContext.setPostDesc(methodContext.getValue("PostDesc"));
        flowContext.setNotifyTypes(methodContext.getValue("NotifyTypes"));
        String string = methodContext.getValue("ApplyExtension");
        if (!CMyString.isEmpty(string) && "1".equals(string)) {
            flowContext.setProperty("ApplyExtension", "1");
        }
        int n = flowDocs.size();
        for (int i = 0; i < n; ++i) {
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc == null) continue;
            flowContext.setCurrFlowDoc(flowDoc);
            this.m_oFlowServer.backTo(flowContext);
        }
        return true;
    }

    public boolean refuse(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        FlowDocs flowDocs = FlowDocs.findByIdsOfDealer(user, methodContext.getObjectIds(), user);
        FlowContext flowContext = new FlowContext();
        flowContext.setCurrUser(user);
        flowContext.setPostUser(user);
        flowContext.setPostDesc(methodContext.getValue("PostDesc"));
        int n = flowDocs.size();
        for (int i = 0; i < n; ++i) {
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc == null) continue;
            flowContext.setCurrFlowDoc(flowDoc);
            this.m_oFlowServer.refuse(flowContext);
        }
        return true;
    }

    public boolean forceEnd(MethodContext methodContext) throws Throwable {
        int n;
        User user = this.getLoginUser();
        int n2 = methodContext.getValue("ContentType", 0);
        IFlowContent iFlowContent = FlowContentFactory.makeFlowContent(n2, n = methodContext.getValue("ContentId", 0));
        if (iFlowContent == null) {
            throw new WCMException(200006, I18NMessage.get(ProcessService.class, "ProcessService.label17", "\u6307\u5b9a\u7684\u5185\u5bb9[Type=") + n2 + ", Id=" + n + I18NMessage.get(ProcessService.class, "ProcessService.label18", "]\u6ca1\u6709\u627e\u5230\uff01"));
        }
        FlowContext flowContext = new FlowContext(user, iFlowContent);
        flowContext.setCurrUser(user);
        flowContext.setPostUser(user);
        flowContext.setPostDesc(methodContext.getValue("PostDesc"));
        flowContext.setFlowContent(iFlowContent);
        this.m_oFlowServer.forceEnd(flowContext);
        return true;
    }

    public void submitTo(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        FlowContext flowContext = this.createFlowContextFrom(methodContext, user);
        FlowDocs flowDocs = FlowDocs.findByIdsOfDealer(user, methodContext.getObjectIds(), user);
        if (flowDocs.isEmpty()) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label36", "\u60a8\u8981\u5904\u7406\u7684\u5185\u5bb9\u53ef\u80fd\u662f\u7ed9\u5176\u5b83\u4eba\u7684\u6216\u8005\u88ab\u5220\u9664\u4e86\uff01ObjectIds=") + methodContext.getObjectIds());
        }
        int n = flowDocs.size();
        for (int i = 0; i < n; ++i) {
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc == null) continue;
            flowContext.setCurrFlowDoc(flowDoc);
            this.m_oFlowServer.submitTo(flowContext);
        }
    }

    public void reSubmitTo(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        FlowContext flowContext = this.createFlowContextFrom(methodContext, user);
        FlowDocs flowDocs = FlowDocs.findByIdsOfPoster(user, methodContext.getObjectIds(), user);
        int n = flowDocs.size();
        for (int i = 0; i < n; ++i) {
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc == null) continue;
            flowContext.setCurrFlowDoc(flowDoc);
            this.m_oFlowServer.resubmitTo(flowContext);
        }
    }

    private FlowContext createFlowContextFrom(MethodContext methodContext, User user) throws WCMException {
        FlowNode flowNode = FlowNode.findById(methodContext.getValue("NextNodeId", 0));
        Users users = null;
        String string = methodContext.getValue("ToUserIds");
        if (string != null && string.length() > 0) {
            users = Users.findByIds(null, string);
        }
        FlowContext flowContext = new FlowContext();
        flowContext.setCurrUser(user);
        flowContext.setPostUser(user);
        flowContext.setPostDesc(methodContext.getValue("PostDesc"));
        flowContext.setNextNode(flowNode);
        flowContext.setToUsers(users);
        flowContext.setNotifyTypes(methodContext.getValue("NotifyTypes"));
        String string2 = "false";
        if (!CMyString.isEmpty(methodContext.getValue("ReffererTo"))) {
            string2 = methodContext.getValue("ReffererTo");
        }
        flowContext.setProperty("ReffererTo", string2);
        return flowContext;
    }

    public FlowNodes getNextNodes(MethodContext methodContext) throws Throwable {
        FlowDoc flowDoc = FlowDoc.findById(methodContext.getObjectId());
        boolean bl = methodContext.getValue("Resubmit", false);
        FlowNodes flowNodes = this.m_oFlowServer.getNextFlowNodes(flowDoc, bl);
        if (bl && flowNodes.size() > 1) {
            FlowNode flowNode = flowDoc.getNode();
            flowNodes.remove(flowNode.getId(), false);
            flowNodes.addElement(flowNode, 0);
        }
        return flowNodes;
    }

    public FlowNodes getProcessedNodes(MethodContext methodContext) throws WCMException {
        int n = methodContext.getObjectId();
        if (n == 0) {
            throw new WCMException("\u4f20\u5165\u7684\u5f53\u524d\u8f68\u8ff9Id\u5fc5\u987b\u5927\u4e8e0\uff01");
        }
        FlowDoc flowDoc = FlowDoc.findById(n);
        if (flowDoc == null) {
            throw new WCMException("\u6c92\u6709\u627e\u5230Id\u4e3a\u3010\uff01" + n + "\u3011\u7684\u6d41\u8f6c\u8f68\u8ff9\uff01");
        }
        FlowNodes flowNodes = this.m_oFlowServer.getProcessedFlowNodes(flowDoc);
        return flowNodes;
    }

    public FlowNodes getWorkModalSepretorEndNodes(MethodContext methodContext) throws WCMException {
        int n = methodContext.getObjectId();
        if (n == 0) {
            throw new WCMException("\u4f20\u5165\u7684\u5f53\u524d\u8f68\u8ff9Id\u5fc5\u987b\u5927\u4e8e0\uff01");
        }
        FlowDoc flowDoc = FlowDoc.findById(n);
        if (flowDoc == null) {
            throw new WCMException("\u6c92\u6709\u627e\u5230Id\u4e3a\u3010\uff01" + n + "\u3011\u7684\u6d41\u8f6c\u8f68\u8ff9\uff01");
        }
        FlowNodes flowNodes = this.m_oFlowServer.getWorkModalSepretorEndNodes(flowDoc);
        return flowNodes;
    }

    public void autoToNextNode(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        FlowContext flowContext = this.createFlowContextFrom(methodContext, user);
        FlowDocs flowDocs = FlowDocs.findByIdsOfDealer(user, methodContext.getObjectIds(), user);
        if (flowDocs.isEmpty()) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label36", "\u60a8\u8981\u5904\u7406\u7684\u5185\u5bb9\u53ef\u80fd\u662f\u7ed9\u5176\u5b83\u4eba\u7684\u6216\u8005\u88ab\u5220\u9664\u4e86\uff01ObjectIds=") + methodContext.getObjectIds());
        }
        int n = flowDocs.size();
        for (int i = 0; i < n; ++i) {
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc == null) continue;
            flowContext.setCurrFlowDoc(flowDoc);
            this.m_oFlowServer.autoToNextNode(flowContext, flowContext.getNextNode());
        }
    }

    private boolean sendReceipt(MethodContext methodContext, boolean bl) throws WCMException {
        User user = this.getLoginUser();
        FlowDocs flowDocs = FlowDocs.findByIdsOfDealer(user, methodContext.getObjectIds(), user);
        FlowContext flowContext = new FlowContext();
        flowContext.setPostUser(user);
        flowContext.setCurrUser(user);
        int n = flowDocs.size();
        for (int i = 0; i < n; ++i) {
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc == null) continue;
            flowContext.setCurrFlowDoc(flowDoc);
            if (bl) {
                this.m_oFlowServer.doAccept(flowContext);
                continue;
            }
            this.m_oFlowServer.doReceive(flowContext);
        }
        return true;
    }

    public boolean doAccept(MethodContext methodContext) throws WCMException {
        return this.sendReceipt(methodContext, true);
    }

    public String getBranchInfo(MethodContext methodContext) throws Throwable {
        Object object;
        Group group;
        User user = this.getLoginUser();
        FlowDoc flowDoc = this.findFlowDocById(methodContext.getValue("FlowDocId", 0));
        int n = methodContext.getValue("NextNodeId", 0);
        boolean bl = methodContext.getValue("ReSubmit", false);
        if (bl) {
            if (!user.getName().equalsIgnoreCase(flowDoc.getPostUserName())) {
                logger.error((Object)(I18NMessage.get(ProcessService.class, "ProcessService.label37", "\u5bf9\u4e0d\u8d77\uff0c\u8fd9\u4e2a\u4e8b\u52a1\u4e0d\u9700\u8981\u60a8\u9012\u4ea4\u7684\uff01\u9012\u4ea4\u4eba\u4e3a[") + flowDoc.getToUser() + "]"));
                throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label38", "\u5bf9\u4e0d\u8d77\uff0c\u8fd9\u4e2a\u4e8b\u52a1\u4e0d\u662f\u7531\u60a8\u9012\u4ea4\u7684\uff0c\u4e0d\u80fd\u83b7\u53d6\u5206\u652f\u4fe1\u606f\uff01"));
            }
        } else if (flowDoc.getToUserId() != user.getId()) {
            logger.error((Object)(I18NMessage.get(ProcessService.class, "ProcessService.label39", "\u5bf9\u4e0d\u8d77\uff0c\u8fd9\u4e2a\u4e8b\u52a1\u4e0d\u9700\u8981\u60a8\u6765\u5904\u7406\uff01\u5904\u7406\u4eba\u4e3a[") + flowDoc.getToUser() + "]"));
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label40", "\u5bf9\u4e0d\u8d77\uff0c\u8fd9\u4e2a\u4e8b\u52a1\u4e0d\u9700\u8981\u60a8\u6765\u5904\u7406\uff01"));
        }
        FlowNextBranchInfo flowNextBranchInfo = new FlowNextBranchInfo(user, flowDoc, n, bl);
        Users users = flowNextBranchInfo.getToUsers();
        Status status = flowNextBranchInfo.getChangeStatus();
        StringBuffer stringBuffer = null;
        String string = "";
        IXMLConvertor iXMLConvertor = XMLConvertorFactory.createConvertor(Users.class);
        if (iXMLConvertor != null && users != null && users.size() != 0) {
            methodContext.setValue("SelectFields", "UserId,TrueName,UserName");
            string = iXMLConvertor.toXmlString(methodContext, users);
        }
        stringBuffer = new StringBuffer(string.length() + 300);
        stringBuffer.append("<BranchInfo>\n");
        stringBuffer.append(string);
        Users users2 = Users.createNewInstance(user);
        User user2 = flowDoc.getPostUser();
        if (user2 != null) {
            users2.addElement(user2);
        }
        String string2 = "";
        if (iXMLConvertor != null && user2 != null && users2.size() != 0) {
            methodContext.setValue("SelectFields", "UserId,TrueName,UserName");
            string2 = iXMLConvertor.toXmlString(methodContext, users2);
            stringBuffer.append(string2.replaceAll("(?ism)Users", "PostUsers"));
        }
        if ((group = flowNextBranchInfo.getGroupRange()) != null) {
            stringBuffer.append("<GroupRange>\n");
            stringBuffer.append("<GroupId>").append(group.getId()).append("</GroupId>\n");
            stringBuffer.append("<GroupName>").append(group.getName()).append("</GroupName>\n");
            stringBuffer.append("</GroupRange>\n");
        }
        if (status != null) {
            stringBuffer.append("\n");
            stringBuffer.append("<DOCSTATUS Id=\"" + status.getId() + "\" Name=\"" + status.getDisp() + "\"/>");
            stringBuffer.append("\n");
        }
        stringBuffer.append("<NOTIFYSTYLES>");
        stringBuffer.append(CMyString.showNull(flowNextBranchInfo.getNotifyTypes()));
        stringBuffer.append("</NOTIFYSTYLES>\n");
        if (iXMLConvertor != null && flowNextBranchInfo.getUsersPassed() != null) {
            methodContext.setValue("SelectFields", "UserId,TrueName,UserName");
            object = iXMLConvertor.toXmlString(methodContext, flowNextBranchInfo.getUsersPassed());
            stringBuffer.append(((String)object).replaceAll("(?ism)Users", "UsersPassed"));
        }
        if (flowDoc.getFlag() == 2) {
            object = flowDoc.getPreNode();
            stringBuffer.append("<NEXTWORKMODAL>");
            stringBuffer.append(((FlowNode)object).getWorkModal());
            stringBuffer.append("</NEXTWORKMODAL>\n");
        }
        stringBuffer.append("</BranchInfo>");
        return stringBuffer.toString();
    }

    public FlowNodeFields getFieldsInfoOfFlowDoc(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("FlowDocId", 0);
        FlowDoc flowDoc = this.findFlowDocById(methodContext.getValue("FlowDocId", 0));
        if (!user.isAdministrator() && !flowDoc.getPostUserName().equalsIgnoreCase(user.getName()) && flowDoc.getToUserId() != user.getId()) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label41", "\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u6b64\u8f68\u8ff9\uff01[FlowDocId=") + n + "]");
        }
        int n2 = 0;
        n2 = flowDoc.isWorked() && flowDoc.getPostUserName().equalsIgnoreCase(user.getName()) ? flowDoc.getPreNodeId() : flowDoc.getNodeId();
        WCMFilter wCMFilter = new WCMFilter("", "NodeId=?", "");
        wCMFilter.addSearchValues(n2);
        FlowNodeFields flowNodeFields = FlowNodeFields.openWCMObjs(user, wCMFilter);
        int n3 = flowNodeFields.size();
        FlowContext flowContext = new FlowContext();
        flowContext.setCurrUser(user);
        flowContext.setPostUser(user);
        flowContext.setCurrFlowDoc(flowDoc);
        for (int i = 0; i < n3; ++i) {
            String string;
            FlowNodeField flowNodeField = (FlowNodeField)flowNodeFields.getAt(i);
            if (flowNodeField == null || CMyString.isEmpty(string = flowNodeField.getPropertyAsString("InitValueCreator"))) continue;
            IInitValueCreator iInitValueCreator = (IInitValueCreator)Class.forName(string).newInstance();
            flowNodeField.getProperties().put("INITVALUE", iInitValueCreator.createInitValue(flowContext));
        }
        return flowNodeFields;
    }

    private WCMFilter makeQueryFlowsOfHostFilter(CMSObj cMSObj, boolean bl) throws WCMException {
        StringBuffer stringBuffer;
        String string = "OwnerId";
        String string2 = "OwnerType";
        String string3 = "WCMFLOW";
        WCMFilter wCMFilter = new WCMFilter();
        switch (cMSObj.getWCMType()) {
            case 1: {
                int n = bl ? 400 : 50;
                stringBuffer = new StringBuffer(n);
                int n2 = 0;
                stringBuffer.append("(" + string + "=? and " + string2 + "=?)");
                wCMFilter.addSearchValues(n2++, cMSObj.getId());
                wCMFilter.addSearchValues(n2++, cMSObj.getWCMType());
                if (!bl) break;
                stringBuffer.append(" or ");
                stringBuffer.append("exists(select WCMWebSite.SiteId from WCMWebSite where WCMWebSite.SiteType=? and " + string3 + "." + string2 + "=103 and " + string3 + "." + string + "=WCMWebSite.SiteId)");
                wCMFilter.addSearchValues(n2++, cMSObj.getId());
                stringBuffer.append(" or ");
                stringBuffer.append("exists(select WCMChannel.ChannelId from WCMChannel where " + string3 + "." + string2 + "=101 and " + string3 + "." + string + "=WCMChannel.ChannelId" + " and exists(select WCMWebSite.SiteId from WCMWebSite where WCMWebSite.SiteType=? and " + "WCMCHANNEL" + ".SiteId=WCMWebSite.SiteId)" + ")");
                wCMFilter.addSearchValues(n2++, cMSObj.getId());
                break;
            }
            case 103: {
                int n = bl ? 300 : 50;
                stringBuffer = new StringBuffer(n);
                int n3 = 0;
                stringBuffer.append("(" + string + "=? and " + string2 + "=?)");
                wCMFilter.addSearchValues(n3++, cMSObj.getId());
                wCMFilter.addSearchValues(n3++, cMSObj.getWCMType());
                if (!bl) break;
                stringBuffer.append(" or ");
                stringBuffer.append("exists(select WCMChannel.ChannelId from WCMChannel where " + string3 + "." + string2 + "=101 and " + string3 + "." + string + "=WCMChannel.ChannelId" + " and exists(select WCMWebSite.SiteId from WCMWebSite where WCMWebSite.SiteId=? and " + "WCMCHANNEL" + ".SiteId=WCMWebSite.SiteId)" + ")");
                wCMFilter.addSearchValues(n3++, cMSObj.getId());
                break;
            }
            case 101: {
                int n = bl ? 200 : 50;
                stringBuffer = new StringBuffer(n);
                if (bl) {
                    stringBuffer.append("" + string2 + "=? and " + string + " in(?");
                    wCMFilter.addSearchValues(0, cMSObj.getWCMType());
                    wCMFilter.addSearchValues(1, cMSObj.getId());
                    this.makeChildrenWhere(wCMFilter, stringBuffer, (Channel)cMSObj);
                    stringBuffer.append(")");
                    break;
                }
                stringBuffer.append("(" + string + "=? and " + string2 + "=?)");
                wCMFilter.addSearchValues(0, cMSObj.getId());
                wCMFilter.addSearchValues(1, cMSObj.getWCMType());
                break;
            }
            default: {
                throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label42", "\u672a\u77e5\u7c7b\u578b[HostType=") + cMSObj.getWCMType() + ",HostId=" + cMSObj.getId() + "]\uff01");
            }
        }
        wCMFilter.setWhere(stringBuffer.toString());
        return wCMFilter;
    }

    private void makeChildrenWhere(WCMFilter wCMFilter, StringBuffer stringBuffer, Channel channel) throws WCMException {
        List list = channel.getChildren(null);
        if (list == null || list.isEmpty()) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Channel channel2 = (Channel)list.get(i);
            if (channel2 == null) continue;
            stringBuffer.append(",?");
            wCMFilter.addSearchValues(wCMFilter.getSearchValues().size(), channel2.getId());
            this.makeChildrenWhere(wCMFilter, stringBuffer, channel2);
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private CMSObj findOwner(int n, int n2) throws WCMException {
        int n3 = n;
        int n4 = n2;
        switch (n3) {
            case 103: {
                WebSite webSite = WebSite.findById(n4);
                if (webSite == null) {
                    throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label43", "\u6307\u5b9a\u7684\u7ad9\u70b9[ID=") + n4 + I18NMessage.get(ProcessService.class, "ProcessService.label44", "]\u4e0d\u5b58\u5728\uff01"));
                }
                return webSite;
            }
            case 101: {
                Channel channel = Channel.findById(n4);
                if (channel == null) {
                    throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label45", "\u6307\u5b9a\u7684\u680f\u76ee[ID=") + n4 + I18NMessage.get(ProcessService.class, "ProcessService.label44", "]\u4e0d\u5b58\u5728\uff01"));
                }
                return channel;
            }
            case 605: {
                int n5 = DBManager.getDBManager().sqlExecuteIntQuery("select DocChannel from WCMDocument where DocId=?", new int[]{n4});
                Channel channel = Channel.findById(n5);
                if (channel == null) {
                    throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label46", "\u6307\u5b9a\u7684\u6587\u6863[ID=") + n4 + I18NMessage.get(ProcessService.class, "ProcessService.label47", "]\u7684\u6240\u5c5e\u680f\u76ee\u4e0d\u5b58\u5728\uff01"));
                }
                return channel;
            }
            case 0: 
            case 1: {
                return new WCMSystemObject(n4);
            }
        }
        throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label42", "\u672a\u77e5\u7c7b\u578b[HostType=") + n3 + "]");
    }

    private void validateRight(User user, CMSObj cMSObj, Flow flow, int n, String string) throws WCMException {
        if (cMSObj == null && flow == null) {
            return;
        }
        if (flow != null && flow.getCrUserName().equalsIgnoreCase(user.getName())) {
            return;
        }
        CMSObj cMSObj2 = cMSObj;
        if (cMSObj == null && flow != null) {
            cMSObj2 = this.findOwner(flow.getOwnerType(), flow.getOwnerId());
        }
        if (!AuthServer.hasRight(user, cMSObj2, n)) {
            throw new WCMException(CMyString.format(I18NMessage.get(ProcessService.class, "ProcessService.label66", "\u60a8[{0}]\u6ca1\u6709\u6743\u9650\u5728{1}\u4e0a{2}!"), new String[]{user.getName(), cMSObj2.toString(), string}));
        }
    }

    private void validateRight(User user, CMSObj cMSObj, Flow flow, int[] nArray, String string) throws WCMException {
        if (cMSObj == null && flow == null) {
            return;
        }
        if (flow != null && flow.getCrUserName().equalsIgnoreCase(user.getName())) {
            return;
        }
        CMSObj cMSObj2 = cMSObj;
        if (cMSObj == null && flow != null) {
            cMSObj2 = this.findOwner(flow.getOwnerType(), flow.getOwnerId());
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (!AuthServer.hasRight(user, cMSObj2, nArray[i])) continue;
            return;
        }
        throw new WCMException(CMyString.format(I18NMessage.get(ProcessService.class, "ProcessService.label66", "\u60a8[{0}]\u6ca1\u6709\u6743\u9650\u5728{1}\u4e0a{2}!"), new String[]{user.getName(), cMSObj.toString(), string}));
    }

    private void validateRight(User user, Flows flows, int n, String string) throws Throwable {
        int n2 = flows.size();
        for (int i = 0; i < n2; ++i) {
            Flow flow = (Flow)flows.getAt(i);
            if (flow == null) continue;
            this.validateRight(user, null, flow, n, string);
        }
    }

    public String getEmploymentInfo(MethodContext methodContext) throws Throwable {
        String string = methodContext.getObjectIds();
        methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(this.getEmploymentInfoByIds(string), 0);
    }

    private HashMap getEmploymentInfoByIds(String string) throws Throwable {
        User user = this.getLoginUser();
        Flows flows = Flows.findByIds(user, string);
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>(1);
        Object[] objectArray = new Object[flows.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            Flow flow = (Flow)flows.getAt(i);
            if (flow == null) continue;
            Channels channels = this.getFlowEmployment(flow, null);
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>(5);
            if (channels != null && !channels.isEmpty()) {
                String[] stringArray = new String[channels.size()];
                for (int j = 0; j < channels.size(); ++j) {
                    Channel channel = (Channel)channels.getAt(j);
                    if (channel == null) continue;
                    stringArray[j] = CMyString.filterForHTMLValue(channel.getDesc()) + I18NMessage.get(ProcessService.class, "ProcessService.label51", "(\u680f\u76ee-") + channel.getId() + ")";
                }
                hashMap2.put("refchannels", stringArray);
            }
            hashMap2.put("flowid", String.valueOf(flow.getId()));
            hashMap2.put("flowname", CMyString.filterForHTMLValue(flow.getName()));
            hashMap2.put("owner", this.getFlowOwnerInfo(flow));
            objectArray[i] = hashMap2;
        }
        hashMap.put("employmentInfo", objectArray);
        return hashMap;
    }

    private Object getFlowOwnerInfo(Flow flow) throws Throwable {
        if (flow.getOwnerType() != 103) {
            return WebSiteServiceProvider.findSiteTypeDesc(flow.getOwnerId());
        }
        BaseObj baseObj = flow.getOwner();
        if (baseObj == null) {
            return "";
        }
        WebSite webSite = (WebSite)baseObj;
        return CMyString.filterForHTMLValue(webSite.getDesc()) + I18NMessage.get(ProcessService.class, "ProcessService.label52", "(\u7ad9\u70b9-") + webSite.getId() + ")";
    }

    public String getFlowOptionAuth(MethodContext methodContext) throws WCMException {
        String string = "";
        boolean bl = false;
        String string2 = "0";
        User user = this.getLoginUser();
        if (user.isAdministrator()) {
            bl = true;
            string2 = "1111111111111111111111111111111111111111111111111111111111111111";
        } else {
            int n = methodContext.getValue("ChannelId", 0);
            int n2 = methodContext.getValue("SiteId", 0);
            try {
                WebSite webSite = null;
                if (n > 0) {
                    Channel channel = Channel.findById(n);
                    webSite = channel.getSite();
                } else if (n2 > 0) {
                    webSite = WebSite.findById(n2);
                }
                string2 = AuthServer.getRightValue((CMSObj)webSite, user).toString();
                bl = AuthServer.hasRight(user, (CMSObj)webSite, 41);
            }
            catch (Throwable throwable) {
                logger.warn((Object)(I18NMessage.get(ProcessService.class, "ProcessService.label53", "\u83b7\u53d6\u5de5\u4f5c\u6d41\u6743\u9650\u65f6\u5931\u8d25\uff0c\u53ef\u80fd\u5bfc\u81f4\u5de5\u4f5c\u6d41\u64cd\u4f5c\u6743\u9650\u8ba1\u7b97\u6709\u8bef\uff01\uff08\u6307\u5b9a[SiteId=") + n2 + ", ChannelId=" + n + "])"), throwable);
            }
        }
        string = string + "<FlowOptionAuth canAddFlow=\"" + bl + "\" rights=\"" + string2 + "\"></FlowOptionAuth>";
        return string;
    }

    public void startDocumentInFlow(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Document document = Document.findById(methodContext.getObjectId());
        if (document == null) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label54", "\u6307\u5b9a\u7684\u6587\u6863\u4e0d\u5b58\u5728![ObjectId=") + methodContext.getObjectId() + "]");
        }
        if (!DocumentAuthServer.hasRight(user, null, document, 32)) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label55", "\u60a8\u6ca1\u6709\u6743\u9650\u8ba9\u6587\u6863[Title=") + document.getTitle() + "][DocId=" + methodContext.getObjectId() + I18NMessage.get(ProcessService.class, "ProcessService.label56", "]\u6d41\u8f6c\uff01"));
        }
        WCMProcessServiceHelper.startDocumentInFlow(user, document, true);
    }

    public String createFrom(MethodContext methodContext) throws Throwable {
        Object object;
        User user = this.getLoginUser();
        CMSObj cMSObj = this.findOwner(0, 1);
        String string = methodContext.getObjectIds();
        Flows flows = Flows.findByIds(this.getLoginUser(), string);
        if (flows.size() == 0) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label57", "\u8981\u7c7b\u4f3c\u521b\u5efa\u7684\u5de5\u4f5c\u6d41[") + string + I18NMessage.get(ProcessService.class, "ProcessService.label58", "]\u5df2\u4e0d\u5b58\u5728\uff01"));
        }
        String string2 = "";
        ArrayList<String> arrayList = new ArrayList<String>(flows.size());
        for (int i = 0; i < flows.size(); ++i) {
            object = (Flow)flows.getAt(i);
            if (object == null) continue;
            arrayList.add(((BaseObj)object).getId() + "-" + ((Flow)object).getName());
        }
        string2 = CMyString.join(arrayList, ",");
        if (!AuthServer.hasRight(user, cMSObj, 41)) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label59", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(ProcessService.class, "ProcessService.label60", "]\u6ca1\u6709\u6743\u9650\u5728\u7cfb\u7edf\u5185\u7c7b\u4f3c\u521b\u5efa\u5de5\u4f5c\u6d41\uff01"));
        }
        FlowXmlConverter flowXmlConverter = new FlowXmlConverter();
        object = new FlowImporter(user, 1);
        boolean bl = methodContext.getValue("CreateWithFlowNodeFields", false);
        ((FlowImporter)object).setImportWithFlowNodeFields(bl);
        ((FlowImporter)object).setImportWithInfoviewId(false);
        try {
            String string3 = FilesMan.getFilesMan().getNextFileName("ST", ".xml", null, true);
            flowXmlConverter.toXMLFile(flows, string3);
            Reports reports = ((FlowImporter)object).importFromFile(string3, null);
            List list = reports.getFailedReporter();
            List list2 = reports.getSucessedReporter();
            if (list != null && list.size() > 0) {
                String string4 = I18NMessage.get(ProcessService.class, "ProcessService.label61", "\u4ece\u5de5\u4f5c\u6d41[") + string2 + I18NMessage.get(ProcessService.class, "ProcessService.label62", "]\u7c7b\u4f3c\u521b\u5efa\u5230\u7cfb\u7edf\u5931\u8d25\uff01");
                reports.setTitle(string4);
                ((Report)list.get(0)).setRportTitle(string4);
            } else if (list2 != null && list2.size() > 0) {
                String string5 = I18NMessage.get(ProcessService.class, "ProcessService.label61", "\u4ece\u5de5\u4f5c\u6d41[") + string2 + I18NMessage.get(ProcessService.class, "ProcessService.label63", "]\u7c7b\u4f3c\u521b\u5efa\u5230\u7cfb\u7edf\u6210\u529f\uff01");
                reports.setTitle(string5);
                ((Report)list2.get(0)).setRportTitle(string5);
            }
            return reports.toJSONXML();
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(ProcessService.class, "ProcessService.label64", "\u7c7b\u4f3c\u521b\u5efa\u5de5\u4f5c\u6d41\u5931\u8d25!"), wCMException);
        }
    }
}

