/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.JSONHelper;
import com.trs.ajaxservice.UnZipFile4Batch;
import com.trs.ajaxservice.ViewDocumentServiceProvider;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.FlowContentFactory;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.IFlowServer;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmployMgr;
import com.trs.cms.process.engine.FlowContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.domain.ContentExtFieldMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.ContentExtField;
import com.trs.components.wcm.content.persistent.ContentExtFields;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.gyl.imagesmetadatas.ImagesMetaDatas;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DataType;
import com.trs.service.IDocumentService;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.IImageLibMgr;
import com.trs.wcm.photo.ImageInfo;
import com.trs.wcm.photo.ImageLibConstants;
import com.trs.wcm.photo.ImageLibHelper;
import com.trs.wcm.photo.impl.ImageMagickCmd;
import com.trs.wcm.photo.impl.MagicImageImpl;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class PhotoServiceProvider
extends ViewDocumentServiceProvider
implements IGlueServiceProvider {
    static final Logger s_logger = Logger.getLogger(PhotoServiceProvider.class);
    private IImageLibConfig m_libConf = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
    private IImageLibMgr m_libManager = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");
    private IDocumentService m_docService = (IDocumentService)DreamFactory.createObjectById("IDocumentService");
    private ContentExtFieldMgr m_oExtFieldMgr = (ContentExtFieldMgr)DreamFactory.createObjectById("ContentExtFieldMgr");
    private static final String FIELDS_OF_CHNLDOC = "RecId,ChnlId,DocId,DocStatus,CrTime,CrUser,DocChannel";
    private static final String FIELDS_OF_DOCUMENT = "DocId,DocTitle,DocContent,DocType,DocSource,DocAbstract,DocRelWords,DocPeople,DocPlace,DocRelTime,Attribute,CrTime,CrUser";

    public void delete(MethodContext methodContext) throws Throwable {
    }

    public Object query(MethodContext methodContext) throws Exception {
        User user = ContextHelper.getLoginUser();
        BaseChannel baseChannel = this.getHost(methodContext);
        if (baseChannel != null && !AuthServer.hasRight(user, (CMSObj)baseChannel, 30)) {
            throw new WCMException(1002, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label1", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u65e0\u6743\u67e5\u770b\u56fe\u7247\u5217\u8868\uff01"));
        }
        methodContext.setValue("ChannelIds", methodContext.getValue("ChannelId"));
        methodContext.setValue("SiteIds", methodContext.getValue("SiteId"));
        methodContext.setValue("ChnlDocSelectFields", FIELDS_OF_CHNLDOC);
        methodContext.setValue("DocumentSelectFields", FIELDS_OF_DOCUMENT);
        return super.query(methodContext);
    }

    public ViewDocuments queryRecycle(MethodContext methodContext) throws Exception {
        User user = ContextHelper.getLoginUser();
        BaseChannel baseChannel = this.getHost(methodContext);
        if (baseChannel != null && !AuthServer.hasRight(user, (CMSObj)baseChannel, 30)) {
            throw new WCMException(1002, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label1", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u65e0\u6743\u67e5\u770b\u56fe\u7247\u5217\u8868\uff01"));
        }
        methodContext.setValue("ChannelIds", methodContext.getValue("ChannelId"));
        methodContext.setValue("SiteIds", methodContext.getValue("SiteId"));
        methodContext.setValue("ChnlDocSelectFields", FIELDS_OF_CHNLDOC);
        methodContext.setValue("DocumentSelectFields", FIELDS_OF_DOCUMENT);
        return super.queryRecycle(methodContext);
    }

    public Object getPublishUrls(MethodContext methodContext) throws Exception {
        User user = ContextHelper.getLoginUser();
        String string = methodContext.getValue("ChnlDocIds");
        int n = methodContext.getValue("ScaleIndex", 0);
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, string);
        HashMap<String, String[][]> hashMap = new HashMap<String, String[][]>(1);
        if (chnlDocs == null || chnlDocs.size() == 0) {
            hashMap.put("urls", new String[0][2]);
        } else {
            String[][] stringArray = new String[chnlDocs.size()][3];
            for (int i = 0; i < chnlDocs.size(); ++i) {
                ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
                stringArray[i][2] = "";
                if (chnlDoc != null) {
                    Document document = chnlDoc.getDocument();
                    stringArray[i][0] = ImageLibHelper.getImageFileNameByScaleIndex(document, n, false);
                    stringArray[i][1] = ImageLibHelper.getOrigImageFilePath(document, false);
                    if (chnlDoc.getStatusId() != 10) continue;
                    stringArray[i][2] = I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label2", "\u5df2\u53d1");
                    continue;
                }
                stringArray[i][0] = "";
                stringArray[i][1] = "";
            }
            hashMap.put("urls", stringArray);
        }
        methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON2(hashMap, 0);
    }

    public Object getOriginalUrls(MethodContext methodContext) throws Exception {
        User user = ContextHelper.getLoginUser();
        String string = methodContext.getValue("ChnlDocIds");
        if (CMyString.isEmpty(string)) {
            throw new WCMException(10, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label3", "\u65e0\u6548\u7684ID\u5e8f\u5217!"));
        }
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, string);
        HashMap<String, String[][]> hashMap = new HashMap<String, String[][]>(1);
        if (chnlDocs == null || chnlDocs.size() == 0) {
            hashMap.put("urls", new String[0][2]);
        } else {
            String[][] stringArray = new String[chnlDocs.size()][3];
            Document document = null;
            String string2 = null;
            IPublishContent iPublishContent = null;
            IPublishFolder iPublishFolder = null;
            PublishPathCompass publishPathCompass = new PublishPathCompass();
            FilesMan filesMan = FilesMan.getFilesMan();
            int n = 0;
            int n2 = chnlDocs.size();
            for (int i = 0; i < n2; ++i) {
                ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
                stringArray[i][2] = "";
                if (chnlDoc != null) {
                    document = chnlDoc.getDocument();
                    string2 = document.getAttributeValue("SRCFILE");
                    if (document.getStatusId() == 10) {
                        if (n != chnlDoc.getChannelId()) {
                            n = chnlDoc.getChannelId();
                            iPublishFolder = (IPublishFolder)PublishElementFactory.lookupElement(101, n);
                        }
                        iPublishContent = PublishElementFactory.makeContentFrom(document, iPublishFolder);
                        string2 = publishPathCompass.getAbsoluteHttpPath(iPublishContent) + string2;
                    } else {
                        string2 = filesMan.mapFilePath(string2, 1) + string2;
                    }
                    stringArray[i][0] = string2;
                    stringArray[i][1] = string2;
                    if (chnlDoc.getStatusId() != 10) continue;
                    stringArray[i][2] = I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label2", "\u5df2\u53d1");
                    continue;
                }
                stringArray[i][0] = "";
                stringArray[i][1] = "";
            }
            hashMap.put("urls", stringArray);
        }
        methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON2(hashMap, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepCode(User user, String string) {
        int n;
        DBManager dBManager = DBManager.getDBManager();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        int[] nArray = CMyString.splitToInt(string, ",");
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("select recid,docid,chnlid,docstatus from wcmdocument");
        stringBuffer.append(" where recid in(");
        stringBuffer.append("?");
        int n2 = nArray.length;
        for (n = 1; n < n2; ++n) {
            stringBuffer.append(",?");
        }
        stringBuffer.append(')');
        try {
            try {
                connection = dBManager.getConnection();
                preparedStatement = connection.prepareStatement(stringBuffer.toString());
                stringBuffer.setLength(0);
                stringBuffer.append("select docid,docchannel,crtime,docstatus,attribute");
                stringBuffer.append("  from wcmdocument where docid=?");
                preparedStatement2 = connection.prepareStatement(stringBuffer.toString());
                stringBuffer.setLength(0);
                n = 1;
                preparedStatement.setInt(n++, nArray[0]);
                int n3 = nArray.length;
                for (n2 = 1; n2 < n3; ++n2) {
                    preparedStatement.setInt(n++, nArray[n2]);
                }
                resultSet = preparedStatement.executeQuery();
                ChnlDoc chnlDoc = null;
                while (resultSet.next()) {
                    chnlDoc = new ChnlDoc();
                    chnlDoc.readFromRs(resultSet, null);
                    preparedStatement2.setInt(1, chnlDoc.getDocId());
                    resultSet2 = preparedStatement2.executeQuery();
                    if (!resultSet2.next()) continue;
                }
                Object var15_16 = null;
            }
            catch (Exception exception) {
                Object var15_17 = null;
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            throw throwable;
        }
    }

    private BaseChannel getHost(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("ChannelId", 0);
        BaseChannel baseChannel = null;
        boolean bl = false;
        if (n > 0) {
            baseChannel = Channel.findById(n);
        } else {
            n = methodContext.getValue("SiteId", 0);
            baseChannel = WebSite.findById(n);
            bl = true;
        }
        int n2 = methodContext.getValue("SiteType", -1);
        if (n2 < 0) {
            this.assertHostValid(n, baseChannel, bl);
        }
        return baseChannel;
    }

    private void assertHostValid(int n, BaseChannel baseChannel, boolean bl) throws WCMException {
        if (baseChannel == null) {
            String string = I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label4", "\u6ca1\u6709\u627e\u5230[id=") + n + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label5", "]\u7684");
            string = bl ? string + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label6", "\u56fe\u7247\u5e93") : string + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label7", "\u56fe\u7247\u5206\u7c7b");
            throw new WCMException(200006, string);
        }
        if (baseChannel.isDeleted()) {
            String string = "[id=" + n + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label5", "]\u7684");
            string = bl ? string + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label6", "\u56fe\u7247\u5e93") : string + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label7", "\u56fe\u7247\u5206\u7c7b");
            string = string + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label8", "\u5df2\u88ab\u5220\u9664\uff01\u8bf7\u5237\u65b0\u60a8\u7684\u5bfc\u822a\u6811");
            throw new WCMException(200006, string);
        }
    }

    public int save(MethodContext methodContext) throws Throwable {
        Object object;
        int n = methodContext.getValue("PhotoDocId", 0);
        Document document = Document.findById(n);
        if (document == null) {
            throw new WCMException(200006, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label9", "\u6ca1\u6709\u627e\u5230[Id=") + n + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label10", "]\u7684\u56fe\u7247\uff01"));
        }
        String string = methodContext.getValue("PhotoFile");
        String string2 = methodContext.getValue("WatermarkFile");
        boolean bl = false;
        int[] nArray = null;
        if (FilesMan.isValidFile(string2, "W0") && !CMyString.isEmpty((String)(object = methodContext.getValue("WatermarkPos")))) {
            bl = true;
            nArray = CMyString.splitToInt((String)object, ",");
        }
        object = new ImageInfo();
        ((ImageInfo)object).setImageFileName(string);
        ((ImageInfo)object).setId(n);
        ((ImageInfo)object).setAddMark(bl);
        ((ImageInfo)object).setMarkImageFile(string2);
        ((ImageInfo)object).setMarkPos(nArray);
        String string3 = methodContext.getValue("BmpConverType");
        ((ImageInfo)object).setConvertToImageType(string3);
        IImageLibMgr iImageLibMgr = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");
        iImageLibMgr.saveImageInfo((ImageInfo)object);
        return n;
    }

    public String addWaterMark(MethodContext methodContext) throws Throwable {
        String string = methodContext.getValue("UploadedFiles");
        if (CMyString.isEmpty(string)) {
            throw new WCMException(10, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label11", "\u6ca1\u6709\u6307\u5b9a\u8981\u4fdd\u5b58\u7684\u56fe\u7247\uff01"));
        }
        String string2 = methodContext.getValue("WatermarkFile");
        String string3 = methodContext.getValue("WatermarkPos");
        if (!CMyString.isEmpty(string3) && !CMyString.isEmpty(string2)) {
            IImageLibMgr iImageLibMgr = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");
            String[] stringArray = string.split(",");
            int[] nArray = CMyString.splitToInt(string3, ",");
            for (int i = stringArray.length - 1; i >= 0; --i) {
                iImageLibMgr.addWaterMark(stringArray[i], string2, nArray);
            }
        }
        return string;
    }

    public String saveImageInfo(MethodContext methodContext) throws Throwable {
        String string;
        Object object;
        int n = methodContext.getValue("MainKindId", 0);
        Channel channel = Channel.findById(n);
        this.assertHostValid(n, channel, false);
        this.assertHasRight(channel);
        String string2 = methodContext.getValue("UploadedFiles");
        if (CMyString.isEmpty(string2)) {
            throw new WCMException(10, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label11", "\u6ca1\u6709\u6307\u5b9a\u8981\u4fdd\u5b58\u7684\u56fe\u7247\uff01"));
        }
        boolean bl = methodContext.getValue("BatchMode", false);
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (bl) {
            object = this.extractPicFiles0(string2);
            stringArray2 = object[0];
            stringArray = object[1];
            if (stringArray.length == 0) {
                throw new WCMDatainvalidException(I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label12", "\u5bfc\u5165\u7684zip\u6587\u4ef6\u4e2d\u6ca1\u6709\u6709\u6548\u7684\u56fe\u7247\uff01"));
            }
        } else {
            stringArray = string2.split(",");
            object = methodContext.getValue("SourceFiles");
            stringArray2 = !CMyString.isEmpty((String)object) ? ((String)object).split(",") : stringArray;
        }
        object = methodContext.getValue("WatermarkFile");
        boolean bl2 = false;
        int[] nArray = null;
        if (FilesMan.isValidFile((String)object, "W0") && !CMyString.isEmpty(string = methodContext.getValue("WatermarkPos"))) {
            bl2 = true;
            nArray = CMyString.splitToInt(string, ",");
        }
        string = methodContext.getValue("OtherKindIds");
        int[] nArray2 = null;
        nArray2 = CMyString.isEmpty(string) ? new int[]{} : CMyString.splitToInt(string, ",");
        String string3 = methodContext.getValue("BmpConverType");
        IImageLibMgr iImageLibMgr = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");
        StringBuffer stringBuffer = new StringBuffer(64);
        ImageInfo imageInfo = null;
        for (int i = stringArray.length - 1; i >= 0; --i) {
            imageInfo = new ImageInfo();
            imageInfo.setImageKindId(n);
            imageInfo.setOtherImageKinedId(nArray2);
            imageInfo.setImageFileName(stringArray[i]);
            imageInfo.setSrcFileName(stringArray2[i]);
            imageInfo.setAddMark(bl2);
            imageInfo.setMarkImageFile((String)object);
            imageInfo.setMarkPos(nArray);
            imageInfo.setConvertToImageType(string3);
            imageInfo = iImageLibMgr.saveImageInfo(imageInfo);
            stringBuffer.append(",").append(imageInfo.getId());
        }
        String string4 = stringBuffer.substring(1);
        this.startFlowIfNeed(channel, string4, methodContext);
        return string4;
    }

    private void startFlowIfNeed(Channel channel, String string, MethodContext methodContext) throws WCMException {
        Channel channel2 = channel;
        final String string2 = string;
        FlowEmployMgr flowEmployMgr = (FlowEmployMgr)DreamFactory.createObjectById("FlowEmployMgr");
        Flow flow = flowEmployMgr.getFlow(channel2);
        if (flow == null) {
            return;
        }
        final User user = ContextHelper.getLoginUser();
        final MethodContext methodContext2 = methodContext;
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                IFlowServer iFlowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
                IFlowContent iFlowContent = null;
                Documents documents = null;
                ContextHelper.initContext(user);
                try {
                    block9: {
                        try {
                            documents = Documents.findByIds(user, string2);
                            FlowContext flowContext = null;
                            if (methodContext2.getValue("DefaultFlowModal", true)) {
                                Document document = null;
                                int n = documents.size();
                                for (int i = 0; i < n; ++i) {
                                    document = (Document)documents.getAt(i);
                                    if (document == null) continue;
                                    iFlowContent = FlowContentFactory.makeFlowContent(document);
                                    flowContext = new FlowContext(user, iFlowContent);
                                    flowContext.setPostDesc(I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label13", "\u7cfb\u7edf\u6839\u636e\u680f\u76ee\u5de5\u4f5c\u6d41\u914d\u7f6e\u81ea\u52a8\u9a71\u52a8\u6d41\u8f6c\uff01"));
                                    iFlowServer.submitTo(flowContext);
                                }
                                break block9;
                            }
                            s_logger.warn((Object)"Flow Modal Not implement!");
                        }
                        catch (Exception exception) {
                            s_logger.error((Object)"put the image into flow failed!", (Throwable)exception);
                            Object var9_10 = null;
                            if (documents != null) {
                                documents.clear();
                            }
                        }
                    }
                    Object var9_9 = null;
                    if (documents != null) {
                        documents.clear();
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (documents != null) {
                        documents.clear();
                    }
                    throw throwable;
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] extractPicFiles(String string) throws CMyException {
        String[] stringArray;
        String string2;
        block5: {
            String[] stringArray2;
            string2 = string;
            if (!CMyFile.fileExists(string2)) {
                string2 = FilesMan.getFilesMan().mapFilePath(string2, 0) + string2;
            }
            String string3 = CMyFile.extractFilePath(string2);
            string3 = string3 + "unziptemp" + File.separator + System.currentTimeMillis() + File.separator;
            IImageLibConfig iImageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
            String[] stringArray3 = iImageLibConfig.getSupportImageFileExt();
            try {
                CMyUnZipFile cMyUnZipFile = new CMyUnZipFile(string2, string3);
                cMyUnZipFile.setZipFile(string2);
                int n = stringArray3.length;
                for (int i = 0; i < n; ++i) {
                    cMyUnZipFile.addFileExtFilters(stringArray3[i]);
                }
                cMyUnZipFile.doUnZipAnd();
                stringArray = new String[]{};
                ArrayList arrayList = cMyUnZipFile.getFilteredFiles();
                if (arrayList == null) break block5;
                stringArray2 = arrayList.toArray(stringArray);
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                CMyFile.deleteFile(string2);
                throw throwable;
            }
            CMyFile.deleteFile(string2);
            return stringArray2;
        }
        String[] stringArray4 = stringArray;
        Object var11_14 = null;
        CMyFile.deleteFile(string2);
        return stringArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[][] extractPicFiles0(String string) throws CMyException {
        String[][] stringArray;
        String string2 = string;
        if (!CMyFile.fileExists(string2)) {
            string2 = FilesMan.getFilesMan().mapFilePath(string2, 0) + string2;
        }
        String string3 = CMyFile.extractFilePath(string2);
        string3 = string3 + "unziptemp" + File.separator + System.currentTimeMillis() + File.separator;
        IImageLibConfig iImageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        try {
            UnZipFile4Batch unZipFile4Batch = new UnZipFile4Batch(string2, string3);
            unZipFile4Batch.setZipFile(string2);
            unZipFile4Batch.setFilters(iImageLibConfig.getSupportImageFileExt());
            unZipFile4Batch.doUnZipAnd();
            SortedMap sortedMap = unZipFile4Batch.getSortedFileNameIndex();
            Iterator iterator = sortedMap.keySet().iterator();
            ArrayList<String> arrayList = new ArrayList<String>(sortedMap.size());
            ArrayList arrayList2 = new ArrayList(sortedMap.size());
            String string4 = null;
            while (iterator.hasNext()) {
                string4 = (String)iterator.next();
                arrayList.add(string4);
                arrayList2.add(sortedMap.get(string4));
            }
            String[][] stringArray2 = new String[2][arrayList.size()];
            arrayList.toArray(stringArray2[0]);
            arrayList2.toArray(stringArray2[1]);
            stringArray = stringArray2;
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            CMyFile.deleteFile(string2);
            throw throwable;
        }
        CMyFile.deleteFile(string2);
        return stringArray;
    }

    private void assertHasRight(BaseChannel baseChannel) throws WCMException {
        User user = ContextHelper.getLoginUser();
        if (!AuthServer.hasRight(user, (CMSObj)baseChannel, 31)) {
            throw new WCMException(1002, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label14", "\u5bf9\u4e0d\u8d77\u60a8\u6ca1\u6709\u6743\u9650\u4e0a\u4f20\u56fe\u7247\uff01"));
        }
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        methodContext.setValue("SelectFieldsOfChnlDoc", FIELDS_OF_CHNLDOC);
        methodContext.setValue("SelectFieldsOfDocument", FIELDS_OF_DOCUMENT);
        return super.findById(methodContext);
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        throw new UnsupportedOperationException("never use:" + methodContext);
    }

    public Object getSupportedFormat(MethodContext methodContext) throws Throwable {
        methodContext.setReturnJSON(false);
        String[] stringArray = this.m_libConf.getSupportImageFileExt();
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("{");
        stringBuffer.append(stringArray[0]);
        stringBuffer.append(":");
        stringBuffer.append(1);
        int n = stringArray.length;
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(",");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(":");
            stringBuffer.append(i + 1);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Object getSacledImages(MethodContext methodContext) throws Throwable {
        methodContext.setReturnJSON(false);
        int n = methodContext.getObjectId();
        Document document = Document.findById(n);
        if (document == null) {
            throw new WCMException(200006, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label9", "\u6ca1\u6709\u627e\u5230[Id=") + n + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label15", "]\u7684\u56fe\u7247!"));
        }
        String[] stringArray = CMyString.split(document.getRelateWords(), ",");
        String string = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put("doctitle", document.getTitle());
        HashMap<String, String> hashMap2 = null;
        ArrayList arrayList = new ArrayList(stringArray.length + 1);
        if (this.m_libConf.isCmdUsed()) {
            ImageMagickCmd.ImageObj imageObj = new ImageMagickCmd.ImageObj();
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                string = stringArray[i];
                hashMap2 = new HashMap<String, String>(4);
                imageObj.setFilename(string);
                hashMap2.put("file", string);
                hashMap2.put("width", String.valueOf(imageObj.width));
                hashMap2.put("height", String.valueOf(imageObj.height));
                hashMap2.put("desc", this.m_libConf.getScaleDescAt(i));
                arrayList.add(hashMap2);
            }
            if (stringArray.length == 1) {
                string = document.getAttributeValue("SRCFILE");
                hashMap2 = new HashMap(4);
                hashMap2.put("file", string);
                imageObj.setFilename(string);
                hashMap2.put("width", String.valueOf(imageObj.width));
                hashMap2.put("height", String.valueOf(imageObj.height));
                hashMap2.put("desc", this.m_libConf.getScaleDescAt(1));
                arrayList.add(hashMap2);
            }
        } else {
            MagicImageImpl magicImageImpl = new MagicImageImpl();
            int n3 = stringArray.length;
            for (int i = 0; i < n3; ++i) {
                string = stringArray[i];
                magicImageImpl.initMagicImage(string);
                hashMap2 = new HashMap(4);
                hashMap2.put("file", string);
                hashMap2.put("width", String.valueOf((int)magicImageImpl.getWidth()));
                hashMap2.put("height", String.valueOf((int)magicImageImpl.getHeight()));
                hashMap2.put("desc", this.m_libConf.getScaleDescAt(i));
                arrayList.add(hashMap2);
            }
            if (stringArray.length == 1) {
                string = document.getAttributeValue("SRCFILE");
                magicImageImpl.initMagicImage(string);
                hashMap2 = new HashMap(4);
                hashMap2.put("file", string);
                hashMap2.put("width", String.valueOf((int)magicImageImpl.getWidth()));
                hashMap2.put("height", String.valueOf((int)magicImageImpl.getHeight()));
                hashMap2.put("desc", this.m_libConf.getScaleDescAt(1));
                arrayList.add(hashMap2);
            }
        }
        hashMap.put("ScaleImages", arrayList.toArray());
        methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(hashMap, 0);
    }

    public Object loadLibConf(MethodContext methodContext) throws Throwable {
        int[] nArray = this.m_libConf.getScaleSizes();
        int n = nArray[1];
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        Boolean bl = !this.m_libConf.isInstalled();
        hashMap.put("firstInstall", bl);
        hashMap.put("surpportedExt", CMyString.join(this.m_libConf.getSupportImageFileExt(), ","));
        hashMap.put("bmp2type", this.m_libConf.getDefaultConvertImageFileExt());
        int n2 = nArray.length;
        Object[] objectArray = new Object[n2];
        HashMap<String, Object> hashMap2 = null;
        String string = null;
        for (int i = 1; i < n2; ++i) {
            n = nArray[i];
            hashMap2 = new HashMap<String, Object>(4);
            hashMap2.put("size", String.valueOf(n));
            hashMap2.put("sizeEditable", bl);
            string = String.valueOf(this.m_libConf.getWaterMarkSize(n));
            hashMap2.put("wmsize", string);
            hashMap2.put("desc", this.m_libConf.getScaleDescAt(i));
            objectArray[i] = hashMap2;
        }
        hashMap.put("iamgeSizes", objectArray);
        methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(hashMap, 0);
    }

    public void saveLibConf(MethodContext methodContext) throws Throwable {
        String string = methodContext.getValue("SupportedExt");
        String string2 = methodContext.getValue("DefaultConvertType");
        String string3 = methodContext.getValue("ScaleSizes");
        String string4 = methodContext.getValue("ScaleSizeDescs");
        String string5 = methodContext.getValue("WatermarkSizes");
        this.m_libConf.setImageFileExt(this.split(string), string2);
        this.m_libConf.setScaleSizes(this.split2Int(string3), this.split(string4), this.split2Int(string5));
        this.m_libConf.saveConfig();
    }

    private int[] split2Int(String string) {
        return CMyString.splitToInt(string, ",");
    }

    private String[] split(String string) {
        return CMyString.split(string, ",");
    }

    public Object getQuoteKinds(MethodContext methodContext) throws Throwable {
        int n = methodContext.getObjectId();
        Document document = Document.findById(n);
        if (document == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
        int n2 = methodContext.getValue("RecId", 0);
        ChnlDoc chnlDoc = ChnlDoc.findById(n2);
        if (chnlDoc != null) {
            hashMap.put("CurrentPath", this.getChnlPath(chnlDoc.getChannel()));
        } else {
            hashMap.put("CurrentPath", this.getChnlPath(document.getChannel()));
        }
        hashMap.put("MainKind", this.getChnlPath(document.getChannel()));
        Channels channels = this.m_docService.getQuoteChannels(document);
        if (channels != null && !channels.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>(channels.size());
            Channel channel = null;
            int n3 = channels.size();
            for (int i = 0; i < n3; ++i) {
                channel = (Channel)channels.getAt(i);
                if (channel == null) continue;
                arrayList.add(this.getChnlPath(channel));
            }
            hashMap.put("OtherKinds", arrayList.toArray());
        } else {
            hashMap.put("OtherKinds", new String[0]);
        }
        methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(hashMap, 0);
    }

    public Object getQuoteDocs(MethodContext methodContext) throws Throwable {
        int n = methodContext.getObjectId();
        Documents documents = this.m_libManager.getDocumentsQuoteImage(n);
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>(documents.size());
        ArrayList arrayList = new ArrayList(documents.size());
        Document document = null;
        HashMap<String, String> hashMap2 = null;
        int n2 = documents.size();
        for (int i = 0; i < n2; ++i) {
            document = (Document)documents.getAt(i);
            if (document == null) continue;
            hashMap2 = new HashMap<String, String>(3);
            hashMap2.put("DocTitle", document.getTitle());
            hashMap2.put("ChnlPath", this.getChnlPath(document.getChannel()));
            hashMap2.put("DocStatus", String.valueOf(document.getStatusId()));
            arrayList.add(hashMap2);
        }
        hashMap.put("Documents", arrayList.toArray());
        methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(hashMap, 0);
    }

    private String getChnlPath(Channel channel) throws WCMException {
        if (channel == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(channel.getSite().getDesc());
        stringBuffer.append("&nbsp;>&nbsp;");
        for (Channel channel2 = channel.getParent(); channel2 != null; channel2 = channel2.getParent()) {
            stringBuffer.append(channel2.getDesc());
            stringBuffer.append("&nbsp;>&nbsp;");
        }
        stringBuffer.append(channel.getDesc());
        return stringBuffer.toString();
    }

    public Object getExtendedProps(MethodContext methodContext) throws Throwable {
        int n = methodContext.getObjectId();
        Document document = Document.findById(n);
        if (document == null) {
            return null;
        }
        Channel channel = document.getChannel();
        ContentExtFields contentExtFields = this.m_oExtFieldMgr.getExtFields(channel, null);
        if (contentExtFields.isEmpty()) {
            return null;
        }
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>(1);
        ArrayList arrayList = new ArrayList(contentExtFields.size());
        HashMap<String, String> hashMap2 = null;
        ContentExtField contentExtField = null;
        String string = null;
        String string2 = null;
        DataType dataType = null;
        int n2 = contentExtFields.size();
        for (int i = 0; i < n2; ++i) {
            contentExtField = (ContentExtField)contentExtFields.getAt(i);
            if (contentExtField == null) continue;
            hashMap2 = new HashMap<String, String>(5);
            hashMap2.put("desc", contentExtField.getDesc());
            string2 = contentExtField.getName();
            hashMap2.put("name", string2);
            string = document.getPropertyAsString(string2);
            hashMap2.put("value", CMyString.transDisplay(string, false));
            dataType = contentExtField.getType();
            hashMap2.put("type", this.mapExtfieldType(dataType.getType()));
            hashMap2.put("maxlen", this.mapExtfieldMaxLength(dataType, contentExtField.getMaxLength()));
            hashMap2.put("minlen", this.mapExtfeildMinLength(dataType));
            arrayList.add(hashMap2);
        }
        hashMap.put("ExtendedProps", arrayList.toArray());
        methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(hashMap, 0);
    }

    private String mapExtfieldMaxLength(DataType dataType, int n) {
        int n2 = dataType.getType();
        switch (n2) {
            case 4: {
                return "2147483647";
            }
            case 2: 
            case 5: {
                return "32767";
            }
            case -5: 
            case 6: 
            case 8: {
                return "9223372036854775807";
            }
            case 91: 
            case 93: {
                return "8";
            }
            case 2005: {
                return "";
            }
        }
        return String.valueOf(n);
    }

    private String mapExtfeildMinLength(DataType dataType) {
        if (dataType.isLengthDefinedByUser()) {
            return "0";
        }
        int n = dataType.getType();
        String string = "-";
        string = -5 == n ? string + "9223372036854775807" : (4 == n ? string + "2147483647" : string + "32767");
        return string;
    }

    private String mapExtfieldType(int n) {
        switch (n) {
            case -5: 
            case 2: 
            case 4: 
            case 5: {
                return "int";
            }
            case 6: 
            case 8: {
                return "float";
            }
            case 91: 
            case 93: {
                return "date";
            }
            case 2005: {
                return "";
            }
        }
        return "string";
    }

    public Object getDefaultBmpConverType(MethodContext methodContext) throws Throwable {
        methodContext.setReturnJSON(false);
        String string = this.m_libConf.getDefaultConvertImageFileExt();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public Object loadOriginImg(MethodContext methodContext) throws Throwable {
        HashMap<String, String> hashMap;
        int n = methodContext.getValue("PhotoId", 0);
        Document document = Document.findById(n, "DocId,Attribute,DocChannel,DocTitle");
        if (document == null) {
            throw new WCMException(200006, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label16", "\u6ca1\u6709\u627e\u5230\u56fe\u7247[Id=") + n + "]!");
        }
        String string = document.getAttributeValue("SrcFile");
        if (CMyString.isEmpty(string)) {
            throw new WCMException(200006, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label17", "\u6ca1\u6709\u627e\u5230\u539f\u56fe!"));
        }
        int n2 = 0;
        int n3 = 0;
        if (this.m_libConf.isCmdUsed()) {
            hashMap = new ImageMagickCmd.ImageObj();
            ((ImageMagickCmd.ImageObj)((Object)hashMap)).setFilename(string);
            n2 = ((ImageMagickCmd.ImageObj)((Object)hashMap)).height;
            n3 = ((ImageMagickCmd.ImageObj)((Object)hashMap)).width;
        } else {
            hashMap = new MagicImageImpl();
            hashMap.initMagicImage(string);
            n2 = (int)hashMap.getHeight();
            n3 = (int)hashMap.getWidth();
        }
        hashMap = new HashMap<String, String>(5);
        hashMap.put("fn", string);
        hashMap.put("width", String.valueOf(n3));
        hashMap.put("height", String.valueOf(n2));
        hashMap.put("libid", String.valueOf(document.getChannel().getSiteId()));
        hashMap.put("doctitle", document.getTitle());
        methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(hashMap, 0);
    }

    public Object scaleImage(MethodContext methodContext) throws Throwable {
        String string = methodContext.getValue("FileName");
        int n = methodContext.getValue("ScaleWidth", 0);
        int n2 = methodContext.getValue("ScaleHeight", 0);
        String string2 = methodContext.getValue("FolderExt");
        if (string2 == null) {
            string2 = "ST";
        }
        if (this.m_libConf.isCmdUsed()) {
            ImageMagickCmd.ImageObj imageObj = new ImageMagickCmd.ImageObj();
            imageObj.setFilename(string);
            FilesMan filesMan = FilesMan.getFilesMan();
            String string3 = filesMan.getNextFileName(string2, CMyFile.extractFileExt(imageObj.filename), CMyDateTime.now(), true);
            ImageMagickCmd.ImageObj imageObj2 = new ImageMagickCmd.ImageObj(string3, n, n2);
            ImageMagickCmd.scale(imageObj, imageObj2);
            return this.newImage(methodContext, imageObj2);
        }
        MagicImageImpl magicImageImpl = new MagicImageImpl();
        magicImageImpl.initMagicImage(string);
        magicImageImpl.scaleImage(n, n2);
        String string4 = magicImageImpl.writeImageToSystemTemp();
        return this.newImage(methodContext, string4);
    }

    private Object newImage(MethodContext methodContext, String string) throws Throwable {
        methodContext.setReturnJSON(true);
        String string2 = CMyFile.extractFileName(string);
        MagicImageImpl magicImageImpl = new MagicImageImpl();
        magicImageImpl.initMagicImage(string2);
        int n = (int)magicImageImpl.getHeight();
        int n2 = (int)magicImageImpl.getWidth();
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("fn", string2);
        hashMap.put("width", String.valueOf(n2));
        hashMap.put("height", String.valueOf(n));
        return JSONHelper.toSimpleJSON(hashMap, 0);
    }

    public Object rotateImage(MethodContext methodContext) throws Throwable {
        String string = methodContext.getValue("FileName");
        String string2 = methodContext.getValue("Degree");
        if (this.m_libConf.isCmdUsed()) {
            ImageMagickCmd.ImageObj imageObj = new ImageMagickCmd.ImageObj(string);
            ImageMagickCmd.roateImg(imageObj, string2);
            return this.newImage(methodContext, imageObj);
        }
        MagicImageImpl magicImageImpl = new MagicImageImpl();
        magicImageImpl.initMagicImage(string);
        magicImageImpl.rotateImage(Double.parseDouble(string2));
        String string3 = magicImageImpl.writeImageToSystemTemp();
        return this.newImage(methodContext, string3);
    }

    private Object newImage(MethodContext methodContext, ImageMagickCmd.ImageObj imageObj) throws Throwable {
        methodContext.setReturnJSON(true);
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("fn", CMyFile.extractFileName(imageObj.filename));
        hashMap.put("width", String.valueOf(imageObj.width));
        hashMap.put("height", String.valueOf(imageObj.height));
        return JSONHelper.toSimpleJSON(hashMap, 0);
    }

    public Object addBorder(MethodContext methodContext) throws Throwable {
        String string = methodContext.getValue("FileName");
        int n = methodContext.getValue("BorderWidth", 0);
        int n2 = methodContext.getValue("BorderHeight", 0);
        String string2 = methodContext.getValue("BorderColor");
        if (this.m_libConf.isCmdUsed()) {
            ImageMagickCmd.ImageObj imageObj = new ImageMagickCmd.ImageObj(string);
            ImageMagickCmd.borderImg(imageObj, string2, n, n2);
            return this.newImage(methodContext, imageObj);
        }
        MagicImageImpl magicImageImpl = new MagicImageImpl();
        magicImageImpl.initMagicImage(string);
        magicImageImpl.borderImage(string2, n, n2);
        String string3 = magicImageImpl.writeImageToSystemTemp();
        return this.newImage(methodContext, string3);
    }

    public Object raiseImage(MethodContext methodContext) throws Throwable {
        String string = methodContext.getValue("FileName");
        int n = methodContext.getValue("RaiseWidth", 0);
        int n2 = methodContext.getValue("RaiseHeight", 0);
        boolean bl = methodContext.getValue("IsRaised", false);
        if (this.m_libConf.isCmdUsed()) {
            ImageMagickCmd.ImageObj imageObj = new ImageMagickCmd.ImageObj(string);
            ImageMagickCmd.raiseImg(imageObj, n, n2, bl);
            return this.newImage(methodContext, imageObj);
        }
        MagicImageImpl magicImageImpl = new MagicImageImpl();
        magicImageImpl.initMagicImage(string);
        magicImageImpl.raiseImage(n, n2, bl);
        String string2 = magicImageImpl.writeImageToSystemTemp();
        return this.newImage(methodContext, string2);
    }

    public Object saveOriginImg(MethodContext methodContext) throws Throwable {
        String string;
        String string2 = methodContext.getValue("FileName");
        String string3 = methodContext.getValue("SrcFile");
        int n = methodContext.getValue("PhotoId", 0);
        String string4 = methodContext.getValue("WaterMarkFile");
        boolean bl = !CMyString.isEmpty(string4);
        int[] nArray = null;
        if (FilesMan.isValidFile(string4, "W0")) {
            string = methodContext.getValue("WaterMarkPos");
            bl = true;
            nArray = !CMyString.isEmpty(string) ? CMyString.splitToInt(string, ",") : new int[]{ImageLibConstants.MARKPOS_RIGHT_BOTTOM};
        }
        string = methodContext.getValue("ConvertType");
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setId(n);
        imageInfo.setImageFileName(string2);
        imageInfo.setSrcFileName(string3);
        imageInfo.setAddMark(bl);
        imageInfo.setMarkImageFile(string4);
        imageInfo.setMarkPos(nArray);
        imageInfo.setConvertToImageType(string);
        imageInfo = this.m_libManager.saveImageInfo(imageInfo);
        return String.valueOf(imageInfo.getId());
    }

    public Object getSysPics(MethodContext methodContext) throws Throwable {
        int n;
        Object object;
        Object object2;
        String[] stringArray;
        WCMFilter wCMFilter = new WCMFilter("", "", "");
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("EXISTS(");
        stringBuffer.append("SELECT docid FROM wcmdocument WHERE");
        stringBuffer.append(" wcmappendix.AppFlag=20 AND ");
        stringBuffer.append(" DocStatus>0 AND ");
        stringBuffer.append(" docid=wcmappendix.appdocid AND ");
        String string = methodContext.getValue("SearchKey");
        String string2 = methodContext.getValue("SearchValue");
        if (!CMyString.isEmpty(string) && !CMyString.isEmpty(string2)) {
            stringArray = string.toUpperCase().split(",");
            object2 = stringArray[0];
            stringBuffer.append("(");
            object = DBManager.getDBManager().getDBType();
            if ("DOCHTMLCON".equals(object2)) {
                stringBuffer.append(((DBType)object).sqlFilterForClob((String)object2, string2));
            } else {
                stringBuffer.append((String)object2);
                stringBuffer.append(" LIKE ? ");
                wCMFilter.addSearchValues("%" + string2 + "%");
            }
            int n2 = stringArray.length;
            for (int i = 1; i < n2; ++i) {
                object2 = stringArray[i];
                stringBuffer.append(" OR ");
                if ("DOCHTMLCON".equals(object2)) {
                    stringBuffer.append(((DBType)object).sqlFilterForClob((String)object2, string2));
                    continue;
                }
                stringBuffer.append((String)object2);
                stringBuffer.append(" LIKE ? ");
                wCMFilter.addSearchValues("%" + string2 + "%");
            }
            stringBuffer.append(")");
            stringBuffer.append(" AND ");
        }
        if (!CMyString.isEmpty((String)(stringArray = methodContext.getValue("StartTime")))) {
            stringBuffer.append(" WCMDocument.CrTime>? AND ");
            object2 = new CMyDateTime();
            ((CMyDateTime)object2).setDateTimeWithString((String)stringArray);
            wCMFilter.addSearchValues((CMyDateTime)object2);
        }
        if (!CMyString.isEmpty((String)(object2 = methodContext.getValue("EndTime")))) {
            stringBuffer.append(" WCMDocument.CrTime<? AND ");
            object = new CMyDateTime();
            ((CMyDateTime)object).setDateTimeWithString((String)object2);
            wCMFilter.addSearchValues((CMyDateTime)object);
        }
        if ((n = methodContext.getValue("ChannelId", 0)) > 0) {
            stringBuffer.append(" wcmdocument.DocChannel=?");
            wCMFilter.addSearchValues(n);
        } else {
            n = methodContext.getValue("SiteId", 0);
            stringBuffer.append(" EXISTS(SELECT channelid FROM WCMChannel WHERE ");
            stringBuffer.append(" wcmdocument.DocChannel=ChannelId AND SiteId=?)");
            wCMFilter.addSearchValues(n);
        }
        stringBuffer.append(")");
        wCMFilter.setWhere(stringBuffer.toString());
        wCMFilter.setSelect("AppendixId,AppDocId,AppFile,AppDesc");
        Appendixes appendixes = new Appendixes(null);
        appendixes.open(wCMFilter);
        Appendix appendix = null;
        FilesMan filesMan = FilesMan.getFilesMan();
        List<String> list = Arrays.asList(this.m_libConf.getSupportImageFileExt());
        String string3 = null;
        String string4 = null;
        for (int i = appendixes.size() - 1; i >= 0; --i) {
            appendix = (Appendix)appendixes.getAt(i);
            if (appendix == null) continue;
            string3 = appendix.getFile();
            string4 = appendix.getFileExt().toLowerCase();
            if (filesMan.fileExists(string3) && list.contains(string4)) continue;
            appendixes.remove(appendix, false);
        }
        return appendixes;
    }

    public Object importSysPics(MethodContext methodContext) throws Throwable {
        String string;
        int n = methodContext.getValue("MainKindId", 0);
        Channel channel = Channel.findById(n);
        this.assertHostValid(n, channel, false);
        this.assertHasRight(channel);
        String string2 = methodContext.getValue("PicIds");
        User user = ContextHelper.getLoginUser();
        Appendixes appendixes = Appendixes.findByIds(user, string2);
        String string3 = methodContext.getValue("WatermarkFile");
        boolean bl = false;
        int[] nArray = null;
        if (FilesMan.isValidFile(string3, "W0") && !CMyString.isEmpty(string = methodContext.getValue("WatermarkPos"))) {
            bl = true;
            nArray = CMyString.splitToInt(string, ",");
        }
        string = methodContext.getValue("OtherKindIds");
        int[] nArray2 = null;
        nArray2 = CMyString.isEmpty(string) ? new int[]{} : CMyString.splitToInt(string, ",");
        String string4 = methodContext.getValue("BmpConverType");
        Appendix appendix = null;
        IImageLibMgr iImageLibMgr = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");
        StringBuffer stringBuffer = new StringBuffer(64);
        ImageInfo imageInfo = null;
        Document document = null;
        int n2 = appendixes.size();
        for (int i = 0; i < n2; ++i) {
            appendix = (Appendix)appendixes.getAt(i);
            if (appendix == null || appendix.getFlag() != 20 || (document = Document.findById(appendix.getDocId())) == null) continue;
            imageInfo = new ImageInfo();
            imageInfo.setImageKindId(n);
            imageInfo.setOtherImageKinedId(nArray2);
            imageInfo.setImageFileName(appendix.getFile());
            imageInfo.setSrcFileName(document.getTitle());
            imageInfo.setAddMark(bl);
            imageInfo.setMarkImageFile(string3);
            imageInfo.setMarkPos(nArray);
            imageInfo.setConvertToImageType(string4);
            imageInfo = iImageLibMgr.saveImageInfo(imageInfo);
            stringBuffer.append(",").append(imageInfo.getId());
        }
        String string5 = stringBuffer.substring(1);
        this.startFlowIfNeed(channel, string5, methodContext);
        return string5;
    }

    public Object loadSysPicProps(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("PhotoId", 0);
        String string = "DocTitle,CrUser,CrTime,DocKeywords,DocChannel";
        Document document = Document.findById(n, string);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
        hashMap.put("DocTitle", document.getTitle());
        hashMap.put("CrTime", document.getCrTime());
        hashMap.put("CrUser", document.getCrUser());
        hashMap.put("DocKeywords", CMyString.showNull(document.getKeywords(), ""));
        hashMap.put("DocPath", this.getChnlPath(document.getChannel()));
        methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(hashMap, 0);
    }

    public Object cropImage(MethodContext methodContext) throws Throwable {
        String string = methodContext.getValue("Filename");
        int n = methodContext.getValue("x", 0);
        int n2 = methodContext.getValue("y", 0);
        int n3 = methodContext.getValue("width", 0);
        int n4 = methodContext.getValue("height", 0);
        if (this.m_libConf.isCmdUsed()) {
            ImageMagickCmd.ImageObj imageObj = new ImageMagickCmd.ImageObj();
            imageObj.setFilename(string);
            ImageMagickCmd.crop(imageObj, n, n2, n3, n4);
            return this.newImage(methodContext, imageObj);
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = filesMan.getNextFileName("ST", CMyFile.extractFileExt(string), CMyDateTime.now(), true);
        MagicImageImpl magicImageImpl = new MagicImageImpl();
        magicImageImpl.initMagicImage(string);
        magicImageImpl.cropImage(n, n2, n3, n4, string2);
        return this.newImage(methodContext, string2);
    }

    public void saveExtif(MethodContext methodContext) throws Throwable {
        int n;
        User user = ContextHelper.getLoginUser();
        String string = methodContext.getValue("SrcFiles");
        String string2 = methodContext.getValue("ObjectIds");
        String string3 = "";
        String string4 = "";
        Document document = null;
        int n2 = string2.split(",").length;
        if (n2 != (n = string.split(",").length)) {
            return;
        }
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                document = Document.findById(Integer.parseInt(string2.split(",")[i]));
                if (document == null) {
                    throw new WCMException(200006, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label16", "\u6ca1\u6709\u627e\u5230\u56fe\u7247[Id=") + string2.split(",")[i] + "]!");
                }
                string4 = FilesMan.getFilesMan().mapFilePath(string.split(",")[i], 0);
                string3 = ImagesMetaDatas.getWCMExif((String)(string4 + string.split(",")[i]));
                if (string3.trim().length() < 10 && (string3 = ImagesMetaDatas.getWCMIptc((String)(string4 + string.split(",")[i]))).trim().length() < 10) continue;
                document.setAbstract(string3);
                document.save(user);
            }
        }
    }
}

