/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.DocumentServiceProvider;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.ajaxservice.xmlconvertors.XMLToCMSObj;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.domain.IRightHost;
import com.trs.cms.auth.domain.ObjectMemberSet;
import com.trs.cms.auth.domain.RightHostFactory;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.ObjectMember;
import com.trs.cms.auth.persistent.ObjectMembers;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMObjHelper;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.ArrayList;
import java.util.List;

public class ObjectMemberServiceProvider
implements IGlueServiceProvider {
    public void delete(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        ObjectMembers objectMembers = ObjectMembers.findByIds(user, methodContext.getObjectIds());
        objectMembers.removeAll(true);
    }

    public Object query(MethodContext methodContext) throws Throwable {
        return null;
    }

    public int save(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        ObjectMember objectMember = null;
        int n = methodContext.getObjectId();
        if (n == 0) {
            objectMember = new ObjectMember();
        } else {
            objectMember = ObjectMember.findById(n);
            if (objectMember == null) {
                throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "ObjectMemberServiceProvider.label19", "\u6307\u5b9a\u7684\u6210\u5458\u4e0d\u5b58\u5728![ObjectId=") + methodContext.getObjectId() + "]");
            }
        }
        objectMember = (ObjectMember)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, objectMember, null);
        objectMember.save(user);
        return objectMember.getId();
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        return ObjectMember.findById(methodContext.getObjectId());
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return null;
    }

    public ObjectMembers queryMembersOfObject(MethodContext methodContext) throws Exception {
        User user = this.getLoginUser();
        int n = methodContext.getValue("ObjType", 0);
        int n2 = methodContext.getValue("ObjId", 0);
        BaseChannel baseChannel = null;
        switch (n) {
            case 101: {
                baseChannel = Channel.findById(n2);
                break;
            }
            case 103: {
                baseChannel = WebSite.findById(n2);
                break;
            }
            default: {
                throw new WCMException("\u4e0d\u652f\u6301\u60a8\u6307\u5b9a\u7684\u5bf9\u8c61\u7c7b\u578b\uff01[ObjType=" + n + "]");
            }
        }
        if (baseChannel == null) {
            throw new WCMException("\u60a8\u6307\u5b9a\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01[ObjType=" + n + ", ObjId=" + n2 + "]");
        }
        WCMFilter wCMFilter = new WCMFilter("", "ObjType=? and ObjId=?", "");
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(n2);
        return ObjectMembers.openWCMObjs(user, wCMFilter);
    }

    public ObjectMembers queryObjectsOfMember(MethodContext methodContext) throws Exception {
        User user = this.getLoginUser();
        int n = methodContext.getValue("MemberType", 0);
        int n2 = methodContext.getValue("MemberId", 0);
        this.findMember(n, n2);
        WCMFilter wCMFilter = new WCMFilter("", "MemberType=? and MemberId=?", "");
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(n2);
        return ObjectMembers.openWCMObjs(user, wCMFilter);
    }

    public void saveObjectsOfMember(MethodContext methodContext) throws Exception {
        User user = this.getLoginUser();
        XMLToCMSObj xMLToCMSObj = new XMLToCMSObj(user, new ObjectMember());
        xMLToCMSObj.parse(methodContext.getValue("ObjectMembersXML"));
        CMSObj[] cMSObjArray = xMLToCMSObj.getCMSObjs();
        int n = methodContext.getValue("MemberType", 0);
        int n2 = methodContext.getValue("MemberId", 0);
        ArrayList<BaseChannel> arrayList = new ArrayList<BaseChannel>();
        for (int i = 0; i < cMSObjArray.length; ++i) {
            ObjectMember objectMember = (ObjectMember)cMSObjArray[i];
            BaseChannel baseChannel = (BaseChannel)BaseChannel.findById(objectMember.getObjType(), objectMember.getObjId());
            if (!this.canSetRight(user, baseChannel)) {
                throw new WCMException(1002, "\u7528\u6237[" + user + "]\u6ca1\u6709\u6743\u9650\u8bbe\u7f6e[" + baseChannel + "]\u7684\u53ef\u8bbf\u95ee\u53ef\u64cd\u4f5c\uff01");
            }
            if (objectMember.isAddMode()) {
                objectMember.setMember(n, n2);
            }
            objectMember.save(user);
            if (!objectMember.isVisible() || baseChannel.isSite()) continue;
            BaseChannel baseChannel2 = baseChannel.getHost();
            while (baseChannel2 != null) {
                if (arrayList.contains(baseChannel2)) {
                    baseChannel2 = baseChannel2.getHost();
                    continue;
                }
                arrayList.add(baseChannel2);
                baseChannel2 = baseChannel2.getHost();
            }
        }
        this.addVisible(arrayList, n, n2);
    }

    private boolean canSetRight(User user, BaseChannel baseChannel) throws WCMException {
        if (baseChannel.getWCMType() == 103) {
            return AuthServer.hasRight(user, (CMSObj)baseChannel, 7);
        }
        return AuthServer.hasRight(user, (CMSObj)baseChannel, 55);
    }

    private void addVisible(List list, int n, int n2) throws WCMException {
        if (list == null || list.size() == 0) {
            return;
        }
        IObjectMemberMgr iObjectMemberMgr = (IObjectMemberMgr)DreamFactory.createObjectById("IObjectMemberMgr");
        CMSObj cMSObj = (CMSObj)BaseObj.findById(n, n2);
        User user = this.getLoginUser();
        for (int i = 0; i < list.size(); ++i) {
            int n3;
            BaseChannel baseChannel = (BaseChannel)list.get(i);
            int n4 = baseChannel.getWCMType();
            if (iObjectMemberMgr.isVisible(cMSObj, n4, n3 = baseChannel.getId())) continue;
            ObjectMember objectMember = iObjectMemberMgr.getObjectMember(n, n2, n4, n3);
            if (objectMember != null) {
                objectMember.setVisible(true);
                objectMember.save(user);
                continue;
            }
            objectMember = ObjectMember.createNewInstance();
            objectMember.setMemberType(n);
            objectMember.setMemberId(n2);
            objectMember.setObjType(n4);
            objectMember.setObjId(n3);
            objectMember.setVisible(true);
            objectMember.insert(user);
        }
    }

    public void saveMembersOfObject(MethodContext methodContext) throws Exception {
        User user = this.getLoginUser();
        int n = methodContext.getValue("ObjType", 0);
        int n2 = methodContext.getValue("ObjId", 0);
        this.findBaseChannel(n, n2);
        String string = methodContext.getValue("ImpartModes");
        int[] nArray = CMyString.splitToInt(string, ",");
        ObjectMember objectMember = ObjectMember.createNewInstance();
        List list = WCMObjHelper.toWCMObjList(methodContext.getValue("ObjectMembersXML"), objectMember, user);
        IRightHost iRightHost = RightHostFactory.makeRightHostFrom(n, n2);
        if (iRightHost == null) {
            return;
        }
        iRightHost.validateCanDoSetRight(user);
        ObjectMemberSet objectMemberSet = new ObjectMemberSet(user, iRightHost, list, nArray);
        objectMemberSet.save();
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private CMSObj findMember(int n, int n2) throws WCMException {
        CMSObj cMSObj = null;
        switch (n) {
            case 204: {
                cMSObj = User.findById(n2);
                break;
            }
            case 201: {
                cMSObj = Group.findById(n2);
                break;
            }
            case 203: {
                cMSObj = Role.findById(n2);
                break;
            }
            default: {
                throw new WCMException("\u4e0d\u652f\u6301\u60a8\u6307\u5b9a\u7684\u6210\u5458\u7c7b\u578b\uff01[MememberType=" + n + "]");
            }
        }
        if (cMSObj == null) {
            throw new WCMException("\u60a8\u6307\u5b9a\u7684\u6210\u5458\u7c7b\u578b\u4e0d\u5b58\u5728\uff01[MememberType=" + n + ", MememberId=" + n2 + "]");
        }
        return cMSObj;
    }

    private BaseChannel findBaseChannel(int n, int n2) throws WCMException {
        BaseChannel baseChannel = null;
        User user = this.getLoginUser();
        switch (n) {
            case 101: {
                baseChannel = Channel.findById(n2);
                if (AuthServer.hasRight(user, (CMSObj)baseChannel, 55)) break;
                throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u7ef4\u62a4\u5f53\u524d\u5bf9\u8c61\u7684\u6210\u5458\uff01\u5bf9\u8c61\u4fe1\u606f\uff1a[" + baseChannel + "]");
            }
            case 103: {
                baseChannel = WebSite.findById(n2);
                if (AuthServer.hasRight(user, (CMSObj)baseChannel, 7)) break;
                throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u7ef4\u62a4\u5f53\u524d\u5bf9\u8c61\u7684\u6210\u5458\uff01\u5bf9\u8c61\u4fe1\u606f\uff1a[" + baseChannel + "]");
            }
            default: {
                throw new WCMException("\u4e0d\u652f\u6301\u60a8\u6307\u5b9a\u7684\u5bf9\u8c61\u7c7b\u578b\uff01[ObjType=" + n + "]");
            }
        }
        if (baseChannel == null) {
            throw new WCMException("\u60a8\u6307\u5b9a\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01[ObjType=" + n + ", ObjId=" + n2 + "]");
        }
        return baseChannel;
    }
}

