/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MessageServer;
import com.trs.components.common.message.Messages;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class MessageServiceProvider
implements IGlueServiceProvider {
    public void delete(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        MessageServer.delete(user, methodContext.getObjectIds());
    }

    public Object query(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("ReadFlag", 1);
        String string = methodContext.getValue("MsgTypes");
        int[] nArray = CMyString.splitToInt(string, ",");
        WCMFilter wCMFilter = new WCMFilter();
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("lower(SendType) like '%message%'");
        if (nArray != null) {
            stringBuffer.append(" and (");
            stringBuffer.append("MsgType=?");
            wCMFilter.addSearchValues(0, nArray[0]);
            int n2 = nArray.length;
            for (int i = 1; i < n2; ++i) {
                stringBuffer.append(" or ");
                stringBuffer.append("MsgType=?");
                wCMFilter.addSearchValues(i, nArray[i]);
            }
            stringBuffer.append(")");
        }
        wCMFilter.setWhere(stringBuffer.toString());
        WCMFilter wCMFilter2 = methodContext.getExtraWCMFilter();
        if (wCMFilter2 != null) {
            wCMFilter.mergeWith(wCMFilter2);
        }
        wCMFilter.mergeWith(methodContext.getExtraWCMFilter());
        return MessageServer.getMessages(n, user, wCMFilter);
    }

    public int save(MethodContext methodContext) throws Throwable {
        throw new WCMException(1103, I18NMessage.get(MessageServiceProvider.class, "MessageServiceProvider.label1", "\u6d88\u606f\u4e2d\u5fc3\u4e0d\u652f\u6301\u4fdd\u5b58\u64cd\u4f5c!"));
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        int n;
        User user = this.getLoginUser();
        Message message = MessageServer.findById(user, n = methodContext.getObjectId());
        if (message == null) {
            throw new WCMException(1100, I18NMessage.get(MessageServiceProvider.class, "MessageServiceProvider.label2", "\u6307\u5b9a\u7684\u6d88\u606f\u5bf9\u8c61[Id=") + n + I18NMessage.get(MessageServiceProvider.class, "MessageServiceProvider.label3", "]\u6ca1\u6709\u627e\u5230!"));
        }
        return message;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        return MessageServer.findByIds(user, methodContext.getObjectIds());
    }

    public boolean hasUnreadMessage(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("MsgTypes");
        int[] nArray = CMyString.splitToInt(string, ",");
        return MessageServer.hasUnreadMessage(user, nArray);
    }

    public int sendMessage(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Message message = Message.createNewInstance();
        WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, message, null);
        message.setReceivers(204, methodContext.getValue("UserIds"));
        message.setReceivers(201, methodContext.getValue("GroupIds"));
        message.setReceivers(203, methodContext.getValue("RoleIds"));
        MessageServer.send(message);
        return message.getId();
    }

    public void setReadFlag(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        boolean bl = methodContext.getValue("Readed", true);
        Messages messages = MessageServer.findByIds(user, methodContext.getObjectIds());
        int n = messages.size();
        for (int i = 0; i < n; ++i) {
            Message message = (Message)messages.getAt(i);
            if (message == null) continue;
            MessageServer.setMessageReaded(message, user, bl);
        }
    }

    public void clearInbox() throws WCMException {
        User user = this.getLoginUser();
        MessageServer.emptyInbox(user);
    }

    public void clearOutbox() throws WCMException {
        User user = this.getLoginUser();
        MessageServer.emptyOutbox(user);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

