/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.infra.I18NMessage;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class JSONHelper {
    private static Logger logger = Logger.getLogger(JSONHelper.class);

    public static String toJSON(Object object, String string, int n) {
        if (object instanceof HashMap) {
            return JSONHelper.toJSON((HashMap)object, n);
        }
        if (object instanceof String) {
            return JSONHelper.toJSON((String)object, string, n);
        }
        if (object instanceof String[]) {
            return JSONHelper.toJSON((String[])object, string, n);
        }
        if (object instanceof String[][]) {
            return JSONHelper.toJSON((String[][])object, n);
        }
        return "";
    }

    public static String toSimpleJSON(Object object, String string, int n) {
        if (object instanceof HashMap) {
            return JSONHelper.toJSON((HashMap)object, n);
        }
        if (object instanceof String) {
            return JSONHelper.toJSON((String)object, string, n);
        }
        if (object instanceof String[]) {
            return JSONHelper.toSimpleJSON((String[])object, string, n);
        }
        if (object instanceof String[][]) {
            return JSONHelper.toJSON((String[][])object, n);
        }
        return "";
    }

    public static String toJSON(Object[] objectArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n;
        String string = JSONHelper.makeTabStr(n2++);
        String string2 = JSONHelper.makeTabStr(n2++);
        stringBuffer.append("{/*Root Begin*/\n");
        stringBuffer.append(string);
        stringBuffer.append("ROOT:\n");
        stringBuffer.append(string);
        stringBuffer.append("{/*Element Begin*/\n");
        stringBuffer.append(string2);
        stringBuffer.append("ELEMENT:");
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("[/*Array Begin*/\n");
        boolean bl = true;
        int n3 = objectArray == null ? 0 : objectArray.length;
        for (int i = 0; i < n3; ++i) {
            if (objectArray[i] == null) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
                stringBuffer.append("\n");
            }
            stringBuffer.append(JSONHelper.toJSON(objectArray[i], null, n2));
        }
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("]/*Array End*/");
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("}/*Element END*/");
        stringBuffer.append("\n}/*Root End*/");
        return stringBuffer.toString();
    }

    public static String toSimpleJSON(Object[] objectArray, String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n + 1;
        String string2 = JSONHelper.makeTabStr(n);
        if (string != null && string.length() > 0) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
            stringBuffer.append(":\n");
        }
        stringBuffer.append(string2);
        stringBuffer.append("[/*Array " + n + " Begin*/\n");
        boolean bl = true;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
                stringBuffer.append("\n");
            }
            stringBuffer.append(JSONHelper.toSimpleJSON(objectArray[i], null, n2));
        }
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("]/*Array " + n + " End*/");
        return stringBuffer.toString();
    }

    private static String makeTabStr(int n) {
        StringBuffer stringBuffer = new StringBuffer(4 * n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("   ");
        }
        return stringBuffer.toString();
    }

    public static String toJSON(String string, String string2, int n) {
        if (string == null) {
            return "";
        }
        boolean bl = string2 != null && string2.length() > 0;
        int n2 = !bl ? 0 : n + string2.length() + 1;
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2 + n2);
        if (bl) {
            stringBuffer.append(JSONHelper.makeTabStr(n));
            stringBuffer.append(string2);
            stringBuffer.append(':');
        }
        stringBuffer.append('\"');
        stringBuffer.append(string.replaceAll("(\n|\r|\"|\\\\)", "\\\\$1"));
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public static String toSimpleJSON(HashMap hashMap, int n) {
        if (hashMap == null || hashMap.isEmpty()) {
            return "";
        }
        String string = JSONHelper.makeTabStr(n++);
        int n2 = n++;
        int n3 = hashMap.size() * 50 + 6;
        StringBuffer stringBuffer = new StringBuffer(n3);
        Iterator iterator = hashMap.keySet().iterator();
        stringBuffer.append(string);
        stringBuffer.append("{\n");
        boolean bl = true;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Object v = hashMap.get(string2);
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",\n");
            }
            string2 = string2.toUpperCase();
            if (v instanceof String[]) {
                stringBuffer.append(JSONHelper.toSimpleJSON((String[])v, string2, n2));
                continue;
            }
            if (v instanceof HashMap) {
                stringBuffer.append(JSONHelper.toSimpleJSON((HashMap)v, n2));
                continue;
            }
            if (v instanceof String[][]) {
                stringBuffer.append(JSONHelper.toJSON((String[][])v, n2));
                continue;
            }
            if (v instanceof Object[]) {
                stringBuffer.append(JSONHelper.toSimpleJSON((Object[])v, string2, n2));
                continue;
            }
            stringBuffer.append(JSONHelper.toSimpleJSON(v.toString(), string2, n2));
        }
        stringBuffer.append('\n');
        stringBuffer.append(string);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String toJSON(HashMap hashMap, int n) {
        if (hashMap == null || hashMap.isEmpty()) {
            return "";
        }
        String string = JSONHelper.makeTabStr(n++);
        int n2 = n++;
        int n3 = hashMap.size() * 50 + 6;
        StringBuffer stringBuffer = new StringBuffer(n3);
        Iterator iterator = hashMap.keySet().iterator();
        stringBuffer.append(string);
        stringBuffer.append("{\n");
        boolean bl = true;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Object v = hashMap.get(string2);
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",\n");
            }
            string2 = string2.toUpperCase();
            if (v instanceof String[]) {
                stringBuffer.append(JSONHelper.toSimpleJSON((String[])v, string2, n2));
                continue;
            }
            if (v instanceof HashMap) {
                stringBuffer.append(JSONHelper.toJSON((HashMap)v, n));
                continue;
            }
            if (v instanceof String[][]) {
                stringBuffer.append(JSONHelper.toJSON((String[][])v, n));
                continue;
            }
            if (v instanceof Object[]) {
                stringBuffer.append(JSONHelper.toJSON((Object[])v, n));
                continue;
            }
            stringBuffer.append(JSONHelper.toJSON(v.toString(), string2, n2));
        }
        stringBuffer.append('\n');
        stringBuffer.append(string);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String toJSON(String[] stringArray, String string, int n) {
        if (stringArray == null) {
            return "";
        }
        boolean bl = string != null && string.length() > 0;
        int n2 = !bl ? 0 : (string.length() + n + 3) * 2;
        String string2 = null;
        int n3 = stringArray.length * 50 + 6 + n2;
        StringBuffer stringBuffer = new StringBuffer(n3);
        if (bl) {
            if (n == 0) {
                stringBuffer.append('{');
            }
            int n4 = ++n;
            string2 = JSONHelper.makeTabStr(n4);
            int n5 = ++n;
            ++n;
            String string3 = JSONHelper.makeTabStr(n5);
            String string4 = string.toUpperCase();
            String string5 = string.toUpperCase();
            if (string5.lastIndexOf(0) == 83) {
                string4 = string4.substring(0, string4.length() - 1);
            } else {
                string5 = string5 + 'S';
            }
            stringBuffer.append(string2);
            stringBuffer.append(string5);
            stringBuffer.append(":\n");
            stringBuffer.append(string2);
            stringBuffer.append("{\n");
            stringBuffer.append(string3);
            stringBuffer.append(string4);
            stringBuffer.append(":");
        }
        stringBuffer.append(JSONHelper.toValueAsJSON(stringArray));
        if (bl) {
            stringBuffer.append('\n');
            stringBuffer.append(string2);
            stringBuffer.append('}');
            if (n == 0) {
                stringBuffer.append('}');
            }
        }
        return stringBuffer.toString();
    }

    private static String toValueAsJSON(String[] stringArray) {
        int n;
        int n2 = stringArray.length * 50 + 6;
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append("[");
        boolean bl = true;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(JSONHelper.toJSON(stringArray[n], null, 0));
        }
        stringBuffer.append("]");
        n = stringBuffer.length();
        int n3 = stringBuffer.toString().length();
        if (n > n3) {
            logger.warn((Object)("sbResult.length[" + n + "]>real.length[" + n3 + "]"));
        }
        return stringBuffer.toString();
    }

    public static String toSimpleJSON(String[] stringArray, String string, int n) {
        if (stringArray == null) {
            return "";
        }
        boolean bl = string != null && string.length() > 0;
        int n2 = !bl ? 0 : (string.length() + n + 3) * 2;
        String string2 = null;
        int n3 = stringArray.length * 50 + 6 + n2;
        StringBuffer stringBuffer = new StringBuffer(n3);
        string2 = JSONHelper.makeTabStr(n++);
        stringBuffer.append(string2);
        if (bl) {
            if (n == 0) {
                stringBuffer.append('{');
                ++n;
            }
            String string3 = string.toUpperCase();
            stringBuffer.append(string3);
            stringBuffer.append(":");
        }
        stringBuffer.append(JSONHelper.toValueAsJSON(stringArray));
        return stringBuffer.toString();
    }

    public static String toJSON(String[][] stringArray, int n) {
        if (stringArray == null) {
            return "";
        }
        String string = JSONHelper.makeTabStr(n++);
        String string2 = JSONHelper.makeTabStr(n++);
        int n2 = stringArray.length * 50 + 6;
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append(string);
        stringBuffer.append("{\n");
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length < 2) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",\n");
            }
            stringBuffer.append(string2);
            stringBuffer.append(stringArray[i][0]);
            stringBuffer.append(" : ");
            stringBuffer.append(JSONHelper.toJSON(stringArray[i][1], null, 0));
        }
        stringBuffer.append('\n');
        stringBuffer.append(string);
        stringBuffer.append("}");
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public static String toSimpleJSON2(HashMap hashMap, int n) {
        if (hashMap == null || hashMap.isEmpty()) {
            return "{}";
        }
        String string = JSONHelper.makeTabStr(n++);
        int n2 = n++;
        int n3 = hashMap.size() * 50 + 6;
        StringBuffer stringBuffer = new StringBuffer(n3);
        Iterator iterator = hashMap.keySet().iterator();
        stringBuffer.append(string);
        stringBuffer.append("{\n");
        boolean bl = true;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Object v = hashMap.get(string2);
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",\n");
            }
            string2 = string2.toUpperCase();
            if (v instanceof String[]) {
                stringBuffer.append(JSONHelper.toSimpleJSON((String[])v, string2, n2));
                continue;
            }
            if (v instanceof HashMap) {
                stringBuffer.append(JSONHelper.toSimpleJSON2((HashMap)v, n2));
                continue;
            }
            if (v instanceof Object[]) {
                stringBuffer.append(JSONHelper.toSimpleJSON2((Object[])v, string2, n2));
                continue;
            }
            stringBuffer.append(JSONHelper.toSimpleJSON2(v.toString(), string2, n2));
        }
        stringBuffer.append('\n');
        stringBuffer.append(string);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String toSimpleJSON2(Object[] objectArray, String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n + 1;
        String string2 = JSONHelper.makeTabStr(n);
        if (string != null && string.length() > 0) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
            stringBuffer.append(":\n");
        }
        stringBuffer.append(string2);
        stringBuffer.append("[\n");
        boolean bl = true;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
                stringBuffer.append("\n");
            }
            stringBuffer.append(JSONHelper.toSimpleJSON2(objectArray[i], null, n2));
        }
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String toSimpleJSON2(Object object, String string, int n) {
        if (object instanceof HashMap) {
            return JSONHelper.toJSON((HashMap)object, n);
        }
        if (object instanceof String) {
            return JSONHelper.toJSON((String)object, string, n);
        }
        if (object instanceof String[]) {
            return JSONHelper.toSimpleJSON((String[])object, string, n);
        }
        if (object instanceof Object[]) {
            return JSONHelper.toSimpleJSON2((Object[])object, string, n);
        }
        return "";
    }

    public static void main(String[] stringArray) {
        String[][] stringArray2 = new String[][]{{"Prop1", I18NMessage.get(JSONHelper.class, "JSONHelper.label1", "\u4e2d\u6587")}, {"Pro2", I18NMessage.get(JSONHelper.class, "JSONHelper.label2", "\u4e2d\u65872")}};
        System.out.println(JSONHelper.toJSON(stringArray2, 0));
        System.out.println(JSONHelper.toJSON(stringArray2, 1));
        HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
        hashMap.put("Prop1", I18NMessage.get(JSONHelper.class, "JSONHelper.label3", "\u6d4b\u8bd5\n\rfdfdsfdsfsdafdsf\")dfadfdfads\"dfdsfa\ndfdasfdsfdsf\r\ndfasfsdfds\"fdaf"));
        hashMap.put("Prop3", I18NMessage.get(JSONHelper.class, "JSONHelper.label4", "\u6d4b\u8bd52"));
        hashMap.put("ArrayProp4", new String[]{"Prop1", I18NMessage.get(JSONHelper.class, "JSONHelper.label5", "\u6d4b\u8bd5")});
        System.out.println(JSONHelper.toJSON(hashMap, 1));
        String[] stringArray3 = new String[]{"Prop1", I18NMessage.get(JSONHelper.class, "JSONHelper.label5", "\u6d4b\u8bd5")};
        System.out.println(JSONHelper.toJSON(stringArray3, null, 0));
        System.out.println(JSONHelper.toJSON(stringArray3, "test", 1));
        String[][] stringArrayArray = new String[][]{{"Prop1", I18NMessage.get(JSONHelper.class, "JSONHelper.label5", "\u6d4b\u8bd5")}, {I18NMessage.get(JSONHelper.class, "JSONHelper.label6", "\u5929\u554a"), I18NMessage.get(JSONHelper.class, "JSONHelper.label7", "\u6211\u662f\u4e8c\u7ef4\u7684")}};
        hashMap = new HashMap(1);
        hashMap.put("URLS", stringArrayArray);
        System.out.println(JSONHelper.toSimpleJSON(hashMap, 0));
        System.out.println(JSONHelper.toSimpleJSON2(hashMap, 0));
        String[][][] stringArrayArray2 = new String[][][]{{{"Prop1", "HAHAHA"}, {I18NMessage.get(JSONHelper.class, "JSONHelper.label5", "\u6d4b\u8bd5")}}, {{I18NMessage.get(JSONHelper.class, "JSONHelper.label6", "\u5929\u554a"), "009"}, {I18NMessage.get(JSONHelper.class, "JSONHelper.label7", "\u6211\u662f\u4e8c\u7ef4\u7684"), "good"}}};
        hashMap = new HashMap(1);
        hashMap.put("URLS", stringArrayArray2);
        System.out.println(JSONHelper.toSimpleJSON(hashMap, 0));
        System.out.println(JSONHelper.toSimpleJSON2(hashMap, 0));
    }
}

