/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.ajaxservice.ServiceConstants;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.individuation.CustomSiteCheckedInfo;
import com.trs.components.wcm.individuation.CustomSiteCheckedInfos;
import com.trs.components.wcm.individuation.Individuation;
import com.trs.components.wcm.individuation.IndividuationMgr;
import com.trs.components.wcm.individuation.Individuations;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;

public class IndividuationServiceProvider
implements ISelfDefinedServiceProvider,
IGlueServiceProvider {
    public Object query(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        WCMFilter wCMFilter = new WCMFilter();
        wCMFilter = methodContext.getExtraWCMFilter();
        return Individuations.openWCMObjs(user, wCMFilter);
    }

    public Object queryCustomSite(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        WCMFilter wCMFilter = new WCMFilter();
        wCMFilter = "customSite".equals(methodContext.getValue("ParamName")) ? this.makeQueryCustomeSiteFillter(Integer.parseInt(methodContext.getValue("userId")), user) : methodContext.getExtraWCMFilter();
        return Individuations.openWCMObjs(user, wCMFilter);
    }

    private User getLoginUser() {
        User user = ContextHelper.getLoginUser();
        return user;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return null;
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        return null;
    }

    public void delete(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Individuations individuations = Individuations.findByIds(user, methodContext.getObjectIds());
        int n = individuations.size();
        for (int i = 0; i < n; ++i) {
            Individuation individuation = (Individuation)individuations.getAt(i);
            if (individuation == null || individuation.getUserId() != user.getId()) continue;
            individuation.delete();
        }
    }

    public int save(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        int n2 = user.getId();
        Individuation individuation = null;
        if (methodContext.getValue("isShared") != null && "1".equals(methodContext.getValue("isShared")) && !user.isAdministrator()) {
            throw new WCMException(I18NMessage.get(IndividuationServiceProvider.class, "IndividuationServiceProvider.label4", "\u60a8\u6ca1\u6709\u6743\u9650\u5171\u4eab\u4e2a\u6027\u5316\u7ad9\u70b9"));
        }
        boolean bl = false;
        if (methodContext.getValue("isSystem") != null && "1".equals(methodContext.getValue("isSystem"))) {
            bl = true;
            n2 = -1;
            if (!user.isAdministrator()) {
                throw new WCMException(I18NMessage.get(IndividuationServiceProvider.class, "IndividuationServiceProvider.label4", "\u60a8\u6ca1\u6709\u6743\u9650\u8bbe\u7f6e\u7cfb\u7edf\u7ea7\u7684\u4e2a\u6027\u5316\u914d\u7f6e"));
            }
        }
        if (n == 0) {
            individuation = new Individuation();
        } else {
            individuation = Individuation.findById(n);
            if (individuation == null) {
                throw new WCMException(I18NMessage.get(IndividuationServiceProvider.class, "IndividuationServiceProvider.label1", "\u6307\u5b9a\u7684\u4e2a\u6027\u5316\u8bbe\u7f6e\u5b57\u6bb5\u4e0d\u5b58\u5728![ObjectId=") + methodContext.getObjectId() + "]");
            }
            if (!bl && individuation.getUserId() != user.getId()) {
                throw new WCMException(I18NMessage.get(IndividuationServiceProvider.class, "IndividuationServiceProvider.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u8fd9\u4e2a\u81ea\u5b9a\u4e49\u8bbe\u7f6e[ParamName=") + individuation.getParamName() + ",Id=" + individuation.getId() + "]\uff01");
            }
        }
        individuation.setUserId(n2);
        String[] stringArray = new String[]{"ObjectId"};
        if (bl) {
            String[] stringArray2 = new String[]{"ObjectId", "isSystem"};
            individuation = (Individuation)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, individuation, stringArray2);
        } else {
            individuation = (Individuation)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, individuation, stringArray);
        }
        individuation.save(user);
        if (individuation.getParamName().equals("customSite")) {
            this.synchronizeCustomSiteCheckInfo(individuation, user);
        }
        return individuation.getId();
    }

    public String getPageInfo(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("objType", 605);
        switch (n) {
            case 605: {
                String[][] stringArray = ServiceConstants.FILTERS_DOCUMENTS_DEFAULT;
                StringBuffer stringBuffer = new StringBuffer("{PageFilters : [");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append("{desc : '" + stringArray[i][0] + "', value : " + stringArray[i][1] + "}");
                    if (i + 1 >= stringArray.length) continue;
                    stringBuffer.append(",");
                }
                methodContext.setReturnJSON(true);
                return stringBuffer.append("]}").toString();
            }
        }
        throw new Exception(I18NMessage.get(IndividuationServiceProvider.class, "IndividuationServiceProvider.label3", "\u5c1a\u672a\u5b9e\u73b0\u6b64\u8fc7\u6ee4\u5668"));
    }

    public boolean setIsChecked(MethodContext methodContext) throws Throwable {
        Individuation individuation;
        int n;
        Individuations individuations;
        User user = this.getLoginUser();
        String string = methodContext.getValue("excludeIds");
        String string2 = methodContext.getValue("includeIds");
        if (string != null) {
            individuations = Individuations.findByIds(user, string);
            for (n = 0; n < individuations.size(); ++n) {
                CustomSiteCheckedInfo customSiteCheckedInfo;
                individuation = (Individuation)individuations.getAt(n);
                if (individuation == null || (customSiteCheckedInfo = CustomSiteCheckedInfo.getCustomSiteCheckInfo(individuation.getId(), user)) == null) continue;
                customSiteCheckedInfo.delete(user);
            }
        }
        if (string2 != null) {
            individuations = Individuations.findByIds(user, string2);
            for (n = 0; n < individuations.size(); ++n) {
                individuation = (Individuation)individuations.getAt(n);
                if (individuation == null) continue;
                this.addCustomSiteCheckedData(individuation.getId(), user);
            }
        }
        if (methodContext.getValue("refreshCustomSiteSession", false)) {
            methodContext.getServiceContext().getRequest().getSession().setAttribute("customSite", (Object)new IndividuationMgr().getObjectIdsHashtable(103));
        }
        return true;
    }

    private void setIsChecked(Individuations individuations, boolean bl, User user) throws Throwable {
        int n = individuations.size();
        for (int i = 0; i < n; ++i) {
            Individuation individuation = (Individuation)individuations.getAt(i);
            if (individuation == null) continue;
            if (individuation.getUserId() == user.getId()) {
                individuation.setIsChecked(bl);
            }
            individuation.save();
        }
    }

    private void synchronizeCustomSiteCheckInfo(Individuation individuation, User user) throws WCMException {
        if (individuation == null || !individuation.getParamName().equals("customSite")) {
            return;
        }
        int n = individuation.getId();
        CustomSiteCheckedInfo customSiteCheckedInfo = CustomSiteCheckedInfo.getCustomSiteCheckInfo(n, user);
        if (!individuation.isIsShared()) {
            this.removeCustomSiteCheckedDataOfOtherUsers(n, user);
        }
        if (individuation.isIsChecked()) {
            if (customSiteCheckedInfo != null) {
                return;
            }
            this.addCustomSiteCheckedData(n, user);
        } else {
            if (customSiteCheckedInfo == null) {
                return;
            }
            customSiteCheckedInfo.delete(user);
        }
    }

    private void addCustomSiteCheckedData(int n, User user) throws WCMException {
        CustomSiteCheckedInfo customSiteCheckedInfo = new CustomSiteCheckedInfo();
        customSiteCheckedInfo.setIndividuationId(n);
        customSiteCheckedInfo.setCheckedUser(user.getId());
        customSiteCheckedInfo.save();
    }

    private void removeCustomSiteCheckedDataOfOtherUsers(int n, User user) throws WCMException {
        CustomSiteCheckedInfos customSiteCheckedInfos = CustomSiteCheckedInfo.getCustomSiteCheckInfoByIndividuationId(n, user);
        for (int i = 0; i < customSiteCheckedInfos.size(); ++i) {
            CustomSiteCheckedInfo customSiteCheckedInfo = (CustomSiteCheckedInfo)customSiteCheckedInfos.getAt(i);
            customSiteCheckedInfo.delete(user);
        }
    }

    private WCMFilter makeQueryCustomeSiteFillter(int n, User user) {
        WCMFilter wCMFilter = new WCMFilter();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ParamName ='customSite' and");
        if (n > 0) {
            stringBuffer.append(" (UserId =" + n);
        } else {
            stringBuffer.append(" (UserId =" + user.getId());
        }
        stringBuffer.append(" or isShared = 1)");
        wCMFilter.setWhere(stringBuffer.toString());
        return wCMFilter;
    }
}

