/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.domain.AutoTransmitMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChannelSyn;
import com.trs.components.wcm.content.persistent.ChannelSyns;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class DocumentSynServiceProvider
implements IGlueServiceProvider {
    private AutoTransmitMgr m_oAutoTransmitMgr = (AutoTransmitMgr)DreamFactory.createObjectById("AutoTransmitMgr");

    public void delete(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Channel channel = this.findChannel(methodContext);
        this.validateRight(user, channel, 13, I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label1", "\u5220\u9664\u540c\u6b65\u4fe1\u606f"));
        ChannelSyns channelSyns = ChannelSyns.findByIds(user, methodContext.getObjectIds());
        int n = channelSyns.size();
        for (int i = 0; i < n; ++i) {
            ChannelSyn channelSyn = (ChannelSyn)channelSyns.getAt(i);
            if (channelSyn == null) continue;
            this.m_oAutoTransmitMgr.delete(channelSyn);
        }
    }

    public Object query(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Channel channel = this.findChannel(methodContext);
        boolean bl = methodContext.getValue("ChannelAsTarget", false);
        this.validateRight(user, channel, 13, I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label2", "\u83b7\u53d6\u540c\u6b65\u4fe1\u606f"));
        return this.m_oAutoTransmitMgr.getChannelSyns(channel, methodContext.getExtraWCMFilter(), bl);
    }

    public int save(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Channel channel = this.findChannel(methodContext);
        int n = methodContext.getObjectId();
        boolean bl = methodContext.getValue("ChannelAsTarget", false);
        this.validateRight(user, channel, 13, I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label2", "\u83b7\u53d6\u540c\u6b65\u4fe1\u606f"));
        String[] stringArray = new String[]{"ChannelId", "DstChannelIds", "ChannelAsTarget"};
        ChannelSyn channelSyn = null;
        Channels channels = Channels.findByIds(user, methodContext.getValue("DstChannelIds"));
        if (n == 0) {
            if (channels.isEmpty()) {
                throw new WCMException(1101, I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label3", "DstChannelIds\u6ca1\u6709\u6307\u5b9a\uff01"));
            }
            int n2 = channels.size();
            for (int i = 0; i < n2; ++i) {
                Channel channel2 = (Channel)channels.getAt(i);
                if (channel2 == null) continue;
                channelSyn = new ChannelSyn();
                if (bl) {
                    channelSyn.setToChannelId(channel.getId());
                    channelSyn.setSrcChannelId(channel2.getId());
                } else {
                    channelSyn.setToChannelId(channel2.getId());
                    channelSyn.setSrcChannelId(channel.getId());
                }
                WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, channelSyn, stringArray);
                channelSyn.save(user);
            }
        } else {
            channelSyn = ChannelSyn.findById(n);
            if (channelSyn == null) {
                throw new WCMException(1101, I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label4", "\u680f\u76ee\u5206\u53d1\u5bf9\u8c61[ID=") + n + I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label5", "]\u6ca1\u6709\u627e\u5230\uff01"));
            }
            channelSyn.validCanEditAndLock(user);
            WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, channelSyn, stringArray);
            if (!channels.isEmpty()) {
                int n3 = channels.getIdAt(0);
                if (bl) {
                    channelSyn.setSrcChannelId(n3);
                } else {
                    channelSyn.setToChannelId(n3);
                }
            }
            channelSyn.save(user);
        }
        return channelSyn.getId();
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Channel channel = this.findChannel(methodContext);
        int n = methodContext.getObjectId();
        if (n <= 0) {
            return null;
        }
        this.validateRight(user, channel, 13, I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label2", "\u83b7\u53d6\u540c\u6b65\u4fe1\u606f"));
        ChannelSyn channelSyn = ChannelSyn.findById(n);
        boolean bl = methodContext.getValue("asTarget", false);
        if (channelSyn == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerSynName(bl)}));
        }
        return channelSyn;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Channel channel = this.findChannel(methodContext);
        this.validateRight(user, channel, 13, I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label2", "\u83b7\u53d6\u540c\u6b65\u4fe1\u606f"));
        return ChannelSyns.findByIds(user, methodContext.getObjectIds());
    }

    public String isValidDocumentSyn(MethodContext methodContext) throws Throwable {
        boolean bl = methodContext.getValue("ChannelAsTarget", false);
        int[] nArray = CMyString.splitToInt(methodContext.getObjectIds(), ",");
        int n = methodContext.getValue("SrcChannelId", 0);
        StringBuffer stringBuffer = new StringBuffer(nArray.length + methodContext.getObjectIds().length());
        for (int i = 0; i < nArray.length; ++i) {
            boolean bl2 = false;
            bl2 = bl ? ChannelSyn.isValid(nArray[i], n) : ChannelSyn.isValid(n, nArray[i]);
            if (bl2) continue;
            Channel channel = Channel.findById(nArray[i]);
            stringBuffer.append(channel.getDesc() + "[" + channel.getId() + "]\n");
        }
        methodContext.setReturnHTML(true);
        return stringBuffer.toString();
    }

    public String isValidDocumentCollection(MethodContext methodContext) throws Throwable {
        int[] nArray = CMyString.splitToInt(methodContext.getObjectIds(), ",");
        int n = methodContext.getValue("SrcChannelId", 0);
        StringBuffer stringBuffer = new StringBuffer(nArray.length + methodContext.getObjectIds().length());
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            if (!ChannelSyn.isValid(nArray[i], n)) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(nArray[i]);
        }
        return stringBuffer.toString();
    }

    private Channel findChannel(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("ChannelId", 0);
        return this.findChannelById(n);
    }

    private Channel findChannelById(int n) throws WCMException {
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException(1100, I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label6", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ID=") + n + "]\uff01");
        }
        return channel;
    }

    private User getLoginUser() {
        User user = ContextHelper.getLoginUser();
        ContextHelper.initContext(user);
        return user;
    }

    private void validateRight(User user, Channel channel, int n, String string) throws WCMException {
        if (!AuthServer.hasRight(user, (CMSObj)channel, n)) {
            throw new WCMException(I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label7", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label8", "]\u6ca1\u6709\u6743\u9650\u5728(") + channel + I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label9", ")\u4e0a\u6267\u884c[") + string + I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label10", "]\u64cd\u4f5c\uff01"));
        }
    }
}

