/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.ContentExtendValues;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.ContentExtFieldMgr;
import com.trs.components.wcm.content.domain.DocBakMgr;
import com.trs.components.wcm.content.domain.RelationMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ContentExtField;
import com.trs.components.wcm.content.persistent.ContentExtFields;
import com.trs.components.wcm.content.persistent.DocBak;
import com.trs.components.wcm.content.persistent.DocBaks;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.Relations;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class DocumentBakServiceProvider
implements IGlueServiceProvider {
    private DocBakMgr m_oDocBakMgr = (DocBakMgr)DreamFactory.createObjectById("DocBakMgr");
    private AppendixMgr m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    private RelationMgr m_oRelationMgr = (RelationMgr)DreamFactory.createObjectById("RelationMgr");
    private ContentExtFieldMgr m_oExtFieldMgr = null;

    public DocumentBakServiceProvider() {
        this.m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        this.m_oExtFieldMgr = (ContentExtFieldMgr)DreamFactory.createObjectById("ContentExtFieldMgr");
    }

    public void delete(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("DocumentId", 0);
        Document document = Document.findById(n);
        this.validateRight(user, null, document, 33, I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label1", "\u5220\u9664\u6587\u6863\u7248\u672c"));
        DocBaks docBaks = this.m_oDocBakMgr.findDocBaks(document, null);
        String string = methodContext.getValue("ObjectIds");
        if (string != null && !string.equals("")) {
            string = "," + string + ",";
            int n2 = docBaks.size();
            for (int i = 0; i < n2; ++i) {
                DocBak docBak = (DocBak)docBaks.getAt(i);
                if (docBak == null || string.indexOf("," + docBak.getVersion() + ",") == -1) continue;
                this.m_oDocBakMgr.deleteDocBak(docBak);
            }
        }
    }

    public Object query(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("DocumentId", 0);
        if (n <= 0) {
            return null;
        }
        Document document = Document.findById(n);
        if (document == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(605)}));
        }
        this.validateRight(user, null, document, 32, I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label2", "\u83b7\u53d6\u6587\u6863\u7248\u672c\u5217\u8868"));
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        DocBaks docBaks = this.m_oDocBakMgr.findDocBaks(document, wCMFilter);
        return docBaks;
    }

    public int save(MethodContext methodContext) throws Throwable {
        return 0;
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("DocumentId", 0);
        int n2 = methodContext.getObjectId();
        Document document = Document.findById(n);
        if (document == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(605)}));
        }
        this.validateRight(user, null, document, 34, I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label3", "\u83b7\u53d6\u6587\u6863\u7248\u672c"));
        DocBak docBak = this.m_oDocBakMgr.getDocBak(document, n2);
        if (docBak == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n2), WCMTypes.getLowerObjName(611)}));
        }
        return docBak;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return null;
    }

    public String backup(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Documents documents = Documents.findByIds(user, methodContext.getValue("DocIds"));
        this.validateRight(user, null, documents, 32, I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label4", "\u4fdd\u5b58\u7248\u672c"));
        Reports reports = new Reports(I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label5", "\u4fdd\u5b58\u6587\u6863\u7248\u672c"));
        boolean bl = methodContext.getValue("ExcludeTrashed", false);
        int n = documents.size();
        for (int i = 0; i < n; ++i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            if (bl && document.getStatusId() < 0) {
                throw new WCMException(document.getTitle() + I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label6", "[\u6587\u6863-") + document.getId() + I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label7", "]\u5c1a\u5728\u5e9f\u7a3f\u7bb1\u4e2d\uff0c\u60a8\u6682\u65f6\u65e0\u6cd5\u5bf9\u5176\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01"));
            }
            try {
                int n2 = this.m_oDocBakMgr.bakupDocument(document).getVersion();
                reports.addSucessedReport(I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label8", "\u4fdd\u5b58\u6587\u6863[") + document.getTitle() + I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label9", "]\u7248\u672c\u6210\u529f\uff01\u7248\u672c\u53f7\u4e3a\uff1a") + (n2 + 1));
                continue;
            }
            catch (Exception exception) {
                reports.addFailedReport(I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label20", "\u4fdd\u5b58\u6587\u6863[") + document.getTitle() + I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label10", "]\u7248\u672c\u5931\u8d25\uff01"), exception);
            }
        }
        return reports.toJSONXML();
    }

    public void recover(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("DocumentId", 0);
        int n2 = methodContext.getValue("Version", 0);
        String string = methodContext.getValue("SelectFields");
        Document document = Document.findById(n, string);
        if (document == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(605)}));
        }
        this.validateRight(user, null, document, 32, I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label11", "\u6062\u590d\u5f53\u524d\u6587\u6863\u7248\u672c"));
        DocBak docBak = this.m_oDocBakMgr.getDocBak(document, n2);
        if (docBak == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n2), WCMTypes.getLowerObjName(611)}));
        }
        this.m_oDocBakMgr.recoverDocument(docBak, document);
    }

    public Appendixes queryAppendixes(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("AppendixType", 50);
        int n2 = methodContext.getValue("DocumentId", 0);
        int n3 = methodContext.getValue("Version", 0);
        String string = methodContext.getValue("SelectFields");
        Document document = Document.findById(n2, string);
        this.validateRight(user, null, document, 34, I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label12", "\u83b7\u53d6\u6587\u6863\u9644\u4ef6"));
        DocBak docBak = this.m_oDocBakMgr.getDocBak(document, n3);
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        return this.m_oAppendixMgr.getAppendixes(docBak, n, wCMFilter);
    }

    public Relations queryRelations(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("DocumentId", 0);
        int n2 = methodContext.getValue("Version", 0);
        String string = methodContext.getValue("SelectFields");
        Document document = Document.findById(n, string);
        this.validateRight(user, null, document, 34, I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label13", "\u83b7\u53d6\u76f8\u5173\u6587\u6863"));
        DocBak docBak = this.m_oDocBakMgr.getDocBak(document, n2);
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        return this.m_oRelationMgr.getRelations(docBak, wCMFilter);
    }

    public ContentExtendValues queryExtendFields(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("DocumentId", 0);
        int n2 = methodContext.getValue("Version", 0);
        String string = methodContext.getValue("SelectFields");
        Document document = Document.findById(n, string);
        DocBak docBak = this.m_oDocBakMgr.getDocBak(document, n2);
        Channel channel = document.getChannel();
        if (channel == null) {
            return new ContentExtendValues(user);
        }
        this.validateRight(user, (BaseChannel)channel, document, 34, I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label14", "\u83b7\u53d6\u6269\u5c55\u5b57\u6bb5"));
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        ContentExtFields contentExtFields = this.m_oExtFieldMgr.getExtFields(channel, wCMFilter, false);
        ContentExtendValues contentExtendValues = new ContentExtendValues(user, contentExtFields.size(), 1);
        int n3 = contentExtFields.size();
        for (int i = 0; i < n3; ++i) {
            ContentExtField contentExtField = (ContentExtField)contentExtFields.getAt(i);
            if (contentExtField == null) continue;
            String string2 = docBak.getPropertyAsString(contentExtField.getName());
            String string3 = CMyString.filterForHTMLValue(contentExtField.getAttributeValue("FIELDTYPE"));
            String[] stringArray = null;
            if (string2 != null && string3 != null && "678".indexOf(string3) != -1) {
                String string4 = CMyString.filterForHTMLValue(contentExtField.getAttributeValue("ENMVALUE"));
                if (CMyString.isEmpty(string4)) continue;
                stringArray = string4.split("~");
                String[] stringArray2 = string2.split(",");
                boolean bl = true;
                int n4 = stringArray.length;
                for (int j = 0; j < n4; ++j) {
                    String[] stringArray3 = this.pairSplit(stringArray[j]);
                    for (int k = 0; k < stringArray2.length; ++k) {
                        if (!stringArray2[k].trim().equalsIgnoreCase(stringArray3[1])) continue;
                        string2 = bl ? stringArray3[0] : string2 + "," + stringArray3[0];
                        bl = false;
                    }
                }
            }
            string2 = string2 + "~" + string3;
            contentExtendValues.addElement(i + 1, contentExtField.getDesc(), contentExtField.getName(), string2);
        }
        return contentExtendValues;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] pairSplit(String string) {
        String[] stringArray = new String[]{"", ""};
        if (string.indexOf("`") != -1) {
            String[] stringArray2 = string.split("`");
            if (stringArray2.length == 2) {
                stringArray[0] = stringArray2[0];
                stringArray[1] = stringArray2[1];
                return stringArray;
            } else {
                if (stringArray2.length != 1) return stringArray;
                stringArray[0] = stringArray[1] = stringArray2[0];
            }
            return stringArray;
        } else {
            stringArray[0] = string;
            stringArray[1] = string;
        }
        return stringArray;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void validateRight(User user, BaseChannel baseChannel, Documents documents, int n, String string) throws WCMException {
        int n2 = documents.size();
        for (int i = 0; i < n2; ++i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            this.validateRight(user, baseChannel, document, n, string);
        }
    }

    private void validateRight(User user, BaseChannel baseChannel, Document document, int n, String string) throws WCMException {
        if (!DocumentAuthServer.hasRight(user, baseChannel, document, n)) {
            throw new WCMException(CMyString.format(I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label20", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[{0}]\u6ca1\u6709\u6743\u9650{1}:{2}."), new Object[]{user.getName(), string, document}));
        }
    }
}

