/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IDepartmentMgr;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class DocumentAuthHelper {
    private static Logger logger = Logger.getLogger(DocumentAuthHelper.class);

    public static WCMFilter makeFilterWithRight(User user, BaseObjs baseObjs) throws WCMException {
        Object object;
        if (user.isAdministrator()) {
            return null;
        }
        WCMFilter wCMFilter = new WCMFilter();
        int n = 34;
        boolean bl = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("WITH_DEPT_FILTER", "false"));
        if (DBManager.getDBManager().getFieldInfo("WCMCHNLDOC", "CRDEPT") == null) {
            bl = false;
        }
        boolean bl2 = false;
        String string = null;
        if (bl) {
            object = (IDepartmentMgr)DreamFactory.createObjectById("IDepartmentMgr");
            string = object.getDepartmentInfo(user);
            bl2 = object.isDepartmentAdmin(user);
        }
        object = null;
        String string2 = null;
        if (!CMyString.isEmpty(string)) {
            string2 = "WCMChnlDoc.CrDept = ?";
            object = "WCMChnlDoc.CrDept like ?";
            if (bl2) {
                object = "(" + string2 + " or " + (String)object + ")";
            }
        }
        if (baseObjs.size() == 1) {
            BaseChannel baseChannel = (BaseChannel)baseObjs.getAt(0);
            if (!AuthServer.hasRight(user, (CMSObj)baseChannel, n)) {
                if (bl2) {
                    wCMFilter.setWhere("(WCMCHNLDOC.cruser=? or " + string2 + ")");
                    wCMFilter.addSearchValues(user.getName());
                    wCMFilter.addSearchValues(string);
                } else {
                    wCMFilter.setWhere("WCMCHNLDOC.cruser=?");
                    wCMFilter.addSearchValues(user.getName());
                }
            } else if (bl) {
                wCMFilter.setWhere((String)object);
                if (bl2) {
                    wCMFilter.addSearchValues(string);
                }
                wCMFilter.addSearchValues(string + "\\%");
            }
        } else if (baseObjs.size() > 1) {
            baseObjs.setMaxBufferSize(baseObjs.size());
            boolean bl3 = DocumentAuthHelper.hasRightOnAllChannels(user, baseObjs, n);
            boolean bl4 = DocumentAuthHelper.existsDoDeptFilterChannel(baseObjs);
            if (bl3 && !bl4) {
                return wCMFilter;
            }
            int n2 = DocumentAuthHelper.makeChannelFilterMode(baseObjs);
            if (bl3 && n2 != 2) {
                if (n2 == 1) {
                    wCMFilter.setWhere((String)object);
                    if (bl2) {
                        wCMFilter.addSearchValues(string);
                    }
                    wCMFilter.addSearchValues(string + "\\%");
                }
                return wCMFilter;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = baseObjs.size() - 1; i >= 0; --i) {
                BaseChannel baseChannel = (BaseChannel)baseObjs.getAt(i);
                if (baseChannel == null || baseChannel.isSite()) continue;
                Channel channel = (Channel)baseChannel;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" or ");
                }
                if (bl3 || AuthServer.hasRight(user, (CMSObj)baseChannel, n)) {
                    stringBuffer.append("(");
                    stringBuffer.append("WCMCHNLDOC.docchannel=?");
                    wCMFilter.addSearchValues(baseChannel.getId());
                    if (channel.isDoDeptFilter()) {
                        stringBuffer.append(" and ");
                        stringBuffer.append((String)object);
                        if (bl2) {
                            wCMFilter.addSearchValues(string);
                        }
                        wCMFilter.addSearchValues(string + "\\%");
                    }
                    stringBuffer.append(")");
                    continue;
                }
                stringBuffer.append("(");
                if (channel.isDoDeptFilter() && bl2) {
                    stringBuffer.append("(WCMCHNLDOC.docchannel=? and (WCMCHNLDOC.cruser=? or " + string2 + "))");
                } else {
                    stringBuffer.append("(WCMCHNLDOC.docchannel=? and WCMCHNLDOC.cruser=?)");
                }
                wCMFilter.addSearchValues(baseChannel.getId());
                wCMFilter.addSearchValues(user.getName());
                if (channel.isDoDeptFilter() && bl2) {
                    wCMFilter.addSearchValues(string);
                }
                stringBuffer.append(")");
            }
            if (stringBuffer.length() > 0) {
                wCMFilter.setWhere(stringBuffer.toString());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.error((Object)"who call me!", (Throwable)new Exception());
            logger.debug((Object)("Filter with auth of [" + user.getName() + "]\n" + wCMFilter));
        }
        return wCMFilter;
    }

    private static boolean hasRightOnAllChannels(User user, BaseObjs baseObjs, int n) throws WCMException {
        boolean bl = false;
        for (int i = baseObjs.size() - 1; i >= 0; --i) {
            BaseChannel baseChannel = (BaseChannel)baseObjs.getAt(i);
            if (baseChannel == null || baseChannel.isSite() || AuthServer.hasRight(user, (CMSObj)baseChannel, n)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static boolean existsDoDeptFilterChannel(BaseObjs baseObjs) {
        for (int i = baseObjs.size() - 1; i >= 0; --i) {
            Channel channel;
            BaseChannel baseChannel = (BaseChannel)baseObjs.getAt(i);
            if (baseChannel == null || baseChannel.isSite() || !(channel = (Channel)baseChannel).isDoDeptFilter()) continue;
            return true;
        }
        return false;
    }

    private static int makeChannelFilterMode(BaseObjs baseObjs) {
        int n = -1;
        for (int i = baseObjs.size() - 1; i >= 0; --i) {
            BaseChannel baseChannel = (BaseChannel)baseObjs.getAt(i);
            if (baseChannel == null || baseChannel.isSite()) continue;
            Channel channel = (Channel)baseChannel;
            if (channel.isDoDeptFilter()) {
                if (n == -1) {
                    n = 1;
                    continue;
                }
                return 2;
            }
            if (n == -1) {
                n = 0;
                continue;
            }
            return 2;
        }
        return n;
    }
}

