/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.distribute.PublishDistributionMgr;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.components.common.publish.persistent.distribute.PublishDistributions;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class DistributeServiceProvider
implements IGlueServiceProvider {
    private PublishDistributionMgr m_oPublishDistributionMgr = (PublishDistributionMgr)DreamFactory.createObjectById("PublishDistributionMgr");

    public void delete(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getObjectIds();
        PublishDistributions publishDistributions = PublishDistributions.findByIds(user, string);
        int n = publishDistributions.size();
        for (int i = 0; i < n; ++i) {
            PublishDistribution publishDistribution = (PublishDistribution)publishDistributions.getAt(i);
            if (publishDistribution == null) continue;
            if (!user.isAdministrator()) {
                this.validateRight(user, publishDistribution.getFolder().getSubstance(), I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label1", "\u5220\u9664\u5206\u53d1\u4fe1\u606f"));
            }
            this.m_oPublishDistributionMgr.delete(publishDistribution);
        }
    }

    public Object query(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        IPublishFolder iPublishFolder = this.findFolder(methodContext);
        this.validateRight(user, iPublishFolder.getSubstance(), I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label2", "\u83b7\u53d6"));
        boolean bl = methodContext.getValue("ExcludeDisabled", false);
        WCMFilter wCMFilter = new WCMFilter();
        int n = methodContext.getValue("FilterType", 0);
        switch (n) {
            case 1: {
                wCMFilter.setWhere("Enabled=?");
                wCMFilter.addSearchValues(0, 1);
                break;
            }
            case 2: {
                wCMFilter.setWhere("Enabled=?");
                wCMFilter.addSearchValues(0, 0);
            }
        }
        wCMFilter.mergeWith(methodContext.getExtraWCMFilter());
        return this.m_oPublishDistributionMgr.getDistributionsOf(iPublishFolder, bl, wCMFilter);
    }

    public int save(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        IPublishFolder iPublishFolder = null;
        PublishDistribution publishDistribution = null;
        int n = methodContext.getObjectId();
        if (n == 0) {
            iPublishFolder = this.findFolder(methodContext);
            this.validateRight(user, iPublishFolder.getSubstance(), I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label3", "\u4fdd\u5b58"));
            publishDistribution = PublishDistribution.createNewInstance();
            publishDistribution.setFolder(iPublishFolder);
        } else {
            publishDistribution = this.findById(n);
            iPublishFolder = publishDistribution.getFolder();
            this.validateRight(user, iPublishFolder.getSubstance(), I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label3", "\u4fdd\u5b58"));
            publishDistribution.validCanEditAndLock(user);
        }
        String[] stringArray = new String[]{"FolderType", "FolderId"};
        WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, publishDistribution, stringArray);
        this.m_oPublishDistributionMgr.save(publishDistribution);
        return publishDistribution.getId();
    }

    private PublishDistribution findById(int n) throws WCMException {
        PublishDistribution publishDistribution = PublishDistribution.findById(n);
        if (publishDistribution == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(955)}));
        }
        return publishDistribution;
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        IPublishFolder iPublishFolder = null;
        PublishDistribution publishDistribution = null;
        if (methodContext.getObjectId() == 0) {
            iPublishFolder = this.findFolder(methodContext);
            this.validateRight(user, iPublishFolder.getSubstance(), I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label5", "\u67e5\u770b\u5177\u4f53\u7684\u5206\u53d1\u4fe1\u606f"));
            publishDistribution = new PublishDistribution();
            publishDistribution.setFolder(iPublishFolder);
        } else {
            publishDistribution = this.findById(methodContext.getObjectId());
            iPublishFolder = publishDistribution.getFolder();
            this.validateRight(user, iPublishFolder.getSubstance(), I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label5", "\u67e5\u770b\u5177\u4f53\u7684\u5206\u53d1\u4fe1\u606f"));
        }
        return publishDistribution;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        PublishDistributions publishDistributions = PublishDistributions.findByIds(user, methodContext.getObjectIds());
        if (user.isAdministrator()) {
            return publishDistributions;
        }
        int n = publishDistributions.size();
        for (int i = 0; i < n; ++i) {
            PublishDistribution publishDistribution = (PublishDistribution)publishDistributions.getAt(i);
            if (publishDistribution == null) continue;
            this.validateRight(user, publishDistribution.getFolder().getSubstance(), I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label5", "\u67e5\u770b\u5177\u4f53\u7684\u5206\u53d1\u4fe1\u606f"));
        }
        return publishDistributions;
    }

    public void updateStatus(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        PublishDistributions publishDistributions = PublishDistributions.findByIds(user, methodContext.getObjectIds());
        boolean bl = methodContext.getValue("Enable", false);
        this.updateStatus(publishDistributions, bl, user);
    }

    public void updateStatusAll(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        methodContext.setValue("PageSize", -1);
        PublishDistributions publishDistributions = (PublishDistributions)this.query(methodContext);
        boolean bl = methodContext.getValue("Enable", false);
        this.updateStatus(publishDistributions, bl, user);
    }

    private void updateStatus(PublishDistributions publishDistributions, boolean bl, User user) throws Throwable {
        int n = publishDistributions.size();
        for (int i = 0; i < n; ++i) {
            PublishDistribution publishDistribution = (PublishDistribution)publishDistributions.getAt(i);
            if (publishDistribution == null || publishDistribution.isEnabled() == bl) continue;
            if (!user.isAdministrator()) {
                this.validateRight(user, publishDistribution.getFolder().getSubstance(), I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label6", "\u66f4\u65b0\u5206\u53d1\u670d\u52a1\u72b6\u6001"));
            }
            publishDistribution.validCanEditAndLock(user);
            publishDistribution.setEnabled(bl);
            this.m_oPublishDistributionMgr.save(publishDistribution);
        }
    }

    public Object[] queryTargetTypes() throws Throwable {
        return PublishServerConfigMapper.getDistributionTargetTypes().values().toArray();
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void validateRight(User user, CMSObj cMSObj, String string) throws Throwable {
        int n = 0;
        switch (cMSObj.getWCMType()) {
            case 103: {
                n = 1;
                break;
            }
            case 101: {
                n = 13;
                break;
            }
        }
        if (!AuthServer.hasRight(user, cMSObj, n)) {
            throw new WCMException(I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label7", "\u60a8[") + user.getName() + I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label8", "]\u6ca1\u6709\u6743\u9650") + string + " " + cMSObj + I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label9", " \u7684\u5206\u53d1\u8bbe\u7f6e"));
        }
    }

    private IPublishFolder findFolder(MethodContext methodContext) throws WCMException {
        int n;
        int n2 = methodContext.getValue("FolderType", 0);
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.lookupElement(n2, n = methodContext.getValue("FolderId", 0));
        if (iPublishFolder == null) {
            throw new WCMException(I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label10", "\u6307\u5b9a\u7684\u680f\u76ee[Type=") + n2 + ", Id=" + n + I18NMessage.get(DistributeServiceProvider.class, "DistributeServiceProvider.label11", "]\u4e0d\u5b58\u5728\uff01"));
        }
        return iPublishFolder;
    }
}

