/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.exception.MailException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;

public class SMTPUtil {
    private static final Logger logger = Logger.getLogger(SMTPUtil.class);

    public static void sendMail(String smtpServer, String from, String to, String usr, String pwd, String subject, String msgBody) {
        Properties prop = new Properties();
        prop.put("mail.smtp.host", smtpServer);
        if (pwd != null && pwd.trim().length() > 0) {
            prop.put("mail.smtp.auth", "true");
        }
        Session session = Session.getInstance((Properties)prop, null);
        MimeMessage message = new MimeMessage(session);
        try {
            message.setHeader("Content-Transfer-Encoding", "base64");
            message.setFrom((Address)new InternetAddress(from));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
            message.setSubject(subject);
            message.setText(msgBody);
            if (pwd != null && pwd.trim().length() > 0) {
                Transport transport = session.getTransport("smtp");
                transport.connect(smtpServer, usr, pwd);
                transport.sendMessage((Message)message, message.getAllRecipients());
                transport.close();
            } else {
                Transport.send((Message)message);
            }
        }
        catch (Exception e) {
            logger.error((Object)("(smtpHost, props)=" + smtpServer + ", " + session.getProperties() + "; (from, to, usr, pwd)=" + from + ", " + to + ", " + usr + ", " + pwd), (Throwable)e);
            throw new MailException("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25!", e);
        }
    }

    public static boolean isValidEMailAddress(String email) {
        if (email == null) {
            return false;
        }
        if (email.indexOf(64) < 1) {
            return false;
        }
        try {
            new InternetAddress(email);
            return true;
        }
        catch (AddressException e) {
            return false;
        }
    }
}

