/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.dao;

import com.trs.dev4.jdk16.dao.Condition;
import com.trs.dev4.jdk16.dao.hb3.HqlGenerator;
import com.trs.dev4.jdk16.utils.ArrayUtil;
import com.trs.dev4.jdk16.utils.DigestUtil;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.common.util.StringHelper;

public class SearchFilter {
    public static final int DEFAULT_PAGE_NO = 0;
    public static final int DEFAULT_PAGE_SIZE = 20;
    public static final int MAX_PAGE_SIZE = 1000;
    private List<Condition> conditions = new ArrayList<Condition>();
    private int startPos = 0;
    private int maxResults = -1;
    private String orderBy;
    private String groupBy;
    private String defaultFields = "*";
    private boolean cacheable = false;
    private String defaultKeyword;

    SearchFilter(int pageNo, int pageSize) {
        this.setMaxResults(pageSize);
        this.setStartPos(pageSize * pageNo);
        this.setCacheable(true);
    }

    public int getTotalConditions() {
        return this.conditions.size();
    }

    public String getPropertyName(int index) {
        return this.getCondition(index).getField();
    }

    public Object getValue(int index) {
        return this.getCondition(index).getValue();
    }

    public Object getBetweenValue2(int index) {
        return this.getCondition(index).getValue2();
    }

    public String getRelationOp(int index) {
        return this.getCondition(index).getOp();
    }

    public void addEqCondition(String prop, Object value) {
        this.addCondition("=", prop, value);
    }

    public void addNotEqCondition(String prop, Object value) {
        this.addCondition("!=", prop, value);
    }

    public void addIsNullCondition(String prop) {
        this.addCondition("is null", prop, null);
    }

    public void addNotNullCondition(String prop) {
        this.addCondition("is not null", prop, null);
    }

    public void addInCondition(String prop, Object ... value) {
        if (value == null || value.length == 0) {
            return;
        }
        this.addCondition("in", prop, value);
    }

    public void addInCondition(String prop, int ... value) {
        if (value == null || value.length == 0) {
            return;
        }
        this.addCondition("in", prop, ArrayUtil.toIntegerArray(value));
    }

    public void addCondition(String op, String prop, Object value) {
        Condition condition = Condition.buildCondition(op, prop, value);
        this.addCondition(condition);
    }

    public void addGreaterThanEquals(String prop, Object value) {
        this.addCondition(">=", prop, value);
    }

    public void addGreaterThan(String prop, Object value) {
        this.addCondition(">", prop, value);
    }

    public void addLesserThan(String prop, Object value) {
        this.addCondition("<", prop, value);
    }

    public void addLesserThanEquals(String prop, Object value) {
        this.addCondition("<=", prop, value);
    }

    public void addLike(String prop, Object value) {
        this.addCondition("like", prop, value);
    }

    private void addCondition(Condition condition) {
        if (condition != null) {
            this.conditions.add(condition);
            condition.setBindName(String.valueOf(condition.getField()) + "_" + this.conditions.size());
        }
    }

    public void addBetweenCondition(String prop, Object value1, Object value2) {
        this.addCondition(Condition.buildBetweenCondition(prop, value1, value2));
    }

    public int getStartPos() {
        return this.startPos;
    }

    public void setStartPos(int startPos) {
        if (startPos > 0) {
            this.startPos = startPos;
        }
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public Condition getCondition(int index) {
        if (index < 0 || index >= this.conditions.size()) {
            throw new IndexOutOfBoundsException("index should in [0, " + this.conditions.size() + "), but it's " + index + "!");
        }
        return this.conditions.get(index);
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String buildWhere() {
        return new HqlGenerator(this).buildWhere();
    }

    public void setPageNo(int pageNo) {
        this.startPos = pageNo * 20;
    }

    public String toString() {
        StringBuilder strBuf = new StringBuilder();
        strBuf.append("{[where: ");
        strBuf.append(this.buildWhere()).append("]");
        if (this.getOrderBy() != null) {
            strBuf.append("[order:").append(this.getOrderBy()).append("]");
        }
        if (this.getGroupBy() != null) {
            strBuf.append("[group:").append(this.getGroupBy()).append("]");
        }
        strBuf.append("[parameters:");
        int totalConditions = this.getTotalConditions();
        int i = 0;
        while (i < totalConditions) {
            Condition condition = this.getCondition(i);
            strBuf.append(condition.getField()).append(' ');
            strBuf.append(condition.getOp()).append(' ');
            if (condition.needBindCollectionParam()) {
                strBuf.append("(").append(condition.getValue()).append(')');
            } else if (condition.isBetweenCondition()) {
                strBuf.append('(').append(condition.getValue());
                strBuf.append(" and ").append(condition.getValue2()).append(')');
            } else if (condition.needBindOneParam()) {
                strBuf.append(condition.getValue());
            }
            if (i < totalConditions - 1) {
                strBuf.append(";");
            }
            ++i;
        }
        strBuf.append("]}");
        return strBuf.toString();
    }

    public String getCacheKey() {
        StringBuilder strBuf = new StringBuilder();
        strBuf.append("[");
        int totalConditions = this.getTotalConditions();
        int i = 0;
        while (i < totalConditions) {
            Condition condition = this.getCondition(i);
            strBuf.append(this.getFieldAbbr(condition.getField()));
            if (condition.needBindCollectionParam()) {
                strBuf.append("(").append(condition.getValue()).append(')');
            } else if (condition.isBetweenCondition()) {
                strBuf.append('(').append(condition.getValue());
                strBuf.append("-").append(condition.getValue2()).append(')');
            } else if (condition.needBindOneParam()) {
                strBuf.append(condition.getValue());
            }
            strBuf.append('_');
            ++i;
        }
        if (this.getOrderBy() != null) {
            strBuf.append(StringHelper.replace((String)this.getOrderBy(), (String)" ", (String)"-")).append("_");
        }
        if (this.getGroupBy() != null) {
            strBuf.append(this.getGroupBy());
        }
        strBuf.append("_sp").append(this.startPos).append("_ps").append(this.maxResults);
        strBuf.append("]");
        return DigestUtil.md5Hex(strBuf.toString());
    }

    protected String getFieldAbbr(String field) {
        if ("createdTime".equals(field)) {
            return "ct";
        }
        if ("createdUserId".equals(field)) {
            return "cui";
        }
        if ("lastModifiedTime".equals(field)) {
            return "lmt";
        }
        if ("receivedTime".equals(field)) {
            return "rt";
        }
        return field;
    }

    public static SearchFilter getDefault() {
        return new SearchFilter(0, 20);
    }

    public static SearchFilter getNoPagedFilter() {
        return new SearchFilter(0, 1000);
    }

    public static SearchFilter getSearchFilter(int pageNo, int pageSize) {
        return new SearchFilter(pageNo, pageSize);
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public String getDefaultFields() {
        return this.defaultFields;
    }

    public void addDefaultFields(String defaultFields) {
        this.defaultFields = defaultFields;
    }

    public String getDefaultKeyword() {
        return this.defaultKeyword;
    }

    public void setDefaultKeyword(String defaultKeyword) {
        this.defaultKeyword = defaultKeyword;
    }

    public boolean isCacheable() {
        if (!this.cacheable) {
            return false;
        }
        int totalConditions = this.getTotalConditions();
        int i = 0;
        while (i < totalConditions) {
            Condition condition = this.getCondition(i);
            if (condition.needBindCollectionParam()) {
                return false;
            }
            ++i;
        }
        return this.cacheable;
    }
}

