/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.job;

import com.trs.dev4.jdk16.job.EJobDetailStatus;
import com.trs.dev4.jdk16.job.EJobDetailType;
import com.trs.dev4.jdk16.job.EJobDetailUnit;
import com.trs.dev4.jdk16.model.BaseEntity;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="`JOBDETAILS`")
@SequenceGenerator(name="SEQ_JOBDETAIL", sequenceName="SEQ_JOBDETAIL")
@GenericGenerator(name="idStrategy", strategy="native", parameters={@Parameter(name="sequence", value="SEQ_JOBDETAIL")})
public class JobDetail
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @Column(name="`JOBNAME`", nullable=false, length=20)
    private String jobName;
    @Column(name="`UPDATEDTIME`")
    private long updatedTime;
    @Column(name="`EXECUTORNODE`", length=100)
    private String executorNode;
    @Column(name="`EXECUTORNAME`", length=100)
    private String executorName;
    @Column(name="`PERIOD`")
    private int period;
    @Column(name="`PERIODUNIT`", length=100)
    @Enumerated(value=EnumType.STRING)
    private EJobDetailUnit periodUnit;
    @Column(name="`DELAYUNIT`", length=100)
    @Enumerated(value=EnumType.STRING)
    private EJobDetailUnit delayUnit;
    @Column(name="`DELAY`")
    private int delay;
    @Column(name="`STATUS`")
    @Enumerated(value=EnumType.STRING)
    private EJobDetailStatus status;
    @Column(name="`CRON`")
    private String cron;
    @Column(name="`TYPE`")
    @Enumerated(value=EnumType.STRING)
    private EJobDetailType type;
    @Column(name="`PARAMETERS`", length=1000)
    private String parameters;

    public String getJobName() {
        return this.jobName;
    }

    public String getExecutorName() {
        return this.executorName;
    }

    public String getParameters() {
        return this.parameters;
    }

    public int getPeriodAsSecond() {
        return this.period;
    }

    public int getDelayAsSecond() {
        return this.delay;
    }

    public int getStatus() {
        return this.status.ordinal();
    }

    public String getExecutorNode() {
        return this.executorNode;
    }

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public EJobDetailType getType() {
        return this.type;
    }

    public void setType(EJobDetailType type) {
        this.type = type;
    }

    public Map<String, String> getParametersAsMap() {
        return StringHelper.isEmpty(this.parameters) ? null : StringHelper.parseAsMap(this.parameters);
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setExecutorNode(String executorNode) {
        this.executorNode = executorNode;
    }

    public void setExecutorName(String executorName) {
        this.executorName = executorName;
    }

    public void setStatus(EJobDetailStatus status) {
        this.status = status;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public EJobDetailUnit getPeriodUnit() {
        return this.periodUnit;
    }

    public void setPeriodUnit(EJobDetailUnit periodUnit) {
        this.periodUnit = periodUnit;
    }

    public EJobDetailUnit getDelayUnit() {
        return this.delayUnit;
    }

    public void setDelayUnit(EJobDetailUnit delayUnit) {
        this.delayUnit = delayUnit;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof JobDetail) {
            JobDetail objDetail = (JobDetail)obj;
            return objDetail.updatedTime == this.updatedTime;
        }
        return false;
    }

    public long getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(long updatedTime) {
        this.updatedTime = updatedTime;
    }
}

