/*
 * Decompiled with CFR 0.152.
 */
package com.trs.gateway.client.impl;

import com.trs.cis4.gateway.bean.AgentConfig;
import com.trs.cis4.gateway.bean.DbParams;
import com.trs.cis4.gateway.bean.FieldData;
import com.trs.cis4.gateway.bean.MachineData;
import com.trs.cis4.gateway.bean.RdbConfig;
import com.trs.cis4.gateway.bean.RunConfig;
import com.trs.cis4.gateway.bean.TaskStatus;
import com.trs.cis4.gateway.bean.TrsConfig;
import com.trs.cis4.gateway.dao.IRobotDAO;
import com.trs.cis4.gateway.dao.impl.RobotDAOImpl;
import com.trs.cis4.gateway.logic.impl.BaseConfigLogicImpl;
import com.trs.cis4.socket.config.RobotConfig;
import com.trs.cis4.util.ExceptionUtil;
import com.trs.cis4.util.GenerateUtil;
import com.trs.gateway.client.GWConnection;
import com.trs.gateway.client.GWException;
import com.trs.gateway.client.GWMetaData;
import com.trs.gateway.client.GWTaskStatus;
import com.trs.gateway.client.common.GWDbURLParams;
import com.trs.gateway.client.impl.GWMetaDataImpl;
import com.trs.gateway.client.impl.GWTaskStatusImpl;
import com.trs.gateway.client.util.GWStringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWConnectionImpl
implements GWConnection {
    private BaseConfigLogicImpl baseConfigLogic;
    private IRobotDAO robotDAO;
    private RobotConfig robotConfig;
    private String host;
    private String port;
    private String username;
    private String password;

    public GWConnectionImpl() {
        this.baseConfigLogic = new BaseConfigLogicImpl();
        this.robotDAO = new RobotDAOImpl();
        this.robotConfig = new RobotConfig();
        this.robotConfig.setRobotid(String.valueOf(GenerateUtil.generate32()));
        this.robotConfig.setRobothost("127.0.0.1");
        this.robotConfig.setRobotport(8004);
        this.robotConfig.setCharset("GBK");
        this.robotConfig.setRobotvalue(4000);
        this.robotConfig.setMachineCode("12345678");
        this.baseConfigLogic.setRobotDAO(this.robotDAO);
        this.baseConfigLogic.setRobotConfig(this.robotConfig);
    }

    public GWConnectionImpl(String host, String port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.robotConfig = new RobotConfig();
        this.robotConfig.setRobothost(host);
        this.robotConfig.setRobotport(Integer.parseInt(port));
        this.robotConfig.setRobotid(String.valueOf(GenerateUtil.generate32()));
        this.robotConfig.setCharset("GBK");
        this.robotConfig.setRobotvalue(4000);
        this.robotConfig.setMachineCode(password);
        this.robotDAO = new RobotDAOImpl();
        this.baseConfigLogic = new BaseConfigLogicImpl();
        this.baseConfigLogic.setRobotDAO(this.robotDAO);
        this.baseConfigLogic.setRobotConfig(this.robotConfig);
    }

    @Override
    public GWMetaData getMetaData() throws GWException {
        try {
            String serverVersion = "";
            serverVersion = this.baseConfigLogic.getServerVersion();
            if (!GWStringUtil.isEmpty(serverVersion)) {
                GWMetaDataImpl gwMeta = new GWMetaDataImpl();
                gwMeta.setServerVersion(serverVersion);
                String versionInfo = serverVersion.substring(serverVersion.indexOf("TRS Gateway") + "TRS Gateway".length(), serverVersion.indexOf("Build"));
                versionInfo = versionInfo.trim();
                String[] versions = versionInfo.split("\\.");
                if (versions.length >= 2) {
                    int serverMajorVersion = Integer.parseInt(versions[0]);
                    int serverMinorVersion = Integer.parseInt(versions[1]);
                    gwMeta.setServerMajorVersion(serverMajorVersion);
                    gwMeta.setServerMinorVersion(serverMinorVersion);
                }
                return gwMeta;
            }
            throw new GWException("\u83b7\u53d6\u7f51\u5173\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25");
        }
        catch (ExceptionUtil e) {
            throw new GWException("\u83b7\u53d6\u7f51\u5173\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25", (Exception)((Object)e));
        }
        catch (Exception e1) {
            throw new GWException("\u83b7\u53d6\u7f51\u5173\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25", e1);
        }
    }

    @Override
    public String createTask(Properties properties, Map<String, String> fieldsMap) throws GWException {
        String taskname = "";
        String taskName_inc = "";
        try {
            AgentConfig agentConfig = this.getAgentConfigFromProperties(properties, fieldsMap);
            if (agentConfig != null) {
                taskname = agentConfig.getTask_name();
                boolean addSuccess = false;
                addSuccess = this.baseConfigLogic.add(agentConfig);
                Thread.sleep(1000L);
                if (addSuccess) {
                    taskName_inc = agentConfig.getTask_name();
                    taskName_inc = String.valueOf(taskName_inc) + "_INC";
                    agentConfig.getRdbConfig().setRdb_policy(1);
                    agentConfig.getRdbConfig().setRdb_temp(taskName_inc);
                    agentConfig.getRdbConfig().setRdb_all_type(0);
                    agentConfig.setTask_name(taskName_inc);
                    addSuccess = this.baseConfigLogic.add(agentConfig);
                    if (addSuccess) {
                        return taskName_inc;
                    }
                    this.rollbackCreateTask(taskname);
                    throw new GWException("\u521b\u5efa\u589e\u91cf\u4efb\u52a1\u5931\u8d25");
                }
                throw new GWException("\u521b\u5efa\u4efb\u52a1\u5931\u8d25");
            }
            throw new GWException("\u4efb\u52a1\u53c2\u6570\u83b7\u53d6\u5931\u8d25");
        }
        catch (ExceptionUtil e) {
            this.rollbackCreateTask(taskname);
            throw new GWException("\u521b\u5efa\u4efb\u52a1\u5931\u8d25", (Exception)((Object)e));
        }
        catch (InterruptedException e) {
            this.rollbackCreateTask(taskname);
            throw new GWException("\u521b\u5efa\u4efb\u52a1\u5931\u8d25", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteTask(String taskName) throws GWException {
        if (GWStringUtil.isEmpty(taskName)) return;
        try {
            AgentConfig agentInc = this.baseConfigLogic.get(taskName);
            if (agentInc == null) throw new GWException("\u4efb\u52a1[" + taskName + "]\u5220\u9664\u5931\u8d25," + "\u627e\u4e0d\u5230\u8be5\u4efb\u52a1");
            if (agentInc.getRdbConfig().getRdb_policy() == 1) {
                String taskname_all = agentInc.getTask_name();
                AgentConfig agentAll = this.baseConfigLogic.get(taskname_all = taskname_all.substring(0, taskname_all.lastIndexOf("_INC")));
                if (!this.checkIsRelatedTask(agentAll, agentInc)) throw new GWException("\u4efb\u52a1[" + taskName + "]\u5220\u9664\u5931\u8d25," + "\u627e\u4e0d\u5230\u76f8\u5173\u7684\u5168\u91cf\u4efb\u52a1" + taskname_all);
                if (!this.baseConfigLogic.delete(taskName)) throw new GWException("\u4efb\u52a1[" + taskName + "]\u5220\u9664\u5931\u8d25");
                this.baseConfigLogic.delete(taskname_all);
                return;
            } else {
                this.baseConfigLogic.delete(taskName);
            }
            return;
        }
        catch (ExceptionUtil e) {
            throw new GWException("\u4efb\u52a1[" + taskName + "]\u5220\u9664\u5931\u8d25", (Exception)((Object)e));
        }
    }

    @Override
    public String[] getTaskNames() throws GWException {
        try {
            List agentconfigs = this.baseConfigLogic.gets();
            ArrayList<String> taskList = new ArrayList<String>();
            for (AgentConfig agentconfig : agentconfigs) {
                taskList.add(agentconfig.getTask_name());
            }
            return taskList.toArray(new String[taskList.size()]);
        }
        catch (ExceptionUtil e) {
            throw new GWException("\u83b7\u53d6\u4efb\u52a1\u5217\u8868\u5931\u8d25", (Exception)((Object)e));
        }
    }

    @Override
    public GWTaskStatus getTaskStatus(String taskName) throws GWException {
        try {
            List taskStatusList = this.baseConfigLogic.getTaskStatus();
            GWTaskStatusImpl gwTaskStaus = new GWTaskStatusImpl();
            for (TaskStatus ts : taskStatusList) {
                if (!ts.getTask_name().equals(taskName)) continue;
                gwTaskStaus.setTaskName(taskName);
                AgentConfig agentConfig = this.baseConfigLogic.get(taskName);
                int status = ts.getStatus();
                gwTaskStaus.setRunStatus(status);
                int run_policy = agentConfig.getRunConfig().getRun_policy();
                if (run_policy >= 1) {
                    gwTaskStaus.setScheduled(true);
                }
                gwTaskStaus.setNext_runtime(ts.getNext_runtime());
                gwTaskStaus.setRun_time(ts.getRun_time());
                return gwTaskStaus;
            }
        }
        catch (ExceptionUtil e) {
            throw new GWException("\u83b7\u53d6\u4efb\u52a1\u72b6\u6001\u5931\u8d25", (Exception)((Object)e));
        }
        return null;
    }

    public void testConnection() throws GWException {
        try {
            String rMac;
            String robotHost;
            List agentConfigList = this.baseConfigLogic.gets();
            if (!(agentConfigList != null && agentConfigList.size() != 0 || (robotHost = this.robotConfig.getRobothost()).equals("127.0.0.1") || robotHost.toLowerCase().equals("localhost") || (rMac = this.robotDAO.getMachineCode()).equalsIgnoreCase(this.robotConfig.getMachineCode()))) {
                throw new GWException("\u8fdc\u7a0b\u670d\u52a1\u5668\u5730\u5740(" + robotHost + ")\u9a8c\u8bc1\u7801\u9519\u8bef!");
            }
        }
        catch (ExceptionUtil e) {
            throw new GWException("\u8fde\u63a5\u7f51\u5173\u670d\u52a1\u5668\u5931\u8d25", (Exception)((Object)e));
        }
    }

    private AgentConfig getAgentConfigFromProperties(Properties taskProperties, Map<String, String> fieldsMap) throws GWException {
        String charset;
        String trs_host = taskProperties.getProperty("property_trs_host");
        if (GWStringUtil.isEmpty(trs_host)) {
            throw new GWException("\u63a5\u6536TRSServer\u5730\u5740\u53c2\u6570\u5b58\u5728\u7a7a\u503c[property_trs_host]");
        }
        String trs_port = taskProperties.getProperty("property_trs_port");
        if (GWStringUtil.isEmpty(trs_port)) {
            throw new GWException("\u63a5\u6536TRSServer\u7aef\u53e3\u53c2\u6570\u5b58\u5728\u7a7a\u503c[property_trs_port]");
        }
        String trs_username = taskProperties.getProperty("property_trs_username");
        if (GWStringUtil.isEmpty(trs_username)) {
            throw new GWException("\u63a5\u6536TRSServer\u7528\u6237\u540d\u53c2\u6570\u5b58\u5728\u7a7a\u503c[property_trs_username]");
        }
        String trs_password = taskProperties.getProperty("property_trs_password");
        if (GWStringUtil.isEmpty(trs_password)) {
            throw new GWException("\u63a5\u6536TRSServer\u5bc6\u7801\u53c2\u6570\u5b58\u5728\u7a7a\u503c[property_trs_password]");
        }
        String trs_database = taskProperties.getProperty("property_trs_database");
        if (GWStringUtil.isEmpty(trs_database)) {
            throw new GWException("\u63a5\u6536TRSServer\u6570\u636e\u540d\u79f0\u53c2\u6570\u5b58\u5728\u7a7a\u503c[property_trs_database]");
        }
        if (!trs_database.startsWith(String.valueOf(trs_username) + ".")) {
            trs_database = String.valueOf(trs_username) + "." + trs_database;
        }
        AgentConfig agentConfig = new AgentConfig();
        RdbConfig rdbConfig = new RdbConfig();
        MachineData virtual_view = new MachineData();
        RunConfig runConfig = new RunConfig();
        TrsConfig trsConfig = new TrsConfig();
        ArrayList<MachineData> machine_list = new ArrayList<MachineData>();
        String createtime = this.buildCreatetime();
        agentConfig.setCreate_time(Long.parseLong(createtime));
        String productName = taskProperties.getProperty("property_product_name");
        String taskname = this.buildTaskName(productName, trs_database, createtime);
        agentConfig.setTask_name(taskname);
        virtual_view.setMachine_no(0);
        virtual_view.setTrs_server(trs_host);
        virtual_view.setTrs_port(trs_port);
        virtual_view.setTrs_username(trs_username);
        virtual_view.setTrs_password(trs_password);
        virtual_view.setTrs_database(trs_database);
        virtual_view.setMachine_view(0);
        virtual_view.setGroup_name("0,0");
        machine_list.add(virtual_view);
        agentConfig.setVirtual_view(virtual_view);
        agentConfig.setMachine_list(machine_list);
        String trscharset = taskProperties.getProperty("property_rdb_client_charset");
        if (!GWStringUtil.isEmpty(trscharset)) {
            if (trscharset.startsWith("GB")) {
                trsConfig.setTrs_charset(0);
            } else if (trscharset.startsWith("UTF-8")) {
                trsConfig.setTrs_charset(1);
            } else {
                trsConfig.setTrs_charset(0);
            }
        } else {
            trsConfig.setTrs_charset(0);
        }
        trsConfig.setTrs_prefix(taskProperties.getProperty("property_trs_prefix"));
        trsConfig.setTrs_ctrl(taskProperties.getProperty("property_trs_control"));
        trsConfig.setTrs_policy(1);
        trsConfig.setTrs_batch(5000);
        String gw_workPath = this.getGWWorkPath();
        trsConfig.setTrs_directory(String.valueOf(gw_workPath) + File.separatorChar + "temp");
        agentConfig.setTrsConfig(trsConfig);
        String rdb_url = taskProperties.getProperty("property_rdb_url");
        if (GWStringUtil.isEmpty(rdb_url)) {
            throw new GWException("\u63a5\u6536\u5173\u7cfb\u5e93URL\u53c2\u6570\u5b58\u5728\u7a7a\u503c[property_rdb_url]");
        }
        int rbd_type = this.checkRbdTypeFromURL(rdb_url);
        if (rbd_type < 1) {
            throw new GWException("\u65e0\u6cd5\u8bc6\u522b\u5173\u7cfb\u5e93URL\u683c\u5f0f\uff1a" + rdb_url);
        }
        rdbConfig.setRdb_type(rbd_type);
        rdbConfig.setRdb_temp(taskname);
        GWDbURLParams gwRdbparame = this.getRdbServer(rbd_type, rdb_url);
        if (gwRdbparame == null) {
            return null;
        }
        if (rbd_type == 2) {
            String oraSrvName = String.valueOf(gwRdbparame.getHost()) + ":" + gwRdbparame.getPort() + "/" + gwRdbparame.getDatabase();
            rdbConfig.setRdb_server(oraSrvName);
        } else {
            rdbConfig.setRdb_server(gwRdbparame.getHost());
        }
        String rdb_username = taskProperties.getProperty("property_rdb_username");
        if (GWStringUtil.isEmpty(rdb_username)) {
            throw new GWException("\u63a5\u6536\u5173\u7cfb\u5e93\u7528\u6237\u540d\u53c2\u6570\u5b58\u5728\u7a7a\u503c[property_rdb_username]");
        }
        String rbd_password = taskProperties.getProperty("property_rdb_password");
        if (GWStringUtil.isEmpty(rbd_password)) {
            throw new GWException("\u63a5\u6536\u5173\u7cfb\u5e93\u5bc6\u7801\u53c2\u6570\u5b58\u5728\u7a7a\u503c[property_rdb_password]");
        }
        rdbConfig.setRdb_username(rdb_username);
        rdbConfig.setRdb_password(rbd_password);
        if (!GWStringUtil.isEmpty(gwRdbparame.getDatabase())) {
            rdbConfig.setRdb_database(gwRdbparame.getDatabase());
        } else {
            rdbConfig.setRdb_database(taskProperties.getProperty("property_rdb_dbname"));
        }
        if (GWStringUtil.isEmpty(rdbConfig.getRdb_database())) {
            throw new GWException("\u63a5\u6536\u5173\u7cfb\u5e93\u6570\u636e\u5e93\u540d\u79f0\u53c2\u6570\u5b58\u5728\u7a7a\u503c");
        }
        String schemaName = taskProperties.getProperty("property_rdb_schema");
        String tableName = taskProperties.getProperty("property_rdb_tablename");
        rdbConfig.setRdb_table(tableName);
        String rdb_pk = taskProperties.getProperty("property_rdb_primarykey");
        String viewName = taskProperties.getProperty("property_rdb_viewname");
        String rdb_view_pk = taskProperties.getProperty("property_rdb_view_primarykey");
        if (GWStringUtil.isEmpty(tableName) && GWStringUtil.isEmpty(viewName)) {
            throw new GWException("\u63a5\u6536\u5173\u7cfb\u5e93\u4e3b\u8868\u6216\u89c6\u56fe\u53c2\u6570\u5b58\u5728\u7a7a\u503c[property_rdb_tablename]or[property_rdb_viewname]");
        }
        if (GWStringUtil.isEmpty(rdb_pk) && GWStringUtil.isEmpty(rdb_view_pk)) {
            throw new GWException("\u63a5\u6536\u5173\u7cfb\u5e93\u8868\u6216\u89c6\u56fe\u4e3b\u952e\u53c2\u6570\u5b58\u5728\u7a7a\u503c[property_rdb_primarykey]or[property_rdb_view_primarykey]");
        }
        if (!GWStringUtil.isEmpty(viewName)) {
            rdbConfig.setRdb_view(true);
            rdbConfig.setRdb_vname(viewName);
            agentConfig.setNode_sync_field(rdb_view_pk);
            if (GWStringUtil.isEmpty(tableName)) {
                throw new GWException("\u63a5\u6536\u5173\u7cfb\u5e93\u4e3b\u8868\u53c2\u6570\u5b58\u5728\u7a7a\u503c[property_rdb_tablename]");
            }
            if (GWStringUtil.isEmpty(rdb_pk)) {
                throw new GWException("\u63a5\u6536\u5173\u7cfb\u5e93\u4e3b\u8868\u4e3b\u952e\u53c2\u6570\u5b58\u5728\u7a7a\u503c[property_rdb_primarykey]");
            }
        } else {
            rdbConfig.setRdb_view(false);
            if (GWStringUtil.isEmpty(rdb_pk)) {
                throw new GWException("\u63a5\u6536\u5173\u7cfb\u5e93\u4e3b\u8868\u4e3b\u952e\u53c2\u6570\u5b58\u5728\u7a7a\u503c[property_rdb_primarykey]");
            }
            agentConfig.setNode_sync_field(rdb_pk);
        }
        if (rbd_type == 1) {
            String last;
            String model;
            int len;
            if (!GWStringUtil.isEmpty(viewName)) {
                if (viewName.indexOf(".") <= 0) {
                    if (GWStringUtil.isEmpty(schemaName)) {
                        schemaName = "dbo";
                    }
                    viewName = !viewName.startsWith("[") && !viewName.endsWith("]") ? "[" + schemaName + "].[" + viewName + "]" : "[" + schemaName + "]." + viewName;
                    rdbConfig.setRdb_vname(viewName);
                } else {
                    String[] viewModle = viewName.split("\\.");
                    len = viewModle.length;
                    if (len >= 2) {
                        model = viewModle[len - 2];
                        viewName = !model.startsWith("[") && !model.endsWith("]") ? "[" + model + "]." : String.valueOf(model) + ".";
                        last = viewModle[len - 1];
                        viewName = !last.startsWith("[") && !last.endsWith("]") ? String.valueOf(viewName) + "[" + last + "]" : String.valueOf(viewName) + last;
                        rdbConfig.setRdb_vname(viewName);
                    }
                }
            }
            if (!GWStringUtil.isEmpty(tableName)) {
                if (tableName.indexOf(".") <= 0) {
                    if (GWStringUtil.isEmpty(schemaName)) {
                        schemaName = "dbo";
                    }
                    tableName = !tableName.startsWith("[") && !tableName.endsWith("]") ? "[" + schemaName + "].[" + tableName + "]" : "[" + schemaName + "]." + tableName;
                    rdbConfig.setRdb_table(tableName);
                } else {
                    String[] tableModle = tableName.split("\\.");
                    len = tableModle.length;
                    if (len >= 2) {
                        model = tableModle[len - 2];
                        tableName = !model.startsWith("[") && !model.endsWith("]") ? "[" + model + "]." : String.valueOf(model) + ".";
                        last = tableModle[len - 1];
                        tableName = !last.startsWith("[") && !last.endsWith("]") ? String.valueOf(tableName) + "[" + last + "]" : String.valueOf(tableName) + last;
                        rdbConfig.setRdb_table(tableName);
                    }
                }
            }
        } else if (rbd_type == 2) {
            if (GWStringUtil.isEmpty(schemaName)) {
                schemaName = rdb_username;
            }
            if (!GWStringUtil.isEmpty(viewName)) {
                if (viewName.indexOf(".") <= 0) {
                    viewName = "\"" + schemaName.toUpperCase() + "\".\"" + viewName + "\"";
                }
                rdbConfig.setRdb_vname(viewName);
            }
            if (!GWStringUtil.isEmpty(tableName)) {
                if (tableName.indexOf(".") <= 0) {
                    tableName = "\"" + schemaName.toUpperCase() + "\".\"" + tableName + "\"";
                }
                rdbConfig.setRdb_table(tableName);
            }
        }
        String rbd_all_type = taskProperties.getProperty("property_rdb_all_type");
        int irdb_all_type = 2;
        if (GWStringUtil.isNumberic(rbd_all_type) && ((irdb_all_type = Integer.parseInt(rbd_all_type)) < 0 || irdb_all_type > 2)) {
            irdb_all_type = 2;
        }
        rdbConfig.setRdb_all_type(irdb_all_type);
        DbParams dbParams1 = new DbParams();
        dbParams1.setDbdatabase(rdbConfig.getRdb_database());
        dbParams1.setDbtype(rdbConfig.getRdb_type());
        dbParams1.setRdbClientCharset(rdbConfig.getRdb_client_charset());
        dbParams1.setDbuser(rdbConfig.getRdb_username());
        dbParams1.setDbpassword(rdbConfig.getRdb_password());
        dbParams1.setDbserver(rdbConfig.getRdb_server());
        boolean flag = false;
        if (!GWStringUtil.isEmpty(viewName)) {
            try {
                List views = this.baseConfigLogic.getView(dbParams1);
                for (String vname : views) {
                    if (!vname.equalsIgnoreCase(viewName)) continue;
                    rdbConfig.setRdb_vname(vname);
                    flag = true;
                    break;
                }
            }
            catch (ExceptionUtil e) {
                throw new GWException("\u83b7\u53d6\u5173\u7cfb\u5e93\u89c6\u56fe\u5931\u8d25", (Exception)((Object)e));
            }
            if (!flag) {
                throw new GWException("\u83b7\u53d6\u5173\u7cfb\u5e93\u89c6\u56fe\u4e0d\u5b58\u5728," + viewName);
            }
        }
        flag = false;
        if (!GWStringUtil.isEmpty(tableName)) {
            try {
                List table = this.baseConfigLogic.getTable(dbParams1);
                for (String tablename : table) {
                    if (!tablename.equalsIgnoreCase(tableName)) continue;
                    rdbConfig.setRdb_table(tablename);
                    flag = true;
                    break;
                }
            }
            catch (ExceptionUtil e) {
                throw new GWException("\u83b7\u53d6\u5173\u7cfb\u5e93\u8868\u5931\u8d25", (Exception)((Object)e));
            }
            if (!flag) {
                throw new GWException("\u83b7\u53d6\u5173\u7cfb\u5e93\u8868\u4e0d\u5b58\u5728," + tableName);
            }
        }
        if (!GWStringUtil.isEmpty(charset = taskProperties.getProperty("property_rdb_server_charset"))) {
            if (charset.startsWith("GB")) {
                rdbConfig.setRdb_charset(0);
            } else if (charset.startsWith("UTF-8")) {
                rdbConfig.setRdb_charset(1);
            } else {
                rdbConfig.setRdb_charset(0);
            }
        } else {
            rdbConfig.setRdb_charset(0);
        }
        String clientCharset = taskProperties.getProperty("property_rdb_client_charset");
        if (!GWStringUtil.isEmpty(clientCharset)) {
            rdbConfig.setRdb_client_charset(clientCharset);
        } else {
            rdbConfig.setRdb_client_charset("GB18030");
        }
        rdbConfig.setRdb_select(taskProperties.getProperty("property_rdb_where"));
        rdbConfig.setRdb_user_pk(true);
        rdbConfig.setRdb_policy(0);
        rdbConfig.setRdb_seg_thread(1);
        rdbConfig.setRdb_seg_record(5000);
        agentConfig.setRdbConfig(rdbConfig);
        runConfig.setRun_policy(0);
        agentConfig.setRunConfig(runConfig);
        RdbConfig rbdConfig2 = agentConfig.getRdbConfig();
        List<Object> field_list = new ArrayList();
        if (rbdConfig2 != null) {
            DbParams dbParams = new DbParams();
            dbParams.setDbdatabase(rbdConfig2.getRdb_database());
            dbParams.setDbtype(rbdConfig2.getRdb_type());
            dbParams.setRdbClientCharset(rbdConfig2.getRdb_client_charset());
            dbParams.setDbuser(rbdConfig2.getRdb_username());
            dbParams.setDbpassword(rbdConfig2.getRdb_password());
            dbParams.setDbserver(rbdConfig2.getRdb_server());
            dbParams.setView(rbdConfig2.getRdb_vname());
            dbParams.setTable(rbdConfig2.getRdb_table());
            field_list = fieldsMap == null || fieldsMap.size() <= 0 ? this.getFieldList(dbParams) : this.getFieldListFromFieldMap(dbParams, fieldsMap);
            field_list = this.processFieldList(field_list, rdb_pk, rdb_view_pk, rbdConfig2.isRdb_view());
            if (rbdConfig2.isRdb_view()) {
                this.checkTablePkFieldExsit(dbParams, rdb_pk);
            }
        }
        agentConfig.setField_list(field_list);
        return agentConfig;
    }

    private void checkTablePkFieldExsit(DbParams dbParams, String rdb_pk) throws GWException {
        boolean tflag = false;
        try {
            List fieldList = this.baseConfigLogic.getTableColumn(dbParams);
            for (FieldData field : fieldList) {
                if (!field.getField_name().equalsIgnoreCase(rdb_pk)) continue;
                tflag = true;
                return;
            }
            if (!tflag) {
                throw new GWException("\u4e3b\u8868\u4e3b\u952e\u5b57\u6bb5\u4e0d\u5b58\u5728," + rdb_pk);
            }
        }
        catch (ExceptionUtil e) {
            throw new GWException("\u83b7\u53d6\u6570\u636e\u5e93\u5b57\u6bb5\u5931\u8d25,", (Exception)((Object)e));
        }
    }

    private String buildCreatetime() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    private String buildTaskName(String seed) {
        if (GWStringUtil.isEmpty(this.username)) {
            this.username = "system";
        }
        String taskname = "gw_" + this.username + "_" + seed;
        return taskname;
    }

    private String cutUsernameFormDatabase(String targetDatabase) {
        if (targetDatabase == null) {
            return null;
        }
        int index = targetDatabase.indexOf(46);
        if (index <= 0) {
            return targetDatabase;
        }
        return targetDatabase.substring(index + 1);
    }

    private String buildTaskName(String tag, String targetDatabase, String seed) throws GWException {
        if (GWStringUtil.isEmpty(tag)) {
            return this.buildTaskName(seed);
        }
        if (GWStringUtil.isEmpty(targetDatabase = this.cutUsernameFormDatabase(targetDatabase))) {
            targetDatabase = this.username;
        }
        if (GWStringUtil.isEmpty(targetDatabase)) {
            targetDatabase = "system";
        }
        int index = 0;
        String taskname = String.valueOf(tag) + "_" + targetDatabase + "_" + ++index;
        while (this.getTaskStatus(taskname) != null || this.getTaskStatus(String.valueOf(taskname) + "_INC") != null) {
            taskname = String.valueOf(tag) + "_" + targetDatabase + "_" + ++index;
        }
        return taskname;
    }

    private int checkRbdTypeFromURL(String url) {
        if (!GWStringUtil.isEmpty(url)) {
            if (url.startsWith("jdbc:microsoft:sqlserver") || url.startsWith("jdbc:jtds:sqlserver") || url.startsWith("jdbc:sqlserver")) {
                return 1;
            }
            if (url.startsWith("jdbc:oracle")) {
                return 2;
            }
            if (url.startsWith("jdbc:db2")) {
                return 3;
            }
            if (url.startsWith("jdbc:sybase")) {
                return 4;
            }
            if (url.startsWith("jdbc:mysql")) {
                return 5;
            }
        }
        return -1;
    }

    public GWDbURLParams getGWDbURLParamsFromURL(String url) throws GWException {
        int type = this.checkRbdTypeFromURL(url);
        return this.getRdbServer(type, url);
    }

    private GWDbURLParams getRdbServer(int type, String url) throws GWException {
        GWDbURLParams gwRdbParame = new GWDbURLParams();
        gwRdbParame.setType(type);
        int index = -1;
        try {
            switch (type) {
                case 1: {
                    if (url.startsWith("jdbc:microsoft:sqlserver") || url.startsWith("jdbc:sqlserver")) {
                        String[] params;
                        String temp = url.substring(url.indexOf("//") + 2, url.lastIndexOf(":"));
                        gwRdbParame.setHost(temp);
                        temp = url.substring(url.lastIndexOf(":") + 1, url.indexOf(";"));
                        gwRdbParame.setPort(temp);
                        index = url.indexOf("DatabaseName=");
                        if (index <= 0) break;
                        String[] stringArray = params = url.split(";");
                        int n = params.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String param = stringArray[n2];
                            if (param.startsWith("DatabaseName=")) {
                                temp = param.substring(param.indexOf("DatabaseName=") + "DatabaseName=".length(), param.length());
                                break;
                            }
                            ++n2;
                        }
                        gwRdbParame.setDatabase(temp);
                        break;
                    }
                    if (!url.startsWith("jdbc:jtds:sqlserver")) break;
                    String temp = url.substring(url.indexOf("//") + 2, url.lastIndexOf(":"));
                    gwRdbParame.setHost(temp);
                    temp = url.substring(url.lastIndexOf(":") + 1, url.lastIndexOf("/"));
                    gwRdbParame.setPort(temp);
                    index = url.indexOf(";");
                    temp = index > 0 ? url.substring(url.lastIndexOf("/") + 1, url.indexOf(";")) : url.substring(url.lastIndexOf("/") + 1, url.length());
                    gwRdbParame.setDatabase(temp);
                    break;
                }
                case 2: {
                    String temp = url.substring(url.indexOf("@") + 1, url.length());
                    temp = temp.substring(0, temp.indexOf(":"));
                    gwRdbParame.setHost(temp);
                    temp = url.substring(url.indexOf("@") + 1, url.length());
                    temp = temp.substring(temp.indexOf(":") + 1, temp.lastIndexOf(":"));
                    gwRdbParame.setPort(temp);
                    temp = url.substring(url.lastIndexOf(":") + 1, url.length());
                    gwRdbParame.setDatabase(temp);
                    break;
                }
                case 3: {
                    String temp = url.substring(url.indexOf("//") + 2, url.lastIndexOf(":"));
                    gwRdbParame.setHost(temp);
                    temp = url.substring(url.lastIndexOf(":") + 1, url.lastIndexOf("/"));
                    gwRdbParame.setPort(temp);
                    temp = url.substring(url.lastIndexOf("/") + 1, url.length());
                    gwRdbParame.setDatabase(temp);
                    break;
                }
                case 4: {
                    String temp = url.substring(url.indexOf("jdbc:sybase:Tds:") + "jdbc:sybase:Tds:".length(), url.lastIndexOf(":"));
                    gwRdbParame.setHost(temp);
                    int i = url.lastIndexOf("/");
                    temp = url.substring(url.lastIndexOf(":") + 1, i > 0 ? url.lastIndexOf("/") : url.length());
                    gwRdbParame.setPort(temp);
                    if (i <= 0) break;
                    temp = url.substring(url.lastIndexOf("/") + 1, url.length());
                    gwRdbParame.setPort(temp);
                    break;
                }
                case 5: {
                    String temp = url.substring(url.indexOf("//") + 2, url.lastIndexOf(":"));
                    gwRdbParame.setHost(temp);
                    temp = url.substring(url.lastIndexOf(":") + 1, url.lastIndexOf("/"));
                    gwRdbParame.setPort(temp);
                    temp = url.substring(url.lastIndexOf("/") + 1, url.length());
                    gwRdbParame.setDatabase(temp);
                    break;
                }
                default: {
                    throw new GWException("\u6570\u636e\u5e93URL\u683c\u5f0f\u975e\u6cd5," + url);
                }
            }
            return gwRdbParame;
        }
        catch (Exception e) {
            throw new GWException("\u6570\u636e\u5e93URL\u683c\u5f0f\u975e\u6cd5," + url, e);
        }
    }

    private String getGWWorkPath() throws GWException {
        try {
            return this.baseConfigLogic.getWorkPath();
        }
        catch (ExceptionUtil e) {
            throw new GWException("\u83b7\u53d6\u7f51\u5173\u5de5\u4f5c\u8def\u5f84\u5931\u8d25,", (Exception)((Object)e));
        }
    }

    private List<FieldData> getFieldList(DbParams dbParams) throws GWException {
        try {
            if (!GWStringUtil.isEmpty(dbParams.getView())) {
                return this.baseConfigLogic.getViewColumn(dbParams);
            }
            return this.baseConfigLogic.getTableColumn(dbParams);
        }
        catch (ExceptionUtil e) {
            throw new GWException("\u83b7\u53d6\u6570\u636e\u5e93\u5b57\u6bb5\u5931\u8d25,", (Exception)((Object)e));
        }
    }

    private List<FieldData> getFieldListFromFieldMap(DbParams dbParams, Map<String, String> fieldMap) throws GWException {
        List<FieldData> fieldList = this.getFieldList(dbParams);
        if (fieldList != null) {
            ArrayList<FieldData> fieldList2 = new ArrayList<FieldData>();
            block0: for (String fieldName : fieldMap.keySet()) {
                for (FieldData fieldData : fieldList) {
                    if (!fieldData.getField_name().equalsIgnoreCase(fieldName)) continue;
                    fieldData.setAlias(fieldMap.get(fieldName));
                    fieldList2.add(fieldData);
                    continue block0;
                }
            }
            return fieldList2;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<FieldData> processFieldList(List<FieldData> fieldList, String rdb_pk, String rbd_view_pk, boolean isView) throws GWException {
        if (fieldList == null || fieldList.size() == 0) {
            throw new GWException("\u5b57\u6bb5\u5217\u8868\u4e3a\u7a7a");
        }
        boolean flag = false;
        if (isView) {
            if (GWStringUtil.isEmpty(rbd_view_pk)) throw new GWException("\u89c6\u56fe\u4e3b\u952e\u4e3a\u7a7a");
            for (FieldData field : fieldList) {
                if (field.getField_name().equalsIgnoreCase(rbd_view_pk)) {
                    field.setField_upk(true);
                    field.setAlias(rdb_pk);
                    flag = true;
                    continue;
                }
                field.setField_upk(false);
                field.setAlias("");
            }
        } else {
            if (GWStringUtil.isEmpty(rdb_pk)) throw new GWException("\u4e3b\u8868\u4e3b\u952e\u4e3a\u7a7a");
            for (FieldData field : fieldList) {
                if (field.getField_name().equalsIgnoreCase(rdb_pk)) {
                    field.setField_upk(true);
                    flag = true;
                    continue;
                }
                field.setField_upk(false);
            }
        }
        if (flag) return fieldList;
        if (!isView) throw new GWException("\u4e3b\u8868\u4e3b\u952e\u5b57\u6bb5\u4e0d\u5b58\u5728," + rdb_pk);
        throw new GWException("\u89c6\u56fe\u4e3b\u952e\u5b57\u6bb5\u4e0d\u5b58\u5728," + rbd_view_pk);
    }

    private boolean rollbackCreateTask(String taskName) throws GWException {
        if (!GWStringUtil.isEmpty(taskName)) {
            try {
                return this.baseConfigLogic.delete(taskName);
            }
            catch (ExceptionUtil e) {
                throw new GWException("\u4efb\u52a1[" + taskName + "]\u56de\u6eda\u5931\u8d25", (Exception)((Object)e));
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkIsRelatedTask(AgentConfig agentAll, AgentConfig agentInc) throws GWException {
        if (agentAll == null || agentInc == null) {
            return false;
        }
        if (agentAll.getRdbConfig().getRdb_policy() != 0 || agentInc.getRdbConfig().getRdb_policy() != 1) return false;
        String all_taskname = agentAll.getTask_name();
        String inc_taskname = agentInc.getTask_name();
        if (!(all_taskname = String.valueOf(all_taskname) + "_INC").equalsIgnoreCase(inc_taskname)) {
            return false;
        }
        List all_FieldList = agentAll.getField_list();
        List inc_FieldList = agentInc.getField_list();
        if (all_FieldList.size() != inc_FieldList.size()) {
            return false;
        }
        FieldData all_field_pk = null;
        FieldData inc_field_pk = null;
        for (FieldData field : all_FieldList) {
            if (!field.isField_upk()) continue;
            all_field_pk = field;
            break;
        }
        for (FieldData field : inc_FieldList) {
            if (!field.isField_upk()) continue;
            inc_field_pk = field;
            break;
        }
        if (all_field_pk == null || inc_field_pk == null) return false;
        if (!all_field_pk.getField_name().equalsIgnoreCase(inc_field_pk.getField_name()) || all_field_pk.getField_type() != inc_field_pk.getField_type()) return false;
        if (!agentAll.getNode_sync_field().equalsIgnoreCase(agentInc.getNode_sync_field())) return false;
        return true;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getPort() {
        return this.port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }
}

