/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.gateway.view.controller.mission;

import com.trs.cis4.gateway.bean.AgentConfig;
import com.trs.cis4.gateway.bean.DbParams;
import com.trs.cis4.gateway.bean.FieldData;
import com.trs.cis4.gateway.bean.MachineData;
import com.trs.cis4.gateway.view.controller.base.Base_Controller;
import com.trs.cis4.gateway.view.util.RDBSqlTypeCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mapping_Colunmn_Content_controller
extends Base_Controller {
    private Logger log = Logger.getLogger(this.getClass());
    private String successView2;
    private RDBSqlTypeCollection rdbSqlTypeCollection;

    @Override
    public ModelAndView _handleRequest(HttpServletRequest request, HttpServletResponse rep) throws Exception {
        HttpSession session = request.getSession();
        AgentConfig agentConfig = new AgentConfig();
        String taskName = (String)session.getAttribute("taskName");
        if (taskName != null) {
            agentConfig = (AgentConfig)session.getAttribute(taskName);
        }
        List<FieldData> field_list = agentConfig.getField_list();
        for (FieldData fd : field_list) {
            if (!fd.isField_upk()) continue;
            request.setAttribute("upk", (Object)fd.getField_name());
            break;
        }
        List<FieldData> ext_list = agentConfig.getExt_list();
        ArrayList<FieldData> fdList = new ArrayList<FieldData>();
        fdList.addAll(field_list);
        fdList.addAll(ext_list);
        Collections.sort(fdList, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((FieldData)o1).getField_name().compareToIgnoreCase(((FieldData)o2).getField_name());
            }
        });
        String[] types = this.getRdbSqlTypeCollection().getRDBSqlTypes(agentConfig.getRdbConfig().getRdb_type());
        String[] trstypes = this.getRdbSqlTypeCollection().getRDBSqlTypes(0);
        String bit_fixed = this.getRdbSqlTypeCollection().getBitType();
        String doc_fixed = this.getRdbSqlTypeCollection().getDocType();
        String columns = "";
        if (fdList != null && fdList.size() > 0) {
            int i = 0;
            while (i < fdList.size()) {
                FieldData fieldData = (FieldData)fdList.get(i);
                columns = String.valueOf(columns) + fieldData.getField_name() + ",";
                ++i;
            }
        }
        if (columns != null && !"".equals(columns) && columns.length() > 0) {
            request.setAttribute("columns", (Object)columns.substring(0, columns.length() - 1));
        }
        request.setAttribute("types", (Object)types);
        request.setAttribute("trstypes", (Object)trstypes);
        request.setAttribute("bit_fixed", (Object)bit_fixed);
        request.setAttribute("doc_fixed", (Object)doc_fixed);
        request.setAttribute("agentConfig", (Object)agentConfig);
        if (request.getAttribute("isFileMission") != null) {
            return new ModelAndView(this.getSuccessView2());
        }
        List<FieldData> rightList = this.getTrsColumns(agentConfig, request);
        Collections.sort(rightList, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((FieldData)o1).getField_name().compareToIgnoreCase(((FieldData)o2).getField_name());
            }
        });
        if (rightList == null || rightList.size() < 1) {
            request.setAttribute("rightTableIsEmpty", (Object)"true");
        }
        request.setAttribute("rightList", rightList);
        return new ModelAndView(this.getSuccessView());
    }

    private List<FieldData> getTrsColumns(AgentConfig agentConfig, HttpServletRequest request) {
        List<FieldData> rightList = new ArrayList<FieldData>();
        List<MachineData> mdList = agentConfig.getMachine_list();
        if (mdList != null && mdList.size() > 0) {
            MachineData md = mdList.get(0);
            int i = 0;
            while (i < mdList.size()) {
                if (mdList.get(i).getMachine_view() != 1) {
                    md = mdList.get(i);
                    break;
                }
                ++i;
            }
            DbParams dbParams = new DbParams();
            dbParams.setDbserver(md.getTrs_server());
            dbParams.setDbport(Integer.parseInt(md.getTrs_port()));
            dbParams.setDbuser(md.getTrs_username());
            dbParams.setDbpassword(md.getTrs_password());
            dbParams.setDbtype(0);
            dbParams.setDbdatabase(md.getTrs_database());
            try {
                rightList = this.getConfigLogic().getTableColumn(dbParams);
            }
            catch (Exception e) {
                this.log.error((Object)("\u5b57\u6bb5\u5339\u914d\u6a21\u5757\u4e2d\u83b7\u53d6TRS Server\u5931\u8d25\uff1a" + e.getMessage()));
            }
        }
        return rightList;
    }

    public RDBSqlTypeCollection getRdbSqlTypeCollection() {
        return this.rdbSqlTypeCollection;
    }

    public void setRdbSqlTypeCollection(RDBSqlTypeCollection rdbSqlTypeCollection) {
        this.rdbSqlTypeCollection = rdbSqlTypeCollection;
    }

    public String getSuccessView2() {
        return this.successView2;
    }

    public void setSuccessView2(String successView2) {
        this.successView2 = successView2;
    }
}

