/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.impl;

import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.ClusterMessageListener;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.MemberListener;
import com.trs.infra.cluster.Startable;
import com.trs.infra.cluster.Statistic;
import com.trs.infra.cluster.impl.ClusterContextImpl;
import com.trs.infra.cluster.impl.ClusterReceiverBase;
import com.trs.infra.cluster.impl.transport.InetListenerByMulticast;
import com.trs.infra.cluster.impl.transport.InetListenerByTCP;
import com.trs.infra.cluster.impl.transport.InetListenerByUDP;
import com.trs.infra.cluster.member.MemberImpl;
import com.trs.infra.cluster.member.MemberManagerImpl;
import org.apache.log4j.Logger;

final class ClusterReceiverDispatcher
implements MemberListener,
Startable {
    private static final Logger s_logger;
    private ClusterContextImpl context;
    private MemberManagerImpl memberManager;
    final ClusterMessageListener[] listeners;
    private InetListenerByMulticast listenerMulticast;
    private InetListenerByTCP listenerTCP;
    private InetListenerByUDP listenerUDP;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.impl.ClusterReceiverDispatcher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    ClusterReceiverDispatcher(ClusterContextImpl context) {
        this.context = context;
        this.listeners = new ClusterMessageListener[256];
    }

    public final MemberManagerImpl getMemberManager() {
        return this.memberManager;
    }

    public final void setMemberManager(MemberManagerImpl memberManager) {
        this.memberManager = memberManager;
    }

    public void start() {
        this.listenerTCP = new InetListenerByTCP();
        this.listenerTCP.setContext(this.context);
        this.listenerTCP.setMemberManager(this.memberManager);
        this.listenerTCP.start();
        this.listenerUDP = new InetListenerByUDP();
        this.listenerUDP.setContext(this.context);
        this.listenerUDP.start();
        this.listenerMulticast = new InetListenerByMulticast();
        this.listenerMulticast.setContext(this.context);
        this.listenerMulticast.start();
    }

    public void close() {
        this.listenerTCP.close();
        this.listenerUDP.close();
        this.listenerMulticast.close();
    }

    void addListener(ClusterMessageListener listener) {
        if (listener == null) {
            return;
        }
        ClusterMessageListener oldListener = this.listeners[listener.getAcceptedMessage()];
        if (oldListener == null) {
            this.listeners[listener.getAcceptedMessage()] = listener;
            return;
        }
        if (oldListener == listener) {
            return;
        }
        s_logger.error((Object)("Collision listener:" + listener + " with:" + oldListener));
    }

    void removeListener(ClusterMessageListener listener) {
        if (listener == null) {
            return;
        }
        ClusterMessageListener oldListener = this.listeners[listener.getAcceptedMessage()];
        if (oldListener == null) {
            return;
        }
        if (oldListener == listener) {
            this.listeners[listener.getAcceptedMessage()] = null;
            return;
        }
        s_logger.error((Object)("Collision listener:" + listener + " with:" + oldListener));
    }

    void dispatch(ClusterMessage msg, Member sender) {
        int major = msg.getMajorId();
        if (major < 0 || major > 255) {
            s_logger.error((Object)("Out of bound major message id:" + major));
            return;
        }
        ClusterMessageListener listener = this.listeners[major];
        if (listener == null) {
            if (major == 127) {
                s_logger.error((Object)"No extension manager");
            } else {
                s_logger.error((Object)("Invalid major message id:" + major));
            }
            return;
        }
        try {
            listener.receive(msg, sender);
        }
        catch (Throwable e) {
            s_logger.error((Object)("Listener '" + listener + "' receive failed"), e);
        }
    }

    public void memberFailed(Member member) {
        this.memberLeft(member);
    }

    public void memberJoined(Member member) {
    }

    /*
     * Unable to fully structure code
     */
    public void memberLeft(Member member) {
        memberImpl = (MemberImpl)member;
        itr = memberImpl.getTransport().getReceivers();
        if (itr != null) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            receiver = (ClusterReceiverBase)itr.next();
            if (receiver == null) continue;
            receiver.close();
lbl8:
            // 3 sources

            ** while (itr.hasNext())
        }
lbl9:
        // 1 sources

    }

    public void addReceiver(ClusterReceiverBase receiver) {
        MemberImpl member = (MemberImpl)receiver.getRemoteMember();
        if (member != null) {
            member.getTransport().addReceiver(receiver);
        }
    }

    public void removeReceiver(ClusterReceiverBase receiver) {
        MemberImpl member = (MemberImpl)receiver.getRemoteMember();
        if (member != null) {
            member.getTransport().removeReceiver(receiver);
        }
    }

    public Statistic getStatistic() {
        return null;
    }
}

