/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.collector;

import com.trs.components.collector.IInformation;
import com.trs.infra.support.config.ConfigServer;
import java.io.File;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WCMFixIndexInfo
implements IInformation {
    private static final String FIELDNAME = "FIXINDEX";
    private static final String FIXEXT = "WCMFIX";

    @Override
    public HashMap<String, String> getInfo() {
        HashMap<String, String> infoMap = new HashMap<String, String>(1);
        String path = ConfigServer.getServer().getInitProperty("WCM_PATH");
        File f = new File(String.valueOf(path) + "/fix");
        if (!f.exists()) {
            infoMap.put(FIELDNAME, "\u6ca1\u5b89\u88c5\u4efb\u4f55fix");
        } else {
            infoMap.put(FIELDNAME, this.getFixIndex(f));
        }
        return infoMap;
    }

    private String getFixIndex(File file) {
        if (file.isFile() || file.list().length == 0) {
            return "\u6c92\u5b89\u88dd\u4efb\u4f55fix";
        }
        File[] files = file.listFiles();
        String sLastFixIndex = "\u6c92\u5b89\u88dd\u4efb\u4f55fix";
        int iLastFixIndex = 0;
        int i = files.length - 1;
        while (i >= 0) {
            File f = files[i];
            String fileName = f.getName();
            String fileExt = this.getFileExtension(fileName);
            if (fileExt.equalsIgnoreCase(FIXEXT) && fileName.indexOf("_") > 0) {
                String sFixIndex = fileName.substring(0, fileName.indexOf("_"));
                int iFixIndex = Integer.parseInt(sFixIndex);
                iLastFixIndex = iLastFixIndex > iFixIndex ? iLastFixIndex : iFixIndex;
                sLastFixIndex = iLastFixIndex > iFixIndex ? sLastFixIndex : sFixIndex;
            }
            --i;
        }
        return sLastFixIndex;
    }

    private String getFileExtension(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length() - 1) {
            return filename.substring(dot + 1);
        }
        return filename;
    }
}

