/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.weibo.utils;

import com.tencent.weibo.api.User_API;
import com.tencent.weibo.beans.Account;
import com.tencent.weibo.beans.OAuth;
import com.tencent.weibo.beans.QParameter;
import com.tencent.weibo.utils.Base64Encoder;
import com.tencent.weibo.utils.QHttpClient;
import com.tencent.weibo.utils.QStr;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthClient {
    private static final String hashAlgorithmName = "HmacSHA1";
    private static Log log = LogFactory.getLog(OAuthClient.class);

    public OAuth requestToken(OAuth oauth) throws Exception {
        QHttpClient http = new QHttpClient();
        String url = "http://open.t.qq.com/cgi-bin/request_token";
        String queryString = this.getOauthParams(url, "GET", oauth.getOauth_consumer_secret(), "", oauth.getParams());
        String responseData = http.httpGet(url, queryString);
        if (!this.parseToken(responseData, oauth)) {
            oauth.setStatus(1);
            log.error((Object)"requestToken past !");
        }
        return oauth;
    }

    public OAuth accessToken(OAuth oauth) throws Exception {
        QHttpClient http = new QHttpClient();
        String url = "http://open.t.qq.com/cgi-bin/access_token";
        String queryString = this.getOauthParams(url, "GET", oauth.getOauth_consumer_secret(), oauth.getOauth_token_secret(), oauth.getAccessParams());
        String responseData = http.httpGet(url, queryString);
        if (!this.parseToken(responseData, oauth)) {
            oauth.setStatus(2);
        }
        return oauth;
    }

    public String getAccessToken4OAuth2(OAuth oauth) throws Exception {
        String url = "http://open.t.qq.com/api/auth/get_oauth2_token";
        QHttpClient http = new QHttpClient();
        List<QParameter> params = oauth.getAccessParams();
        params.add(new QParameter("format", "json"));
        params.add(new QParameter("clientip", "127.0.0.1"));
        params.add(new QParameter("callbackurl", "http://www.baidu.com"));
        String queryString = this.getOauthParams(url, "GET", oauth.getOauth_consumer_secret(), oauth.getOauth_token_secret(), params);
        String responseData = http.httpGet(url, queryString);
        return responseData;
    }

    public Account getAccount(OAuth oauth) throws Exception {
        Account account = new Account();
        SAXReader saxReader = new SAXReader();
        String myInfo = new User_API().info(oauth, "xml");
        Document xml = saxReader.read((InputStream)new ByteArrayInputStream(myInfo.getBytes("UTF-8")));
        int ret = Integer.parseInt(xml.selectSingleNode("root/ret").getText());
        if (ret != 0) {
            return account;
        }
        String openid = xml.selectSingleNode("root/data/openid").getText();
        String name = xml.selectSingleNode("root/data/name").getText();
        String nick = xml.selectSingleNode("root/data/nick").getText();
        String head = xml.selectSingleNode("root/data/head").getText();
        String isvip = xml.selectSingleNode("root/data/isvip").getText();
        String sex = xml.selectSingleNode("root/data/sex").getText();
        String fansnum = xml.selectSingleNode("root/data/fansnum").getText();
        String idolnum = xml.selectSingleNode("root/data/idolnum").getText();
        String tweetnum = xml.selectSingleNode("root/data/tweetnum").getText();
        account.setOpenid(openid);
        account.setName(name);
        account.setNick(nick);
        account.setHead(head);
        account.setIsvip(isvip);
        account.setSex(sex);
        account.setFansnum(fansnum);
        account.setIdolnum(idolnum);
        account.setTweetnum(tweetnum);
        return account;
    }

    public String getOauthParams(String url, String httpMethod, String consumerSecret, String tokenSecrect, List<QParameter> parameters) {
        Collections.sort(parameters);
        String urlWithParameter = url;
        String parameterString = OAuthClient.encodeParams(parameters);
        if (parameterString != null && !parameterString.equals("")) {
            urlWithParameter = String.valueOf(urlWithParameter) + "?" + parameterString;
        }
        URL aUrl = null;
        try {
            aUrl = new URL(urlWithParameter);
        }
        catch (MalformedURLException e) {
            System.err.println("URL parse error:" + e.getLocalizedMessage());
        }
        String signature = this.generateSignature(aUrl, consumerSecret, tokenSecrect, httpMethod, parameters);
        parameterString = String.valueOf(parameterString) + "&oauth_signature=";
        parameterString = String.valueOf(parameterString) + QStr.encode(signature);
        return parameterString;
    }

    public boolean parseToken(String response, OAuth oauth) throws Exception {
        String[] params;
        if (response == null || response.equals("")) {
            return false;
        }
        oauth.setMsg(response);
        String[] tokenArray = response.split("&");
        if (tokenArray.length < 2) {
            return false;
        }
        String strTokenKey = tokenArray[0];
        String strTokenSecrect = tokenArray[1];
        String[] token = strTokenKey.split("=");
        if (token.length < 2) {
            return false;
        }
        oauth.setOauth_token(token[1]);
        String[] tokenSecrect = strTokenSecrect.split("=");
        if (tokenSecrect.length < 2) {
            return false;
        }
        oauth.setOauth_token_secret(tokenSecrect[1]);
        if (tokenArray.length == 3 && "name".equals((params = tokenArray[2].split("="))[0])) {
            int cfr_ignored_0 = params.length;
        }
        return true;
    }

    private String generateSignature(URL url, String consumerSecret, String accessTokenSecret, String httpMethod, List<QParameter> parameters) {
        String base = this.generateSignatureBase(url, httpMethod, parameters);
        return this.generateSignature(base, consumerSecret, accessTokenSecret);
    }

    private String generateSignature(String base, String consumerSecret, String accessTokenSecret) {
        try {
            Mac mac = Mac.getInstance(hashAlgorithmName);
            String oauthSignature = String.valueOf(QStr.encode(consumerSecret)) + "&" + (accessTokenSecret == null ? "" : QStr.encode(accessTokenSecret));
            SecretKeySpec spec = new SecretKeySpec(oauthSignature.getBytes(), hashAlgorithmName);
            mac.init(spec);
            byte[] bytes = mac.doFinal(base.getBytes());
            return new String(Base64Encoder.encode(bytes));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String generateSignatureBase(URL url, String httpMethod, List<QParameter> parameters) {
        StringBuilder base = new StringBuilder();
        base.append(httpMethod.toUpperCase());
        base.append("&");
        base.append(QStr.encode(OAuthClient.getNormalizedUrl(url)));
        base.append("&");
        base.append(QStr.encode(OAuthClient.encodeParams(parameters)));
        return base.toString();
    }

    private static String getNormalizedUrl(URL url) {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(url.getProtocol());
            buf.append("://");
            buf.append(url.getHost());
            if ((url.getProtocol().equals("http") || url.getProtocol().equals("https")) && url.getPort() != -1) {
                buf.append(":");
                buf.append(url.getPort());
            }
            buf.append(url.getPath());
            return buf.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String encodeParams(List<QParameter> params) {
        StringBuilder result = new StringBuilder();
        for (QParameter param : params) {
            if (result.length() != 0) {
                result.append("&");
            }
            result.append(QStr.encode(param.getName()));
            result.append("=");
            result.append(QStr.encode(param.getValue()));
        }
        return result.toString();
    }
}

