/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.StringUtils;

public class SimpleInstantiationStrategy
implements InstantiationStrategy {
    protected final Log log = LogFactory.getLog(this.getClass());

    public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner) {
        if (beanDefinition.getMethodOverrides().isEmpty()) {
            return BeanUtils.instantiateClass(beanDefinition.getBeanClass());
        }
        return this.instantiateWithMethodInjection(beanDefinition, beanName, owner);
    }

    protected Object instantiateWithMethodInjection(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner) {
        throw new UnsupportedOperationException("Method Injection not supported in SimpleInstantiationStrategy");
    }

    public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner, Constructor ctor, Object[] args) {
        if (beanDefinition.getMethodOverrides().isEmpty()) {
            return BeanUtils.instantiateClass(ctor, args);
        }
        return this.instantiateWithMethodInjection(beanDefinition, beanName, owner, ctor, args);
    }

    protected Object instantiateWithMethodInjection(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner, Constructor ctor, Object[] args) {
        throw new UnsupportedOperationException("Method Injection not supported in SimpleInstantiationStrategy");
    }

    public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner, Method factoryMethod, Object[] args) {
        Object target = null;
        if (beanDefinition.getFactoryBeanName() != null) {
            target = owner.getBean(beanDefinition.getFactoryBeanName());
        }
        try {
            return factoryMethod.invoke(target, args);
        }
        catch (IllegalArgumentException ex) {
            throw new BeanDefinitionStoreException("Illegal arguments to factory method " + factoryMethod + "; " + "args=" + StringUtils.arrayToCommaDelimitedString(args));
        }
        catch (IllegalAccessException ex) {
            throw new BeanDefinitionStoreException("Cannot access factory method " + factoryMethod + "; is it public?");
        }
        catch (InvocationTargetException ex) {
            String mesg = "Factory method " + factoryMethod + " threw exception";
            this.log.warn((Object)mesg, ex.getTargetException());
            throw new BeanDefinitionStoreException(mesg, ex.getTargetException());
        }
    }
}

