/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi;

import java.util.Properties;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jndi.JndiTemplate;

public abstract class JndiLocatorSupport {
    public static String CONTAINER_PREFIX = "java:comp/env/";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private JndiTemplate jndiTemplate = new JndiTemplate();
    private boolean resourceRef = false;

    public void setJndiTemplate(JndiTemplate jndiTemplate) {
        this.jndiTemplate = jndiTemplate;
    }

    public JndiTemplate getJndiTemplate() {
        return this.jndiTemplate;
    }

    public void setJndiEnvironment(Properties jndiEnvironment) {
        this.jndiTemplate = new JndiTemplate(jndiEnvironment);
    }

    public Properties getJndiEnvironment() {
        return this.jndiTemplate.getEnvironment();
    }

    public void setResourceRef(boolean resourceRef) {
        this.resourceRef = resourceRef;
    }

    public boolean isResourceRef() {
        return this.resourceRef;
    }

    protected Object lookup(String jndiName) throws NamingException {
        String jndiNameToUse = this.convertJndiName(jndiName);
        Object jndiObject = this.getJndiTemplate().lookup(jndiNameToUse);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Located object with JNDI name '" + jndiNameToUse + "': value=[" + jndiObject + "]"));
        }
        return jndiObject;
    }

    protected String convertJndiName(String jndiName) {
        if (this.isResourceRef() && !jndiName.startsWith(CONTAINER_PREFIX) && jndiName.indexOf(58) == -1) {
            jndiName = CONTAINER_PREFIX + jndiName;
        }
        return jndiName;
    }
}

