/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.KBResultSetMetaData;
import com.kingbase8.core.BaseConnection;
import com.kingbase8.core.Field;
import com.kingbase8.jdbc.FieldMetadata;
import com.kingbase8.util.GT;
import com.kingbase8.util.JdbcBlackHole;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LruCache;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class KbResultSetMetaData
implements ResultSetMetaData,
KBResultSetMetaData {
    protected final BaseConnection connection;
    protected final Field[] fields;
    private boolean fieldInfoFetched;

    public KbResultSetMetaData(BaseConnection connection, Field[] fields) {
        this.connection = connection;
        this.fields = fields;
        this.fieldInfoFetched = false;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.fields.length;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.fetchFieldMetaData();
        Field field = this.getField(column);
        FieldMetadata metadata = field.getMetadata();
        return metadata != null && metadata.autoIncrement;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        Field field = this.getField(column);
        return this.connection.getTypeInfo().isCaseSensitive(field.getOID());
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        String type_name = this.getKBType(column);
        return type_name.equals("cash") || type_name.equals("MONEY");
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.fetchFieldMetaData();
        Field field = this.getField(column);
        return field.getMetadata().nullable;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        Field field = this.getField(column);
        return this.connection.getTypeInfo().isSigned(field.getOID());
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        Field field = this.getField(column);
        return this.connection.getTypeInfo().getDisplaySize(field.getOID(), field.getMod());
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        Field field = this.getField(column);
        return field.getColumnLabel();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnLabel(column);
    }

    @Override
    public String getBaseColumnName(int column) throws SQLException {
        Field field = this.getField(column);
        if (field.getTableOid() == 0) {
            return "";
        }
        this.fetchFieldMetaData();
        return field.getMetadata().columnName;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    private boolean populateFieldsWithCachedMetadata() {
        boolean allOk = true;
        LruCache<FieldMetadata.Key, FieldMetadata> metadata = this.connection.getFieldMetadataCache();
        for (Field field : this.fields) {
            if (field.getMetadata() != null) continue;
            FieldMetadata fieldMetadata = metadata.get(new FieldMetadata.Key(field.getTableOid(), field.getPositionInTable()));
            if (fieldMetadata == null) {
                allOk = false;
                continue;
            }
            field.setMetadata(fieldMetadata);
        }
        return allOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchFieldMetaData() throws SQLException {
        if (this.fieldInfoFetched) {
            return;
        }
        if (this.populateFieldsWithCachedMetadata()) {
            this.fieldInfoFetched = true;
            return;
        }
        StringBuilder sql = new StringBuilder("SELECT c.oid, a.attnum, a.attname, c.relname, n.nspname, a.attnotnull OR (t.typtype = 'd' AND t.typnotnull), sys_catalog.sys_get_expr(d.adbin, d.adrelid) LIKE '%NEXTVAL(%' FROM sys_catalog.sys_class c JOIN sys_catalog.sys_namespace n ON (c.relnamespace = n.oid) JOIN sys_catalog.sys_attribute a ON (c.oid = a.attrelid) JOIN sys_catalog.sys_type t ON (a.atttypid = t.oid) LEFT JOIN sys_catalog.sys_attrdef d ON (d.adrelid = a.attrelid AND d.adnum = a.attnum) JOIN (");
        boolean hasSourceInfo = false;
        for (Field field : this.fields) {
            if (field.getMetadata() != null) continue;
            if (hasSourceInfo) {
                sql.append(" UNION ALL ");
            }
            sql.append("SELECT ");
            sql.append(field.getTableOid());
            if (!hasSourceInfo) {
                sql.append(" AS oid ");
            }
            sql.append(", ");
            sql.append(field.getPositionInTable());
            if (!hasSourceInfo) {
                sql.append(" AS attnum");
            }
            if (hasSourceInfo) continue;
            hasSourceInfo = true;
        }
        sql.append(") vals ON (c.oid = vals.oid AND a.attnum = vals.attnum) ");
        if (!hasSourceInfo) {
            this.fieldInfoFetched = true;
            return;
        }
        Statement stmt = this.connection.createStatement();
        ResultSet rs = null;
        try {
            LruCache<FieldMetadata.Key, FieldMetadata> metadataCache = this.connection.getFieldMetadataCache();
            rs = stmt.executeQuery(sql.toString());
            while (rs.next()) {
                int table = (int)rs.getLong(1);
                int column = (int)rs.getLong(2);
                String columnName = rs.getString(3);
                String tableName = rs.getString(4);
                String schemaName = rs.getString(5);
                int nullable = rs.getBoolean(6) ? 0 : 1;
                boolean autoIncrement = rs.getBoolean(7);
                FieldMetadata fieldMetadata = new FieldMetadata(columnName, tableName, schemaName, nullable, autoIncrement);
                FieldMetadata.Key key = new FieldMetadata.Key(table, column);
                metadataCache.put(key, fieldMetadata);
            }
        }
        catch (Throwable throwable) {
            JdbcBlackHole.close(rs);
            JdbcBlackHole.close(stmt);
            throw throwable;
        }
        JdbcBlackHole.close(rs);
        JdbcBlackHole.close(stmt);
        this.populateFieldsWithCachedMetadata();
    }

    @Override
    public String getBaseSchemaName(int column) throws SQLException {
        this.fetchFieldMetaData();
        Field field = this.getField(column);
        return field.getMetadata().schemaName;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        Field field = this.getField(column);
        return this.connection.getTypeInfo().getPrecision(field.getOID(), field.getMod());
    }

    @Override
    public int getScale(int column) throws SQLException {
        Field field = this.getField(column);
        return this.connection.getTypeInfo().getScale(field.getOID(), field.getMod());
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.getBaseTableName(column);
    }

    @Override
    public String getBaseTableName(int column) throws SQLException {
        this.fetchFieldMetaData();
        Field field = this.getField(column);
        return field.getMetadata().tableName;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getSQLType(column);
    }

    @Override
    public int getFormat(int column) throws SQLException {
        return this.getField(column).getFormat();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        String type = this.getKBType(column);
        if (this.isAutoIncrement(column)) {
            if ("INT4".equals(type)) {
                return "SERIAL";
            }
            if ("INT8".equals(type)) {
                return "BIGSERIAL";
            }
        }
        if (type.equalsIgnoreCase("DSINTERVAL")) {
            return "INTERVAL DAY TO SECOND";
        }
        if (type.equalsIgnoreCase("YMINTERVAL")) {
            return "INTERVAL YEAR TO MONTH";
        }
        return type;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    protected Field getField(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw new KSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", columnIndex, this.fields.length), KSQLState.INVALID_PARAMETER_VALUE);
        }
        return this.fields[columnIndex - 1];
    }

    protected String getKBType(int columnIndex) throws SQLException {
        return this.connection.getTypeInfo().getKBType(this.getField(columnIndex).getOID());
    }

    protected int getSQLType(int columnIndex) throws SQLException {
        return this.connection.getTypeInfo().getSQLType(this.getField(columnIndex).getOID());
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        Field field = this.getField(column);
        String result = this.connection.getTypeInfo().getJavaClass(field.getOID());
        if (result != null) {
            return result;
        }
        int sqlType = this.getSQLType(column);
        switch (sqlType) {
            case 2003: {
                return "java.sql.Array";
            }
        }
        String type = this.getKBType(column);
        if ("unknown".equals(type)) {
            return "java.lang.String";
        }
        return "java.lang.Object";
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }
}

