/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LOGGER;
import java.util.logging.Level;

class BooleanTypeUtil {
    private BooleanTypeUtil() {
    }

    static boolean castToBoolean(Object in) throws KSQLException {
        LOGGER.log(Level.FINE, "Object to cast: {0}", in);
        if (in instanceof Boolean) {
            return (Boolean)in;
        }
        if (in instanceof String) {
            return BooleanTypeUtil.from((String)in);
        }
        if (in instanceof Character) {
            return BooleanTypeUtil.from((Character)in);
        }
        if (in instanceof Number) {
            return BooleanTypeUtil.from((Number)in, in.getClass().getName());
        }
        throw BooleanTypeUtil.cannotCoerceException(in.getClass().getName());
    }

    private static boolean from(String strval) throws KSQLException {
        String val = strval.trim();
        if ("1".equals(val) || "true".equalsIgnoreCase(val) || "t".equalsIgnoreCase(val) || "yes".equalsIgnoreCase(val) || "y".equalsIgnoreCase(val) || "on".equalsIgnoreCase(val)) {
            return true;
        }
        if ("0".equals(val) || "false".equalsIgnoreCase(val) || "f".equalsIgnoreCase(val) || "no".equalsIgnoreCase(val) || "n".equalsIgnoreCase(val) || "off".equalsIgnoreCase(val)) {
            return false;
        }
        throw BooleanTypeUtil.cannotCoerceException("String", val);
    }

    private static boolean from(Character charval) throws KSQLException {
        if ('1' == charval.charValue() || 't' == charval.charValue() || 'T' == charval.charValue() || 'y' == charval.charValue() || 'Y' == charval.charValue()) {
            return true;
        }
        if ('0' == charval.charValue() || 'f' == charval.charValue() || 'F' == charval.charValue() || 'n' == charval.charValue() || 'N' == charval.charValue()) {
            return false;
        }
        throw BooleanTypeUtil.cannotCoerceException("Character", charval.toString());
    }

    private static boolean from(Number numval, String className) throws KSQLException {
        double value = numval.doubleValue();
        if (value == 1.0) {
            return true;
        }
        if (value == 0.0) {
            return false;
        }
        throw BooleanTypeUtil.cannotCoerceException(className, String.valueOf(numval));
    }

    private static KSQLException cannotCoerceException(String fromType) {
        LOGGER.log(Level.FINE, "Cannot cast type {0} to boolean", fromType);
        return new KSQLException(GT.tr("Cannot cast type {0} to boolean", fromType), KSQLState.CANNOT_COERCE);
    }

    private static KSQLException cannotCoerceException(String fromType, String value) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Cannot cast type {0} to boolean: \"{1}\"", new Object[]{fromType, value});
        }
        return new KSQLException(GT.tr("Cannot cast type {0} to boolean: \"{1}\"", fromType, value), KSQLState.CANNOT_COERCE);
    }
}

