/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.dbunit.dataset.stream.DataSetProducerAdapter;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.util.xml.XmlWriter;

public class FlatXmlWriter
implements IDataSetConsumer {
    private static final String DEFAULT_ENCODING = "UTF8";
    private static final String DATASET = "dataset";
    private XmlWriter _xmlWriter;
    private ITableMetaData _activeMetaData;
    private int _activeRowCount;
    private boolean _includeEmptyTable = false;
    private String _systemId = null;

    public FlatXmlWriter(Writer writer) {
        this._xmlWriter = new XmlWriter(writer);
        this._xmlWriter.enablePrettyPrint(true);
    }

    public FlatXmlWriter(OutputStream out) throws IOException {
        this._xmlWriter = new XmlWriter(new OutputStreamWriter(out, DEFAULT_ENCODING));
        this._xmlWriter.enablePrettyPrint(true);
    }

    public FlatXmlWriter(Writer writer, String encoding) {
        this._xmlWriter = new XmlWriter(writer, encoding);
        this._xmlWriter.enablePrettyPrint(true);
    }

    public void setIncludeEmptyTable(boolean includeEmptyTable) {
        this._includeEmptyTable = includeEmptyTable;
    }

    public void setDocType(String systemId) {
        this._systemId = systemId;
    }

    public void write(IDataSet dataSet) throws DataSetException {
        DataSetProducerAdapter provider = new DataSetProducerAdapter(dataSet);
        provider.setConsumer(this);
        provider.produce();
    }

    public void startDataSet() throws DataSetException {
        try {
            this._xmlWriter.writeDeclaration();
            this._xmlWriter.writeDoctype(this._systemId, null);
            this._xmlWriter.writeElement(DATASET);
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    public void endDataSet() throws DataSetException {
        try {
            this._xmlWriter.endElement();
            this._xmlWriter.close();
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    public void startTable(ITableMetaData metaData) throws DataSetException {
        this._activeMetaData = metaData;
        this._activeRowCount = 0;
    }

    public void endTable() throws DataSetException {
        if (this._includeEmptyTable && this._activeRowCount == 0) {
            try {
                String tableName = this._activeMetaData.getTableName();
                this._xmlWriter.writeEmptyElement(tableName);
            }
            catch (IOException e) {
                throw new DataSetException(e);
            }
        }
        this._activeMetaData = null;
    }

    public void row(Object[] values) throws DataSetException {
        try {
            String tableName = this._activeMetaData.getTableName();
            this._xmlWriter.writeElement(tableName);
            Column[] columns = this._activeMetaData.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                String columnName = columns[i].getColumnName();
                Object value = values[i];
                if (value == null) continue;
                try {
                    String stringValue = DataType.asString(value);
                    this._xmlWriter.writeAttribute(columnName, stringValue);
                    continue;
                }
                catch (TypeCastException e) {
                    throw new DataSetException("table=" + this._activeMetaData.getTableName() + ", row=" + i + ", column=" + columnName + ", value=" + value, e);
                }
            }
            ++this._activeRowCount;
            this._xmlWriter.endElement();
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }
}

