/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.pool.KeyedObjectPool;

public class PoolablePreparedStatement
extends DelegatingPreparedStatement
implements PreparedStatement {
    protected Connection _conn = null;
    protected KeyedObjectPool _pool = null;
    protected Object _key = null;

    public PoolablePreparedStatement(PreparedStatement stmt, Object key, KeyedObjectPool pool, Connection conn) {
        super((DelegatingConnection)conn, stmt);
        this._pool = pool;
        this._key = key;
        this._conn = conn;
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Already closed");
        }
        try {
            this._pool.returnObject(this._key, (Object)this);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLNestedException("Cannot close preparedstatement (return to pool failed)", e);
        }
    }

    public Connection getConnection() throws SQLException {
        return null == this._conn ? this._stmt.getConnection() : this._conn;
    }
}

