/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.parserapplications;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLParser;
import org.htmlparser.HTMLReader;
import org.htmlparser.tags.HTMLAppletTag;
import org.htmlparser.tags.HTMLFormTag;
import org.htmlparser.tags.HTMLFrameTag;
import org.htmlparser.tags.HTMLJspTag;
import org.htmlparser.tags.HTMLMetaTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.tags.HTMLTitleTag;
import org.htmlparser.util.DefaultHTMLParserFeedback;
import org.htmlparser.util.HTMLEnumeration;
import org.htmlparser.util.HTMLParserFeedback;

public class TestGetHTML {
    public static String getStr(String _strSrc, String _encoding) {
        if (_encoding == null || _encoding.length() == 0) {
            return _strSrc;
        }
        try {
            byte[] byteStr = new byte[_strSrc.length()];
            _strSrc.getBytes(0, _strSrc.length(), byteStr, 0);
            String string = new String(byteStr, _encoding);
            return string;
        }
        catch (Exception ex) {
            String string = _strSrc;
            return string;
        }
    }

    public void getHTML(String _sUrl) throws Exception {
        HTMLParser parser = new HTMLParser(_sUrl, (HTMLParserFeedback)new DefaultHTMLParserFeedback());
        parser.registerScanners();
        int nStartPose = -1;
        int nEndPose = 0;
        int nCurrLine = 1;
        boolean bNewLine = true;
        String sPreHTML = "";
        HTMLEnumeration e = parser.elements();
        while (e.hasMoreNodes()) {
            int i;
            HTMLNode node = e.nextHTMLNode();
            if (sPreHTML.indexOf(HTMLNode.getLineSeparator()) < 0 && nCurrLine != node.getLine()) {
                System.out.print("\n");
                for (i = 0; i < node.elementBegin(); ++i) {
                    System.out.print(" ");
                }
            }
            nCurrLine = node.getLine();
            nStartPose = node.elementBegin();
            for (i = nEndPose + 1; i < nStartPose; ++i) {
                System.out.print(" ");
            }
            nEndPose = node.elementEnd();
            sPreHTML = node.toHTML();
            System.out.print(sPreHTML);
        }
    }

    public static boolean writeFile(String _sFileName, String _sFileContent, String _encoding) throws Exception {
        boolean bRet = false;
        try {
            int BUFFER = 2048;
            FileOutputStream fos = new FileOutputStream(_sFileName);
            BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
            OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)dest, _encoding);
            outWriter.write(_sFileContent);
            ((Writer)outWriter).flush();
            ((Writer)outWriter).close();
            dest.close();
            fos.close();
            bRet = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bRet;
    }

    private boolean dowithHTMLTag(HTMLTag _currTag, Vector _vImgRecs, boolean _bRecopyAllPics) {
        ImgRec imgRec;
        if (_currTag == null || _currTag.getTagName() == null) {
            return false;
        }
        String sTagName = _currTag.getTagName().toUpperCase();
        String sSrcName = "";
        if (sTagName.equals("IMG")) {
            sSrcName = "SRC";
        } else if (sTagName.equals("BODY") && _currTag.getAttributeValue("BACKGROUND") != null) {
            sSrcName = "BACKGROUND";
        } else if (sTagName.equals("TD") && _currTag.getAttributeValue("BACKGROUND") != null) {
            sSrcName = "BACKGROUND";
        } else if (sTagName.equals("INPUT") && _currTag.getAttributeValue("TYPE") != null && _currTag.getAttributeValue("TYPE").equals("IMAGE")) {
            sSrcName = "SRC";
        } else if (sTagName.equals("LINK") && _currTag.getAttributeValue("HREF") != null) {
            sSrcName = "HREF";
        } else if (sTagName.equals("SCRIPT") && _currTag.getAttributeValue("SRC") != null) {
            sSrcName = "SRC";
        } else if (sTagName.equals("TABLE") && _currTag.getAttributeValue("BACKGROUND") != null) {
            sSrcName = "BACKGROUND";
        } else {
            return false;
        }
        String sImgSrc = _currTag.getAttributeValue(sSrcName);
        if (sImgSrc == null || sImgSrc.trim().length() <= 0) {
            return false;
        }
        boolean bAddAppendix = true;
        for (int i = 0; i < _vImgRecs.size(); ++i) {
            imgRec = (ImgRec)_vImgRecs.get(i);
            if (sImgSrc.compareToIgnoreCase(imgRec.src) != 0) continue;
            bAddAppendix = false;
            if (_bRecopyAllPics || _currTag.getAttributeValue("OLDSRC") == null) {
                _currTag.setAttribute("OLDSRC", imgRec.oldSrc);
                _currTag.setAttribute("OLDID", String.valueOf(imgRec.oldId));
            }
            return true;
        }
        String sFileName = null;
        if (_currTag.getAttributeValue("OLDSRC") != null) {
            sFileName = _currTag.getAttributeValue("OLDSRC");
            if (!_bRecopyAllPics) {
                bAddAppendix = false;
                imgRec = new ImgRec(this);
                imgRec.src = sImgSrc;
                imgRec.oldSrc = sFileName;
                try {
                    imgRec.oldId = Integer.parseInt(_currTag.getAttributeValue("OLDID"));
                }
                catch (Exception ex) {
                    imgRec.oldId = 0;
                }
                _vImgRecs.add(imgRec);
            }
        } else {
            sFileName = _currTag.getAttributeValue("UPLOADPIC") != null ? _currTag.getAttributeValue("UPLOADPIC") : sImgSrc;
        }
        if (bAddAppendix && sFileName != null) {
            _currTag.setAttribute("OLDSRC", sFileName);
            imgRec = new ImgRec(this);
            imgRec.src = sImgSrc;
            imgRec.oldSrc = sFileName;
            _vImgRecs.add(imgRec);
        }
        _currTag.setAttribute(sSrcName, sFileName == null ? "" : sFileName);
        return true;
    }

    private boolean setHtmlContent(String _htmlContent, boolean _bRecopyAllPics) throws Exception {
        String sPre = "HTMLContent_".concat(String.valueOf(String.valueOf(System.currentTimeMillis())));
        File currFile = File.createTempFile(sPre, "HTML");
        String sContentFileName = currFile.getPath();
        TestGetHTML.writeFile(sContentFileName, _htmlContent, "GBK");
        StringBuffer sbHtmlContent = new StringBuffer(_htmlContent.length() + 200);
        Vector vImgRecs = new Vector();
        boolean nVersion = false;
        try {
            HTMLParser parser = new HTMLParser(sContentFileName);
            parser.registerScanners();
            int nStartPose = -1;
            int nEndPose = 0;
            int nCurrLine = 1;
            boolean bNewLine = true;
            String sPreHTML = "";
            HTMLEnumeration e = parser.elements();
            while (e.hasMoreNodes()) {
                HTMLNode node = e.nextHTMLNode();
                if (sPreHTML.indexOf(HTMLNode.getLineSeparator()) < 0 && nCurrLine != node.getLine()) {
                    sbHtmlContent.append(HTMLNode.getLineSeparator());
                }
                nCurrLine = node.getLine();
                nStartPose = node.elementBegin();
                for (int i = nEndPose; i < nStartPose; ++i) {
                    sbHtmlContent.append(" ");
                }
                nEndPose = node.elementEnd();
                sPreHTML = node.toHTML();
                if (node instanceof HTMLTag) {
                    if (this.dowithHTMLTag((HTMLTag)node, vImgRecs, _bRecopyAllPics)) {
                        sbHtmlContent.append(((HTMLTag)node).toStrictHTML());
                        continue;
                    }
                    sbHtmlContent.append(sPreHTML);
                    continue;
                }
                sbHtmlContent.append(sPreHTML);
            }
            TestGetHTML.writeFile("d:\\result.html", sbHtmlContent.toString(), "GBK");
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
    }

    public static int getRandNum(int _nBase) {
        String sRand = String.valueOf(Math.random());
        sRand = sRand.substring(sRand.length() - 2);
        return Math.abs(Integer.parseInt(sRand) % _nBase);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFile(String _sFileName) throws Exception {
        Object file = null;
        InputStreamReader fileReader = null;
        StringBuffer buffContent = null;
        try {
            try {
                String sLine;
                FileInputStream fis = new FileInputStream(_sFileName);
                BufferedReader buffReader = new BufferedReader(new InputStreamReader((InputStream)fis, "GBK"));
                while ((sLine = buffReader.readLine()) != null) {
                    if (buffContent == null) {
                        buffContent = new StringBuffer();
                    } else {
                        buffContent.append("\n");
                    }
                    buffContent.append(sLine);
                }
                buffReader.close();
                fis.close();
                String string = buffContent == null ? "" : buffContent.toString();
                Object var9_10 = null;
                if (fileReader == null) return string;
                try {
                    fileReader.close();
                    return string;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return string;
            }
            catch (FileNotFoundException ex) {
                throw new Exception("\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230(CMyFile.readFile)");
            }
            catch (IOException ex) {
                throw new Exception("\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef(CMyFile.readFile)");
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (fileReader == null) throw throwable;
            try {}
            catch (Exception exception) {
                throw throwable;
            }
            fileReader.close();
            throw throwable;
        }
    }

    public String getTextWithImgFilter(String _sFileName, String _sImgSrcPre, boolean _bRemoveExtraAttribute) throws Exception {
        StringBuffer sbHtmlContent = new StringBuffer();
        BufferedReader currFileReader = null;
        try {
            try {
                currFileReader = new BufferedReader(new FileReader(_sFileName));
                HTMLParser parser = new HTMLParser(new HTMLReader((Reader)currFileReader, _sFileName), (HTMLParserFeedback)new DefaultHTMLParserFeedback());
                parser.registerScanners();
                int nStartPose = -1;
                int nEndPose = 0;
                int nCurrLine = 1;
                boolean bNewLine = true;
                String sPreHTML = "";
                HTMLEnumeration e = parser.elements();
                while (e.hasMoreNodes()) {
                    int i;
                    HTMLNode node = e.nextHTMLNode();
                    if (sPreHTML.indexOf(HTMLNode.getLineSeparator()) < 0 && nCurrLine != node.getLine()) {
                        sbHtmlContent.append(HTMLNode.getLineSeparator());
                        for (i = 0; i < node.elementBegin(); ++i) {
                            sbHtmlContent.append(" ");
                        }
                    }
                    nCurrLine = node.getLine();
                    nStartPose = node.elementBegin();
                    for (i = nEndPose + 1; i < nStartPose; ++i) {
                        sbHtmlContent.append(" ");
                    }
                    nEndPose = node.elementEnd();
                    sPreHTML = node.toHTML();
                    if (!(!(node instanceof HTMLTag) || node instanceof HTMLAppletTag || node instanceof HTMLFormTag || node instanceof HTMLFrameTag || node instanceof HTMLJspTag || node instanceof HTMLMetaTag || node instanceof HTMLTitleTag)) {
                        HTMLTag currTag = (HTMLTag)node;
                        String strSrc = currTag.getAttributeValue("OLDSRC");
                        if (strSrc != null) {
                            strSrc = String.valueOf(String.valueOf(_sImgSrcPre)).concat(String.valueOf(String.valueOf(strSrc)));
                            if (currTag.getAttributeValue("SRC") != null) {
                                currTag.setAttribute("SRC", strSrc);
                            } else if (currTag.getAttributeValue("BACKGROUND") != null) {
                                currTag.setAttribute("BACKGROUND", strSrc);
                            } else if (currTag.getAttributeValue("HREF") != null) {
                                currTag.setAttribute("HREF", strSrc);
                            } else {
                                currTag.setAttribute("SRC", strSrc);
                            }
                            if (_bRemoveExtraAttribute) {
                                currTag.removeAttribute("OLDSRC");
                                currTag.removeAttribute("OLDID");
                                currTag.removeAttribute("RELATED");
                                currTag.removeAttribute("UPLOADPIC");
                            }
                            sbHtmlContent.append(currTag.toStrictHTML());
                            continue;
                        }
                        sbHtmlContent.append(sPreHTML);
                        continue;
                    }
                    sbHtmlContent.append(sPreHTML);
                }
                Object var17_18 = null;
                return sbHtmlContent.toString();
            }
            catch (Exception ex) {
                System.out.println("\u4f7f\u7528\u56fe\u7247\u8fc7\u6ee4\u5668\u63d0\u53d6\u6a21\u677f\u6b63\u6587\u5185\u5bb9\u5931\u8d25(Template.getTextWithImgFilter)");
                ex.printStackTrace();
                Object var17_19 = null;
                return sbHtmlContent.toString();
            }
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            return sbHtmlContent.toString();
        }
    }

    public static void main(String[] args) {
        TestGetHTML testGetHTML1 = new TestGetHTML();
        try {
            String sFileName = "d:\\test.html";
            testGetHTML1.getHTML(sFileName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public class ImgRec {
        public String src;
        public String oldSrc;
        public int oldId = 0;

        public ImgRec(TestGetHTML this$0) {
        }
    }
}

