/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.stat;

import dm.jdbc.b.i;
import dm.jdbc.filter.stat.StatService;
import dm.jdbc.filter.stat.util.TableFormator;
import dm.jdbc.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class StatReader {
    private static final String[] sqlRowTitle = new String[]{"", "Connection", "SQL", "ExecCount", "ExecTime", "ExecMax", "Txn", "Error", "Update", "FetchRow", "Running", "Concurrent", "ExecHisto", "ExecRsHisto", "FetchRowHisto", "UpdateHisto"};
    private static final String[] sqlRowField = new String[]{"rowNum", "DataSource", "SQL", "ExecuteCount", "TotalTime", "MaxTimespan", "InTransactionCount", "ErrorCount", "EffectedRowCount", "FetchRowCount", "RunningCount", "ConcurrentMax", "ExecuteHoldTimeHistogram", "ExecuteAndResultHoldTimeHistogram", "FetchRowCountHistogram", "EffectedRowCountHistogram"};
    private static final String[] sqlColField = new String[]{"ID", "DataSource", "SQL", "ExecuteCount", "ErrorCount", "TotalTime", "LastTime", "MaxTimespan", "LastError", "EffectedRowCount", "FetchRowCount", "MaxTimespanOccurTime", "BatchSizeMax", "BatchSizeTotal", "ConcurrentMax", "RunningCount", "Name", "File", "LastErrorMessage", "LastErrorClass", "LastErrorStackTrace", "LastErrorTime", "DbType", "URL", "InTransactionCount", "Histogram", "LastSlowParameters", "ResultSetHoldTime", "ExecuteAndResultSetHoldTime", "FetchRowCountHistogram", "EffectedRowCountHistogram", "ExecuteAndResultHoldTimeHistogram", "EffectedRowCountMax", "FetchRowCountMax", "ClobOpenCount"};
    private static final String[] dsRowTitle = new String[]{"", "Connection", "ActiveConnCount", "MaxActiveConnCount", "ActiveStmtCount", "MaxActiveStmtCount", "ExecuteCount", "ErrorCount", "CommitCount", "RollbackCount"};
    private static final String[] dsRowField = new String[]{"rowNum", "Url", "ActiveConnCount", "MaxActiveConnCount", "ActiveStmtCount", "MaxActiveStmtCount", "ExecuteCount", "ErrorCount", "CommitCount", "RollbackCount"};
    private static final String[] dsColField = new String[]{"ID", "ConnCount", "ActiveConnCount", "MaxActiveConnCount", "StmtCount", "ActiveStmtCount", "MaxActiveStmtCount", "ExecuteCount", "ErrorCount", "CommitCount", "RollbackCount", "ClobOpenCount", "BlobOpenCount"};
    private List connStat;
    private int[] connStatColLens;
    private List highFreqSqlStat;
    private int[] highFreqSqlStatColLens;
    private List slowSqlStat;
    private int[] slowSqlStatColLens;

    public boolean readConnStat(List list, int n2) {
        String[] stringArray = dsRowTitle;
        String[] stringArray2 = dsRowField;
        boolean bl = false;
        if (this.connStat == null) {
            this.connStat = this.getConnStat(null, stringArray, stringArray2);
            this.connStatColLens = TableFormator.calcColLens(this.connStat, stringArray, 32);
            bl = false;
        } else {
            bl = true;
        }
        List list2 = null;
        if (n2 > 0 && this.connStat.size() > n2) {
            list2 = this.connStat.subList(0, n2);
            this.connStat = this.connStat.subList(n2, this.connStat.size());
        } else {
            list2 = this.connStat;
            this.connStat = null;
        }
        list.add(this.getFormattedOutput(list2, stringArray2, this.connStatColLens, bl));
        return this.connStat != null;
    }

    public boolean readHighFreqSqlStat(List list, int n2) {
        boolean bl = false;
        if (this.highFreqSqlStat == null) {
            this.highFreqSqlStat = this.getHighFreqSqlStat(i.eq.eB, -1, sqlRowTitle, sqlRowField);
            this.highFreqSqlStatColLens = TableFormator.calcColLens(this.highFreqSqlStat, sqlRowTitle, 32);
            bl = false;
        } else {
            bl = true;
        }
        List list2 = null;
        if (n2 > 0 && this.highFreqSqlStat.size() > n2) {
            list2 = this.highFreqSqlStat.subList(0, n2);
            this.highFreqSqlStat = this.highFreqSqlStat.subList(n2, this.highFreqSqlStat.size());
        } else {
            list2 = this.highFreqSqlStat;
            this.highFreqSqlStat = null;
        }
        list.add(this.getFormattedOutput(list2, sqlRowField, this.highFreqSqlStatColLens, bl));
        return this.highFreqSqlStat != null;
    }

    public List getHighFreqSqlStat(int n2, int n3, String[] stringArray, String[] stringArray2) {
        Properties properties = new Properties();
        properties.put("field", "ExecuteCount");
        properties.put("direction", "desc");
        properties.put("pageNum", "1");
        properties.put("pageSize", String.valueOf(n2));
        ArrayList arrayList = StatService.getInstance().service("/sql.json", properties);
        if (n3 != -1) {
            ArrayList<Map> arrayList2 = new ArrayList<Map>();
            for (Map map : arrayList) {
                Integer n4 = (Integer)map.get("ID");
                if (n4 != n3) continue;
                arrayList2.add(map);
                break;
            }
            arrayList = arrayList2;
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        } else {
            int n5 = 1;
            for (Map map : arrayList) {
                map.put("rowNum", n5);
                ++n5;
            }
        }
        TableFormator.addTitles(arrayList, stringArray, stringArray2);
        return arrayList;
    }

    public boolean readSlowSqlStat(List list, int n2) {
        boolean bl = false;
        if (this.slowSqlStat == null) {
            this.slowSqlStat = this.getSlowSqlStat(i.eq.eA, -1, sqlRowTitle, sqlRowField);
            this.slowSqlStatColLens = TableFormator.calcColLens(this.slowSqlStat, sqlRowTitle, 32);
            bl = false;
        } else {
            bl = true;
        }
        List list2 = null;
        if (n2 > 0 && this.slowSqlStat.size() > n2) {
            list2 = this.slowSqlStat.subList(0, n2);
            this.slowSqlStat = this.slowSqlStat.subList(n2, this.slowSqlStat.size());
        } else {
            list2 = this.slowSqlStat;
            this.slowSqlStat = null;
        }
        list.add(this.getFormattedOutput(list2, sqlRowField, this.slowSqlStatColLens, bl));
        return this.slowSqlStat != null;
    }

    private List getSlowSqlStat(int n2, int n3, String[] stringArray, String[] stringArray2) {
        Properties properties = new Properties();
        properties.put("field", "MaxTimespan");
        properties.put("direction", "desc");
        properties.put("pageNum", "1");
        properties.put("pageSize", String.valueOf(n2));
        ArrayList arrayList = StatService.getInstance().service("/sql.json", properties);
        if (n3 != -1) {
            ArrayList<Map> arrayList2 = new ArrayList<Map>();
            for (Map map : arrayList) {
                Integer n4 = (Integer)map.get("ID");
                if (n4 != n3) continue;
                arrayList2.add(map);
                break;
            }
            arrayList = arrayList2;
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        } else {
            int n5 = 1;
            for (Map map : arrayList) {
                map.put("rowNum", n5);
                ++n5;
            }
        }
        TableFormator.addTitles(arrayList, stringArray, stringArray2);
        return arrayList;
    }

    private List getConnStat(String string, String[] stringArray, String[] stringArray2) {
        ArrayList arrayList = StatService.getInstance().service("/dataSource.json");
        if (StringUtil.isNotEmpty(string)) {
            ArrayList<Map> arrayList2 = new ArrayList<Map>();
            for (Map map : arrayList) {
                String string2 = map.get("Identity").toString();
                if (!string.equals(string2)) continue;
                arrayList2.add(map);
                break;
            }
            arrayList = arrayList2;
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        } else {
            int n2 = 1;
            for (Map map : arrayList) {
                map.put("rowNum", n2);
                ++n2;
            }
        }
        TableFormator.addTitles(arrayList, stringArray, stringArray2);
        return arrayList;
    }

    private String getFormattedOutput(List list, String[] stringArray, int[] nArray, boolean bl) {
        return TableFormator.toTable(list, stringArray, nArray, true, bl);
    }
}

