/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.stat;

import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.filter.stat.ConnectionStat;
import dm.jdbc.filter.stat.JdbcStat$1;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class JdbcStat {
    private LinkedHashMap connStatMap;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private int maxConnSize = 1000;
    private AtomicLong skipConnCount = new AtomicLong();

    public JdbcStat(int n2) {
        if (n2 > 0) {
            this.maxConnSize = n2;
        }
        this.connStatMap = new JdbcStat$1(this, 16, 0.75f, false);
    }

    public ConnectionStat createConnStat(DmdbConnection dmdbConnection) {
        String string = String.valueOf(dmdbConnection.connection_property_host) + ":" + dmdbConnection.connection_property_port;
        this.lock.writeLock().lock();
        try {
            ConnectionStat connectionStat = (ConnectionStat)this.connStatMap.get(string);
            if (connectionStat == null) {
                connectionStat = new ConnectionStat(string);
                connectionStat.setProperties(dmdbConnection.eo.toString());
                this.connStatMap.put(string, connectionStat);
            }
            ConnectionStat connectionStat2 = connectionStat;
            return connectionStat2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Map getConnStatMap() {
        LinkedHashMap linkedHashMap = new LinkedHashMap(this.connStatMap.size());
        this.lock.readLock().lock();
        try {
            linkedHashMap.putAll(this.connStatMap);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return linkedHashMap;
    }

    static /* synthetic */ int access$0(JdbcStat jdbcStat) {
        return jdbcStat.maxConnSize;
    }

    static /* synthetic */ AtomicLong access$1(JdbcStat jdbcStat) {
        return jdbcStat.skipConnCount;
    }
}

