/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.b.j;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbResultSetKey;
import dm.jdbc.driver.DmdbStatement;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DmdbResultSetCachePool {
    static Map iO = null;
    static List iP = null;
    static long iQ;

    static {
        iO = Collections.synchronizedMap(new HashMap(100));
        iP = Collections.synchronizedList(new LinkedList());
        iQ = 0L;
    }

    private static long removeLast() {
        int n2 = iP.size();
        if (n2 == 0) {
            return 0L;
        }
        DmdbResultSetKey dmdbResultSetKey = (DmdbResultSetKey)iP.remove(n2 - 1);
        if (dmdbResultSetKey == null) {
            return 0L;
        }
        DmdbResultSetCache dmdbResultSetCache = (DmdbResultSetCache)iO.remove(dmdbResultSetKey);
        if (dmdbResultSetCache == null) {
            return 0L;
        }
        return dmdbResultSetCache.getDataLen();
    }

    private static void refreshKeyList(DmdbResultSetKey dmdbResultSetKey) {
        iP.remove(dmdbResultSetKey);
        iP.add(0, dmdbResultSetKey);
    }

    public static void addResultSet(DmdbStatement dmdbStatement, String string, j j2) {
        DmdbConnection dmdbConnection = dmdbStatement.connection;
        long l2 = j2 == null ? 0L : j2.eL;
        long l3 = dmdbConnection.connection_property_rsCacheSize * 1024 * 1024;
        while (iQ + l2 > l3) {
            if (iQ == 0L) {
                return;
            }
            iQ -= DmdbResultSetCachePool.removeLast();
        }
        DmdbResultSetKey dmdbResultSetKey = new DmdbResultSetKey(dmdbConnection.gA, dmdbConnection.gz, string, dmdbStatement);
        DmdbResultSetCachePool.refreshKeyList(dmdbResultSetKey);
        DmdbResultSetCache dmdbResultSetCache = new DmdbResultSetCache(j2);
        iO.put(dmdbResultSetKey, dmdbResultSetCache);
        iQ += l2;
    }

    public static DmdbResultSetCache getResultSetCache(String string, String string2, String string3, DmdbStatement dmdbStatement) {
        DmdbResultSetKey dmdbResultSetKey = new DmdbResultSetKey(string, string2, string3, dmdbStatement);
        DmdbResultSetCache dmdbResultSetCache = (DmdbResultSetCache)iO.get(dmdbResultSetKey);
        if (dmdbResultSetCache == null) {
            return null;
        }
        if (dmdbResultSetCache.refreshed(dmdbStatement.connection)) {
            iO.remove(dmdbResultSetKey);
            iP.remove(dmdbResultSetKey);
            return null;
        }
        DmdbResultSetCachePool.refreshKeyList(dmdbResultSetKey);
        return dmdbResultSetCache;
    }
}

