/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import java.io.OutputStream;
import java.sql.SQLException;

public class DmdbOutputStream
extends OutputStream {
    public static final int IS_BLOB = 0;
    public static final int IS_CLOB = 1;
    private DmdbBlob ij;
    private DmdbClob ik;
    private int hz;
    private long il = 0L;

    public DmdbOutputStream(Object object, long l2) {
        if (object instanceof DmdbBlob) {
            this.ij = (DmdbBlob)object;
            this.hz = 0;
        } else if (object instanceof DmdbClob) {
            this.ik = (DmdbClob)object;
            this.hz = 1;
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        }
        this.il = l2;
    }

    @Override
    public void write(int n2) {
        byte[] byArray = new byte[]{(byte)n2};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n2 < 0) {
            DBError.throwIOException("off IndexOutOfBounds :" + n2);
        }
        if (n3 < 0) {
            DBError.throwIOException("len IndexOutOfBounds :" + n3);
        }
        if (n2 + n3 > byArray.length) {
            DBError.throwIOException("off + len IndexOutOfBounds :" + n2 + n3);
        }
        try {
            if (this.hz == 0) {
                this.ij.do_setBytes(this.il, byArray, n2, n3);
                this.il += (long)n3;
            } else if (this.hz == 1) {
                char[] cArray = new char[n3];
                int n4 = 0;
                while (n4 < n3) {
                    cArray[n4] = (char)byArray[n4 + n2];
                    ++n4;
                }
                String string = new String(cArray);
                this.ik.do_setString(this.il, string);
                this.il += (long)string.length();
            } else {
                DBError.throwIOException("Fatal error occured in DmdbOutputStream ");
            }
        }
        catch (SQLException sQLException) {
            DBError.throwIOException(sQLException.getMessage());
        }
    }
}

