/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.maps;

import org.xmlmiddleware.conversions.formatters.StringFormatter;
import org.xmlmiddleware.db.JDBCTypes;
import org.xmlmiddleware.xmldbms.maps.MapBase;

public class Column
extends MapBase {
    private String name;
    private int resultSetIndex;
    private int type;
    private int length;
    private int precision;
    private int scale;
    private int nullability;
    private StringFormatter formatter;
    private boolean precisionExists = false;
    private boolean scaleExists = false;
    private boolean lengthExists = false;

    private Column(String string) {
        this.name = string;
        this.resetMetadata();
    }

    public static Column create(String string) {
        MapBase.checkArgNull(string, "columnName");
        return new Column(string);
    }

    public final String getName() {
        return this.name;
    }

    public final int getResultSetIndex() {
        return this.resultSetIndex;
    }

    public void setResultSetIndex(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Result set index must be >= 1");
        }
        this.resultSetIndex = n;
    }

    public final int getType() {
        return this.type;
    }

    public void setType(int n) {
        if (!JDBCTypes.typeIsValid(n)) {
            throw new IllegalArgumentException("Invalid JDBC type: " + n);
        }
        if (!JDBCTypes.typeIsChar(n) && !JDBCTypes.typeIsBinary(n)) {
            this.length = -1;
        }
        if (n != 3 && n != 2) {
            this.precision = -1;
            this.scale = Integer.MIN_VALUE;
        }
        this.type = n;
    }

    public final boolean lengthExists() {
        return this.lengthExists;
    }

    public final int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Length must be >= 1");
        }
        this.length = n;
        this.lengthExists = true;
    }

    public final boolean precisionExists() {
        return this.precisionExists;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Precision must be >= 1");
        }
        this.precision = n;
        this.precisionExists = true;
    }

    public final boolean scaleExists() {
        return this.scaleExists;
    }

    public final int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
        this.scaleExists = true;
    }

    public final int getNullability() {
        return this.nullability;
    }

    public void setNullability(int n) {
        if (n != 2 && n != 1 && n != 0) {
            throw new IllegalArgumentException("Invalid nullability value: " + n);
        }
        this.nullability = n;
    }

    public final StringFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(StringFormatter stringFormatter) {
        MapBase.checkArgNull(stringFormatter, "formatter");
        this.formatter = stringFormatter;
    }

    public void resetMetadata() {
        this.resultSetIndex = -1;
        this.type = 0;
        this.length = -1;
        this.precision = -1;
        this.scale = Integer.MIN_VALUE;
        this.nullability = 2;
        this.formatter = null;
    }

    public boolean isMetadataSet() {
        if (this.resultSetIndex == -1) {
            return false;
        }
        if (this.type == 0) {
            return false;
        }
        if ((JDBCTypes.typeIsChar(this.type) || JDBCTypes.typeIsBinary(this.type)) && this.length == -1) {
            return false;
        }
        if (this.type == 3 || this.type == 2) {
            if (this.precision == -1) {
                return false;
            }
            if (this.scale == Integer.MIN_VALUE) {
                return false;
            }
        }
        return this.formatter != null;
    }
}

