/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.conversions.formatters;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.xmlmiddleware.conversions.formatters.StringFormatter;
import org.xmlmiddleware.utils.XMLMiddlewareException;

public class DateFormatter
implements StringFormatter {
    private DateFormat formatter;

    public DateFormatter(DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new IllegalArgumentException("formatter argument must be non-null");
        }
        this.formatter = dateFormat;
    }

    public Object parse(String string, int n) throws XMLMiddlewareException {
        Date date;
        try {
            date = this.formatter.parse(string);
        }
        catch (ParseException parseException) {
            throw new XMLMiddlewareException(parseException);
        }
        switch (n) {
            case -4: 
            case -3: 
            case -2: {
                throw new XMLMiddlewareException("Conversion to binary types not supported.");
            }
            case -1: 
            case 1: 
            case 12: {
                throw new XMLMiddlewareException("Use an implementation of StringFormatter to convert to strings.");
            }
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                throw new XMLMiddlewareException("Conversion to numeric types not supported.");
            }
            case 91: {
                return new java.sql.Date(date.getTime());
            }
            case 92: {
                return new Time(date.getTime());
            }
            case 93: {
                return new Timestamp(date.getTime());
            }
        }
        throw new XMLMiddlewareException("Conversion to specified JDBC type not supported.");
    }

    public String format(Object object) throws XMLMiddlewareException {
        if (object instanceof Date) {
            return this.formatter.format((Date)object);
        }
        throw new XMLMiddlewareException("Object must be a Date.");
    }

    public boolean canConvert(int n) {
        return n == 91 || n == 92 || n == 93;
    }

    public DateFormat getDateFormat() {
        return this.formatter;
    }
}

