/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.DefaultObj;
import com.trs.cms.content.DefaultObjs;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.metadata.publish.PublishContentViewDataImpl;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.components.wcm.publish.tagparser.WCMDocumentImagesGenerator;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class XWCMContImgsTagParser
extends BaseTagParser4List {
    private static Logger logger = Logger.getLogger(XWCMContImgsTagParser.class);
    protected static TagBeanInfo m_sTagBeanInfo = null;
    private List m_ContentImages;
    private Document m_oDocument;
    private int m_nCurrPos = 0;
    private IPublishContent m_oCurrContent;
    private PublishTagContext m_nextRecordContext = null;
    private Map hmImages = new HashMap();

    @Override
    public TagBeanInfo getBeanInfo() {
        if (m_sTagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_CONTIMGS");
            tbi.setDesc("TRS_CONTIMGS");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("OWNER");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("STARTPOS");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NUM");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MINWIDTH");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MINHEIGHT");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ONLYFROM");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"content", "appendix"});
            tbai.setDefaultValue("content");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIRSTFROM");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"content", "appendix"});
            tbai.setDefaultValue("");
            tbi.addAttrInfo(tbai);
            m_sTagBeanInfo = tbi;
        }
        return m_sTagBeanInfo;
    }

    @Override
    public void setStartPos(int _nPos) {
        this.m_nCurrPos = _nPos;
    }

    @Override
    public int getRecordSize() {
        return this.m_ContentImages == null ? 0 : this.m_ContentImages.size();
    }

    @Override
    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            DefaultObj oImage = (DefaultObj)this.m_ContentImages.get(this.m_nCurrPos++);
            IPublishContent publishElement = this.m_oCurrContent;
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(publishElement);
            this.hmImages.put("IMAGE", oImage);
            this.m_nextRecordContext.setExtraAttributes(this.hmImages);
            return this.m_nextRecordContext;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, ex);
        }
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        if (!_context.getTagItem().hasChildren()) {
            return null;
        }
        if (!this.isValidate(_context)) {
            return null;
        }
        CMSBaseObjs oDefaultObjects = this.findObjects(_context);
        this.m_ContentImages = new ArrayList(oDefaultObjects.size());
        int nSize = oDefaultObjects.size();
        for (int i = 0; i < nSize; ++i) {
            DefaultObj element = (DefaultObj)oDefaultObjects.getAt(i);
            if (element == null) continue;
            this.m_ContentImages.add(element);
        }
        this.m_nextRecordContext = new PublishTagContext(_context, _context.getTagItem(), this);
        String[] results = TagParseHelper.parse4List(_context.getTagItem(), _context, this);
        return results;
    }

    @Override
    protected CMSBaseObjs findObjects(PublishTagContext _context) throws WCMException {
        int nNum = _context.getAttribute("NUM", 20);
        if (_context.getUpperHost() instanceof PublishContentViewDataImpl) {
            this.m_oCurrContent = (IPublishContent)_context.getUpperHost();
            String sFieldName = _context.getAttribute("Field");
            CMSObj obj = _context.getUpperHost().getSubstance();
            String sFieldValue = obj.getPropertyAsString(sFieldName, "");
            DefaultObjs images = WCMDocumentImagesGenerator.getImagesFromHtmlContent(_context, sFieldValue, nNum);
            return images;
        }
        String sId = _context.getAttribute("ID");
        if (CMyString.isEmpty(sId) || "OWNER".equalsIgnoreCase(sId)) {
            IPublishElement publishElement = _context.getUpperHost();
            if (!(publishElement instanceof PublishContentDocumentImpl)) {
                throw new WCMException(200006, "\u5f53\u524dUpperHost\u4e0d\u662fDocument\uff01");
            }
            this.m_oCurrContent = (IPublishContent)publishElement;
            this.m_oDocument = (Document)this.m_oCurrContent.getSubstance();
        } else {
            this.m_oDocument = Document.findById(Integer.parseInt(sId));
            if (this.m_oDocument == null) {
                throw new WCMException(200006, "\u6ca1\u6709\u627e\u5230\u6240\u5c5e\u7684\u6587\u6863\uff01");
            }
            this.m_oCurrContent = (IPublishContent)PublishElementFactory.makeElementFrom(this.m_oDocument);
        }
        DefaultObjs images = WCMDocumentImagesGenerator.getDocumentImages(_context, this.m_oDocument, nNum);
        return images;
    }

    @Override
    protected boolean isValidate(PublishTagContext _context) throws WCMException {
        String sId = _context.getAttribute("ID");
        return CMyString.isEmpty(sId) || sId.indexOf(",") <= -1;
    }
}

