/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.advisor;

import com.trs.components.wcm.advisor.AdvisorXmlConverter;
import com.trs.components.wcm.advisor.Advisors;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyZip;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class AdvisorExporter {
    private static Logger logger = Logger.getLogger(AdvisorExporter.class);

    public String export(Advisors advisors) throws WCMException {
        if (advisors == null || advisors.isEmpty()) {
            throw new WCMException(10, "\u6ca1\u6709\u6307\u5b9a\u8981\u5bfc\u51fa\u7684\u987e\u95ee!");
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String sTempZipFile = filesMan.getNextFileName("ST", "zip", null, true);
        ArrayList lstExportFiles = new ArrayList();
        AdvisorXmlConverter advisorXmlConverter = new AdvisorXmlConverter(lstExportFiles);
        String sTempXmlFile = filesMan.getNextFileName("ST", "xml", null, true);
        advisorXmlConverter.toXMLFile(advisors, sTempXmlFile);
        CMyZip oMyZip = new CMyZip();
        try {
            oMyZip.setZipFileName(sTempZipFile);
            oMyZip.addToZip(sTempXmlFile, false);
            List listExportFiles = advisorXmlConverter.getExportFiles();
            int length = listExportFiles.size();
            for (int i = 0; i < length; ++i) {
                String sFileName = (String)listExportFiles.get(i);
                if (!CMyFile.fileExists(sFileName)) {
                    logger.error((Object)CMyString.format("\u5bfc\u51fa\u987e\u95ee\u56fe\u7247\u65f6\u56fe\u7247\u4e0d\u5b58\u5728[{0}]", new String[]{sFileName}));
                }
                oMyZip.addToZip((String)listExportFiles.get(i), false);
            }
            oMyZip.done();
        }
        catch (CMyException e) {
            throw new WCMException(54, "\u521b\u5efaZip\u6587\u4ef6\u5931\u8d25!", e);
        }
        finally {
            CMyFile.deleteFile(sTempXmlFile);
        }
        return CMyFile.extractFileName(sTempZipFile);
    }
}

