/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;

public class TimeRange {
    public static final int STEP_DAY = 1;
    public static final int STEP_MONTH = 2;
    public static final int STEP_YEAR = 3;
    public static final int STEP_QUARTER = 4;
    private CMyDateTime mStartDate;
    private CMyDateTime mEndDate;
    private CMyDateTime mCurrRangeStartDate;
    private CMyDateTime mCurrRangeEndDate;
    private int mStepType;

    public TimeRange(CMyDateTime startDate, CMyDateTime endDate, int nStepType) {
        this.mStartDate = new CMyDateTime(startDate.getTimeInMillis());
        this.mEndDate = new CMyDateTime(endDate.getTimeInMillis());
        this.mStepType = nStepType;
        this.mCurrRangeStartDate = (CMyDateTime)this.mStartDate.clone();
        this.mCurrRangeEndDate = (CMyDateTime)this.mStartDate.clone();
    }

    public boolean next() throws CMyException {
        this.countRangeTime();
        return this.mCurrRangeStartDate.compareTo(this.mEndDate) < 0L;
    }

    private void countRangeTime() throws CMyException {
        this.mCurrRangeStartDate = (CMyDateTime)this.mCurrRangeEndDate.clone();
        String sCurrStart = "";
        String sCurrEnd = "";
        switch (this.mStepType) {
            case 1: {
                sCurrStart = this.mCurrRangeStartDate.getDateTimeAsString("yyyy-MM-dd");
                this.mCurrRangeStartDate.setDateTimeWithString(sCurrStart);
                this.mCurrRangeEndDate.dateAdd(3, 1);
                sCurrEnd = this.mCurrRangeEndDate.getDateTimeAsString("yyyy-MM-dd");
                this.mCurrRangeEndDate.setDateTimeWithString(sCurrEnd);
                break;
            }
            case 2: {
                sCurrStart = this.mCurrRangeStartDate.getDateTimeAsString("yyyy-MM");
                this.mCurrRangeStartDate.setDateTimeWithString(sCurrStart);
                this.mCurrRangeEndDate.dateAdd(2, 1);
                sCurrEnd = this.mCurrRangeEndDate.getDateTimeAsString("yyyy-MM");
                this.mCurrRangeEndDate.setDateTimeWithString(sCurrEnd);
                break;
            }
            case 3: {
                sCurrStart = this.mCurrRangeStartDate.getDateTimeAsString("yyyy");
                this.mCurrRangeStartDate.setDateTimeWithString(sCurrStart);
                this.mCurrRangeEndDate.dateAdd(1, 1);
                sCurrEnd = this.mCurrRangeEndDate.getDateTimeAsString("yyyy");
                this.mCurrRangeEndDate.setDateTimeWithString(sCurrEnd);
                break;
            }
            case 4: {
                this.mCurrRangeStartDate.setDateTimeFormat("yyyy-MM-01");
                int nMonth = this.mCurrRangeStartDate.getMonth();
                int nYear = this.mCurrRangeStartDate.getYear();
                String sStartMonth = "";
                String sEndMonth = "";
                if (nMonth >= 10) {
                    sStartMonth = "10";
                    sEndMonth = "01";
                    ++nYear;
                } else if (nMonth >= 7) {
                    sStartMonth = "07";
                    sEndMonth = "10";
                } else if (nMonth >= 4) {
                    sStartMonth = "04";
                    sEndMonth = "07";
                } else if (nMonth >= 1) {
                    sStartMonth = "01";
                    sEndMonth = "04";
                }
                this.mCurrRangeStartDate.setDateTimeWithString(this.mCurrRangeStartDate.getYear() + "-" + sStartMonth + "-01");
                this.mCurrRangeEndDate.setDateTimeWithString(nYear + "-" + sEndMonth + "-01");
            }
        }
    }

    public String getXlabel() throws CMyException {
        return this.getLabelByStep(this.mCurrRangeStartDate);
    }

    private String getLabelByStep(CMyDateTime dateTime) throws CMyException {
        String sLabel = "";
        switch (this.mStepType) {
            case 1: {
                int nDay = dateTime.getDay();
                int _Month = dateTime.getMonth();
                if (nDay == 1) {
                    if (_Month == 1) {
                        sLabel = dateTime.getDateTimeAsString("yyyy-MM-dd");
                        break;
                    }
                    sLabel = dateTime.getDateTimeAsString("MM-dd");
                    break;
                }
                sLabel = String.valueOf(nDay);
                break;
            }
            case 2: {
                int nMonth = dateTime.getMonth();
                if (nMonth == 1) {
                    sLabel = dateTime.getDateTimeAsString("yyyy-MM");
                    break;
                }
                sLabel = String.valueOf(nMonth);
                break;
            }
            case 3: {
                sLabel = String.valueOf(dateTime.getYear());
                break;
            }
            case 4: {
                int nTempMonth = dateTime.getMonth();
                int nTempYear = dateTime.getYear();
                if (nTempMonth == 1) {
                    sLabel = nTempYear + " Q1";
                    break;
                }
                if (nTempMonth == 4) {
                    sLabel = "Q2";
                    break;
                }
                if (nTempMonth == 7) {
                    sLabel = "Q3";
                    break;
                }
                if (nTempMonth != 10) break;
                sLabel = "Q4";
            }
        }
        return "\"" + sLabel + "\"";
    }

    public CMyDateTime getRangeStart() {
        return this.mCurrRangeStartDate;
    }

    public CMyDateTime getRangeEnd() {
        return this.mCurrRangeEndDate;
    }
}

