/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.components.stat.StatDocCountByChannel;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import java.util.ArrayList;
import java.util.HashMap;

public class StatDocCountOfGroupByChannel {
    public static final int MODAL_STAT_NORM = 1;
    public static final int MODAL_STAT_SNAP = 2;
    public int m_nStatModal = 2;
    private String m_sSQL = null;
    private int m_nParentGroupId = 0;

    public StatDocCountOfGroupByChannel(String _sStatSQL, int _nParentGroupId) {
        this.m_sSQL = _sStatSQL;
        this.m_nParentGroupId = _nParentGroupId;
    }

    public HashMap stat(int _nSiteId, CMyDateTime _dtStartTime) throws Exception {
        return this.stat(_nSiteId, _dtStartTime, null);
    }

    public HashMap stat(int _nSiteId, CMyDateTime _dtStartTime, CMyDateTime _dtEndTime) throws Exception {
        WCMFilter queryGroupsFilter = new WCMFilter("", "ParentId=?", "");
        queryGroupsFilter.addSearchValues(this.m_nParentGroupId);
        Groups groups = Groups.openWCMObjs(null, queryGroupsFilter);
        if (groups == null || groups.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, ArrayList> hUserNamesOfGroup = new HashMap<String, ArrayList>(groups.size());
        int nSize = groups.size();
        for (int i = 0; i < nSize; ++i) {
            ArrayList arUserNames;
            Group group = (Group)groups.getAt(i);
            if (group == null || (arUserNames = this.makeUserNamesOfGroup(group, new ArrayList())) == null || arUserNames.isEmpty()) continue;
            hUserNamesOfGroup.put(group.getName() + "_" + group.getId(), arUserNames);
        }
        if (hUserNamesOfGroup.isEmpty()) {
            return new HashMap();
        }
        StatDocCountByChannel statOfUser = new StatDocCountByChannel(this.m_sSQL);
        HashMap hResultOfUser = null;
        hResultOfUser = _dtEndTime == null || _dtEndTime.isNull() ? statOfUser.stat(_nSiteId, _dtStartTime) : statOfUser.stat(_nSiteId, _dtStartTime, _dtEndTime);
        if (hResultOfUser == null || hResultOfUser.isEmpty()) {
            return new HashMap();
        }
        HashMap hResultOfGroup = new HashMap(hResultOfUser.size());
        for (Object oChannelOrSiteKey : hResultOfUser.keySet()) {
            HashMap hDocCountOfUsersOnChannel = (HashMap)hResultOfUser.get(oChannelOrSiteKey);
            HashMap hDocCountOfGroupsOnChannel = new HashMap(hDocCountOfUsersOnChannel.size());
            for (Object oGroupKey : hUserNamesOfGroup.keySet()) {
                ArrayList arUsers = (ArrayList)hUserNamesOfGroup.get(oGroupKey);
                int nDocCountOfGroupOnChannel = this.makeDocCountOfCurrUsersOnChannel(hDocCountOfUsersOnChannel, arUsers);
                if (nDocCountOfGroupOnChannel == 0) continue;
                hDocCountOfGroupsOnChannel.put(oGroupKey, new Integer(nDocCountOfGroupOnChannel));
            }
            if (hDocCountOfGroupsOnChannel.isEmpty()) continue;
            hResultOfGroup.put(oChannelOrSiteKey, hDocCountOfGroupsOnChannel);
        }
        return hResultOfGroup;
    }

    public CMyDateTime createStatDataInTempTableByDay(CMyDateTime _dtStartTime, CMyDateTime _dtEndTime) throws Exception {
        return null;
    }

    private int makeDocCountOfCurrUsersOnChannel(HashMap _hDocCountOfUsersOnChannel, ArrayList _arUsers) {
        int nDocCountOfGroupOnChannel = 0;
        int nSize = _arUsers.size();
        for (int i = 0; i < nSize; ++i) {
            String sUserName = (String)_arUsers.get(i);
            Integer iDocCount = (Integer)_hDocCountOfUsersOnChannel.get(sUserName);
            if (iDocCount == null) continue;
            nDocCountOfGroupOnChannel += iDocCount.intValue();
        }
        return nDocCountOfGroupOnChannel;
    }

    private ArrayList makeUserNamesOfGroup(Group _currGroup, ArrayList _arTemp) throws WCMException {
        Groups children;
        ArrayList arResult = _arTemp;
        Users users = _currGroup.getUsers(null);
        if (users != null && !users.isEmpty()) {
            arResult.ensureCapacity(arResult.size() + users.size());
            int nSize = users.size();
            for (int i = 0; i < nSize; ++i) {
                String sUserName;
                User user = (User)users.getAt(i);
                if (user == null || arResult.indexOf(sUserName = user.getName()) >= 0) continue;
                arResult.add(user.getName());
            }
        }
        if ((children = _currGroup.getChildren(null)) == null || children.isEmpty()) {
            return arResult;
        }
        int nSize = children.size();
        for (int i = 0; i < nSize; ++i) {
            Group childGroup = (Group)children.getAt(i);
            if (childGroup == null) continue;
            this.makeUserNamesOfGroup(childGroup, arResult);
        }
        return arResult;
    }
}

