/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.ISynDocumentWorker;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class SynDocumentWorker
implements ISynDocumentWorker,
Runnable,
Serializable {
    private static Logger logger = Logger.getLogger(SynDocumentWorker.class);
    private Map m_oParamMap = new HashMap();
    private Map m_oParams = null;
    private User m_oLoginUser = ContextHelper.getLoginUser();
    private HttpSession m_oSession = null;
    public static final String RUNNINGFLAG = "isRunning";
    public static final String HANDLEDCOUNT = "handledCount";
    public static final String NORIGHTCOUNT = "noRightCount";
    public static final String HANDINGCHANNEL = "handingChannel";
    public static final String ERRORINFO = "errorInfo";
    public static final String SYNDOCPROGRESSINFO = "synDocProgressInfo";
    public static final String ENABLEINTERRUPT = "enableInterrupt";

    public SynDocumentWorker(HttpSession session) {
        this.m_oSession = session;
        Object tempMap1 = session.getAttribute(SYNDOCPROGRESSINFO);
        if (tempMap1 == null) {
            this.m_oParams = this.initParamsMap();
            session.setAttribute(SYNDOCPROGRESSINFO, (Object)this.m_oParams);
        } else {
            this.m_oParams = (Map)tempMap1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Logger logger = SynDocumentWorker.logger;
        synchronized (logger) {
            if (this.m_oParams == null) return;
            if (this.m_oParams.size() <= 1) {
                return;
            }
            boolean bRunning = this.isRunning();
            if (bRunning) {
                return;
            }
            bRunning = true;
            this.m_oParams.put(RUNNINGFLAG, new Boolean(bRunning));
            try {
                ContextHelper.initContext(this.m_oLoginUser);
                WebSites websites = this.getWebsites();
                Channels channels = this.getChannels();
                MetaViews metaviews = this.getMetaviews();
                if (websites == null && channels == null && metaviews == null) {
                    return;
                }
                boolean enableInterrupt = this.isEnableInterrupt();
                if (enableInterrupt) {
                    return;
                }
                if (channels != null) {
                    this.synChnlDocs(channels);
                } else if (websites != null) {
                    this.synWebsiteDocs(websites);
                } else if (metaviews != null) {
                    this.synMetaviewDocs(metaviews);
                }
                if (!this.isEnableInterrupt()) return;
                this.resetParams();
            }
            catch (WCMException e) {
                SynDocumentWorker.logger.error((Object)"\u540c\u6b65\u6587\u6863\u65f6\u51fa\u73b0\u9519\u8bef\uff01", (Throwable)e);
            }
            finally {
                bRunning = false;
                if (this.m_oParams != null) {
                    this.m_oParams.put(RUNNINGFLAG, new Boolean(bRunning));
                }
                ContextHelper.clear();
            }
            return;
        }
    }

    @Override
    public void synWebsiteDocs(String websiteIds) throws Throwable {
        if (this.m_oLoginUser == null || !this.m_oLoginUser.isAdministrator()) {
            throw new WCMException("\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u540c\u6b65\u6587\u6863\u7684\u6743\u9650\uff01");
        }
        if (CMyString.isEmpty(websiteIds)) {
            return;
        }
        WebSites oWebSites = WebSites.findByIds(this.m_oLoginUser, websiteIds);
        if (oWebSites.size() <= 0) {
            return;
        }
        this.setWebsites(oWebSites);
        Thread thread = new Thread(this);
        thread.start();
    }

    @Override
    public void synMetaviewDocs(String metaviewIds) throws Throwable {
        if (this.m_oLoginUser == null || !this.m_oLoginUser.isAdministrator()) {
            throw new WCMException("\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u540c\u6b65\u6587\u6863\u7684\u6743\u9650\uff01");
        }
        if (CMyString.isEmpty(metaviewIds)) {
            return;
        }
        MetaViews oMetaViews = MetaViews.findByIds(this.m_oLoginUser, metaviewIds);
        if (oMetaViews.size() <= 0) {
            return;
        }
        this.setMetaviews(oMetaViews);
        Thread thread = new Thread(this);
        thread.start();
    }

    @Override
    public void synChannelDocs(String chnlIds, boolean bContainChildren) throws Throwable {
        this.setContainChildren(bContainChildren);
        this.synChannelDocs(chnlIds);
    }

    @Override
    public void synChannelDocs(String chnlIds) throws Throwable {
        if (this.m_oLoginUser == null || !this.m_oLoginUser.isAdministrator()) {
            throw new WCMException("\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u540c\u6b65\u6587\u6863\u7684\u6743\u9650\uff01");
        }
        if (CMyString.isEmpty(chnlIds)) {
            return;
        }
        Channels oChannels = Channels.findByIds(this.m_oLoginUser, chnlIds);
        if (oChannels.size() <= 0) {
            return;
        }
        this.setChannels(oChannels);
        Thread thread = new Thread(this);
        if (thread.isAlive()) {
            System.out.println("\u7ebf\u7a0b\u5df2\u542f\u52a8....");
            return;
        }
        thread.start();
    }

    public boolean isRunning() {
        return (Boolean)this.m_oParams.get(RUNNINGFLAG);
    }

    @Override
    public boolean isFinished() {
        boolean isStopped = !this.isRunning();
        int nHandledCount = this.getHandledCount();
        int nNoRightCount = this.getNoRightCount();
        boolean isMapNull = nHandledCount == 0 && nNoRightCount == 0;
        return isStopped && isMapNull;
    }

    @Override
    public int getHandledCount() {
        return (Integer)this.m_oParams.get(HANDLEDCOUNT);
    }

    @Override
    public int getNoRightCount() {
        return (Integer)this.m_oParams.get(NORIGHTCOUNT);
    }

    public String getHandingChannelInfo() {
        return (String)this.m_oParams.get(HANDINGCHANNEL);
    }

    @Override
    public String getErrorInfo() {
        return ((StringBuffer)this.m_oParams.get(ERRORINFO)).toString();
    }

    public void setEnableInterrupt(boolean enableInterrupt) {
        this.m_oParams.put(ENABLEINTERRUPT, new Boolean(enableInterrupt));
    }

    public void resetParams() {
        this.m_oParamMap.clear();
        this.m_oParams.clear();
        this.m_oParams = null;
        this.m_oLoginUser = null;
        this.m_oSession.setAttribute(SYNDOCPROGRESSINFO, (Object)this.m_oParams);
    }

    private boolean isEnableInterrupt() {
        return (Boolean)this.m_oParams.get(ENABLEINTERRUPT);
    }

    private void synMetaviewDocs(MetaViews _metaviews) throws WCMException {
        int nSize = _metaviews.size();
        for (int i = 0; i < nSize; ++i) {
            if (this.isEnableInterrupt()) {
                return;
            }
            MetaView view = (MetaView)_metaviews.getAt(i);
            if (view == null) continue;
            this.synMetaviewDocs(view);
        }
    }

    private void synMetaviewDocs(MetaView view) throws WCMException {
        Channels channels = this.getMetaViewEmployerMgr().getEmployers(view, null);
        this.synChnlDocs(channels);
    }

    private void synWebsiteDocs(WebSites _websites) throws WCMException {
        int nSize = _websites.size();
        for (int i = 0; i < nSize; ++i) {
            if (this.isEnableInterrupt()) {
                return;
            }
            WebSite oWebsite = (WebSite)_websites.getAt(i);
            if (oWebsite == null) continue;
            this.synWebsiteDocs(oWebsite);
        }
    }

    private void setProcessingChannelInfo(String processing) {
        this.m_oParams.put(HANDINGCHANNEL, processing);
    }

    private void synWebsiteDocs(WebSite _website) throws WCMException {
        Channels channels = this.getChannelMgr().getChannels(_website.getId(), null);
        this.synChnlDocs(channels);
    }

    private void synChnlDocs(Channels _channels) throws WCMException {
        int nSize = _channels.size();
        for (int i = 0; i < nSize; ++i) {
            if (this.isEnableInterrupt()) {
                return;
            }
            Channel oChannel = (Channel)_channels.getAt(i);
            String sTempInfo = oChannel.getName() + "\u680f\u76ee...\u680f\u76eeid\u4e3a[" + oChannel.getId() + "]";
            this.setProcessingChannelInfo(sTempInfo);
            if (oChannel == null) continue;
            this.synChnlDocs(oChannel);
            this.setProcessingChannelInfo("");
        }
    }

    private void synChnlDocs(Channel _channel) throws WCMException {
        MetaView metaView = this.getMetaViewEmployerMgr().getViewOfEmployer(_channel);
        if (metaView == null) {
            return;
        }
        int nNoRightCount = (Integer)this.m_oParams.get(NORIGHTCOUNT);
        int nHandledCount = (Integer)this.m_oParams.get(HANDLEDCOUNT);
        StringBuffer sErrorInfo = (StringBuffer)this.m_oParams.get(ERRORINFO);
        WCMFilter filter = new WCMFilter("", "DocKind=? and DocChannel=?", "");
        filter.addSearchValues(metaView.getId());
        filter.addSearchValues(_channel.getId());
        Documents documents = Documents.openWCMObjs(this.m_oLoginUser, filter);
        if (documents.size() <= 0) {
            return;
        }
        int nSize = documents.size();
        for (int i = 0; i < nSize; ++i) {
            Document document = (Document)documents.getAt(i);
            if (this.isEnableInterrupt()) {
                return;
            }
            if (document == null) continue;
            if (!AuthServer.hasRight(this.m_oLoginUser, (CMSObj)document.getChannel(), 32)) {
                this.m_oParams.put(NORIGHTCOUNT, new Integer(++nNoRightCount));
                continue;
            }
            int docId = document.getId();
            MetaViewData metaViewData = MetaViewData.findById(docId);
            try {
                metaViewData.synDocumentFieldValueWithRule(document);
            }
            catch (Exception e) {
                sErrorInfo.append("\u540c\u6b65\u6587\u6863[" + document.getTitle() + "]\u65f6\u51fa\u9519\uff0c\u6587\u6863id\u4e3a[" + docId + "] \r\n");
                logger.error((Object)("\u540c\u6b65\u6587\u6863[" + document.getTitle() + "]\u65f6\u51fa\u9519\uff0c\u6587\u6863id\u4e3a[" + docId + "] \r\n"));
                this.m_oParams.put(ERRORINFO, sErrorInfo);
            }
            WCMFilter oFilter = new WCMFilter("", "DOCID=? and CHNLID>?", "", "RECID,DOCSTATUS,DocPubTime");
            oFilter.addSearchValues(docId);
            oFilter.addSearchValues(0);
            ChnlDocs chnlDocs = ChnlDocs.openWCMObjs(this.m_oLoginUser, oFilter);
            HashMap statusMap = new HashMap();
            int innerJSize = chnlDocs.size();
            for (int j = 0; j < innerJSize; ++j) {
                ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(j);
                if (chnlDoc == null) continue;
                ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
                arrayList.add(new Integer(chnlDoc.getStatusId()));
                arrayList.add(chnlDoc.getDocPubTime());
                statusMap.put(chnlDoc.getId() + "", arrayList);
            }
            int nOldDocStatus = document.getStatusId();
            CMyDateTime docPubTime = document.getPubTime();
            this.getDocumentMgr().save(document);
            for (Map.Entry mapObj : statusMap.entrySet()) {
                int nObjId = Integer.parseInt((String)mapObj.getKey());
                List arrayList = (List)mapObj.getValue();
                Integer oOldStatusId = (Integer)arrayList.get(0);
                int nOldStatusId = oOldStatusId;
                CMyDateTime sOldPubTime = (CMyDateTime)arrayList.get(1);
                ChnlDoc currChnlDoc = ChnlDoc.findById(nObjId);
                if (currChnlDoc.getStatusId() == nOldStatusId) continue;
                String sUpdateChnlDocStatusSql = "UPDATE WCMCHNLDOC SET DOCSTATUS=?,DOCPUBTIME=? WHERE RECID=?";
                Object[] oParamObject = new Object[]{oOldStatusId, sOldPubTime, new Integer(nObjId)};
                DBManager.getDBManager().sqlExecuteUpdate(new String[]{sUpdateChnlDocStatusSql}, oParamObject);
            }
            String sUpdateChnlDocStatusSql = "UPDATE WCMDocument SET DOCSTATUS=?,DOCPUBTIME=? WHERE DOCID=?";
            Object[] oParamObject = new Object[]{new Integer(nOldDocStatus), docPubTime, new Integer(docId)};
            DBManager.getDBManager().sqlExecuteUpdate(new String[]{sUpdateChnlDocStatusSql}, oParamObject);
            this.m_oParams.put(HANDLEDCOUNT, new Integer(++nHandledCount));
        }
        if (this.getContainChildren()) {
            List<Channel> oChildren = _channel.getChildren(this.m_oLoginUser);
            int length = oChildren.size();
            for (int i = 0; i < length; ++i) {
                this.synChnlDocs(oChildren.get(i));
            }
        }
    }

    private void setWebsites(WebSites _websites) {
        this.m_oParamMap.put("websites", _websites);
    }

    private WebSites getWebsites() {
        WebSites websites = (WebSites)this.m_oParamMap.get("websites");
        return websites;
    }

    private void setContainChildren(boolean bContainChildren) {
        this.m_oParamMap.put("containchildren", String.valueOf(bContainChildren));
    }

    private boolean getContainChildren() {
        String sContainChildren = (String)this.m_oParamMap.get("containchildren");
        return Boolean.parseBoolean(sContainChildren);
    }

    private void setChannels(Channels _chls) {
        this.m_oParamMap.put("channels", _chls);
    }

    private Channels getChannels() {
        Channels _chls = (Channels)this.m_oParamMap.get("channels");
        return _chls;
    }

    private void setMetaviews(MetaViews _mataviews) {
        this.m_oParamMap.put("metaviews", _mataviews);
    }

    private MetaViews getMetaviews() {
        MetaViews websites = (MetaViews)this.m_oParamMap.get("metaviews");
        return websites;
    }

    private ChannelMgr getChannelMgr() {
        return (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
    }

    private DocumentMgr getDocumentMgr() {
        return (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    }

    private IMetaViewEmployerMgr getMetaViewEmployerMgr() {
        return (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
    }

    private Map initParamsMap() {
        this.m_oParams = new HashMap();
        this.m_oParams.put(ENABLEINTERRUPT, new Boolean(false));
        this.m_oParams.put(RUNNINGFLAG, new Boolean(false));
        this.m_oParams.put(HANDLEDCOUNT, new Integer(0));
        this.m_oParams.put(NORIGHTCOUNT, new Integer(0));
        this.m_oParams.put(HANDINGCHANNEL, new String(""));
        this.m_oParams.put(ERRORINFO, new StringBuffer(""));
        return this.m_oParams;
    }
}

