/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget.acceptor;

import com.trs.DreamFactory;
import com.trs.cms.content.DefaultObjs;
import com.trs.components.common.publish.widget.IWidgetMgr;
import com.trs.components.common.publish.widget.IWidgetParameterMgr;
import com.trs.components.common.publish.widget.Widget;
import com.trs.components.common.publish.widget.acceptor.IWidgetAcceptor;
import com.trs.components.common.publish.widget.acceptor.IWidgetAcceptorContext;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.tagparser.WCMDocumentImagesGenerator;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class BaseWidgetAcceptor
implements IWidgetAcceptor {
    private static Logger logger = Logger.getLogger(BaseWidgetAcceptor.class);
    private static Map acceptorsParams = new HashMap();
    private Map acceptorParams;
    private static final String IMAGE_FIRST_FROM_APPENDIX = "appendix";
    private static final String IMAGE_FIRST_FROM_CONTENT = "content";
    private String widgetName;
    private Widget widget;
    protected IWidgetMgr widgetMgr = (IWidgetMgr)DreamFactory.createObjectById("IWidgetMgr");
    protected IWidgetParameterMgr widgetParameterMgr = (IWidgetParameterMgr)DreamFactory.createObjectById("IWidgetParameterMgr");
    private DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    private AppendixMgr appendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    private ChannelMgr channelMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");

    public BaseWidgetAcceptor() {
        this.acceptorParams = new HashMap();
    }

    @Override
    public void setWidgetName(String sWidgetName) throws WCMException {
        this.widgetName = sWidgetName;
        Widget widget = this.getWidget();
        if (widget == null) {
            throw new WCMException("\u5bf9\u5e94\u7684\u8d44\u6e90\u4e0d\u5b58\u5728\uff0c\u8d44\u6e90\u540d\u79f0\u4e3a[" + sWidgetName + "]");
        }
    }

    @Override
    public String getWidgetName() {
        return this.widgetName;
    }

    @Override
    public Widget getWidget() throws WCMException {
        if (this.widget == null) {
            this.widget = this.widgetMgr.findWidgetByName(null, this.widgetName);
        }
        return this.widget;
    }

    @Override
    public void setExtraParam(String paramName, String paramValue) {
        this.acceptorParams.put(paramName.toUpperCase(), paramValue);
    }

    @Override
    public String getExtraParam(String paramName) {
        return (String)this.acceptorParams.get(paramName.toUpperCase());
    }

    @Override
    public void setGlobalParam(String paramName, String paramValue) {
        acceptorsParams.put(paramName.toUpperCase(), paramValue);
    }

    @Override
    public String getGlobalParam(String paramName) {
        return (String)acceptorsParams.get(paramName.toUpperCase());
    }

    protected float getExpressionEval(String sExpression) throws WCMException {
        String sReplacedExpression = CMyString.parsePageVariables(sExpression, acceptorsParams);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u5f53\u524d\u7684acceptorsParams\uff1a" + acceptorsParams));
            logger.debug((Object)("\u53d8\u91cf\u66ff\u6362\u524d\uff1a" + sExpression));
            logger.debug((Object)("\u53d8\u91cf\u66ff\u6362\u540e\uff1a" + sReplacedExpression));
        }
        return CMyString.expressionEval(sReplacedExpression);
    }

    protected Channel findChannel(IWidgetAcceptorContext context) {
        return (Channel)context.getHost();
    }

    protected Documents findDocs(IWidgetAcceptorContext context) throws WCMException {
        Documents docs = (Documents)context.getProperty("docs");
        if (docs != null) {
            return docs;
        }
        docs = this.documentMgr.getDocuments(this.findChannel(context), null);
        context.setProperty("docs", docs);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("docs:" + docs.size()));
        }
        return docs;
    }

    protected Documents findImageDocs(IWidgetAcceptorContext context) throws WCMException {
        Documents imageDocs = (Documents)context.getProperty("imagedocs");
        if (imageDocs != null) {
            return imageDocs;
        }
        WCMFilter filter = new WCMFilter("", "ATTACHPIC>0", "");
        imageDocs = this.documentMgr.getDocuments(this.findChannel(context), filter);
        context.setProperty("imagedocs", imageDocs);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("imagedocs:" + imageDocs.size()));
        }
        return imageDocs;
    }

    protected String findFirstImage(IWidgetAcceptorContext context, String sFirstFrom) throws WCMException {
        Appendixes appendixes;
        sFirstFrom = sFirstFrom.toLowerCase();
        String sCurrentKey = "firstimage-firstfrom-" + sFirstFrom;
        String sFirstImage = (String)context.getProperty(sCurrentKey);
        if (sFirstImage != null) {
            return sFirstImage;
        }
        Documents imageDocs = this.findImageDocs(context);
        if (imageDocs.size() <= 0) {
            context.setProperty(sCurrentKey, "");
            return "";
        }
        Document firstImageDoc = (Document)imageDocs.getAt(0);
        String sHtmlContent = firstImageDoc.getHtmlContent();
        DefaultObjs defaultObjs = WCMDocumentImagesGenerator.getImagesFromHtmlContent(sHtmlContent, 1);
        if (defaultObjs.size() > 0) {
            String sFileName = defaultObjs.getAt(0).getPropertyAsString("FileName");
            String sLocalFileName = FilesMan.getFilesMan().mapFilePath(sFileName, 0) + sFileName;
            context.setProperty("firstimage-firstfrom-content", sLocalFileName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("firstimage-firstfrom-content:" + sLocalFileName));
            }
        }
        if ((appendixes = this.findImagesAppendixes(context, firstImageDoc)).size() > 0) {
            String sFileName = appendixes.getAt(0).getPropertyAsString("APPFILE");
            String sLocalFileName = FilesMan.getFilesMan().mapFilePath(sFileName, 0) + sFileName;
            context.setProperty("firstimage-firstfrom-appendix", sLocalFileName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("firstimage-firstfrom-appendix:" + sLocalFileName));
            }
        }
        if (context.getProperty("firstimage-firstfrom-appendix") == null && context.getProperty("firstimage-firstfrom-content") != null) {
            context.setProperty("firstimage-firstfrom-appendix", context.getProperty("firstimage-firstfrom-content"));
        } else if (context.getProperty("firstimage-firstfrom-content") == null && context.getProperty("firstimage-firstfrom-appendix") != null) {
            context.setProperty("firstimage-firstfrom-content", context.getProperty("firstimage-firstfrom-appendix"));
        }
        return (String)context.getProperty(sCurrentKey);
    }

    protected Channels findSubChannels(IWidgetAcceptorContext context) throws WCMException {
        Channels subChannels = (Channels)context.getProperty("subchannels");
        if (subChannels != null) {
            return subChannels;
        }
        subChannels = (Channels)this.channelMgr.getChildren(this.findChannel(context), -1, false, null);
        context.setProperty("subchannels", subChannels);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("subchannels:" + subChannels.size()));
        }
        return subChannels;
    }

    protected Appendixes findImagesAppendixes(IWidgetAcceptorContext context, Document doc) throws WCMException {
        Appendixes appendixes = (Appendixes)context.getProperty("docappendixs-" + doc.getId());
        if (appendixes != null) {
            return appendixes;
        }
        appendixes = this.appendixMgr.getAppendixes(doc, 20);
        context.setProperty("docappendixs-" + doc.getId(), appendixes);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("docappendixs-" + doc.getId() + ":" + appendixes.size()));
        }
        return appendixes;
    }

    protected int getDocsCount(IWidgetAcceptorContext context) throws WCMException {
        Integer docsCount = (Integer)context.getProperty("docscount");
        if (docsCount != null) {
            return docsCount;
        }
        int nChnlId = this.findChannel(context).getId();
        String sSQL = "select count(*) from WCMCHNLDOC where CHNLID=? and DocStatus>0 and DocChannel>0 ";
        int nDocsCount = DBManager.getDBManager().sqlExecuteIntQuery(sSQL, new int[]{nChnlId});
        context.setProperty("docscount", nDocsCount);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("docscount:" + nDocsCount));
        }
        return nDocsCount;
    }

    protected int getImageDocsCount(IWidgetAcceptorContext context) throws WCMException {
        Integer imageDocsCount = (Integer)context.getProperty("imagedocscount");
        if (imageDocsCount != null) {
            return imageDocsCount;
        }
        int nChnlId = this.findChannel(context).getId();
        String sSQL = "select count(*) from WCMCHNLDOC where CHNLID=? and ATTACHPIC>0 and DocStatus>0 and DocChannel>0 ";
        int nImageDocsCount = DBManager.getDBManager().sqlExecuteIntQuery(sSQL, new int[]{nChnlId});
        context.setProperty("imagedocscount", nImageDocsCount);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("imagedocscount:" + nImageDocsCount));
        }
        return nImageDocsCount;
    }

    protected boolean isImageChannel(IWidgetAcceptorContext context) throws WCMException {
        boolean bImageChannel;
        int nDocsCount = this.getDocsCount(context);
        int nImageDocsCount = this.getImageDocsCount(context);
        String sRate = this.getGlobalParam("\u56fe\u7247\u680f\u76ee\u6587\u6863\u6240\u5360\u6bd4\u4f8b");
        boolean bl = bImageChannel = 100.0 * (double)nImageDocsCount / (double)nDocsCount >= (double)Float.parseFloat(sRate = CMyString.showNull(sRate, "70"));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("bImageChannel:" + bImageChannel));
        }
        return bImageChannel;
    }
}

