/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.ContentStyle;
import com.trs.components.common.publish.widget.ContentStyleImporter;
import com.trs.components.common.publish.widget.IPageStyleMgr;
import com.trs.components.common.publish.widget.IStyleCenterMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.PageStyles;
import com.trs.components.common.publish.widget.ResourceStyle;
import com.trs.components.common.publish.widget.ResourceStyleImporter;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItemMgr;
import com.trs.components.common.publish.widget.StylePathHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.XmlToObjConverter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.Reports;
import com.trs.infra.util.store.FileService;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class PageStyleImporter {
    private static Logger s_logger = Logger.getLogger(PageStyleImporter.class);
    private XmlToObjConverter m_converter = null;
    private final Map m_PageStyleIds = new HashMap();
    private static final String PROPERTY_CRUSER = "CRUSER";
    private static final String PROPERTY_CRTIME = "CRTIME";
    private static final char CHAR_S = 'S';
    private static final String TAG_STYLE_ITEMS = "XWCMSTYLEITEMS";
    private static final String TAG_CONTENT_STYLES = "XWCMCONTENTSTYLES";
    private static final String TAG_RESOURCE_STYLES = "XWCMRESOURCESTYLES";
    private static String m_sUnzipFilePath = "";
    private Reports m_reports;
    private ArrayList m_successReportList;
    private HttpSession hs_session;
    public static final int PAGE_STYLE_INDEX = 5;

    public PageStyleImporter() {
        this.m_converter = new XmlToObjConverter(1);
        this.registerConverter();
    }

    public Reports importFromFile(String _sFile, int _nImportMode, int _nSubStyleImportMode) throws Exception {
        this.checkFile(_sFile);
        String sFullFile = this.getFullName(_sFile);
        this.m_reports = new Reports("");
        this.m_successReportList = new ArrayList();
        return this.importFromZip(sFullFile, _nImportMode, _nSubStyleImportMode);
    }

    public String checkPageStyleNameExists(String _sZipFile) throws Exception {
        this.checkFile(_sZipFile);
        String sFullFile = this.getFullName(_sZipFile);
        String sUnZipPath = CMyFile.extractFilePath(sFullFile) + "unzip" + System.currentTimeMillis();
        sUnZipPath = CMyString.setStrEndWith(sUnZipPath, File.separatorChar);
        List xmlFiles = this.extractXmlFiles(sFullFile, sUnZipPath);
        StringBuffer sbCheckResult = new StringBuffer("\u9875\u9762\u98ce\u683c");
        boolean bFirstAppend = true;
        String xmlFile = null;
        for (int i = 0; i < xmlFiles.size(); ++i) {
            xmlFile = (String)xmlFiles.get(i);
            XmlObject[] xmlObjects = this.convertXmlFile(xmlFile, null);
            String sCheckResult = this.checkPageStyleNames(xmlObjects, sUnZipPath);
            if (sCheckResult == null) continue;
            if (!bFirstAppend) {
                sbCheckResult.append(",");
            }
            sbCheckResult.append(sCheckResult);
            bFirstAppend = false;
        }
        if (bFirstAppend) {
            return null;
        }
        return sbCheckResult.append("\u5df2\u7ecf\u5b58\u5728\uff01").toString();
    }

    private String checkPageStyleNames(XmlObject[] _xmlObjects, String _sUnZipPath) throws Exception {
        StringBuffer sbCheckResult = new StringBuffer("");
        boolean bFirstAppend = true;
        for (int i = 0; i < _xmlObjects.length; ++i) {
            boolean bExists;
            XmlObject _xmlObject = _xmlObjects[i];
            if (_xmlObject == null) continue;
            this.validateXmlObject(_xmlObject);
            PageStyle currPageStyle = (PageStyle)_xmlObject.getCurrentObj();
            if (currPageStyle == null || !(bExists = this.existStyleName(currPageStyle))) continue;
            if (!bFirstAppend) {
                sbCheckResult.append(",");
            }
            sbCheckResult.append("[ \u540d\u79f0=" + currPageStyle.getStyleDesc() + "(" + currPageStyle.getStyleName() + ") ]");
            bFirstAppend = false;
        }
        if (bFirstAppend) {
            return null;
        }
        return sbCheckResult.toString();
    }

    private Reports importFromZip(String _sFullZipPath, int _nImportMode, int _nSubStyleImportMode) throws Exception {
        String sUnZipPath = CMyFile.extractFilePath(_sFullZipPath) + "unzip" + System.currentTimeMillis();
        sUnZipPath = CMyString.setStrEndWith(sUnZipPath, File.separatorChar);
        List xmlFiles = this.extractXmlFiles(_sFullZipPath, sUnZipPath);
        String xmlFile = null;
        for (int i = 0; i < xmlFiles.size(); ++i) {
            xmlFile = (String)xmlFiles.get(i);
            XmlObject[] xmlObjects = this.convertXmlFile(xmlFile, null);
            this.importPageStyles(xmlObjects, sUnZipPath, _nImportMode, _nSubStyleImportMode);
        }
        CMyFile.deleteDir(sUnZipPath);
        this.m_reports.setTitle("\u4eceZip\u6587\u4ef6\u4e2d\u5bfc\u5165\u9875\u9762\u98ce\u683c");
        this.m_reports.setExtraData(this.m_successReportList);
        return this.m_reports;
    }

    private void importPageStyles(XmlObject[] _xmlObjects, String _sUnZipPath, int _nImportMode, int _nSubStyleImportMode) throws Exception {
        int[] resultIds = new int[_xmlObjects.length];
        for (int i = 0; i < _xmlObjects.length; ++i) {
            BaseObj result = this.importOnePageStyle(_xmlObjects[i], _sUnZipPath, _nImportMode, _nSubStyleImportMode);
            if (result == null) continue;
            resultIds[i] = result.getId();
        }
        String sTargetDefaultPath = StylePathHelper.getStyleCommonDir() + "default";
        if (!CMyFile.fileExists(sTargetDefaultPath)) {
            CMyFile.makeDir(sTargetDefaultPath, true);
        }
        String sDefaultPath = CMyString.setStrEndWith(_sUnZipPath, File.separatorChar) + "default";
        CMyFile.copyFileDir(sDefaultPath, sTargetDefaultPath, false);
        this.m_reports.setResultIds(resultIds);
    }

    private BaseObj importOnePageStyle(XmlObject _xmlObject, String _sUnZipPath, int _nImportMode, int _nSubStyleImportMode) throws Exception {
        PageStyle currPageStyle;
        block13: {
            m_sUnzipFilePath = _sUnZipPath;
            if (_xmlObject == null) {
                return null;
            }
            this.validateXmlObject(_xmlObject);
            currPageStyle = (PageStyle)_xmlObject.getCurrentObj();
            if (currPageStyle == null) {
                return null;
            }
            String sStyleDesc = (String)currPageStyle.getProperty("STYLEDESC");
            this.hs_session = (HttpSession)ContextHelper.getArg(5);
            if (this.hs_session != null) {
                this.hs_session.setAttribute("currentPageStyle", (Object)new String("\u4fdd\u5b58\u9875\u9762\u98ce\u683c\u3010" + sStyleDesc + "\u3011\uff0c"));
            } else {
                s_logger.info((Object)("\u6b63\u5728\u4fdd\u5b58\u9875\u9762\u98ce\u683c\u3010" + sStyleDesc + "\u3011\uff01"));
            }
            try {
                String sSourceThumbPath;
                FileService sourceThumbFile;
                String sOldPageStyleId = currPageStyle.getPropertyAsString("PAGESTYLEID");
                boolean bExistSameNamePageStyle = false;
                PageStyle sameNamePageStyle = this.getSameNamePageStyle(currPageStyle);
                String sThumbName = currPageStyle.getStyleThumb();
                if (sameNamePageStyle != null) {
                    bExistSameNamePageStyle = true;
                    switch (_nImportMode) {
                        case 1: {
                            this.deletePageStyleBasicInfos(this.getLoginUser(), sameNamePageStyle);
                            Hashtable<String, Object> properties = currPageStyle.getAllProperty();
                            properties.remove("PAGESTYLEID");
                            properties.remove("STYLETHUMB");
                            currPageStyle = sameNamePageStyle;
                            currPageStyle.setNewProperties(properties);
                            break;
                        }
                        case 2: {
                            return null;
                        }
                    }
                } else {
                    currPageStyle.setNextId();
                }
                currPageStyle.setIsPublish(0);
                currPageStyle.setProperty(PROPERTY_CRUSER, this.getLoginUser().getName());
                currPageStyle.setProperty(PROPERTY_CRTIME, CMyDateTime.now());
                currPageStyle.setStyleThumb(sThumbName);
                if (!CMyString.isEmpty(sThumbName) && (sourceThumbFile = new FileService(sSourceThumbPath = m_sUnzipFilePath + "thumb" + File.separator + sThumbName)).exists()) {
                    String sNewStyleThumbName = this.copyFileIfNeed(sSourceThumbPath, true);
                    currPageStyle.setStyleThumb(sNewStyleThumbName);
                }
                IPageStyleMgr pageStyleMgr = (IPageStyleMgr)DreamFactory.createObjectById("IPageStyleMgr");
                pageStyleMgr.save(this.getLoginUser(), currPageStyle);
                this.m_PageStyleIds.put(this.makePageStyleIdMapKey(368170809, sOldPageStyleId), new Integer(currPageStyle.getId()));
                this.importStyleItems(_xmlObject.getChild(TAG_STYLE_ITEMS), this.m_PageStyleIds, _nImportMode, bExistSameNamePageStyle);
                this.importPageResourceStyles(_xmlObject.getChild(TAG_RESOURCE_STYLES), currPageStyle.getId(), _nSubStyleImportMode);
                this.importPageContentStyles(_xmlObject.getChild(TAG_CONTENT_STYLES), currPageStyle.getId(), _nSubStyleImportMode);
                this.copyThumbCustomFiles(currPageStyle, _sUnZipPath);
                IStyleCenterMgr styleCenterMgr = (IStyleCenterMgr)DreamFactory.createObjectById("IStyleCenterMgr");
                styleCenterMgr.createStyleFile(this.getLoginUser(), currPageStyle);
                this.m_successReportList.add("[ \u540d\u79f0=" + currPageStyle.getStyleDesc() + "(" + currPageStyle.getStyleName() + ") ]");
            }
            catch (Exception e) {
                if (this.hs_session == null) break block13;
                this.hs_session.setAttribute("ErrorInfo", (Object)e.getStackTrace());
            }
        }
        return currPageStyle;
    }

    private void validateXmlObject(XmlObject _xmlObject) throws WCMException {
        BaseObj currObj = _xmlObject.getCurrentObj();
        if (currObj == null) {
            throw new WCMException(20, "\u65e0\u6548\u7684\u9875\u9762\u98ce\u683c\u63cf\u8ff0xml\u6587\u4ef6.");
        }
        if (!(currObj instanceof PageStyle)) {
            throw new WCMException("\u5bf9\u8c61\u4e0d\u662f[currObj" + currObj.getClass().getName() + "]\u4e0d\u662fPageStyle\u5bf9\u8c61\u7c7b\u578b\uff01");
        }
    }

    private void importPageResourceStyles(XmlObject[] _resourceStyles, int _nPageStyleId, int _nImportMode) throws WCMException {
        if (_resourceStyles == null || _nPageStyleId == 0) {
            return;
        }
        for (int i = 0; i < _resourceStyles.length; ++i) {
            ResourceStyle currResourceStyle;
            XmlObject aXmlObject = _resourceStyles[i];
            if (aXmlObject == null || (currResourceStyle = (ResourceStyle)aXmlObject.getCurrentObj()) == null) continue;
            String sRStyleDesc = currResourceStyle.getStyleName();
            PageStyle currPageStyle = PageStyle.findById(_nPageStyleId);
            String sPageStyleDesc = (String)currPageStyle.getProperty("STYLEDESC");
            this.hs_session = (HttpSession)ContextHelper.getArg(5);
            if (this.hs_session != null) {
                this.hs_session.setAttribute("currentPageStyle", (Object)new String("\u4fdd\u5b58\u9875\u9762\u98ce\u683c\u3010" + sPageStyleDesc + "\u3011\u4e0b\u7684\u8d44\u6e90\u98ce\u683c\u3010" + sRStyleDesc + "\u3011\uff0c"));
            } else {
                s_logger.info((Object)("\u6b63\u5728\u4fdd\u5b58\u9875\u9762\u98ce\u683c\u3010" + sPageStyleDesc + "\u3011\u4e0b\u7684\u8d44\u6e90\u98ce\u683c\u3010" + sRStyleDesc + "\u3011\uff01"));
            }
            ResourceStyleImporter resourceStyleImporter = (ResourceStyleImporter)DreamFactory.createObjectById("ResourceStyleImporter");
            try {
                resourceStyleImporter.importResourceStyleToPageStyle(currResourceStyle, aXmlObject.getChild(TAG_STYLE_ITEMS), _nImportMode, m_sUnzipFilePath, _nPageStyleId);
                continue;
            }
            catch (Throwable t) {
                String sErrorDesc = "\u5bfc\u5165ResourceStyle\u5bf9\u8c61\u5173\u7cfb\u5931\u8d25";
                if (this.hs_session != null) {
                    this.hs_session.setAttribute("ErrorInfo", (Object)"\u5bfc\u5165ResourceStyle\u5bf9\u8c61\u5173\u7cfb\u5931\u8d25");
                }
                s_logger.debug((Object)sErrorDesc, t);
                this.m_reports.addWarnedReport(sErrorDesc, t);
            }
        }
    }

    private void importPageContentStyles(XmlObject[] _contentStyles, int _nPageStyleId, int _nImportMode) throws WCMException {
        if (_contentStyles == null || _nPageStyleId == 0) {
            return;
        }
        for (int i = 0; i < _contentStyles.length; ++i) {
            ContentStyle currContentStyle;
            XmlObject aXmlObject = _contentStyles[i];
            if (aXmlObject == null || (currContentStyle = (ContentStyle)aXmlObject.getCurrentObj()) == null) continue;
            PageStyle currPageStyle = PageStyle.findById(_nPageStyleId);
            String sPageStyleDesc = (String)currPageStyle.getProperty("STYLEDESC");
            String sCStyleDesc = currContentStyle.getStyleName();
            this.hs_session = (HttpSession)ContextHelper.getArg(5);
            if (this.hs_session != null) {
                this.hs_session.setAttribute("currentPageStyle", (Object)new String("\u4fdd\u5b58\u9875\u9762\u98ce\u683c\u3010" + sPageStyleDesc + "\u3011\u4e0b\u7684\u5185\u5bb9\u98ce\u683c\u3010" + sCStyleDesc + "\u3011\uff0c"));
            } else {
                s_logger.info((Object)("\u6b63\u5728\u4fdd\u5b58\u9875\u9762\u98ce\u683c\u3010" + sPageStyleDesc + "\u3011\u4e0b\u7684\u5185\u5bb9\u98ce\u683c\u3010" + sCStyleDesc + "\u3011\uff01"));
            }
            ContentStyleImporter contentStyleImporter = (ContentStyleImporter)DreamFactory.createObjectById("ContentStyleImporter");
            try {
                contentStyleImporter.importContentStyleToPageStyle(currContentStyle, aXmlObject.getChild(TAG_STYLE_ITEMS), _nImportMode, m_sUnzipFilePath, _nPageStyleId);
                continue;
            }
            catch (Throwable t) {
                String sErrorDesc = "\u5bfc\u5165ContentStyle\u5bf9\u8c61\u5173\u7cfb\u5931\u8d25";
                if (this.hs_session != null) {
                    this.hs_session.setAttribute("ErrorInfo", (Object)"\u5bfc\u5165ContentStyle\u5bf9\u8c61\u5173\u7cfb\u5931\u8d25");
                }
                s_logger.debug((Object)sErrorDesc, t);
                this.m_reports.addWarnedReport(sErrorDesc, t);
            }
        }
    }

    private void importStyleItems(XmlObject[] _pageStyleItems, Map _IdsMap, int _nImportMode, boolean _bExistSameNameStyle) throws WCMException {
        for (int i = 0; i < _pageStyleItems.length; ++i) {
            this.importOneStyleItem(_pageStyleItems[i], _IdsMap, _nImportMode, _bExistSameNameStyle);
        }
    }

    private void importOneStyleItem(XmlObject _pageStyleItem, Map _IdsMap, int _nImportMode, boolean _bExistSameNameStyle) throws WCMException {
        if (_pageStyleItem == null) {
            return;
        }
        if (_IdsMap == null) {
            throw new WCMException("\u4f20\u5165\u7684ids\u6620\u5c04\u5173\u7cfbmap\u4e3anull\uff01");
        }
        if (_bExistSameNameStyle && _nImportMode == 2) {
            return;
        }
        StyleItem aStyleItem = null;
        int nOldStyleItemId = 0;
        try {
            aStyleItem = (StyleItem)_pageStyleItem.getCurrentObj();
            nOldStyleItemId = aStyleItem.getPropertyAsInt("STYLEITEMID", 0);
            int nOldStyleObjType = aStyleItem.getStyleObjType();
            int nOldStyleObjId = aStyleItem.getStyleObjId();
            String sMapKey = this.makePageStyleIdMapKey(nOldStyleObjType, String.valueOf(nOldStyleObjId));
            Integer iNewObjId = (Integer)_IdsMap.get(sMapKey);
            if (iNewObjId == null) {
                throw new WCMException("Map\u4e2d[key=" + sMapKey + "]\u5bf9\u5e94\u7684\u98ce\u683cid\u4e0d\u5b58\u5728\uff01");
            }
            aStyleItem.setStyleObjId(iNewObjId);
            aStyleItem.setNextId();
            aStyleItem.removeProperty(PROPERTY_CRTIME);
            aStyleItem.removeProperty(PROPERTY_CRUSER);
            aStyleItem.save(this.getLoginUser());
        }
        catch (Throwable t) {
            String sErrorDesc = "\u5bfc\u5165StyleItem\u5bf9\u8c61\u5173\u7cfb\u5931\u8d25";
            if (aStyleItem != null) {
                sErrorDesc = sErrorDesc + "[\u6e90Id=" + nOldStyleItemId + "]\uff01";
            }
            s_logger.debug((Object)sErrorDesc, t);
            this.m_reports.addWarnedReport(sErrorDesc, t);
        }
    }

    private PageStyles querySameNamePageStyles(PageStyle _pageStyle) throws WCMException {
        WCMFilter filter;
        if (_pageStyle == null) {
            return null;
        }
        IPageStyleMgr pageStyleMgr = (IPageStyleMgr)DreamFactory.createObjectById("IPageStyleMgr");
        PageStyles pageStyles = pageStyleMgr.query(filter = new WCMFilter("", "StyleName='" + _pageStyle.getStyleName() + "'", "", "PageStyleId"));
        if (pageStyles.isEmpty()) {
            return null;
        }
        return pageStyles;
    }

    private PageStyle getSameNamePageStyle(PageStyle _pageStyle) throws WCMException {
        PageStyles sameNameStyles = this.querySameNamePageStyles(_pageStyle);
        if (sameNameStyles == null || sameNameStyles.size() == 0) {
            return null;
        }
        return (PageStyle)sameNameStyles.getAt(0);
    }

    private boolean existStyleName(PageStyle _pageStyle) throws WCMException {
        PageStyles sameNamePageStyles = this.querySameNamePageStyles(_pageStyle);
        return sameNamePageStyles != null && sameNamePageStyles.size() > 0;
    }

    private String getFullName(String _sFile) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!CMyFile.fileExists(_sFile)) {
            String sPath = filesMan.mapFilePath(_sFile, 0);
            _sFile = sPath + _sFile;
        }
        return _sFile;
    }

    private XmlObject[] convertXmlFile(String _sXmlFile, String _sXslFile) throws WCMException {
        try {
            XmlObject[] xmlObjects = this.m_converter.convertXml(_sXmlFile, _sXslFile, null);
            return xmlObjects;
        }
        catch (Throwable ex) {
            s_logger.debug((Object)"failed to convert xml to object!", ex);
            throw new WCMException("\u8f6c\u6362XML\u6587\u4ef6\u5931\u8d25!\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u9875\u9762\u98ce\u683c\u63cf\u8ff0xml\u6587\u4ef6", ex);
        }
    }

    private void registerConverter() {
        this.m_converter.registPersistentObj("XWCMPAGESTYLE", PageStyle.class);
        this.m_converter.registPersistentObj("XWCMRESOURCESTYLE", ResourceStyle.class);
        this.m_converter.registPersistentObj("XWCMCONTENTSTYLE", ContentStyle.class);
        this.m_converter.registPersistentObj("XWCMSTYLEITEM", StyleItem.class);
    }

    private String makePageStyleIdMapKey(int _nObjType, String _sObjId) {
        return _nObjType + ":" + _sObjId;
    }

    private void copyThumbCustomFiles(PageStyle _currPageStyle, String _sUnZipPath) throws Exception {
        if (_currPageStyle == null || _sUnZipPath == null || "".equals(_sUnZipPath)) {
            return;
        }
        _sUnZipPath = CMyString.setStrEndWith(_sUnZipPath, File.separatorChar);
        String sSourceCustomFolder = _sUnZipPath + _currPageStyle.getStyleName();
        sSourceCustomFolder = CMyString.setStrEndWith(sSourceCustomFolder, File.separatorChar);
        String sDestCustomFoler = StylePathHelper.getStyleCommonDir();
        sDestCustomFoler = CMyString.setStrEndWith(sDestCustomFoler, File.separatorChar);
        CMyFile.copyFileDir(sSourceCustomFolder, sDestCustomFoler, true);
    }

    private void checkFile(String _sFile) throws WCMException {
        if (_sFile == null || _sFile.length() == 0) {
            throw new WCMException("\u4f20\u5165\u7684\u6587\u4ef6\u540d\u65e0\u6548\uff01");
        }
        String sExt = CMyFile.extractFileExt(_sFile);
        if (!"zip".equalsIgnoreCase(sExt)) {
            throw new WCMException("\u53ea\u652f\u6301\u4eceZIP\u6587\u4ef6\u4e2d\u5bfc\u5165!");
        }
    }

    private List extractXmlFiles(String _sFullZipPath, String sUnZipPath) throws WCMException {
        CMyUnZipFile uzf = new CMyUnZipFile(_sFullZipPath, sUnZipPath);
        uzf.addFileExtFilters("xml");
        try {
            uzf.doUnZipAnd();
        }
        catch (CMyException e) {
            s_logger.error((Object)"failed to unzip the file!", (Throwable)e);
            throw new WCMException(200, "\u89e3\u538b\u7f29\u6587\u4ef6[" + _sFullZipPath + "]\u5931\u8d25!", e);
        }
        ArrayList xmlFiles = uzf.getFilteredFiles();
        if (xmlFiles == null) {
            throw new WCMException(10, "\u5bfc\u5165\u7684zip\u5305\u4e2d\u6ca1\u6709\u6709\u6548\u7684\u63cf\u8ff0\u9875\u9762\u98ce\u683c\u4fe1\u606f\u7684xml\u6587\u4ef6!");
        }
        return xmlFiles;
    }

    private void deletePageStyleBasicInfos(User _loginUser, PageStyle _pageStyle) throws WCMException {
        if (_pageStyle == null) {
            return;
        }
        StyleItemMgr m_oStyleItemMgr = (StyleItemMgr)DreamFactory.createObjectById("IStyleItemMgr");
        m_oStyleItemMgr.delete(_loginUser, _pageStyle);
    }

    private String copyFileIfNeed(String _sFile, boolean _isPath) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!_isPath) {
            String sFileFlag = filesMan.getFileFlag(_sFile);
            String sNewFileName = _sFile;
            if (sFileFlag != "W0") {
                sNewFileName = filesMan.copyWCMFile(_sFile, "W0");
            }
            return sNewFileName;
        }
        return CMyFile.extractFileName(filesMan.copyFile(_sFile, "W0", true));
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

