/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSSResourceProcessor {
    private String[] m_pRelateFileNames = new String[0];

    public String[] getRelateFiles() {
        return this.m_pRelateFileNames;
    }

    public String parseCSSFile(String _sCSSFileName, HashMap _hExistsFileMap) throws WCMException {
        if (!CMyFile.fileExists(_sCSSFileName)) {
            return null;
        }
        String sFileContent = null;
        try {
            sFileContent = CMyFile.readFile(_sCSSFileName);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(CSSResourceProcessor.class, "CSSResourceProcessor.label1", "\u8bfb\u53d6\u6837\u5f0f\u6587\u4ef6\u5931\u8d25\uff01[File=") + _sCSSFileName + "]", e);
        }
        return this.parseContent(sFileContent, _hExistsFileMap);
    }

    public String processConent(String _sContent, Map _hExsitsFileMap, String _sAppendixLocalPath) {
        return this.processConent(_sContent, _hExsitsFileMap, _sAppendixLocalPath, null);
    }

    public String processConent(String _sContent, Map _hExsitsFileMap, String _sAppendixLocalPath, String[] _pImgSrcPre) {
        Pattern pattern = Pattern.compile("(?is)URL\\((.+?)\\)");
        Matcher matcher = pattern.matcher(_sContent);
        StringBuffer buff = new StringBuffer(_sContent.length());
        int nIndex = 0;
        ArrayList<String> cssresources = new ArrayList<String>(20);
        int nCurrPreIndex = 0;
        while (matcher.find()) {
            int nCommentEnd;
            buff.append(_sContent.substring(nIndex, matcher.start()));
            buff.append("url(");
            String url = matcher.group(1).trim();
            int nCommentStart = url.indexOf("/*");
            if (nCommentStart > -1 && (nCommentEnd = url.indexOf("*/", nCommentStart)) > -1) {
                url = url.substring(0, nCommentStart) + url.substring(nCommentEnd + "*/".length());
            }
            String tempUrl = url;
            char ch = url.charAt(0);
            if (ch == '\"' || ch == '\'') {
                tempUrl = tempUrl.substring(1, tempUrl.length() - 1).intern();
            }
            if (!tempUrl.toLowerCase().startsWith("http")) {
                int ix = tempUrl.lastIndexOf(47);
                if (ix != -1) {
                    tempUrl = tempUrl.substring(ix + 1).intern();
                }
                if (_hExsitsFileMap.get(tempUrl.toLowerCase()) != null || _hExsitsFileMap.get(tempUrl.toUpperCase()) != null || CMyFile.fileExists(_sAppendixLocalPath + tempUrl)) {
                    cssresources.add(tempUrl);
                    url = tempUrl;
                    if (_pImgSrcPre != null) {
                        url = _pImgSrcPre[nCurrPreIndex++] + url;
                        if (nCurrPreIndex >= _pImgSrcPre.length) {
                            nCurrPreIndex = 0;
                        }
                    }
                }
            }
            buff.append(url);
            buff.append(')');
            nIndex = matcher.end();
        }
        if (nIndex == 0 || cssresources.isEmpty()) {
            return null;
        }
        buff.append(_sContent.substring(nIndex));
        this.m_pRelateFileNames = cssresources.toArray(this.m_pRelateFileNames);
        return buff.toString();
    }

    public String parseContent(String _sCSSFileContent, HashMap _hExistsFileMap) {
        Pattern pattern = Pattern.compile("(?is)URL\\(.*?\\)");
        Matcher matcher = pattern.matcher(_sCSSFileContent);
        StringBuffer sbResult = new StringBuffer(_sCSSFileContent.length());
        int nNextStart = 0;
        while (matcher.find()) {
            sbResult.append(_sCSSFileContent.substring(nNextStart, matcher.start()));
            String sURLContent = matcher.group();
            String sFileName = CSSResourceProcessor.processURLContent(sURLContent, _hExistsFileMap);
            if (sFileName == null) {
                sbResult.append(sURLContent);
            } else {
                sbResult.append("url(" + sFileName + ")");
                String[] pTemp = new String[this.m_pRelateFileNames.length + 1];
                System.arraycopy(this.m_pRelateFileNames, 0, pTemp, 0, this.m_pRelateFileNames.length);
                pTemp[this.m_pRelateFileNames.length] = sFileName;
                this.m_pRelateFileNames = pTemp;
            }
            nNextStart = matcher.end();
        }
        if (nNextStart == 0) {
            return null;
        }
        sbResult.append(_sCSSFileContent.substring(nNextStart));
        return sbResult.toString();
    }

    private static String processURLContent(String _sURLContent, HashMap _hExistsApdFile) {
        String sAbsoluteFilePath;
        int nPos;
        if (_sURLContent.toLowerCase().indexOf("http") >= 0) {
            return null;
        }
        int nStartPos = _sURLContent.indexOf("(");
        if (nStartPos < 0) {
            return null;
        }
        int nEndPos = _sURLContent.indexOf(")", nStartPos);
        if (nEndPos < 0) {
            return null;
        }
        String sFile = _sURLContent.substring(nStartPos + 1, nEndPos).trim();
        if (sFile.charAt(0) == '\"' || sFile.charAt(0) == '\'') {
            sFile = sFile.substring(1);
        }
        if (sFile.charAt(sFile.length() - 1) == '\"' || sFile.charAt(sFile.length() - 1) == '\'') {
            sFile = sFile.substring(0, sFile.length() - 1);
        }
        if ((nPos = sFile.lastIndexOf(47)) < 0) {
            nPos = sFile.lastIndexOf(92);
        }
        if ((sAbsoluteFilePath = (String)_hExistsApdFile.get((sFile = sFile.substring(nPos + 1)).toLowerCase())) == null) {
            sAbsoluteFilePath = (String)_hExistsApdFile.get(sFile.toUpperCase());
        }
        if (sAbsoluteFilePath == null) {
            return null;
        }
        return sFile;
    }

    public static void main(String[] args) {
        try {
            String sCSSFile = "d:/css_test.txt";
            String sContent = CMyFile.readFile(sCSSFile);
            Pattern pattern = Pattern.compile("(?is)URL\\((.*?)\\)");
            Matcher matcher = pattern.matcher(sContent);
            System.out.println(sContent);
            System.out.println("---------------");
            System.out.println(matcher.toString());
            while (matcher.find()) {
                String url = matcher.group(1).trim();
                System.out.println("1:-----" + url);
                if (url.indexOf("/*") > -1) {
                    url = url.substring(0, url.indexOf("/*")) + url.substring(url.indexOf("*/") + 2, url.length());
                }
                System.out.println("2:------" + url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

