/*
 * Decompiled with CFR 0.152.
 */
package com.trs.bbs.plad.upload;

import com.trs.bbs.plad.StringUtil;
import com.trs.bbs.plad.upload.RFC1867Exception;
import com.trs.bbs.plad.upload.RFC1867FormPart;
import com.trs.bbs.plad.upload.RFC1867InputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;

public class RFC1867Processer {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";
    public static final String MULTIPART = "multipart/";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    private File m_fTmpDir;
    private Hashtable m_allPart;

    private void addPart(RFC1867FormPart part) {
        RFC1867FormPart prePart = this.m_allPart.put(part.m_strName, part);
        if (prePart == null) {
            return;
        }
        part.m_iBrotherCount = prePart.m_iBrotherCount + 1;
        part.m_rfNextBrother = prePart;
    }

    private String getFileName(String fileInfo) {
        int endQuoteIndex;
        int index;
        if (fileInfo != null && (fileInfo.startsWith(FORM_DATA) || fileInfo.startsWith(ATTACHMENT)) && (index = fileInfo.indexOf("filename=\"")) > 0 && (endQuoteIndex = fileInfo.indexOf(34, index += "filename=\"".length())) > index) {
            return fileInfo.substring(index, endQuoteIndex).trim();
        }
        return null;
    }

    private String getFileName(Hashtable headers) {
        return this.getFileName(this.getHeader(headers, CONTENT_DISPOSITION));
    }

    private String getHeader(String headerName) {
        int colonIndex = headerName.indexOf(58);
        if (colonIndex > 0) {
            return headerName.substring(colonIndex + 1).trim();
        }
        return null;
    }

    private String getHeader(Hashtable headers, String headerName) {
        return (String)headers.get(headerName);
    }

    private String getPartName(String partInfoLine) {
        int end;
        int start;
        if (partInfoLine != null && partInfoLine.startsWith(FORM_DATA) && (start = partInfoLine.indexOf("name=\"")) > 0 && (end = partInfoLine.indexOf(34, start += "name=\"".length())) > start) {
            return partInfoLine.substring(start, end).trim();
        }
        return null;
    }

    private String getPartName(Hashtable headers) {
        return this.getPartName(this.getHeader(headers, CONTENT_DISPOSITION));
    }

    private void process(RFC1867InputStream rfc1876Ins) {
        while (rfc1876Ins.hasMorePart()) {
            int boundaryIndex;
            String partName;
            Hashtable headers = rfc1876Ins.readHeaders();
            if (rfc1876Ins.inMixedPart() || (partName = this.getPartName(headers)) == null) continue;
            String filenName = this.getFileName(headers);
            String contentType = this.getHeader(headers, CONTENT_TYPE);
            if (!rfc1876Ins.inMixedPart() && contentType != null && contentType.startsWith(MULTIPART_MIXED) && (boundaryIndex = contentType.indexOf("boundary=")) > 0) {
                rfc1876Ins.pushBoundary(contentType.substring(boundaryIndex + "boundary=".length()).getBytes());
            }
            if (filenName == null && rfc1876Ins.inMixedPart()) continue;
            RFC1867FormPart part = new RFC1867FormPart();
            part.m_strName = partName;
            part.setFileName(filenName);
            part.m_strMimeType = contentType;
            part.setTemporalPath(this.m_fTmpDir);
            part.fillPartData(rfc1876Ins);
            this.addPart(part);
        }
    }

    public void process(HttpServletRequest request, Hashtable allParts, String tempPath) {
        if (request == null) {
            throw new NullPointerException("Request is null");
        }
        if (allParts == null) {
            throw new NullPointerException("Hashtable is null");
        }
        String contentType = request.getHeader(CONTENT_TYPE);
        if (contentType == null) {
            throw new NullPointerException("ContentType is null");
        }
        if (!contentType.startsWith(MULTIPART_FORM_DATA) && !contentType.startsWith(MULTIPART_MIXED)) {
            throw new RFC1867Exception("\"" + contentType + "\" isn't " + MULTIPART_FORM_DATA + "or" + MULTIPART_MIXED);
        }
        int contentLength = request.getContentLength();
        if (contentLength == -1) {
            throw new RFC1867Exception("unknown size");
        }
        int boundaryIndex = contentType.indexOf("boundary=");
        if (boundaryIndex < 0) {
            throw new RFC1867Exception("missing boundary");
        }
        byte[] baBoundary = contentType.substring(boundaryIndex + "boundary=".length() - 2).getBytes();
        baBoundary[0] = 45;
        baBoundary[1] = 45;
        this.m_allPart = allParts;
        this.setTemporalPath(tempPath);
        try {
            this.process(new RFC1867InputStream((InputStream)request.getInputStream(), baBoundary));
        }
        catch (IOException ex) {
            throw new RFC1867Exception(ex);
        }
    }

    private void setTemporalPath(String tempPath) {
        File localFile;
        if (StringUtil.isEmpty(tempPath)) {
            tempPath = System.getProperty("java.io.tmpdir");
        }
        if (StringUtil.isEmpty(tempPath)) {
            tempPath = System.getProperty("user.dir");
        }
        if (StringUtil.isEmpty(tempPath)) {
            tempPath = ".";
        }
        if (!(localFile = new File(tempPath)).exists()) {
            localFile.mkdirs();
        }
        this.m_fTmpDir = localFile;
    }

    public static void main(String[] args) {
        try {
            String fn = "/f:/temp.zip";
            if (args.length > 1) {
                fn = args[0];
            }
            String temp = "/f:/temp";
            if (args.length > 2) {
                temp = args[2];
            }
            RFC1867Processer processer = new RFC1867Processer();
            processer.setTemporalPath(temp);
            processer.m_allPart = new Hashtable();
            byte[] boundary = "-----------------------------7d31eb20780192".getBytes();
            FileInputStream fins = new FileInputStream(fn);
            RFC1867InputStream rfc1876Ins = new RFC1867InputStream(fins, boundary);
            processer.process(rfc1876Ins);
            System.out.println(processer.m_allPart);
            fins.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

