/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.exception.IdMException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import org.apache.log4j.Logger;

public class ClassUtil {
    private static final Logger LOG = Logger.getLogger(ClassUtil.class);

    public static Object getInstanceByClassName(String className) throws IdMException {
        if (className == null) {
            throw new IllegalArgumentException("className is null!");
        }
        if ((className = className.trim()).length() == 0) {
            throw new IllegalArgumentException("className is empty!");
        }
        try {
            return Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new IdMException("fail to initialize class, className:" + className);
        }
    }

    public static Class getClassByName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("fail to find class: " + className), (Throwable)e);
            return null;
        }
    }

    public static Object getInstanceByClass(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            LOG.error((Object)("fail to create instance! class=" + clazz), (Throwable)e);
            return null;
        }
    }

    public static String getSourceLocation(Class clazz) {
        if (clazz != null) {
            try {
                ProtectionDomain pd = clazz.getProtectionDomain();
                CodeSource cs = pd.getCodeSource();
                if (cs != null) {
                    return cs.getLocation().toString();
                }
                return "unkown";
            }
            catch (RuntimeException e) {
                return e.toString();
            }
        }
        return "unkown";
    }

    public static boolean isPrimitiveWrapClass(Class clz) {
        try {
            return ((Class)clz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }
}

