/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client;

import com.trs.idm.exception.IdMException;
import com.trs.idm.security.DefaultDataSignaturer;
import com.trs.idm.security.IDataEncrypter;
import com.trs.idm.security.IDataSignaturer;
import com.trs.idm.security.SymmetricEncrypter;
import com.trs.idm.util.Base64Util;
import com.trs.idm.util.PropertyUtil;
import com.trs.idm.util.StringHelper;
import java.io.File;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ClientSecurityController {
    private static final Logger LOG = Logger.getLogger(ClientSecurityController.class);
    private IDataSignaturer clientSignaturer;
    private IDataSignaturer serverSignaturer;
    private String clientName;
    private IDataEncrypter encrypter;

    public void beforeAccept(String machineIP) throws IdMException {
        if (machineIP == null) {
            throw new IdMException("applicatioName == null || machineIP == null");
        }
    }

    public String beforeAccept(String machineIP, String data, String signature) throws IdMException {
        this.beforeAccept(machineIP);
        byte[] byteData = Base64Util.decodeBytes(data);
        byte[] byteSignature = Base64Util.decodeBytes(signature);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("byteData:" + StringHelper.toString(byteData)));
            LOG.debug((Object)("byteSignature:" + StringHelper.toString(byteSignature)));
        }
        if (!this.serverSignaturer.verifySign(byteData, byteSignature)) {
            throw new IdMException("Verification failed,Maybe data(" + StringHelper.toString(byteData) + ") isn't signed with this signature(" + StringHelper.toString(byteSignature) + ")!");
        }
        return new String(this.encrypter.decrypt(byteData));
    }

    public String[] beforeSend(String data) throws IdMException {
        String[] sendData = new String[2];
        if (this.encrypter != null) {
            byte[] byteData = this.encrypter.encrypt(data.getBytes());
            sendData[0] = Base64Util.encode(byteData);
            sendData[1] = Base64Util.encode(this.clientSignaturer.sign(sendData[0].getBytes()));
        }
        return sendData;
    }

    public void start() {
        Properties properties = new Properties();
        PropertyUtil.loadProperties(new File("/trsids-security.properties"));
        this.load(properties);
    }

    public void load(Properties properties) {
        String serverPublicKey = properties.getProperty("serverKey");
        String clientPrivateKey = properties.getProperty("clientKey");
        String signatureAlgorithm = properties.getProperty("signatureAlgorithm");
        this.clientSignaturer = new DefaultDataSignaturer(signatureAlgorithm, clientPrivateKey, null);
        this.serverSignaturer = new DefaultDataSignaturer("DSA", null, serverPublicKey);
        String keyAlgorithm = properties.getProperty("keyAlgorithm");
        String keyData = properties.getProperty("keyData");
        String cipherAlgorithm = properties.getProperty("cipherAlgorithm");
        try {
            this.encrypter = new SymmetricEncrypter(keyAlgorithm, keyData, cipherAlgorithm);
        }
        catch (IdMException idMException) {
            // empty catch block
        }
        this.clientName = properties.getProperty("clientName");
    }

    public void stop() {
        this.encrypter.close();
    }

    public String getClientName() {
        return this.clientName;
    }
}

